/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.i18n.I18nSupport;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public final class FactoryRegistry {
    private static Lookup.Result result;
    private static final Set cache;
    private static final Set ncache;

    private FactoryRegistry() {
    }

    private static Lookup.Result getSupports() {
        if (result == null) {
            result = Lookup.getDefault().lookup(new Lookup.Template(I18nSupport.Factory.class));
            result.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent lookupEvent) {
                    cache.clear();
                    ncache.clear();
                }
            });
        }
        return result;
    }

    public static I18nSupport.Factory getFactory(Class clazz) {
        Object object;
        Object object2;
        ArrayList<Object> arrayList = new ArrayList<Object>(3);
        Object object3 = FactoryRegistry.getSupports().allInstances().iterator();
        while (object3.hasNext()) {
            object2 = (I18nSupport.Factory)object3.next();
            object = ((I18nSupport.Factory)object2).getDataObjectClass();
            if (object == null || !((Class)object).isAssignableFrom(clazz)) continue;
            arrayList.add(object2);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        if (arrayList.size() == 1) {
            return (I18nSupport.Factory)arrayList.get(0);
        }
        object3 = null;
        object2 = arrayList.iterator();
        while (object2.hasNext()) {
            object = (I18nSupport.Factory)object2.next();
            if (object3 == null) {
                object3 = object;
                continue;
            }
            if (!((I18nSupport.Factory)object3).getDataObjectClass().isAssignableFrom(((I18nSupport.Factory)object).getDataObjectClass())) continue;
            object3 = object;
        }
        return object3;
    }

    public static boolean hasFactory(Class clazz) {
        if (cache.contains(clazz)) {
            return true;
        }
        if (ncache.contains(clazz)) {
            return false;
        }
        Iterator iterator = FactoryRegistry.getSupports().allInstances().iterator();
        while (iterator.hasNext()) {
            I18nSupport.Factory factory = (I18nSupport.Factory)iterator.next();
            Class clazz2 = factory.getDataObjectClass();
            if (clazz2 == null || !clazz2.isAssignableFrom(clazz)) continue;
            cache.add(clazz);
            return true;
        }
        ncache.add(clazz);
        return false;
    }

    static {
        cache = Collections.synchronizedSet(new HashSet(5));
        ncache = Collections.synchronizedSet(new HashSet(50));
    }
}

