/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.text.Caret;
import org.netbeans.api.project.Project;
import org.netbeans.modules.i18n.FactoryRegistry;
import org.netbeans.modules.i18n.HardCodedString;
import org.netbeans.modules.i18n.I18nPanel;
import org.netbeans.modules.i18n.I18nString;
import org.netbeans.modules.i18n.I18nSupport;
import org.netbeans.modules.i18n.I18nUtil;
import org.netbeans.modules.i18n.Util;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.util.RequestProcessor;

public class I18nManager {
    private static I18nManager manager;
    private I18nSupport support;
    private WeakReference i18nPanelWRef = new WeakReference<Object>(null);
    private WeakReference dialogWRef = new WeakReference<Object>(null);
    private WeakReference caretWRef;
    private HardCodedString hcString;

    private I18nManager() {
    }

    public static synchronized I18nManager getDefault() {
        if (manager == null) {
            manager = new I18nManager();
        }
        return manager;
    }

    private void initSupport(DataObject dataObject) throws IOException {
        I18nSupport.Factory factory = FactoryRegistry.getFactory(dataObject.getClass());
        this.support = factory.create(dataObject);
    }

    public void internationalize(DataObject dataObject) {
        this.closeDialog();
        try {
            this.initSupport(dataObject);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
            return;
        }
        final EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            return;
        }
        this.getDialog(dataObject);
        final I18nPanel i18nPanel = (I18nPanel)this.i18nPanelWRef.get();
        i18nPanel.showBundleMessage("TXT_SearchingForStrings");
        i18nPanel.getCancelButton().requestFocusInWindow();
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                if (I18nManager.this.find()) {
                    I18nManager.this.initCaret(editorCookie);
                    I18nManager.this.highlightHCString();
                    I18nManager.this.fillDialogValues();
                    i18nPanel.getReplaceButton().requestFocusInWindow();
                } else {
                    i18nPanel.showBundleMessage("TXT_NoHardcodedString");
                    i18nPanel.getCancelButton().requestFocusInWindow();
                }
            }
        });
    }

    private void initCaret(EditorCookie editorCookie) {
        JEditorPane[] jEditorPaneArray = editorCookie.getOpenedPanes();
        if (jEditorPaneArray == null) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)I18nUtil.getBundle().getString("MSG_CouldNotOpen"), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return;
        }
        this.caretWRef = new WeakReference<Caret>(jEditorPaneArray[0].getCaret());
    }

    private void highlightHCString() {
        HardCodedString hardCodedString = this.hcString;
        if (hardCodedString == null) {
            return;
        }
        Caret caret = (Caret)this.caretWRef.get();
        if (caret != null) {
            caret.setDot(hardCodedString.getStartPosition().getOffset());
            caret.moveDot(hardCodedString.getEndPosition().getOffset());
        }
    }

    private boolean find() {
        this.hcString = this.support.getFinder().findNextHardCodedString();
        return this.hcString != null;
    }

    private void fillDialogValues() {
        I18nPanel i18nPanel = (I18nPanel)this.i18nPanelWRef.get();
        i18nPanel.setI18nString(this.support.getDefaultI18nString(this.hcString));
        this.showDialog();
    }

    private void replace() {
        I18nString i18nString = null;
        try {
            i18nString = ((I18nPanel)this.i18nPanelWRef.get()).getI18nString();
        }
        catch (IllegalStateException illegalStateException) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)I18nUtil.getBundle().getString("EXC_BadKey"), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return;
        }
        this.support.getResourceHolder().addProperty(i18nString.getKey(), i18nString.getValue(), i18nString.getComment());
        if (this.support.hasAdditionalCustomizer()) {
            this.support.performAdditionalChanges();
        }
        this.support.getReplacer().replace(this.hcString, i18nString);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                I18nManager.this.skip();
            }
        });
    }

    private void skip() {
        if (this.find()) {
            this.highlightHCString();
            this.fillDialogValues();
        } else {
            ((I18nPanel)this.i18nPanelWRef.get()).showBundleMessage("TXT_NoMoreStrings");
            ((I18nPanel)this.i18nPanelWRef.get()).getCancelButton().requestFocusInWindow();
        }
    }

    private void showInfo() {
        JPanel jPanel = this.support.getInfo(this.hcString);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jPanel, I18nUtil.getBundle().getString("CTL_InfoPanelTitle"));
        dialogDescriptor.setModal(true);
        dialogDescriptor.setOptionType(-1);
        dialogDescriptor.setOptions(new Object[]{DialogDescriptor.OK_OPTION});
        dialogDescriptor.setAdditionalOptions(new Object[0]);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
    }

    public void cancel() {
        this.support = null;
        this.closeDialog();
    }

    private void getDialog(DataObject dataObject) {
        ActionListener actionListener;
        Object object;
        Project project = Util.getProjectFor(dataObject);
        Dialog dialog = (Dialog)this.dialogWRef.get();
        I18nPanel i18nPanel = (I18nPanel)this.i18nPanelWRef.get();
        if (i18nPanel == null) {
            i18nPanel = new I18nPanel(this.support.getPropertyPanel(), project, dataObject.getPrimaryFile());
            object = i18nPanel;
            actionListener = new ActionListener((I18nPanel)object){
                private final /* synthetic */ I18nPanel val$panel;
                {
                    this.val$panel = i18nPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getSource() == this.val$panel.getReplaceButton()) {
                        I18nManager.this.replace();
                    } else if (actionEvent.getSource() == this.val$panel.getSkipButton()) {
                        I18nManager.this.skip();
                    } else if (actionEvent.getSource() == this.val$panel.getInfoButton()) {
                        I18nManager.this.showInfo();
                    } else if (actionEvent.getSource() == this.val$panel.getCancelButton()) {
                        I18nManager.this.cancel();
                    }
                }
            };
            i18nPanel.getReplaceButton().addActionListener(actionListener);
            i18nPanel.getSkipButton().addActionListener(actionListener);
            i18nPanel.getInfoButton().addActionListener(actionListener);
            i18nPanel.getCancelButton().addActionListener(actionListener);
            this.i18nPanelWRef = new WeakReference<I18nPanel>(i18nPanel);
        } else {
            i18nPanel.setProject(project);
            i18nPanel.setFile(dataObject.getPrimaryFile());
        }
        i18nPanel.setI18nString(this.support.getDefaultI18nString());
        i18nPanel.setDefaultResource(dataObject);
        if (dialog == null) {
            object = Util.getString("CTL_I18nDialogTitle");
            actionListener = new DialogDescriptor((Object)i18nPanel, (String)object, false, new Object[0], null, 0, null, null);
            dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)actionListener);
            dialog.setLocation(80, 80);
            this.dialogWRef = new WeakReference<Dialog>(dialog);
        }
        dialog.setVisible(true);
    }

    private void showDialog() {
        Caret caret;
        Dialog dialog = (Dialog)this.dialogWRef.get();
        if (dialog != null) {
            dialog.setVisible(true);
        }
        if ((caret = (Caret)this.caretWRef.get()) != null && !caret.isVisible()) {
            caret.setVisible(true);
        }
    }

    private void closeDialog() {
        Dialog dialog = (Dialog)this.dialogWRef.get();
        if (dialog != null) {
            dialog.hide();
        }
    }
}

