/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.javahelp.Help;
import org.netbeans.api.project.Project;
import org.netbeans.modules.i18n.EmptyPropertyPanel;
import org.netbeans.modules.i18n.I18nString;
import org.netbeans.modules.i18n.I18nUtil;
import org.netbeans.modules.i18n.PropertyPanel;
import org.netbeans.modules.i18n.ResourcePanel;
import org.netbeans.modules.i18n.Util;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;

public class I18nPanel
extends JPanel {
    private I18nString i18nString;
    private ResourceBundle bundle;
    private PropertyChangeListener propListener;
    static final long serialVersionUID = -6982482491017390786L;
    private Project project;
    private FileObject file;
    static final long ALL_BUTTONS = 0xFFFFFFL;
    static final long NO_BUTTONS = 0L;
    static final long REPLACE_BUTTON = 983040L;
    static final long SKIP_BUTTON = 61440L;
    static final long INFO_BUTTON = 3840L;
    static final long CANCEL_BUTTON = 240L;
    static final long HELP_BUTTON = 15L;
    private boolean contentsShown;
    private JPanel buttonsPanel;
    private JButton cancelButton;
    private JPanel contentsPanelPlaceholder;
    private JPanel fillPanel;
    private JButton helpButton;
    private JButton infoButton;
    private JButton replaceButton;
    private JButton skipButton;
    private EmptyPropertyPanel emptyPanel;
    private JPanel resourcePanel;
    private JPanel propertyPanel;
    private JPanel contentsPanel;

    public I18nPanel(PropertyPanel propertyPanel, Project project, FileObject fileObject) {
        this(propertyPanel, true, project, fileObject);
    }

    public I18nPanel(PropertyPanel propertyPanel, boolean bl, Project project, FileObject fileObject) {
        this.project = project;
        this.file = fileObject;
        this.propertyPanel = propertyPanel;
        this.propertyPanel.setEnabled(project != null);
        this.bundle = I18nUtil.getBundle();
        this.initComponents();
        this.myInitComponents();
        this.initAccessibility();
        if (!bl) {
            this.remove(this.buttonsPanel);
        }
        this.emptyPanel = new EmptyPropertyPanel();
        this.contentsShown = true;
        this.showBundleMessage("TXT_SearchingForStrings");
    }

    public void showBundleMessage(String string) {
        this.emptyPanel.setBundleText(string);
        if (this.contentsShown) {
            this.contentsPanelPlaceholder.remove(this.contentsPanel);
            this.contentsPanelPlaceholder.add(this.emptyPanel);
            this.contentsPanelPlaceholder.validate();
            this.contentsPanelPlaceholder.repaint();
            this.contentsShown = false;
        }
        this.buttonsEnableDisable();
    }

    public void showPropertyPanel() {
        if (!this.contentsShown) {
            this.contentsPanelPlaceholder.remove(this.emptyPanel);
            this.contentsPanelPlaceholder.add(this.contentsPanel);
            this.contentsPanelPlaceholder.validate();
            this.contentsPanelPlaceholder.repaint();
            this.contentsShown = true;
        }
        this.buttonsEnableDisable();
    }

    public void setProject(Project project) {
        ((ResourcePanel)this.resourcePanel).setProject(project);
        this.propertyPanel.setEnabled(project != null);
    }

    public Project getProject() {
        return ((ResourcePanel)this.resourcePanel).getProject();
    }

    public void setFile(FileObject fileObject) {
        ((ResourcePanel)this.resourcePanel).setFile(fileObject);
    }

    public FileObject getFile() {
        return ((ResourcePanel)this.resourcePanel).getFile();
    }

    public void addNotify() {
        super.addNotify();
        if (SwingUtilities.isDescendingFrom(this.replaceButton, this)) {
            this.getRootPane().setDefaultButton(this.replaceButton);
        }
    }

    public I18nString getI18nString() {
        return this.i18nString;
    }

    public void setI18nString(I18nString i18nString) {
        this.i18nString = i18nString;
        ((PropertyPanel)this.propertyPanel).setI18nString(i18nString);
        ((ResourcePanel)this.resourcePanel).setI18nString(i18nString);
        this.showPropertyPanel();
    }

    JButton getReplaceButton() {
        return this.replaceButton;
    }

    JButton getSkipButton() {
        return this.skipButton;
    }

    JButton getInfoButton() {
        return this.infoButton;
    }

    JButton getCancelButton() {
        return this.cancelButton;
    }

    private void buttonsEnableDisable() {
        if (this.contentsShown) {
            this.enableButtons(0xFFFFFFL);
            boolean bl = this.i18nString != null && this.i18nString.getSupport().getResourceHolder().getResource() != null;
            boolean bl2 = this.getI18nString() == null || this.getI18nString().getKey() == null || this.getI18nString().getKey().trim().length() == 0;
            this.replaceButton.setEnabled(bl && !bl2);
        } else {
            this.enableButtons(255L);
        }
    }

    public void setDefaultResource(DataObject dataObject) {
        if (dataObject != null) {
            FileObject fileObject = dataObject.getPrimaryFile();
            ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
            for (FileObject fileObject2 = classPath.findResource(classPath.getResourceName(fileObject.getParent())); fileObject2 != null && classPath.contains(fileObject2); fileObject2 = fileObject2.getParent()) {
                String string = classPath.getResourceName(fileObject2) + "/Bundle.properties";
                FileObject fileObject3 = classPath.findResource(string);
                if (fileObject3 == null) continue;
                try {
                    DataObject dataObject2 = DataObject.find((FileObject)fileObject3);
                    ((ResourcePanel)this.resourcePanel).setResource(dataObject2);
                    return;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private JPanel createResourcePanel() {
        return new ResourcePanel(this.project, this.file);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_I18nPanel"));
        this.skipButton.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_CTL_SkipButton"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_CTL_CancelButton"));
        this.replaceButton.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_CTL_ReplaceButton"));
        this.infoButton.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_CTL_InfoButton"));
        this.helpButton.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_CTL_HelpButton"));
    }

    private void initComponents() {
        this.fillPanel = new JPanel();
        this.buttonsPanel = new JPanel();
        this.replaceButton = new JButton();
        this.skipButton = new JButton();
        this.infoButton = new JButton();
        this.cancelButton = new JButton();
        this.helpButton = new JButton();
        this.contentsPanelPlaceholder = new JPanel();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.fillPanel, gridBagConstraints);
        this.buttonsPanel.setLayout(new GridLayout(1, 5, 5, 0));
        this.replaceButton.setMnemonic(Util.getChar("CTL_ReplaceButton_Mnem"));
        this.replaceButton.setText(this.bundle.getString("CTL_ReplaceButton"));
        this.buttonsPanel.add(this.replaceButton);
        this.skipButton.setMnemonic(Util.getChar("CTL_SkipButton_Mnem"));
        this.skipButton.setText(this.bundle.getString("CTL_SkipButton"));
        this.buttonsPanel.add(this.skipButton);
        this.infoButton.setMnemonic(Util.getChar("CTL_InfoButton_Mnem"));
        this.infoButton.setText(this.bundle.getString("CTL_InfoButton"));
        this.buttonsPanel.add(this.infoButton);
        this.cancelButton.setMnemonic(Util.getChar("CTL_CloseButton_mne"));
        this.cancelButton.setText(this.bundle.getString("CTL_CloseButton"));
        this.buttonsPanel.add(this.cancelButton);
        this.helpButton.setMnemonic(Util.getChar("CTL_HelpButton_Mnem"));
        this.helpButton.setText(this.bundle.getString("CTL_HelpButton"));
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                I18nPanel.this.helpButtonActionPerformed(actionEvent);
            }
        });
        this.buttonsPanel.add(this.helpButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(17, 0, 11, 11);
        this.add((Component)this.buttonsPanel, gridBagConstraints);
        this.contentsPanelPlaceholder.setLayout(new BoxLayout(this.contentsPanelPlaceholder, 1));
        this.contentsPanelPlaceholder.setPreferredSize(new Dimension(520, 460));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.contentsPanelPlaceholder, gridBagConstraints);
    }

    private void myInitComponents() {
        this.resourcePanel = this.createResourcePanel();
        this.contentsPanel = new JPanel();
        this.contentsPanel.setLayout(new BoxLayout(this.contentsPanel, 1));
        this.contentsPanel.add(this.resourcePanel);
        this.contentsPanel.add(this.propertyPanel);
        this.contentsShown = true;
        this.contentsPanelPlaceholder.add(this.contentsPanel);
        this.propertyPanel.addPropertyChangeListener("propString", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                I18nPanel.this.buttonsEnableDisable();
            }
        });
        this.resourcePanel.addPropertyChangeListener("property_resource", WeakListeners.propertyChange((PropertyChangeListener)new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("property_resource".equals(propertyChangeEvent.getPropertyName())) {
                    I18nPanel.this.buttonsEnableDisable();
                    ((PropertyPanel)I18nPanel.this.propertyPanel).updateAllValues();
                }
            }
        }, (Object)this.resourcePanel));
    }

    private void helpButtonActionPerformed(ActionEvent actionEvent) {
        HelpCtx helpCtx = new HelpCtx("internation.autoinsert");
        String string = System.getProperty("org.openide.actions.HelpAction.DEBUG");
        if ("true".equals(string) || "full".equals(string)) {
            System.err.println("I18n module: Help button showing: " + helpCtx);
        }
        Help help = (Help)Lookup.getDefault().lookup(Help.class);
        help.showHelp(helpCtx);
    }

    private void enableButtons(long l) {
        this.replaceButton.setEnabled((l & 0xF0000L) != 0L);
        this.skipButton.setEnabled((l & 0xF000L) != 0L);
        this.infoButton.setEnabled((l & 0xF00L) != 0L);
        this.cancelButton.setEnabled((l & 0xF0L) != 0L);
        this.helpButton.setEnabled((l & 0xFL) != 0L);
    }
}

