/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.i18n.I18nSupport;
import org.netbeans.modules.i18n.I18nUtil;
import org.netbeans.modules.i18n.Util;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.MapFormat;

public class I18nString {
    protected I18nSupport support;
    protected String key;
    protected String value;
    protected String comment;
    protected String replaceFormat;

    protected I18nString(I18nSupport i18nSupport) {
        if (i18nSupport == null) {
            throw new NullPointerException();
        }
        this.support = i18nSupport;
        this.replaceFormat = I18nUtil.getOptions().getReplaceJavaCode();
    }

    protected I18nString(I18nString i18nString) {
        this.key = i18nString.key;
        this.value = i18nString.value;
        this.comment = i18nString.comment;
        this.replaceFormat = i18nString.replaceFormat;
        this.support = i18nString.support;
    }

    public void become(I18nString i18nString) {
        this.key = i18nString.key;
        this.value = i18nString.value;
        this.comment = i18nString.comment;
        this.replaceFormat = i18nString.replaceFormat;
        this.support = i18nString.support;
    }

    public Object clone() {
        return new I18nString(this);
    }

    public I18nSupport getSupport() {
        return this.support;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String string) {
        if (this.key == string || this.key != null && this.key.equals(string)) {
            return;
        }
        this.key = string;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        if (this.value == string || this.value != null && this.value.equals(string)) {
            return;
        }
        this.value = string;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        if (this.comment == string || this.comment != null && this.comment.equals(string)) {
            return;
        }
        this.comment = string;
    }

    public String getReplaceFormat() {
        return this.replaceFormat;
    }

    public void setReplaceFormat(String string) {
        this.replaceFormat = string;
    }

    public String getReplaceString() {
        if (this.getKey() == null || this.getSupport() == null || this.getSupport().getResourceHolder().getResource() == null) {
            return null;
        }
        if (this.replaceFormat == null) {
            this.replaceFormat = I18nUtil.getOptions().getReplaceJavaCode();
        }
        DataObject dataObject = this.getSupport().getSourceDataObject();
        FileObject fileObject = this.getSupport().getResourceHolder().getResource().getPrimaryFile();
        ClassPath classPath = Util.getExecClassPath(dataObject.getPrimaryFile(), fileObject);
        HashMap<String, String> hashMap = new HashMap<String, String>(4);
        hashMap.put("key", this.getKey());
        hashMap.put("bundleNameSlashes", classPath.getResourceName(fileObject, '/', false));
        hashMap.put("bundleNameDots", classPath.getResourceName(fileObject, '.', false));
        hashMap.put("sourceFileName", dataObject == null ? "" : dataObject.getPrimaryFile().getName());
        this.fillFormatMap(hashMap);
        return MapFormat.format((String)this.replaceFormat, hashMap);
    }

    protected void fillFormatMap(Map map) {
    }
}

