/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.i18n.HelpStringCustomEditor;
import org.netbeans.modules.i18n.I18nString;
import org.netbeans.modules.i18n.I18nUtil;
import org.netbeans.modules.i18n.Util;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;

public class PropertyPanel
extends JPanel {
    public static final String PROP_STRING = "propString";
    private static final String DUMMY_ACTION = "dont_proceed";
    protected I18nString i18nString;
    private int internalTextChange = 0;
    private JLabel commentLabel;
    private JScrollPane commentScroll;
    private JTextArea commentText;
    private JPanel jPanel1;
    private JComboBox keyBundleCombo;
    private JLabel keyLabel;
    private JButton replaceFormatButton;
    private JLabel replaceFormatLabel;
    private JTextField replaceFormatTextField;
    private JLabel valueLabel;
    private JScrollPane valueScroll;
    private JTextArea valueText;

    public PropertyPanel() {
        this.initComponents();
        this.myInitComponents();
        this.initAccessibility();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.commentText.setEnabled(bl);
        this.commentLabel.setEnabled(bl);
        this.commentScroll.setEnabled(bl);
        this.keyBundleCombo.setEnabled(bl);
        this.keyLabel.setEnabled(bl);
        this.replaceFormatButton.setEnabled(bl);
        this.replaceFormatLabel.setEnabled(bl);
        this.replaceFormatTextField.setEnabled(bl);
        this.valueLabel.setEnabled(bl);
        this.valueText.setEnabled(bl);
        this.valueScroll.setEnabled(bl);
    }

    public void setI18nString(I18nString i18nString) {
        this.i18nString = i18nString;
        this.updateAllValues();
        this.firePropertyChange(PROP_STRING, null, null);
    }

    void updateAllValues() {
        this.updateBundleKeys();
        this.updateKey();
        this.updateValue();
        this.updateComment();
    }

    private void updateKey() {
        String string = this.i18nString.getKey();
        if (string == null || !string.equals(this.keyBundleCombo.getSelectedItem())) {
            String string2 = this.keyBundleCombo.getActionCommand();
            this.keyBundleCombo.setActionCommand(DUMMY_ACTION);
            ++this.internalTextChange;
            this.keyBundleCombo.setSelectedItem(string == null ? "" : string);
            --this.internalTextChange;
            this.keyBundleCombo.setActionCommand(string2);
        }
        this.updateReplaceText();
    }

    private void updateValue() {
        String string = this.i18nString.getValue();
        if (!this.valueText.getText().equals(string)) {
            this.valueText.setText(string == null ? "" : string);
        }
        this.updateReplaceText();
    }

    private void updateComment() {
        String string = this.i18nString.getComment();
        if (!this.commentText.getText().equals(string)) {
            this.commentText.setText(string == null ? "" : string);
        }
    }

    protected void updateReplaceText() {
        this.replaceFormatTextField.setText(this.i18nString.getReplaceString());
    }

    void updateBundleKeys() {
        String string = this.keyBundleCombo.getActionCommand();
        this.keyBundleCombo.setActionCommand(DUMMY_ACTION);
        ++this.internalTextChange;
        this.keyBundleCombo.setModel(new DefaultComboBoxModel<String>(this.i18nString.getSupport().getResourceHolder().getAllKeys()));
        --this.internalTextChange;
        this.keyBundleCombo.setActionCommand(string);
        this.updateKey();
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_PropertyPanel"));
        this.valueText.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_valueText"));
        this.commentText.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_commentText"));
        this.replaceFormatButton.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_CTL_Format"));
        this.replaceFormatTextField.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_replaceFormatTextField"));
    }

    private void myInitComponents() {
        ((JTextField)this.keyBundleCombo.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                PropertyPanel.this.keyBundleTextChanged();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                PropertyPanel.this.keyBundleTextChanged();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                PropertyPanel.this.keyBundleTextChanged();
            }
        });
        this.valueText.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                PropertyPanel.this.valueTextChanged();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                PropertyPanel.this.valueTextChanged();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                PropertyPanel.this.valueTextChanged();
            }
        });
    }

    private void keyBundleTextChanged() {
        String string;
        if (this.internalTextChange == 0 && !(string = ((JTextField)this.keyBundleCombo.getEditor().getEditorComponent()).getText()).equals(this.i18nString.getKey())) {
            this.i18nString.setKey(string);
            this.firePropertyChange(PROP_STRING, null, null);
        }
    }

    private void valueTextChanged() {
        this.i18nString.setValue(this.valueText.getText());
        this.firePropertyChange(PROP_STRING, null, null);
    }

    private void initComponents() {
        this.commentLabel = new JLabel();
        this.commentScroll = new JScrollPane();
        this.commentText = new JTextArea();
        this.keyLabel = new JLabel();
        this.valueLabel = new JLabel();
        this.valueScroll = new JScrollPane();
        this.valueText = new JTextArea();
        this.keyBundleCombo = new JComboBox();
        this.replaceFormatTextField = new JTextField();
        this.replaceFormatLabel = new JLabel();
        this.replaceFormatButton = new JButton();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.commentLabel.setLabelFor(this.commentText);
        this.commentLabel.setText(I18nUtil.getBundle().getString("LBL_Comment"));
        this.commentLabel.setDisplayedMnemonic(I18nUtil.getBundle().getString("LBL_Comment_Mnem").charAt(0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 12, 0, 0);
        this.add((Component)this.commentLabel, gridBagConstraints);
        this.commentText.setColumns(40);
        this.commentText.setRows(3);
        this.commentText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                PropertyPanel.this.commentTextFocusLost(focusEvent);
            }
        });
        this.commentScroll.setViewportView(this.commentText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 12, 0, 11);
        this.add((Component)this.commentScroll, gridBagConstraints);
        this.keyLabel.setLabelFor(this.keyBundleCombo);
        this.keyLabel.setText(I18nUtil.getBundle().getString("LBL_Key"));
        this.keyLabel.setDisplayedMnemonic(I18nUtil.getBundle().getString("LBL_Key_Mnem").charAt(0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 12, 0, 0);
        this.add((Component)this.keyLabel, gridBagConstraints);
        this.valueLabel.setLabelFor(this.valueText);
        this.valueLabel.setText(I18nUtil.getBundle().getString("LBL_Value"));
        this.valueLabel.setDisplayedMnemonic(I18nUtil.getBundle().getString("LBL_Value_Mnem").charAt(0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 12, 11, 0);
        this.add((Component)this.valueLabel, gridBagConstraints);
        this.valueText.setColumns(40);
        this.valueText.setRows(3);
        this.valueText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                PropertyPanel.this.valueTextFocusLost(focusEvent);
            }
        });
        this.valueScroll.setViewportView(this.valueText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 12, 11, 11);
        this.add((Component)this.valueScroll, gridBagConstraints);
        this.keyBundleCombo.setEditable(true);
        this.keyBundleCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyPanel.this.keyBundleComboActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 12, 0, 11);
        this.add((Component)this.keyBundleCombo, gridBagConstraints);
        this.replaceFormatTextField.setColumns(40);
        this.replaceFormatTextField.setEditable(false);
        this.replaceFormatTextField.selectAll();
        this.replaceFormatTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                PropertyPanel.this.replaceFormatTextFieldFocusGained(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.replaceFormatTextField, gridBagConstraints);
        this.replaceFormatLabel.setLabelFor(this.replaceFormatTextField);
        this.replaceFormatLabel.setText(I18nUtil.getBundle().getString("LBL_ReplaceFormat"));
        this.replaceFormatLabel.setDisplayedMnemonic(I18nUtil.getBundle().getString("LBL_ReplaceFormat_Mnem").charAt(0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.replaceFormatLabel, gridBagConstraints);
        this.replaceFormatButton.setMnemonic(I18nUtil.getBundle().getString("CTL_Format_Mnem").charAt(0));
        this.replaceFormatButton.setText(I18nUtil.getBundle().getString("CTL_Format"));
        this.replaceFormatButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyPanel.this.replaceFormatButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(11, 5, 0, 11);
        this.add((Component)this.replaceFormatButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void replaceFormatTextFieldFocusGained(FocusEvent focusEvent) {
        this.replaceFormatTextField.selectAll();
    }

    private void replaceFormatButtonActionPerformed(ActionEvent actionEvent) {
        final Dialog[] dialogArray = new Dialog[1];
        final HelpStringCustomEditor helpStringCustomEditor = new HelpStringCustomEditor(this.i18nString.getReplaceFormat(), I18nUtil.getReplaceFormatItems(), I18nUtil.getReplaceHelpItems(), I18nUtil.getBundle().getString("LBL_ReplaceCodeFormat"), Util.getChar("LBL_ReplaceCodeFormat_mne"), "i18n.pe.replacestring");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)helpStringCustomEditor, I18nUtil.getBundle().getString("LBL_ReplaceStringFormatEditor"), true, 2, DialogDescriptor.OK_OPTION, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == DialogDescriptor.OK_OPTION) {
                    String string = (String)helpStringCustomEditor.getPropertyValue();
                    if (!string.equals(PropertyPanel.this.replaceFormatTextField.getText())) {
                        PropertyPanel.this.i18nString.setReplaceFormat(string);
                        PropertyPanel.this.updateReplaceText();
                        PropertyPanel.this.firePropertyChange(PropertyPanel.PROP_STRING, null, null);
                        I18nUtil.getOptions().setReplaceJavaCode(string);
                    }
                    dialogArray[0].setVisible(false);
                    dialogArray[0].dispose();
                } else if (actionEvent.getSource() == DialogDescriptor.CANCEL_OPTION) {
                    dialogArray[0].setVisible(false);
                    dialogArray[0].dispose();
                }
            }
        });
        dialogArray[0] = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialogArray[0].setVisible(true);
    }

    private void keyBundleComboActionPerformed(ActionEvent actionEvent) {
        String string;
        if (DUMMY_ACTION.equals(actionEvent.getActionCommand())) {
            return;
        }
        String string2 = (String)this.keyBundleCombo.getSelectedItem();
        this.i18nString.setKey(string2);
        this.updateKey();
        String string3 = this.i18nString.getSupport().getResourceHolder().getValueForKey(string2);
        if (string3 != null) {
            this.i18nString.setValue(string3);
            this.updateValue();
        }
        if ((string = this.i18nString.getSupport().getResourceHolder().getCommentForKey(string2)) != null) {
            this.i18nString.setComment(string);
            this.updateComment();
        }
        this.firePropertyChange(PROP_STRING, null, null);
    }

    private void commentTextFocusLost(FocusEvent focusEvent) {
        this.i18nString.setComment(this.commentText.getText());
        this.updateComment();
        this.firePropertyChange(PROP_STRING, null, null);
    }

    private void valueTextFocusLost(FocusEvent focusEvent) {
        this.valueTextChanged();
    }
}

