/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.api.project.Project;
import org.netbeans.modules.i18n.I18nString;
import org.netbeans.modules.i18n.I18nUtil;
import org.netbeans.modules.i18n.SelectorUtils;
import org.netbeans.modules.i18n.Util;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.UserCancelException;

public class ResourcePanel
extends JPanel {
    public static final String PROP_RESOURCE = "property_resource";
    private I18nString i18nString;
    private Project project;
    private FileObject file;
    private JButton browseButton;
    private JPanel jPanel1;
    private JButton newButton;
    private JLabel resourceLabel;
    private JTextField resourceText;

    public ResourcePanel(Project project, FileObject fileObject) {
        this.project = project;
        this.file = fileObject;
        this.initComponents();
        this.initAccessibility();
        this.enableComponents();
    }

    public void setFile(FileObject fileObject) {
        this.file = fileObject;
    }

    public FileObject getFile() {
        return this.file;
    }

    public void setI18nString(I18nString i18nString) {
        this.i18nString = i18nString;
        this.updateValues();
    }

    public void setProject(Project project) {
        if (this.project != project) {
            this.project = project;
            this.resourceText.setText("");
        }
        this.enableComponents();
    }

    public Project getProject() {
        return this.project;
    }

    private void updateValues() {
        this.resourceText.setText(this.getResourceName(this.i18nString.getSupport().getResourceHolder().getResource()));
    }

    private void changeResource(DataObject dataObject) {
        if (dataObject == null) {
            throw new IllegalArgumentException();
        }
        DataObject dataObject2 = this.i18nString.getSupport().getResourceHolder().getResource();
        if (dataObject2 != null && dataObject2.equals(dataObject)) {
            return;
        }
        this.i18nString.getSupport().getResourceHolder().setResource(dataObject);
        String string = this.i18nString.getSupport().getResourceHolder().getValueForKey(this.i18nString.getKey());
        if (string != null) {
            this.i18nString.setValue(string);
        }
        this.updateValues();
        this.firePropertyChange(PROP_RESOURCE, dataObject2, dataObject);
        I18nUtil.getOptions().setLastResource2(dataObject);
    }

    private void resourceTextActionPerformedDelegate(ActionEvent actionEvent) {
        DataObject dataObject = this.findResource(this.resourceText.getText());
        if (dataObject != null) {
            this.changeResource(dataObject);
        } else {
            this.resourceText.setText(this.getResourceName(this.i18nString.getSupport().getResourceHolder().getResource()));
        }
    }

    private DataObject findResource(String string) {
        try {
            string = string.replace('.', '/');
            String string2 = string + ".properties";
            FileObject fileObject = Util.getResource(this.file, string2);
            if (fileObject == null) {
                return null;
            }
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            if (this.isResourceClass(dataObject.getClass())) {
                return dataObject;
            }
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private boolean isResourceClass(Class clazz) {
        return Arrays.asList(this.i18nString.getSupport().getResourceHolder().getResourceClasses()).contains(clazz);
    }

    private String getResourceName(DataObject dataObject) {
        if (dataObject == null) {
            return "";
        }
        String string = Util.getResourceName(this.file, dataObject.getPrimaryFile(), '.', false);
        if (string != null) {
            return string;
        }
        return "";
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_ResourcePanel"));
        this.newButton.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_CTL_NewButton"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_CTL_BrowseButton"));
        this.resourceText.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_ResourceText"));
    }

    private void initComponents() {
        this.resourceLabel = new JLabel();
        this.resourceText = new JTextField();
        this.jPanel1 = new JPanel();
        this.browseButton = new JButton();
        this.newButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.resourceLabel.setText(I18nUtil.getBundle().getString("LBL_BundleName"));
        this.resourceLabel.setLabelFor(this.resourceText);
        this.resourceLabel.setDisplayedMnemonic(I18nUtil.getBundle().getString("LBL_BundleName_Mnem").charAt(0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.resourceLabel, gridBagConstraints);
        this.resourceText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResourcePanel.this.resourceTextActionPerformed(actionEvent);
            }
        });
        this.resourceText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                ResourcePanel.this.resourceTextFocusLost(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.resourceText, gridBagConstraints);
        this.jPanel1.setLayout(new GridLayout(1, 2, 5, 0));
        this.browseButton.setMnemonic(I18nUtil.getBundle().getString("CTL_BrowseButton_Mnem").charAt(0));
        this.browseButton.setText(I18nUtil.getBundle().getString("CTL_BrowseButton"));
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResourcePanel.this.browseButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.browseButton);
        this.newButton.setMnemonic(I18nUtil.getBundle().getString("CTL_NewButton_Mnem").charAt(0));
        this.newButton.setText(I18nUtil.getBundle().getString("CTL_NewButton"));
        this.newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResourcePanel.this.newButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.newButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(11, 0, 11, 11);
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void newButtonActionPerformed(ActionEvent actionEvent) {
        try {
            DataObject dataObject = this.i18nString.getSupport().getResourceHolder().getTemplate(this.i18nString.getSupport().getResourceHolder().getResourceClasses()[0]);
            DataObject dataObject2 = SelectorUtils.instantiateTemplate(this.project, this.file, dataObject);
            if (dataObject2 != null) {
                this.changeResource(dataObject2);
            }
        }
        catch (UserCancelException userCancelException) {
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent) {
        DataObject dataObject = SelectorUtils.selectBundle(this.project, this.file);
        if (dataObject != null) {
            this.changeResource(dataObject);
        }
    }

    private void resourceTextFocusLost(FocusEvent focusEvent) {
        this.resourceTextActionPerformedDelegate(new ActionEvent(focusEvent.getSource(), focusEvent.getID(), null));
    }

    private void resourceTextActionPerformed(ActionEvent actionEvent) {
        this.resourceTextActionPerformedDelegate(actionEvent);
    }

    public void setResource(DataObject dataObject) {
        if (this.isResourceClass(dataObject.getClass())) {
            this.changeResource(dataObject);
        }
    }

    private void enableComponents() {
        boolean bl = this.project != null;
        this.setEnabled(bl);
        this.browseButton.setEnabled(bl);
        this.newButton.setEnabled(bl);
        this.resourceText.setEnabled(bl);
        this.resourceLabel.setEnabled(bl);
    }
}

