/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.java;

import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JPanel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.i18n.HardCodedString;
import org.netbeans.modules.i18n.I18nString;
import org.netbeans.modules.i18n.I18nSupport;
import org.netbeans.modules.i18n.I18nUtil;
import org.netbeans.modules.i18n.InfoPanel;
import org.netbeans.modules.i18n.PropertyPanel;
import org.netbeans.modules.i18n.ResourceHolder;
import org.netbeans.modules.i18n.java.JavaI18nString;
import org.netbeans.modules.i18n.java.JavaPropertyPanel;
import org.netbeans.modules.i18n.java.JavaReplacePanel;
import org.netbeans.modules.i18n.java.JavaResourceHolder;
import org.netbeans.modules.i18n.java.Util;
import org.netbeans.modules.i18n.regexp.ParseException;
import org.netbeans.modules.i18n.regexp.Translator;
import org.netbeans.modules.properties.UtilConvert;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.SourceCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.src.ClassElement;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.MapFormat;

public class JavaI18nSupport
extends I18nSupport {
    protected int modifiers = 26;
    protected String identifier;
    protected boolean generateField;
    protected String initFormat = I18nUtil.getOptions().getInitJavaCode();
    static /* synthetic */ Class class$java$lang$ClassLoader;

    public JavaI18nSupport(DataObject dataObject) {
        super(dataObject);
    }

    protected I18nSupport.I18nFinder createFinder() {
        return new JavaI18nFinder(this.document);
    }

    protected I18nSupport.I18nReplacer createReplacer() {
        return new JavaI18nReplacer();
    }

    protected ResourceHolder createResourceHolder() {
        return new JavaResourceHolder();
    }

    public I18nString getDefaultI18nString(HardCodedString hardCodedString) {
        DataObject dataObject;
        JavaI18nString javaI18nString = new JavaI18nString(this);
        ResourceHolder resourceHolder = javaI18nString.getSupport().getResourceHolder();
        if (resourceHolder.getResource() == null && (dataObject = I18nUtil.getOptions().getLastResource2()) != null) {
            FileObject fileObject = this.sourceDataObject.getPrimaryFile();
            FileObject fileObject2 = dataObject.getPrimaryFile();
            ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/execute");
            if (classPath.getResourceName(fileObject2) != null) {
                resourceHolder.setResource(dataObject);
            }
        }
        if (hardCodedString == null) {
            return javaI18nString;
        }
        javaI18nString.setComment("");
        javaI18nString.setKey(hardCodedString.getText().replace(' ', '_'));
        javaI18nString.setValue(hardCodedString.getText());
        if (this.isGenerateField() && javaI18nString.getReplaceFormat().indexOf("{identifier}") == -1) {
            javaI18nString.setReplaceFormat((String)I18nUtil.getReplaceFormatItems().get(0));
        }
        return javaI18nString;
    }

    public JPanel getInfo(HardCodedString hardCodedString) {
        return new JavaInfoPanel(hardCodedString, this.document);
    }

    public String getIdentifier() {
        if (this.identifier == null || this.identifier == "") {
            this.createIdentifier();
        }
        return this.identifier;
    }

    public void setIdentifier(String string) {
        this.identifier = string;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(int n) {
        this.modifiers = n;
    }

    public boolean isGenerateField() {
        return this.generateField;
    }

    public void setGenerateField(boolean bl) {
        this.generateField = bl;
    }

    public String getInitFormat() {
        return this.initFormat;
    }

    public void setInitFormat(String string) {
        this.initFormat = string;
    }

    public PropertyPanel getPropertyPanel() {
        return new JavaPropertyPanel();
    }

    public boolean hasAdditionalCustomizer() {
        return true;
    }

    public JPanel getAdditionalCustomizer() {
        return new JavaReplacePanel(this);
    }

    public void performAdditionalChanges() {
        this.createField();
    }

    public void createIdentifier() {
        String string;
        try {
            string = this.resourceHolder.getResource().getName();
        }
        catch (NullPointerException nullPointerException) {
            this.identifier = "";
            return;
        }
        string = string.length() > 0 ? string.substring(0, 1).toLowerCase() + string.substring(1) : string.toLowerCase();
        this.identifier = string;
    }

    private void createField() {
        if (!this.isGenerateField()) {
            return;
        }
        ClassElement classElement = this.getSourceClassElement();
        if (classElement.getField(Identifier.create((String)this.getIdentifier())) != null) {
            return;
        }
        try {
            FieldElement fieldElement = new FieldElement();
            fieldElement.setName(Identifier.create((String)this.getIdentifier()));
            fieldElement.setModifiers(this.getModifiers());
            fieldElement.setType(Type.parse((String)"java.util.ResourceBundle"));
            fieldElement.setInitValue(this.getInitString());
            if (classElement != null) {
                classElement.addField(fieldElement);
            }
        }
        catch (SourceException sourceException) {
            ErrorManager.getDefault().notify(1, (Throwable)sourceException);
        }
        catch (NullPointerException nullPointerException) {
            ErrorManager.getDefault().notify(1, (Throwable)nullPointerException);
        }
    }

    public String getInitString() {
        String string = this.getInitFormat();
        FileObject fileObject = this.resourceHolder.getResource().getPrimaryFile();
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        hashMap.put("bundleNameSlashes", classPath.getResourceName(fileObject, '/', false));
        hashMap.put("bundleNameDots", classPath.getResourceName(fileObject, '.', false));
        hashMap.put("sourceFileName", this.sourceDataObject == null ? "" : this.sourceDataObject.getPrimaryFile().getName());
        return MapFormat.format((String)string, hashMap);
    }

    private ClassElement getSourceClassElement() {
        SourceElement sourceElement = ((SourceCookie)this.sourceDataObject.getCookie(SourceCookie.class)).getSource();
        ClassElement classElement = sourceElement.getClass(Identifier.create((String)this.sourceDataObject.getName()));
        if (classElement != null) {
            return classElement;
        }
        ClassElement[] classElementArray = sourceElement.getClasses();
        for (int i = 0; i < classElementArray.length; ++i) {
            int n = classElementArray[i].getModifiers();
            if (!classElementArray[i].isClass() || !Modifier.isPublic(n)) continue;
            classElement = classElementArray[i];
            break;
        }
        return classElement;
    }

    public static class Factory
    extends I18nSupport.Factory {
        public I18nSupport createI18nSupport(DataObject dataObject) {
            return new JavaI18nSupport(dataObject);
        }

        public Class getDataObjectClass() {
            try {
                return Class.forName("org.netbeans.modules.java.JavaDataObject", false, (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = JavaI18nSupport.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader));
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
    }

    private static class JavaInfoPanel
    extends InfoPanel {
        public JavaInfoPanel(HardCodedString hardCodedString, StyledDocument styledDocument) {
            super(hardCodedString, styledDocument);
        }

        protected void setHardCodedString(HardCodedString hardCodedString, StyledDocument styledDocument) {
            String string;
            this.getStringText().setText(hardCodedString == null ? "" : hardCodedString.getText());
            if (hardCodedString.getStartPosition() == null) {
                string = "";
            } else {
                int n = hardCodedString.getStartPosition().getOffset();
                try {
                    Element element = styledDocument.getParagraphElement(n);
                    string = styledDocument.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset()).trim();
                }
                catch (BadLocationException badLocationException) {
                    string = "";
                }
            }
            this.getFoundInText().setText(string);
            this.remove(this.getComponentLabel());
            this.remove(this.getComponentText());
            this.remove(this.getPropertyLabel());
            this.remove(this.getPropertyText());
        }
    }

    public static class JavaI18nReplacer
    implements I18nSupport.I18nReplacer {
        public void replace(HardCodedString hardCodedString, I18nString i18nString) {
            if (!(i18nString instanceof JavaI18nString)) {
                throw new IllegalArgumentException("I18N module: i18nString have to be an instance of JavaI18nString.");
            }
            String string = i18nString.getReplaceString();
            StyledDocument styledDocument = i18nString.getSupport().getDocument();
            NbDocument.runAtomic((StyledDocument)styledDocument, (Runnable)new Runnable(this, hardCodedString, styledDocument, string){
                private final /* synthetic */ HardCodedString val$hcString;
                private final /* synthetic */ StyledDocument val$document;
                private final /* synthetic */ String val$newCode;
                private final /* synthetic */ JavaI18nReplacer this$0;
                {
                    this.this$0 = javaI18nReplacer;
                    this.val$hcString = hardCodedString;
                    this.val$document = styledDocument;
                    this.val$newCode = string;
                }

                public void run() {
                    try {
                        if (this.val$hcString.getLength() > 0) {
                            this.val$document.remove(this.val$hcString.getStartPosition().getOffset(), this.val$hcString.getLength());
                        }
                        if (this.val$newCode != null && this.val$newCode.length() > 0) {
                            this.val$document.insertString(this.val$hcString.getEndPosition().getOffset(), this.val$newCode, null);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)Util.getString("MSG_CouldNotReplace"), 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    }
                }
            });
        }
    }

    public static class JavaI18nFinder
    implements I18nSupport.I18nFinder {
        protected static final int STATE_JAVA = 0;
        protected static final int STATE_JAVA_A_SLASH = 1;
        protected static final int STATE_LINECOMMENT = 2;
        protected static final int STATE_BLOCKCOMMENT = 3;
        protected static final int STATE_BLOCKCOMMENT_A_STAR = 4;
        protected static final int STATE_STRING = 5;
        protected static final int STATE_STRING_A_BSLASH = 6;
        protected static final int STATE_CHAR = 7;
        protected StyledDocument document;
        protected int state;
        protected boolean i18nSearch;
        protected Position lastPosition;
        protected StringBuffer lastJavaString;
        protected char[] buffer;
        protected int position;
        protected int currentStringStart;
        protected int currentStringEnd;

        public JavaI18nFinder(StyledDocument styledDocument) {
            this.document = styledDocument;
            this.init();
        }

        private void init() {
            this.state = 0;
            this.initJavaStringBuffer();
            this.lastPosition = null;
        }

        protected void reset() {
            this.init();
        }

        public HardCodedString[] findAllHardCodedStrings() {
            this.reset();
            this.i18nSearch = false;
            return this.findAllStrings();
        }

        public HardCodedString findNextHardCodedString() {
            this.i18nSearch = false;
            return this.findNextString();
        }

        public HardCodedString[] findAllI18nStrings() {
            this.reset();
            this.i18nSearch = true;
            return this.findAllStrings();
        }

        public HardCodedString findNextI18nString() {
            this.i18nSearch = true;
            return this.findNextString();
        }

        protected HardCodedString[] findAllStrings() {
            HardCodedString hardCodedString;
            ArrayList<HardCodedString> arrayList = new ArrayList<HardCodedString>();
            while ((hardCodedString = this.findNextString()) != null) {
                arrayList.add(hardCodedString);
            }
            if (arrayList.isEmpty()) {
                return null;
            }
            HardCodedString[] hardCodedStringArray = new HardCodedString[arrayList.size()];
            arrayList.toArray(hardCodedStringArray);
            return hardCodedStringArray;
        }

        protected HardCodedString findNextString() {
            try {
                this.buffer = this.document.getText(0, this.document.getLength()).toCharArray();
            }
            catch (BadLocationException badLocationException) {
                if (Boolean.getBoolean("netbeans.debug.exception")) {
                    badLocationException.printStackTrace();
                }
                return null;
            }
            this.position = this.lastPosition == null ? 0 : this.lastPosition.getOffset();
            this.currentStringStart = -1;
            this.currentStringEnd = -1;
            while (this.position < this.buffer.length) {
                char c = this.buffer[this.position];
                if (c != '\n') {
                    HardCodedString hardCodedString = this.handleCharacter(c);
                    if (hardCodedString != null) {
                        return hardCodedString;
                    }
                } else {
                    this.handleNewLineCharacter();
                }
                ++this.position;
            }
            return null;
        }

        protected HardCodedString handleCharacter(char c) {
            if (this.state == 0) {
                return this.handleStateJava(c);
            }
            if (this.state == 1) {
                return this.handleStateJavaASlash(c);
            }
            if (this.state == 7) {
                return this.handleStateChar(c);
            }
            if (this.state == 6) {
                return this.handleStateStringABSlash(c);
            }
            if (this.state == 2) {
                return this.handleStateLineComment(c);
            }
            if (this.state == 3) {
                return this.handleStateBlockComment(c);
            }
            if (this.state == 4) {
                return this.handleStateBlockCommentAStar(c);
            }
            if (this.state == 5) {
                return this.handleStateString(c);
            }
            return null;
        }

        protected void handleNewLineCharacter() {
            if (this.state == 0 || this.state == 1 || this.state == 7 || this.state == 2 || this.state == 5 || this.state == 6) {
                this.initJavaStringBuffer();
                this.currentStringStart = -1;
                this.currentStringEnd = -1;
                this.state = 0;
            } else if (this.state == 3 || this.state == 4) {
                this.state = 3;
            }
        }

        protected HardCodedString handleStateJava(char c) {
            this.lastJavaString.append(c);
            if (c == '/') {
                this.state = 1;
            } else if (c == '\"') {
                this.state = 5;
                if (this.currentStringStart == -1) {
                    this.currentStringStart = this.position;
                }
            } else if (c == '\'') {
                this.state = 7;
            }
            return null;
        }

        protected HardCodedString handleStateJavaASlash(char c) {
            this.lastJavaString.append(c);
            if (c == '/') {
                this.state = 2;
            } else if (c == '*') {
                this.state = 3;
            }
            return null;
        }

        protected HardCodedString handleStateChar(char c) {
            this.lastJavaString.append(c);
            if (c == '\'') {
                this.state = 0;
            }
            return null;
        }

        protected HardCodedString handleStateStringABSlash(char c) {
            this.state = 5;
            return null;
        }

        protected HardCodedString handleStateLineComment(char c) {
            return null;
        }

        protected HardCodedString handleStateBlockComment(char c) {
            if (c == '*') {
                this.state = 4;
            }
            return null;
        }

        protected HardCodedString handleStateBlockCommentAStar(char c) {
            if (c == '/') {
                this.state = 0;
                this.initJavaStringBuffer();
            } else if (c != '*') {
                this.state = 3;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected HardCodedString handleStateString(char c) {
            if (c == '\\') {
                this.state = 6;
            } else if (c == '\"') {
                this.state = 0;
                if (this.currentStringEnd == -1 && this.currentStringStart != -1) {
                    this.currentStringEnd = this.position + 1;
                    int n = this.currentStringEnd - this.currentStringStart;
                    try {
                        Position position = this.document.createPosition(this.currentStringStart);
                        Position position2 = this.document.createPosition(this.currentStringEnd);
                        String string = this.document.getText(position.getOffset(), n);
                        String string2 = new String(this.buffer, this.currentStringEnd, this.buffer.length - this.currentStringEnd);
                        int n2 = string2.indexOf(10);
                        if (n2 == -1) {
                            n2 = string2.length();
                        }
                        this.lastJavaString.append(this.document.getText(this.currentStringStart + 1, string.length()));
                        String string3 = this.document.getText(this.currentStringStart + 1 + string.length(), this.currentStringEnd + n2 - this.currentStringStart - string.length());
                        this.lastJavaString.append(string3.replace('\"', '_'));
                        if (this.isSearchedString(this.lastJavaString.toString(), string)) {
                            this.lastPosition = position2;
                            HardCodedString hardCodedString = new HardCodedString(this.extractString(string), position, position2);
                            return hardCodedString;
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        ErrorManager.getDefault().notify(1, (Throwable)badLocationException);
                    }
                    finally {
                        this.currentStringStart = -1;
                        this.currentStringEnd = -1;
                        this.initJavaStringBuffer();
                    }
                }
            }
            return null;
        }

        private void initJavaStringBuffer() {
            this.lastJavaString = new StringBuffer();
        }

        private String extractString(String string) {
            if (string == null) {
                return "";
            }
            if (string.length() >= 2 && string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
                string = string.substring(1, string.length() - 1);
            }
            return string;
        }

        protected boolean isSearchedString(String string, String string2) {
            String string3 = UtilConvert.unicodesToChars((String)string);
            Exception exception = null;
            try {
                String string4 = this.createRegularExpression(string2);
                return Pattern.compile(string4).matcher(string3).find() == this.i18nSearch;
            }
            catch (ParseException parseException) {
                exception = parseException;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                exception = patternSyntaxException;
            }
            ErrorManager.getDefault().notify(1, (Throwable)exception);
            String string5 = MessageFormat.format(Util.getString("MSG_RegExpCompileError"), string2);
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)string5, 0, 0));
            return NotifyDescriptor.YES_OPTION.equals(object);
        }

        private String createRegularExpression(String string) throws ParseException {
            String string2 = this.i18nSearch ? I18nUtil.getOptions().getI18nRegularExpression() : I18nUtil.getOptions().getRegularExpression();
            HashMap<String, String> hashMap = new HashMap<String, String>(3);
            hashMap.put("key", string);
            hashMap.put("hardString", string);
            return Translator.translateRegexp(string2, hashMap);
        }
    }
}

