/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.regexp;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.i18n.regexp.TreeNode;

class Generator {
    private StringBuffer buf = new StringBuffer(20);
    private Map tokenReplacements;
    private boolean generatingSetOfChars = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    Generator() {
    }

    public static String generateRegexp(TreeNode treeNode) {
        return Generator.generateRegexp(treeNode, null);
    }

    public static String generateRegexp(TreeNode treeNode, Map map) {
        if (treeNode == null) {
            return null;
        }
        Generator generator = new Generator();
        generator.setTokenReplacements(map);
        generator.generate(treeNode);
        return generator.buf.toString();
    }

    private static String quoteString(String string) {
        StringBuffer stringBuffer;
        if (string.length() == 0) {
            return string;
        }
        int n = 0;
        int n2 = string.indexOf(92);
        if (n2 == -1) {
            stringBuffer = new StringBuffer(string.length() + 4);
            stringBuffer.append("\\Q").append(string).append("\\E");
        } else {
            stringBuffer = new StringBuffer(string.length() + 16);
            do {
                if (n2 != n) {
                    stringBuffer.append("\\Q");
                    stringBuffer.append(string.substring(n, n2));
                    stringBuffer.append("\\E");
                }
                stringBuffer.append('\\').append('\\');
            } while ((n2 = string.indexOf(92, n = n2 + 1)) != -1);
            if (n != string.length()) {
                stringBuffer.append("\\Q");
                stringBuffer.append(string.substring(n));
                stringBuffer.append("\\E");
            }
        }
        return stringBuffer.toString();
    }

    private void setTokenReplacements(Map map) {
        if (map != null && map.isEmpty()) {
            map = null;
        }
        this.tokenReplacements = map;
        if (map != null) {
            this.quoteTokenReplacements();
        }
    }

    private void quoteTokenReplacements() {
        if (this.tokenReplacements == null || this.tokenReplacements.isEmpty()) {
            return;
        }
        Set set = this.tokenReplacements.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            entry.setValue(Generator.quoteString((String)entry.getValue()));
        }
    }

    private void generate(TreeNode treeNode) {
        List list = treeNode.getChildren();
        int n = treeNode.getTokenType();
        Object object = treeNode.getAttribs();
        block0 : switch (n) {
            case 8: {
                char c = ((Character)object).charValue();
                switch (c) {
                    case '\t': {
                        this.buf.append('\\').append('t');
                        break block0;
                    }
                    case '\n': {
                        this.buf.append('\\').append('n');
                        break block0;
                    }
                    case '\r': {
                        this.buf.append('\\').append('r');
                        break block0;
                    }
                    case '\f': {
                        this.buf.append('\\').append('f');
                        break block0;
                    }
                    case '\\': {
                        this.buf.append('\\').append('\\');
                        break block0;
                    }
                }
                if (!this.generatingSetOfChars && "^$|*+?.()[]{}".indexOf(c) != -1) {
                    this.buf.append('\\');
                }
                this.buf.append(c);
                break;
            }
            case 6: {
                char c = ((Character)object).charValue();
                if (c == '.') {
                    this.buf.append('.');
                    break;
                }
                this.buf.append('\\').append(c);
                break;
            }
            case 4: {
                if (object instanceof Character) {
                    char c = ((Character)object).charValue();
                    this.buf.append(c);
                    break;
                }
                String string = (String)object;
                this.buf.append('{');
                this.generate((TreeNode)list.get(0));
                if (string.length() > 3) {
                    this.buf.append(',');
                    if (string.length() == 5) {
                        this.generate((TreeNode)list.get(1));
                    }
                }
                this.buf.append('}');
                break;
            }
            case 3: {
                this.generate((TreeNode)list.get(0));
                if (list.size() != 2) break;
                this.generate((TreeNode)list.get(1));
                break;
            }
            case 12: {
                this.generate((TreeNode)list.get(0));
                this.buf.append('-');
                this.generate((TreeNode)list.get(1));
                break;
            }
            case 11: {
                this.buf.append('[');
                if (object != null) {
                    this.buf.append((String)object);
                }
                if (list != null) {
                    this.generatingSetOfChars = true;
                    if (list.size() == 1) {
                        this.generate((TreeNode)list.get(0));
                    } else {
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            this.generate((TreeNode)iterator.next());
                        }
                    }
                    this.generatingSetOfChars = false;
                }
                this.buf.append(']');
                break;
            }
            case 2: {
                if (list == null) break;
                if (list.size() == 1) {
                    this.generate((TreeNode)list.get(0));
                    break;
                }
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    this.generate((TreeNode)iterator.next());
                }
                break;
            }
            case 9: {
                this.buf.append('(').append('?').append(':');
                this.generate((TreeNode)list.get(0));
                this.buf.append(')');
                break;
            }
            case 1: {
                this.generate((TreeNode)list.get(0));
                if (list.size() <= 1) break;
                Iterator iterator = list.iterator();
                iterator.next();
                do {
                    this.buf.append('|');
                    this.generate((TreeNode)iterator.next());
                } while (iterator.hasNext());
                break;
            }
            case 5: {
                this.buf.append(object.toString());
                break;
            }
            case 7: {
                int n2 = (Integer)object;
                this.buf.append((char)n2);
                break;
            }
            case 10: {
                this.buf.append('\\').append('p');
                this.buf.append('{');
                String string = (String)object;
                if (string.equals("ascii")) {
                    this.buf.append("ASCII");
                } else if (string.equals("xdigit")) {
                    this.buf.append("XDigit");
                } else {
                    this.buf.append(Character.toUpperCase(string.charAt(0)));
                    this.buf.append(string.substring(1));
                }
                this.buf.append('}');
                break;
            }
            case 0: {
                String string = (String)object;
                if (string != null && string.charAt(0) == '^') {
                    this.buf.append('^');
                }
                if (list != null) {
                    this.generate((TreeNode)list.get(0));
                }
                if (string == null || string.length() != 2 && string.charAt(0) != '$') break;
                this.buf.append('$');
                break;
            }
            case 13: {
                Object object2;
                String string = (String)object;
                Object object3 = object2 = this.tokenReplacements != null ? (Object)this.tokenReplacements.get(string) : null;
                if (object2 != null) {
                    this.buf.append('(').append('?').append(':');
                    this.buf.append(object2.toString());
                    this.buf.append(')');
                    break;
                }
                this.buf.append('{').append(string).append('}');
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
    }

    static {
        $assertionsDisabled = !Generator.class.desiredAssertionStatus();
    }
}

