/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.regexp;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.netbeans.modules.i18n.regexp.ParseException;
import org.netbeans.modules.i18n.regexp.TreeNode;
import org.netbeans.modules.i18n.regexp.TreeNodeRoot;

public class Parser {
    private String regexp;
    private String[] tokenNames;
    private int maxTokenLength;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static TreeNodeRoot parse(String string) throws IllegalArgumentException, ParseException {
        return Parser.parse(string, null);
    }

    public static TreeNodeRoot parse(String string, String[] stringArray) throws IllegalArgumentException, ParseException {
        Parser parser = new Parser(string);
        if (stringArray != null && stringArray.length != 0) {
            parser.setTokenNames(stringArray);
        }
        return parser.parse();
    }

    Parser(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.regexp = string;
    }

    private void setTokenNames(String[] stringArray) {
        if (stringArray != null && stringArray.length != 0) {
            this.tokenNames = stringArray;
            this.maxTokenLength = stringArray[0].length();
            for (int i = 1; i < stringArray.length; ++i) {
                if (stringArray[i].length() <= this.maxTokenLength) continue;
                this.maxTokenLength = stringArray[i].length();
            }
        } else {
            this.tokenNames = null;
            this.maxTokenLength = 0;
        }
    }

    TreeNodeRoot parse() throws ParseException {
        TreeNode treeNode = null;
        int n = 0;
        int n2 = this.regexp.length();
        boolean bl = false;
        boolean bl2 = false;
        if (n == n2) {
            return null;
        }
        if (this.regexp.charAt(0) == '^') {
            bl = true;
            ++n;
        }
        if (n2 == n + 1 && this.regexp.charAt(n) == '$') {
            bl2 = true;
            --n2;
        }
        if (n != n2) {
            treeNode = this.parseMultiRegexp(n, n2);
            if (treeNode == null) {
                this.throwParseException(n);
            }
            if (treeNode.end == n2 - 1 && this.regexp.charAt(n2 - 1) == '$') {
                bl2 = true;
                --n2;
            }
            if (treeNode.end != n2) {
                this.throwParseException(n);
            }
        }
        String string = null;
        if (bl || bl2) {
            StringBuffer stringBuffer = new StringBuffer(2);
            if (bl) {
                stringBuffer.append('^');
            }
            if (bl2) {
                stringBuffer.append('$');
            }
            string = stringBuffer.toString();
        }
        TreeNodeRoot treeNodeRoot = new TreeNodeRoot(this.regexp, string);
        if (treeNode != null) {
            treeNodeRoot.add(treeNode);
        }
        return treeNodeRoot;
    }

    private void throwParseException(int n) throws ParseException {
        throw new ParseException(this.regexp, n);
    }

    private TreeNode parseMultiRegexp(int n, int n2) throws ParseException {
        if (n == n2) {
            return null;
        }
        TreeNode treeNode = this.parseRegexpSequence(n, n2);
        if (treeNode == null) {
            return null;
        }
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>(4);
        arrayList.add(treeNode);
        while (treeNode.end != n2 && this.regexp.charAt(treeNode.end) == '|') {
            int n3 = treeNode.end + 1;
            treeNode = this.parseRegexpSequence(n3, n2);
            if (treeNode == null) {
                this.throwParseException(n3);
            }
            arrayList.add(treeNode);
        }
        TreeNode treeNode2 = new TreeNode(1, n, treeNode.end);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            treeNode2.add((TreeNode)iterator.next());
        }
        return treeNode2;
    }

    private TreeNode parseRegexpSequence(int n, int n2) throws ParseException {
        Object object;
        if (n == n2) {
            return null;
        }
        ArrayList<TreeNode> arrayList = null;
        TreeNode treeNode = null;
        int n3 = n;
        while ((object = this.parseQRegexp(n3, n2)) != null) {
            if (arrayList == null) {
                arrayList = new ArrayList<TreeNode>(4);
            }
            arrayList.add((TreeNode)object);
            treeNode = object;
            if (((TreeNode)object).end == n2) break;
            n3 = ((TreeNode)object).end;
        }
        if (arrayList == null) {
            return null;
        }
        TreeNode treeNode2 = new TreeNode(2, n, treeNode.end);
        object = arrayList.iterator();
        while (object.hasNext()) {
            treeNode2.add((TreeNode)object.next());
        }
        return treeNode2;
    }

    private TreeNode parseQRegexp(int n, int n2) throws ParseException {
        TreeNode treeNode;
        if (n == n2) {
            return null;
        }
        TreeNode treeNode2 = this.parseSingleRegexp(n, n2);
        if (treeNode2 == null) {
            return null;
        }
        if (treeNode2.end == n2) {
            TreeNode treeNode3 = new TreeNode(3, n, treeNode2.end);
            treeNode3.add(treeNode2);
            return treeNode3;
        }
        TreeNode treeNode4 = this.parseQuantifier(treeNode2.end, n2);
        if (treeNode4 == null) {
            treeNode = new TreeNode(3, n, treeNode2.end);
            treeNode.add(treeNode2);
        } else {
            treeNode = new TreeNode(3, n, treeNode4.end);
            treeNode.add(treeNode2);
            treeNode.add(treeNode4);
        }
        return treeNode;
    }

    private TreeNode parseSingleRegexp(int n, int n2) throws ParseException {
        TreeNode treeNode;
        if (n == n2) {
            return null;
        }
        char c = this.regexp.charAt(n);
        block0 : switch (c) {
            case '.': {
                treeNode = new TreeNode(6, n, n + 1, new Character(c));
                break;
            }
            case '[': {
                TreeNode treeNode2 = this.parseSet(n, n2);
                if (!$assertionsDisabled && treeNode2 == null) {
                    throw new AssertionError();
                }
                return treeNode2;
            }
            case '(': {
                TreeNode treeNode3 = this.parseSubexpr(n, n2);
                if (!$assertionsDisabled && treeNode3 == null) {
                    throw new AssertionError();
                }
                return treeNode3;
            }
            case '\\': {
                char c2;
                if (n2 == n + 1) {
                    this.throwParseException(n2);
                }
                char c3 = this.regexp.charAt(n + 1);
                switch (c3) {
                    case 'B': 
                    case 'b': {
                        treeNode = new TreeNode(6, n, n + 2, new Character(c3));
                        break block0;
                    }
                    case 'u': {
                        Integer n3 = this.parseUnicode(n + 2, n2);
                        if (n3 == null) {
                            this.throwParseException(n + 2);
                        }
                        treeNode = new TreeNode(7, n, n + 6, n3);
                        break block0;
                    }
                }
                switch (c3) {
                    case 't': {
                        c2 = '\t';
                        break;
                    }
                    case 'n': {
                        c2 = '\n';
                        break;
                    }
                    case 'r': {
                        c2 = '\r';
                        break;
                    }
                    case 'f': {
                        c2 = '\f';
                        break;
                    }
                    default: {
                        c2 = c3;
                    }
                }
                treeNode = new TreeNode(8, n, n + 2, new Character(c2));
                break;
            }
            case '{': {
                String string = this.getTokenName(n, n2);
                if (string != null) {
                    treeNode = new TreeNode(13, n, n + string.length() + 2, string);
                    break;
                }
            }
            default: {
                if ("^$|*+?)]{}".indexOf(c) != -1) {
                    return null;
                }
                treeNode = new TreeNode(8, n, n + 1, new Character(c));
            }
        }
        return treeNode;
    }

    private TreeNode parseQuantifier(int n, int n2) throws ParseException {
        TreeNode treeNode;
        if (n == n2) {
            return null;
        }
        TreeNode treeNode2 = null;
        char c = this.regexp.charAt(n);
        switch (c) {
            case '*': 
            case '+': 
            case '?': {
                treeNode2 = new TreeNode(4, n, n + 1, new Character(c));
                return treeNode2;
            }
            case '{': {
                break;
            }
            default: {
                return null;
            }
        }
        if (n2 - n == 1) {
            this.throwParseException(n + 1);
        }
        if ((treeNode = this.parseNumber(n + 1, n2)) == null) {
            if (this.getTokenName(n, n2) != null) {
                return null;
            }
            this.throwParseException(n + 1);
        }
        if (treeNode.end == n2) {
            this.throwParseException(treeNode.end);
        }
        switch (this.regexp.charAt(treeNode.end)) {
            case '}': {
                treeNode2 = new TreeNode(4, n, treeNode.end + 1, "{n}");
                treeNode2.add(treeNode);
                return treeNode2;
            }
            case ',': {
                break;
            }
            default: {
                this.throwParseException(treeNode.end);
            }
        }
        if (treeNode.end + 1 == n2) {
            this.throwParseException(treeNode.end + 1);
        }
        if (this.regexp.charAt(treeNode.end + 1) == '}') {
            treeNode2 = new TreeNode(4, n, treeNode.end + 2, "{n,}");
            treeNode2.add(treeNode);
            return treeNode2;
        }
        TreeNode treeNode3 = this.parseNumber(treeNode.end + 1, n2);
        if (treeNode3 == null) {
            this.throwParseException(treeNode.end + 1);
        }
        if (treeNode3.end == n2 || this.regexp.charAt(treeNode3.end) != '}') {
            this.throwParseException(treeNode3.end);
        }
        int n3 = (Integer)treeNode.getAttribs();
        int n4 = (Integer)treeNode3.getAttribs();
        if (n4 < n3) {
            this.throwParseException(treeNode3.start);
        }
        treeNode2 = new TreeNode(4, n, treeNode3.end + 1, "{n,n}");
        treeNode2.add(treeNode);
        treeNode2.add(treeNode3);
        return treeNode2;
    }

    private TreeNode parseNumber(int n, int n2) throws ParseException {
        int n3;
        if (n == n2) {
            return null;
        }
        char[] cArray = this.regexp.substring(n, n2).toCharArray();
        int n4 = cArray.length;
        for (n3 = 0; n3 < cArray.length; ++n3) {
            if (cArray[n3] >= '0' && cArray[n3] <= '9') continue;
            n4 = n3;
            break;
        }
        if (n4 == 0) {
            return null;
        }
        if (n4 > 3) {
            this.throwParseException(n);
        }
        if (n4 == 1) {
            n3 = cArray[0] - 48;
        } else {
            try {
                n3 = Integer.parseInt(this.regexp.substring(n, n + n4));
            }
            catch (NumberFormatException numberFormatException) {
                throw new AssertionError();
            }
        }
        TreeNode treeNode = new TreeNode(5, n, n + n4, new Integer(n3));
        return treeNode;
    }

    private String getTokenName(int n, int n2) {
        if (this.tokenNames == null) {
            return null;
        }
        int n3 = Math.min(n2 - n, this.maxTokenLength + 2);
        String string = this.regexp.substring(n, n + n3);
        if (string.charAt(0) != '{') {
            return null;
        }
        int n4 = string.indexOf(125, 1);
        if (n4 == -1) {
            return null;
        }
        String string2 = string.substring(1, n4);
        for (int i = 0; i < this.tokenNames.length; ++i) {
            if (!string2.equals(this.tokenNames[i])) continue;
            return string2;
        }
        return null;
    }

    private Integer parseUnicode(int n, int n2) throws ParseException {
        Integer n3;
        if (n == n2) {
            return null;
        }
        if (n2 - n < 4) {
            this.throwParseException(n);
        }
        char[] cArray = this.regexp.substring(n, n + 4).toCharArray();
        for (int i = 0; i < 4; ++i) {
            char c = cArray[i];
            if ("01234567890abcdefABCDEF".indexOf(c) != -1) continue;
            if (i == 0) {
                return null;
            }
            this.throwParseException(n);
        }
        try {
            n3 = Integer.valueOf(this.regexp.substring(n, n + 4), 16);
        }
        catch (NumberFormatException numberFormatException) {
            throw new AssertionError();
        }
        return n3;
    }

    private TreeNode parseSubexpr(int n, int n2) throws ParseException {
        TreeNode treeNode;
        if (n == n2) {
            return null;
        }
        if (this.regexp.charAt(n) != '(') {
            return null;
        }
        if (n2 == n + 1) {
            this.throwParseException(n + 1);
        }
        if ((treeNode = this.parseMultiRegexp(n + 1, n2)) == null) {
            this.throwParseException(n + 1);
        }
        if (treeNode.end == n2 || this.regexp.charAt(treeNode.end) != ')') {
            this.throwParseException(treeNode.end);
        }
        TreeNode treeNode2 = new TreeNode(9, n, treeNode.end + 1);
        treeNode2.add(treeNode);
        return treeNode2;
    }

    private TreeNode parseSet(int n, int n2) throws ParseException {
        String string;
        String string2;
        int n3;
        if (n == n2) {
            return null;
        }
        if (this.regexp.charAt(n) != '[') {
            return null;
        }
        if (n2 == n + 1) {
            this.throwParseException(n + 1);
        }
        if ((n3 = (string2 = this.regexp.substring(n, n2)).indexOf(93, 1 + (string = this.getSpecials(string2)).length())) == -1) {
            this.throwParseException(n);
        } else {
            ++n3;
        }
        string2 = this.regexp.substring(n, n3 += n);
        int n4 = string2.length();
        if (n4 >= 5 && string2.charAt(1) == ':' && string2.charAt(n4 - 2) == ':') {
            String string3 = string2.substring(2, n4 - 2);
            if (this.isPosixCharClass(string3)) {
                TreeNode treeNode = new TreeNode(10, n, n3, string3);
                return treeNode;
            }
            this.throwParseException(n + 2);
        }
        TreeNode treeNode = new TreeNode(11, n, n3, string);
        int n5 = n + 1 + string.length();
        int n6 = n3 - 1;
        while (n5 != n6) {
            TreeNode treeNode2 = this.parseRangeOrChar(n5, n6);
            if (treeNode2 == null) {
                this.throwParseException(n5);
            }
            treeNode.add(treeNode2);
            n5 = treeNode2.end;
        }
        return treeNode;
    }

    private TreeNode parseRangeOrChar(int n, int n2) throws ParseException {
        int n3;
        Object object;
        if (n == n2) {
            return null;
        }
        TreeNode treeNode = this.parseRangeChar(n, n2);
        if (treeNode == null) {
            return null;
        }
        if (treeNode.end == n2 || this.regexp.charAt(treeNode.end) != '-') {
            return treeNode;
        }
        TreeNode treeNode2 = this.parseRangeChar(treeNode.end + 1, n2);
        if (treeNode2 == null) {
            this.throwParseException(treeNode.end + 1);
        }
        int n4 = (object = treeNode.getAttribs()) instanceof Character ? Character.getNumericValue(((Character)object).charValue()) : (Integer)object;
        object = treeNode2.getAttribs();
        int n5 = n3 = object instanceof Character ? Character.getNumericValue(((Character)object).charValue()) : (Integer)object;
        if (n4 >= n3) {
            this.throwParseException(treeNode.end + 1);
        }
        TreeNode treeNode3 = new TreeNode(12, n, treeNode2.end);
        treeNode3.add(treeNode);
        treeNode3.add(treeNode2);
        return treeNode3;
    }

    private TreeNode parseRangeChar(int n, int n2) throws ParseException {
        TreeNode treeNode;
        if (n == n2) {
            return null;
        }
        char c = this.regexp.charAt(n);
        switch (c) {
            case '-': 
            case ']': {
                return null;
            }
            case '\\': {
                char c2;
                if (n2 == n + 1) {
                    this.throwParseException(n + 1);
                }
                char c3 = this.regexp.charAt(n + 1);
                switch (c3) {
                    case 'u': {
                        Integer n3 = this.parseUnicode(n + 2, n2);
                        if (n3 == null) {
                            this.throwParseException(n + 2);
                        }
                        int n4 = n3;
                        if (!$assertionsDisabled && n4 < 0) {
                            throw new AssertionError();
                        }
                        if (n4 <= 127) {
                            this.throwParseException(n + 2);
                        }
                        return new TreeNode(7, n, n + 6, n3);
                    }
                    case '-': 
                    case ']': {
                        this.throwParseException(n + 2);
                    }
                    case 't': {
                        c2 = '\t';
                        break;
                    }
                    case 'n': {
                        c2 = '\n';
                        break;
                    }
                    case 'r': {
                        c2 = '\r';
                        break;
                    }
                    case 'f': {
                        c2 = '\f';
                        break;
                    }
                    default: {
                        c2 = c3;
                    }
                }
                treeNode = new TreeNode(8, n, n + 2, new Character(c2));
                break;
            }
            default: {
                treeNode = new TreeNode(8, n, n + 1, new Character(c));
            }
        }
        return treeNode;
    }

    private String getSpecials(String string) {
        int n = 1;
        int n2 = 3;
        if (string.length() < 5) {
            n2 = string.length() - 2;
        }
        StringBuffer stringBuffer = new StringBuffer(n2 - n + 1);
        char c = string.charAt(n);
        if (c == '^') {
            stringBuffer.append(c);
            if (n == n2) {
                return stringBuffer.toString();
            }
            c = string.charAt(++n);
        }
        if (c == ']') {
            stringBuffer.append(c);
            if (n == n2) {
                return stringBuffer.toString();
            }
            c = string.charAt(++n);
        }
        if (c == '-') {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private boolean isPosixCharClass(String string) {
        if (string.equals("xdigit")) {
            return true;
        }
        if (string.length() != 5) {
            return false;
        }
        String string2 = "alnum alpha blank cntrl digit graph lower print punct space upper";
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
        while (stringTokenizer.hasMoreTokens()) {
            if (!string.equals(stringTokenizer.nextToken())) continue;
            return true;
        }
        return false;
    }

    static {
        $assertionsDisabled = !Parser.class.desiredAssertionStatus();
    }
}

