/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.wizard;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

final class I18nWizardDescriptor
extends WizardDescriptor {
    public static final Dimension PREFERRED_DIMENSION = new Dimension(500, 300);
    private final WizardDescriptor.Iterator panels;
    private final Settings settings;
    private final JButton nextButton = new JButton();
    private final JButton previousButton = new JButton();
    private final JButton finishButton = new JButton();
    private final JButton cancelButton = new JButton();
    private PropertyChangeListener rootListener;
    static /* synthetic */ Class class$java$awt$Dialog;

    private I18nWizardDescriptor(WizardDescriptor.Iterator iterator, Settings settings) {
        super(iterator, (Object)settings);
        Listener listener = new Listener();
        this.nextButton.setText(NbBundle.getBundle((Class)I18nWizardDescriptor.class).getString("CTL_Next"));
        this.nextButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)I18nWizardDescriptor.class).getString("ACSD_NEXT"));
        this.previousButton.setText(NbBundle.getBundle((Class)I18nWizardDescriptor.class).getString("CTL_Previous"));
        this.previousButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)I18nWizardDescriptor.class).getString("ACSD_PREVIOUS"));
        this.finishButton.setText(NbBundle.getBundle((Class)I18nWizardDescriptor.class).getString("CTL_Finish"));
        this.finishButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)I18nWizardDescriptor.class).getString("ACSD_FINISH"));
        this.cancelButton.setText(NbBundle.getBundle((Class)I18nWizardDescriptor.class).getString("CTL_Cancel"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)I18nWizardDescriptor.class).getString("ACSD_CANCEL"));
        this.nextButton.addActionListener(listener);
        this.previousButton.addActionListener(listener);
        this.finishButton.addActionListener(listener);
        this.cancelButton.addActionListener(listener);
        this.nextButton.setMnemonic(NbBundle.getBundle((Class)I18nWizardDescriptor.class).getString("CTL_Next_Mnem").charAt(0));
        this.previousButton.setMnemonic(NbBundle.getBundle((Class)I18nWizardDescriptor.class).getString("CTL_Previous_Mnem").charAt(0));
        this.setOptions(new Object[]{this.previousButton, this.nextButton, this.finishButton, this.cancelButton});
        this.setClosingOptions(new Object[]{this.cancelButton});
        this.panels = iterator;
        this.settings = settings;
    }

    static WizardDescriptor createI18nWizardDescriptor(WizardDescriptor.Iterator iterator, Settings settings) {
        return new I18nWizardDescriptor(iterator, settings);
    }

    protected synchronized void updateState() {
        super.updateState();
        WizardDescriptor.Panel panel = this.panels.current();
        boolean bl = this.panels.hasNext();
        boolean bl2 = this.panels.hasPrevious();
        boolean bl3 = panel.isValid();
        this.nextButton.setEnabled(bl && bl3);
        this.previousButton.setEnabled(bl2);
        this.finishButton.setEnabled(bl3 && (!bl || panel instanceof WizardDescriptor.FinishablePanel && ((WizardDescriptor.FinishablePanel)panel).isFinishPanel()));
        if (bl) {
            this.setValue(this.nextButton);
        } else {
            this.setValue(this.finishButton);
        }
        this.setHelpCtx(panel.getHelp());
        this.updateDefaultButton();
    }

    private void updateDefaultButton() {
        JRootPane jRootPane = this.getRootPane();
        if (jRootPane == null) {
            return;
        }
        WizardDescriptor.Panel panel = this.panels.current();
        if (panel instanceof WizardDescriptor.FinishablePanel && ((WizardDescriptor.FinishablePanel)panel).isFinishPanel()) {
            jRootPane.setDefaultButton(this.finishButton);
        } else {
            jRootPane.setDefaultButton(this.nextButton);
        }
    }

    private JRootPane getRootPane() {
        JRootPane jRootPane = null;
        Component component = this.panels.current().getComponent();
        if (component instanceof JComponent) {
            jRootPane = ((JComponent)component).getRootPane();
        }
        if (jRootPane != null && this.rootListener == null) {
            this.rootListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Object object;
                    if ("defaultButton".equals(propertyChangeEvent.getPropertyName()) && (object = propertyChangeEvent.getNewValue()) != I18nWizardDescriptor.this.nextButton && object != I18nWizardDescriptor.this.finishButton) {
                        RequestProcessor.getDefault().post(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                I18nWizardDescriptor.access$400(1.access$300(this.this$1));
                            }
                        });
                    }
                }

                static /* synthetic */ I18nWizardDescriptor access$300(1 var0) {
                    return var0.I18nWizardDescriptor.this;
                }
            };
            jRootPane.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.rootListener, (Object)jRootPane));
        }
        return jRootPane;
    }

    static /* synthetic */ void access$400(I18nWizardDescriptor i18nWizardDescriptor) {
        i18nWizardDescriptor.updateDefaultButton();
    }

    public static class Settings {
        public Map map;
        public Project project;

        public Settings(Map map, Project project) {
            this.map = map;
            this.project = project;
        }
    }

    public static abstract class Panel
    implements WizardDescriptor.Panel {
        private Component component;
        private ChangeListener changeListener;
        private Settings settings = null;

        public final synchronized Component getComponent() {
            if (this.component == null) {
                this.component = this.createComponent();
            }
            return this.component;
        }

        protected abstract Component createComponent();

        public boolean isValid() {
            return true;
        }

        public void readSettings(Object object) {
            this.settings = (Settings)object;
        }

        public void storeSettings(Object object) {
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.changeListener = changeListener;
        }

        public void removeChangeListener(ChangeListener changeListener) {
            if (this.changeListener != null && this.changeListener == changeListener) {
                this.changeListener = null;
            }
        }

        public final void fireStateChanged() {
            if (this.changeListener != null) {
                this.changeListener.stateChanged(new ChangeEvent(this));
            }
        }

        public Project getProject() {
            return this.settings.project;
        }

        public Map getMap() {
            return this.settings.map;
        }
    }

    public static interface ProgressMonitor {
        public void doLongTimeChanges();

        public void reset();
    }

    private abstract class ProgressThread
    implements Runnable {
        private ProgressMonitor progressMonitor;

        public ProgressThread(ProgressMonitor progressMonitor) {
            this.progressMonitor = progressMonitor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                I18nWizardDescriptor.this.previousButton.setEnabled(false);
                I18nWizardDescriptor.this.nextButton.setEnabled(false);
                I18nWizardDescriptor.this.finishButton.setEnabled(false);
                I18nWizardDescriptor.this.cancelButton.setEnabled(false);
                this.progressMonitor.doLongTimeChanges();
                this.handleAction();
                Object var2_1 = null;
                this.progressMonitor.reset();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.progressMonitor.reset();
                I18nWizardDescriptor.this.cancelButton.setEnabled(true);
                throw throwable;
            }
            I18nWizardDescriptor.this.cancelButton.setEnabled(true);
        }

        public abstract void handleAction();
    }

    private class Listener
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == I18nWizardDescriptor.this.nextButton) {
                WizardDescriptor.Panel panel = I18nWizardDescriptor.this.panels.current();
                if (panel instanceof ProgressMonitor) {
                    RequestProcessor.getDefault().post((Runnable)new ProgressThread(this, (ProgressMonitor)panel){
                        private final /* synthetic */ Listener this$1;
                        {
                            this.this$1 = listener;
                            super(progressMonitor);
                        }

                        public void handleAction() {
                            Listener.access$700(this.this$1);
                        }
                    });
                } else {
                    this.handleNextButton();
                }
            } else if (actionEvent.getSource() == I18nWizardDescriptor.this.previousButton) {
                I18nWizardDescriptor.this.panels.previousPanel();
                I18nWizardDescriptor.this.updateState();
            } else if (actionEvent.getSource() == I18nWizardDescriptor.this.finishButton) {
                WizardDescriptor.Panel panel = I18nWizardDescriptor.this.panels.current();
                panel.storeSettings((Object)I18nWizardDescriptor.this.settings);
                I18nWizardDescriptor.this.setValue(NotifyDescriptor.OK_OPTION);
                if (panel instanceof ProgressMonitor) {
                    RequestProcessor.getDefault().post((Runnable)new ProgressThread(this, (ProgressMonitor)panel, panel){
                        private final /* synthetic */ WizardDescriptor.Panel val$current;
                        private final /* synthetic */ Listener this$1;
                        {
                            this.this$1 = listener;
                            this.val$current = panel;
                            super(progressMonitor);
                        }

                        public void handleAction() {
                            Dialog dialog = (Dialog)SwingUtilities.getAncestorOfClass(class$java$awt$Dialog == null ? (class$java$awt$Dialog = I18nWizardDescriptor.class$("java.awt.Dialog")) : class$java$awt$Dialog, this.val$current.getComponent());
                            dialog.setVisible(false);
                            dialog.dispose();
                        }
                    });
                }
            } else if (actionEvent.getSource() == I18nWizardDescriptor.this.cancelButton) {
                I18nWizardDescriptor.this.panels.current().storeSettings((Object)I18nWizardDescriptor.this.settings);
                I18nWizardDescriptor.this.setValue(NotifyDescriptor.CANCEL_OPTION);
            }
        }

        private void handleNextButton() {
            Runnable runnable = new Runnable(this){
                private final /* synthetic */ Listener this$1;
                {
                    this.this$1 = listener;
                }

                public void run() {
                    I18nWizardDescriptor.access$500(Listener.access$600(this.this$1)).nextPanel();
                    try {
                        Listener.access$600(this.this$1).updateState();
                    }
                    catch (IllegalStateException illegalStateException) {
                        I18nWizardDescriptor.access$500(Listener.access$600(this.this$1)).previousPanel();
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)illegalStateException.getMessage()));
                        Listener.access$600(this.this$1).updateState();
                    }
                    WizardDescriptor.Panel panel = I18nWizardDescriptor.access$500(Listener.access$600(this.this$1)).current();
                    panel.getComponent().requestFocus();
                }
            };
            Mutex.EVENT.writeAccess(runnable);
        }

        static /* synthetic */ I18nWizardDescriptor access$600(Listener listener) {
            return listener.I18nWizardDescriptor.this;
        }

        static /* synthetic */ void access$700(Listener listener) {
            listener.handleNextButton();
        }
    }
}

