/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.i18n.FactoryRegistry;
import org.netbeans.modules.i18n.HardCodedString;
import org.netbeans.modules.i18n.I18nString;
import org.netbeans.modules.i18n.I18nSupport;
import org.netbeans.modules.i18n.SelectorUtils;
import org.netbeans.modules.i18n.wizard.I18nWizardDescriptor;
import org.netbeans.modules.i18n.wizard.ProgressWizardPanel;
import org.netbeans.modules.i18n.wizard.SourceData;
import org.netbeans.modules.i18n.wizard.Util;
import org.netbeans.modules.properties.UtilConvert;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class ResourceWizardPanel
extends JPanel {
    private final Map sourceMap = Util.createWizardSourceMap();
    private final ResourceTableModel tableModel = new ResourceTableModel();
    private final Panel descPanel;
    private final boolean testMode;
    private JButton addAllButton;
    private JButton addButton;
    private JTextArea descTextArea;
    private JScrollPane jScrollPane1;
    private JTable resourcesTable;

    private ResourceWizardPanel(Panel panel, boolean bl) {
        this.descPanel = panel;
        this.testMode = bl;
        this.initComponents();
        this.postInitComponents();
        this.initTable();
        this.initAccesibility();
    }

    public Map getSourceMap() {
        return this.sourceMap;
    }

    public void setSourceMap(Map map) {
        this.sourceMap.clear();
        this.sourceMap.putAll(map);
        this.tableModel.fireTableDataChanged();
        this.descPanel.fireStateChanged();
    }

    private String getPanelDescription() {
        if (!this.testMode) {
            return Util.getString("MSG_ResourcePanel_desc");
        }
        return Util.getString("MSG_ResourcePanel_test_desc");
    }

    private void postInitComponents() {
        this.addAllButton.setMnemonic(NbBundle.getBundle(this.getClass()).getString("CTL_SelectResourceAll_Mnem").charAt(0));
        this.addButton.setMnemonic(NbBundle.getBundle(this.getClass()).getString("CTL_SelectResource_Mnem").charAt(0));
    }

    private void initTable() {
        this.resourcesTable.setDefaultRenderer(DataObject.class, new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                DataObject dataObject = (DataObject)object;
                if (dataObject != null) {
                    String string = "N/A";
                    if (n2 == 0) {
                        ClassPath classPath = ClassPath.getClassPath((FileObject)dataObject.getPrimaryFile(), (String)"classpath/source");
                        string = classPath.getResourceName(dataObject.getPrimaryFile(), '.', false);
                    } else {
                        DataObject dataObject2 = (DataObject)ResourceWizardPanel.this.tableModel.getValueAt(n, 0);
                        string = Util.getResourceName(dataObject2.getPrimaryFile(), dataObject.getPrimaryFile(), '.', false);
                    }
                    jLabel.setText(string);
                    jLabel.setIcon(new ImageIcon(dataObject.getNodeDelegate().getIcon(1)));
                } else {
                    jLabel.setText("");
                    jLabel.setIcon(null);
                }
                return jLabel;
            }
        });
        Component component = new DefaultTableCellRenderer().getTableCellRendererComponent(this.resourcesTable, "N/A", false, false, 0, 0);
        int n = component.getPreferredSize().height;
        int n2 = n + this.resourcesTable.getRowMargin();
        this.resourcesTable.setRowHeight(Math.max(16, n2));
        this.resourcesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ResourceWizardPanel.this.addButton.setEnabled(!ResourceWizardPanel.this.resourcesTable.getSelectionModel().isSelectionEmpty());
            }
        });
        this.addButton.setEnabled(!this.resourcesTable.getSelectionModel().isSelectionEmpty());
    }

    private void initAccesibility() {
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)ResourceWizardPanel.class).getString("ACS_CTL_SelectResource"));
        this.addAllButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)ResourceWizardPanel.class).getString("ACS_CTL_SelectResourceAll"));
        this.resourcesTable.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)ResourceWizardPanel.class).getString("ACSD_resourcesTable"));
        this.resourcesTable.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)ResourceWizardPanel.class).getString("ACSN_resourcesTable"));
    }

    private void initComponents() {
        this.descTextArea = new JTextArea();
        this.jScrollPane1 = new JScrollPane();
        this.resourcesTable = new JTable();
        this.addAllButton = new JButton();
        this.addButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.descTextArea.setColumns(20);
        this.descTextArea.setEditable(false);
        this.descTextArea.setLineWrap(true);
        this.descTextArea.setText(this.getPanelDescription());
        this.descTextArea.setWrapStyleWord(true);
        this.descTextArea.setDisabledTextColor(new JLabel().getForeground());
        this.descTextArea.setEnabled(false);
        this.descTextArea.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.descTextArea, gridBagConstraints);
        this.resourcesTable.setModel(this.tableModel);
        this.jScrollPane1.setViewportView(this.resourcesTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.addAllButton.setText(NbBundle.getBundle((Class)ResourceWizardPanel.class).getString("CTL_SelectResourceAll"));
        this.addAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResourceWizardPanel.this.addAllButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 11, 0, 0);
        this.add((Component)this.addAllButton, gridBagConstraints);
        this.addButton.setText(NbBundle.getBundle((Class)ResourceWizardPanel.class).getString("CTL_SelectResource"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResourceWizardPanel.this.addButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 11, 0, 0);
        this.add((Component)this.addButton, gridBagConstraints);
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        DataObject dataObject = this.selectResource();
        if (dataObject == null) {
            return;
        }
        int[] nArray = this.resourcesTable.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            DataObject dataObject2 = (DataObject)this.resourcesTable.getValueAt(nArray[i], 0);
            this.sourceMap.put(dataObject2, new SourceData(dataObject));
            this.tableModel.fireTableCellUpdated(nArray[i], 1);
        }
        this.descPanel.fireStateChanged();
    }

    private void addAllButtonActionPerformed(ActionEvent actionEvent) {
        DataObject dataObject = this.selectResource();
        if (dataObject == null) {
            return;
        }
        for (int i = 0; i < this.resourcesTable.getRowCount(); ++i) {
            DataObject dataObject2 = (DataObject)this.resourcesTable.getValueAt(i, 0);
            this.sourceMap.put(dataObject2, new SourceData(dataObject));
            this.tableModel.fireTableCellUpdated(i, 1);
        }
        this.descPanel.fireStateChanged();
    }

    private DataObject selectResource() {
        Project project = null;
        FileObject fileObject = null;
        Iterator iterator = this.sourceMap.keySet().iterator();
        if (iterator.hasNext()) {
            DataObject dataObject = (DataObject)iterator.next();
            fileObject = dataObject.getPrimaryFile();
            project = FileOwnerQuery.getOwner((FileObject)fileObject);
        }
        return SelectorUtils.selectBundle(project, fileObject);
    }

    public static class Panel
    extends I18nWizardDescriptor.Panel
    implements I18nWizardDescriptor.ProgressMonitor {
        private transient ResourceWizardPanel resourcePanel;
        private boolean testWizard;

        public Panel() {
            this(false);
        }

        public Panel(boolean bl) {
            this.testWizard = bl;
        }

        protected Component createComponent() {
            JPanel jPanel = new JPanel();
            jPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel == null ? (class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel = ResourceWizardPanel.class$("org.netbeans.modules.i18n.wizard.ResourceWizardPanel")) : class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel)).getString("ACS_ResourceWizardPanel"));
            jPanel.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(1));
            if (this.testWizard) {
                jPanel.setName(NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel == null ? (class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel = ResourceWizardPanel.class$("org.netbeans.modules.i18n.wizard.ResourceWizardPanel")) : class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel)).getString("TXT_SelectTestResource"));
            } else {
                jPanel.setName(NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel == null ? (class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel = ResourceWizardPanel.class$("org.netbeans.modules.i18n.wizard.ResourceWizardPanel")) : class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel)).getString("TXT_SelectResource"));
            }
            jPanel.setPreferredSize(I18nWizardDescriptor.PREFERRED_DIMENSION);
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            jPanel.add((Component)this.getUI(), gridBagConstraints);
            return jPanel;
        }

        public boolean isValid() {
            return !this.getUI().getSourceMap().containsValue(null);
        }

        public void readSettings(Object object) {
            super.readSettings(object);
            this.getUI().setSourceMap(this.getMap());
        }

        public void storeSettings(Object object) {
            super.storeSettings(object);
            this.getMap().clear();
            this.getMap().putAll(this.getUI().getSourceMap());
        }

        public void doLongTimeChanges() {
            ProgressWizardPanel progressWizardPanel = new ProgressWizardPanel(false);
            this.showProgressPanel(progressWizardPanel);
            progressWizardPanel.setMainText(NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel == null ? (class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel = ResourceWizardPanel.class$("org.netbeans.modules.i18n.wizard.ResourceWizardPanel")) : class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel)).getString("TXT_Loading"));
            progressWizardPanel.setMainProgress(0);
            Map map = this.getUI().getSourceMap();
            Iterator iterator = map.keySet().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                block6: {
                    I18nSupport i18nSupport;
                    DataObject dataObject = (DataObject)iterator.next();
                    ClassPath classPath = ClassPath.getClassPath((FileObject)dataObject.getPrimaryFile(), (String)"classpath/source");
                    progressWizardPanel.setMainText(NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel == null ? ResourceWizardPanel.class$("org.netbeans.modules.i18n.wizard.ResourceWizardPanel") : class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel)).getString("TXT_Loading") + " " + classPath.getResourceName(dataObject.getPrimaryFile(), '.', false));
                    SourceData sourceData = (SourceData)map.get(dataObject);
                    try {
                        i18nSupport = FactoryRegistry.getFactory(dataObject.getClass()).create(dataObject);
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify(1, (Throwable)iOException);
                        map.remove(dataObject);
                        break block6;
                    }
                    sourceData = new SourceData(sourceData.getResource(), i18nSupport);
                    map.put(dataObject, sourceData);
                    classPath = ClassPath.getClassPath((FileObject)dataObject.getPrimaryFile(), (String)"classpath/source");
                    progressWizardPanel.setMainText(NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel == null ? ResourceWizardPanel.class$("org.netbeans.modules.i18n.wizard.ResourceWizardPanel") : class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel)).getString("TXT_SearchingIn") + " " + classPath.getResourceName(dataObject.getPrimaryFile(), '.', false));
                    Map map2 = sourceData.getStringMap();
                    HardCodedString[] hardCodedStringArray = this.testWizard ? i18nSupport.getFinder().findAllI18nStrings() : i18nSupport.getFinder().findAllHardCodedStrings();
                    if (hardCodedStringArray == null) {
                        sourceData.setStringMap(new HashMap(0));
                    } else {
                        HashMap<HardCodedString, I18nString> hashMap = new HashMap<HardCodedString, I18nString>(hardCodedStringArray.length);
                        for (int i = 0; i < hardCodedStringArray.length; ++i) {
                            if (this.testWizard && i18nSupport.getResourceHolder().getValueForKey(UtilConvert.escapePropertiesSpecialChars((String)hardCodedStringArray[i].getText())) != null) continue;
                            hashMap.put(hardCodedStringArray[i], i18nSupport.getDefaultI18nString(hardCodedStringArray[i]));
                        }
                        progressWizardPanel.setMainProgress((int)((float)(n + 1) / (float)map.size() * 100.0f));
                        sourceData.setStringMap(hashMap);
                    }
                }
                ++n;
            }
        }

        private void showProgressPanel(ProgressWizardPanel progressWizardPanel) {
            ((Container)this.getComponent()).remove(this.getUI());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            ((Container)this.getComponent()).add((Component)progressWizardPanel, gridBagConstraints);
            ((JComponent)this.getComponent()).revalidate();
            this.getComponent().repaint();
        }

        public void reset() {
            Container container = (Container)this.getComponent();
            if (!container.isAncestorOf(this.getUI())) {
                container.removeAll();
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 1;
                container.add((Component)this.getUI(), gridBagConstraints);
            }
        }

        public HelpCtx getHelp() {
            if (this.testWizard) {
                return new HelpCtx("internation.testing");
            }
            return new HelpCtx("internation.wizard");
        }

        private synchronized ResourceWizardPanel getUI() {
            if (this.resourcePanel == null) {
                this.resourcePanel = new ResourceWizardPanel(this, this.testWizard);
            }
            return this.resourcePanel;
        }
    }

    private class ResourceTableModel
    extends AbstractTableModel {
        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return ResourceWizardPanel.this.sourceMap.size();
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return ResourceWizardPanel.this.sourceMap.keySet().toArray()[n];
            }
            SourceData sourceData = (SourceData)ResourceWizardPanel.this.sourceMap.values().toArray()[n];
            return sourceData == null ? null : sourceData.getResource();
        }

        public Class getColumnClass(int n) {
            return class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = ResourceWizardPanel.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject;
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel == null ? (class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel = ResourceWizardPanel.class$("org.netbeans.modules.i18n.wizard.ResourceWizardPanel")) : class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel)).getString("CTL_Source");
            }
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel == null ? (class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel = ResourceWizardPanel.class$("org.netbeans.modules.i18n.wizard.ResourceWizardPanel")) : class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel)).getString("CTL_Resource");
        }
    }
}

