/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.wizard;

import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.netbeans.modules.i18n.HardCodedString;
import org.netbeans.modules.i18n.I18nSupport;
import org.openide.loaders.DataObject;

final class SourceData {
    private DataObject resource;
    private I18nSupport support;
    private Map stringMap = new TreeMap(new HardStringComparator());
    private Set removedStrings;

    public SourceData(DataObject dataObject) {
        this.resource = dataObject;
    }

    public SourceData(DataObject dataObject, I18nSupport i18nSupport) {
        this.resource = dataObject;
        this.support = i18nSupport;
        i18nSupport.getResourceHolder().setResource(dataObject);
    }

    public DataObject getResource() {
        return this.resource;
    }

    public I18nSupport getSupport() {
        return this.support;
    }

    public Map getStringMap() {
        return this.stringMap;
    }

    public void setStringMap(Map map) {
        this.stringMap.clear();
        this.stringMap.putAll(map);
    }

    public Set getRemovedStrings() {
        return this.removedStrings;
    }

    public void setRemovedStrings(Set set) {
        this.removedStrings = set;
    }

    private static class HardStringComparator
    implements Comparator {
        private HardStringComparator() {
        }

        public int compare(Object object, Object object2) {
            HardCodedString hardCodedString = (HardCodedString)object;
            HardCodedString hardCodedString2 = (HardCodedString)object2;
            return hardCodedString.getStartPosition().getOffset() - hardCodedString2.getStartPosition().getOffset();
        }
    }
}

