/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.wizard;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.i18n.FactoryRegistry;
import org.netbeans.modules.i18n.I18nUtil;
import org.netbeans.modules.i18n.wizard.SourceData;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

final class Util
extends org.netbeans.modules.i18n.Util {
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$openide$loaders$DataObject$Container;

    Util() {
    }

    public static String getString(String string) {
        return NbBundle.getMessage((Class)Util.class, (String)string);
    }

    public static char getChar(String string) {
        return Util.getString(string).charAt(0);
    }

    public static Map createWizardSourceMap() {
        return new TreeMap(new DataObjectComparator());
    }

    public static Map createWizardSourceMap(Node[] nodeArray) {
        Map map = Util.createWizardSourceMap();
        if (nodeArray != null && nodeArray.length > 0) {
            VisibilityQuery visibilityQuery = VisibilityQuery.getDefault();
            for (int i = 0; i < nodeArray.length; ++i) {
                DataObject dataObject = (DataObject)nodeArray[i].getCookie(class$org$openide$loaders$DataObject == null ? Util.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                if (dataObject != null && !visibilityQuery.isVisible(dataObject.getPrimaryFile())) continue;
                DataObject.Container container = (DataObject.Container)nodeArray[i].getCookie(class$org$openide$loaders$DataObject$Container == null ? Util.class$("org.openide.loaders.DataObject$Container") : class$org$openide$loaders$DataObject$Container);
                if (container != null) {
                    Iterator iterator = I18nUtil.getAcceptedDataObjects(container).iterator();
                    while (iterator.hasNext()) {
                        Util.addSource(map, (DataObject)iterator.next());
                    }
                }
                if (dataObject == null || !FactoryRegistry.hasFactory(dataObject.getClass())) continue;
                Util.addSource(map, dataObject);
            }
        }
        return map;
    }

    public static void addSource(Map map, DataObject dataObject) {
        if (map.containsKey(dataObject)) {
            return;
        }
        DataFolder dataFolder = dataObject.getFolder();
        if (dataFolder == null) {
            map.put(dataObject, null);
            return;
        }
        DataObject[] dataObjectArray = dataFolder.getChildren();
        for (int i = 0; i < dataObjectArray.length; ++i) {
            if (!(dataObjectArray[i] instanceof PropertiesDataObject)) continue;
            map.put(dataObject, new SourceData(dataObjectArray[i]));
            return;
        }
        map.put(dataObject, null);
    }

    static boolean wizardEnabled(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length == 0) {
            return false;
        }
        for (int i = 0; i < nodeArray.length; ++i) {
            FileObject fileObject;
            DataObject dataObject = null;
            Node node = nodeArray[i];
            Node.Cookie cookie = node.getCookie(class$org$openide$loaders$DataObject == null ? Util.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
            if (cookie != null) {
                boolean bl;
                dataObject = (DataObject)cookie;
                fileObject = dataObject.getPrimaryFile();
                try {
                    bl = !fileObject.isVirtual() && fileObject.isValid() && fileObject.getURL().getProtocol().equals("file");
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    bl = false;
                }
                if (!bl) {
                    return false;
                }
            }
            if ((fileObject = node.getCookie(class$org$openide$loaders$DataObject$Container == null ? Util.class$("org.openide.loaders.DataObject$Container") : class$org$openide$loaders$DataObject$Container)) != null) continue;
            if (dataObject == null) {
                return false;
            }
            if (FileOwnerQuery.getOwner((FileObject)dataObject.getPrimaryFile()) != null) continue;
            return false;
        }
        return true;
    }

    private static class DataObjectComparator
    implements Comparator {
        private DataObjectComparator() {
        }

        public int compare(Object object, Object object2) {
            if (!(object instanceof DataObject) || !(object2 instanceof DataObject)) {
                return 0;
            }
            DataObject dataObject = (DataObject)object;
            DataObject dataObject2 = (DataObject)object2;
            if (dataObject == dataObject2) {
                return 0;
            }
            if (dataObject == null) {
                return -1;
            }
            if (dataObject2 == null) {
                return 1;
            }
            return dataObject.getPrimaryFile().getPath().compareTo(dataObject2.getPrimaryFile().getPath());
        }

        public boolean equals(Object object) {
            return this == object;
        }
    }
}

