/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mdr;

import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import org.netbeans.modules.mdr.MDRDescriptor;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Node;

public class MDRDataObject
extends MultiDataObject {
    private final String name;
    private final MDRDescriptor descriptor;
    private static final String TAG_START = "{";
    private static final String TAG_END = "}";
    private static final String TAG_BODY_FOLDER = "folder.";

    public MDRDataObject(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException {
        super(fileObject, multiFileLoader);
        String string = fileObject.getName();
        int n = string.indexOf(91);
        int n2 = string.indexOf(93);
        this.name = string.substring(0, n);
        String string2 = string.substring(n + 1, n2).replace('-', '.');
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Enumeration enumeration = fileObject.getAttributes();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            hashMap.put(string3, this.resolveTags(fileObject.getAttribute(string3)));
        }
        this.descriptor = new MDRDescriptor(string2, hashMap);
    }

    public MDRDescriptor getDescriptor() {
        return this.descriptor;
    }

    public String getName() {
        return this.name;
    }

    public boolean isCopyAllowed() {
        return false;
    }

    public boolean isDeleteAllowed() {
        return false;
    }

    public boolean isMoveAllowed() {
        return false;
    }

    public boolean isRenameAllowed() {
        return false;
    }

    public boolean isShadowAllowed() {
        return false;
    }

    public Node createNodeDelegate() {
        DataNode dataNode = (DataNode)super.createNodeDelegate();
        dataNode.setIconBase("/org/netbeans/modules/mdr/resources/repository");
        return dataNode;
    }

    private Object resolveTags(Object object) {
        if (object instanceof String) {
            int n;
            String string = (String)object;
            ErrorManager.getDefault().log(1, "tag: " + string);
            StringBuffer stringBuffer = new StringBuffer(string.length());
            int n2 = 0;
            while ((n = string.indexOf(TAG_START, n2)) > -1) {
                ErrorManager.getDefault().log(1, "tag found at pos: " + n);
                stringBuffer.append(string.substring(n2, n));
                ErrorManager.getDefault().log("temp. result: " + stringBuffer);
                n2 = string.indexOf(TAG_END, n);
                ErrorManager.getDefault().log("tag end found at: " + n2);
                if (n2 == -1) {
                    n2 = n;
                    break;
                }
                stringBuffer.append(this.getTagValue(string.substring(n + 1, n2)));
                ErrorManager.getDefault().log(1, "added tag value, temp. result: " + stringBuffer);
                ++n2;
            }
            stringBuffer.append(string.substring(n2));
            ErrorManager.getDefault().log(1, "finished, result: " + stringBuffer);
            return stringBuffer.toString();
        }
        return object;
    }

    private String getTagValue(String string) {
        ErrorManager.getDefault().log(1, "replacing tag: " + string);
        if (string.startsWith(TAG_BODY_FOLDER)) {
            String string2 = string.substring(TAG_BODY_FOLDER.length()).replace('\\', '/');
            ErrorManager.getDefault().log(1, "found folder: " + string2);
            String string3 = System.getProperty("netbeans.user") + "/var/cache/" + string2;
            try {
                File file = new File(string3);
                file.mkdirs();
                return string3;
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
                return "";
            }
        }
        return TAG_START + string + TAG_END;
    }
}

