/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mdr;

import java.io.IOException;
import org.netbeans.modules.mdr.MDRDataObject;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.ExtensionList;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.UniFileLoader;

public class MDRLoader
extends UniFileLoader {
    private static final String MDR_EXTENSION = "mdr";

    public MDRLoader() {
        super("org.netbeans.modules.mdr.MDRDataObject");
        ExtensionList extensionList = new ExtensionList();
        extensionList.addExtension(MDR_EXTENSION);
        this.setExtensions(extensionList);
    }

    public MultiDataObject createMultiObject(FileObject fileObject) throws DataObjectExistsException, IOException {
        return new MDRDataObject(fileObject, (MultiFileLoader)this);
    }

    protected FileObject findPrimaryFile(FileObject fileObject) {
        FileObject fileObject2 = super.findPrimaryFile(fileObject);
        if (fileObject2 == null) {
            return null;
        }
        String string = fileObject2.getName();
        if (string.indexOf(91) == -1 || string.indexOf(93) == -1) {
            return null;
        }
        return fileObject2;
    }
}

