/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mdr;

import java.util.Enumeration;
import java.util.HashMap;
import org.netbeans.api.mdr.MDRManager;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.mdr.NBMDRepositoryImpl;
import org.netbeans.mdr.handlers.BaseObjectHandler;
import org.netbeans.mdr.handlers.ClassLoaderProvider;
import org.netbeans.modules.mdr.MDRDataObject;
import org.netbeans.modules.mdr.MDRDescriptor;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;

public class MDRManagerImpl
extends MDRManager
implements FileChangeListener,
NBMDRepositoryImpl.ShutdownListener {
    private static final String FOLDER_REPOSITORY = "MDRepositories";
    private static final String DEFAULT_REPOSITORY = "Default";
    private HashMap repositoryMap = null;
    private FileObject repFolder = null;
    private static MDRManagerImpl instance = null;
    private ProgressListener progress = null;
    private boolean stopFired = false;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    static synchronized void uninstall() {
        if (instance != null) {
            instance.uninstallMe();
        }
    }

    private void uninstallMe() {
        this.repositoryMap = null;
        if (this.repFolder != null) {
            this.repFolder.removeFileChangeListener((FileChangeListener)this);
        }
        this.repFolder = null;
    }

    private void refreshChildren() {
        if (this.repFolder == null) {
            this.repFolder = Repository.getDefault().getDefaultFileSystem().getRoot().getFileObject(FOLDER_REPOSITORY);
            this.repFolder.addFileChangeListener((FileChangeListener)this);
        }
        this.repositoryMap.clear();
        if (this.repFolder != null) {
            Enumeration enumeration = this.repFolder.getData(false);
            while (enumeration.hasMoreElements()) {
                try {
                    DataObject dataObject = DataObject.find((FileObject)((FileObject)enumeration.nextElement()));
                    if (!(dataObject instanceof MDRDataObject)) continue;
                    this.repositoryMap.put(dataObject.getName(), dataObject);
                    ErrorManager.getDefault().log("found repository: " + dataObject.getName());
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {}
            }
        }
    }

    private void init() {
        if (this.repositoryMap == null) {
            this.repositoryMap = new HashMap();
            this.refreshChildren();
        }
    }

    public MDRManagerImpl() {
        instance = this;
    }

    public void shutdownAll() {
        int n;
        String[] stringArray = this.getRepositoryNames();
        MDRepository[] mDRepositoryArray = new MDRepository[stringArray.length];
        int n2 = 0;
        for (n = 0; n < stringArray.length; ++n) {
            mDRepositoryArray[n] = this.getRepository(stringArray[n]);
            if (mDRepositoryArray[n] instanceof NBMDRepositoryImpl) {
                n2 += ((NBMDRepositoryImpl)mDRepositoryArray[n]).getShutdownSteps();
                continue;
            }
            ++n2;
        }
        this.fireProgressListenerStart(n2);
        for (n = 0; n < stringArray.length; ++n) {
            ((NBMDRepositoryImpl)mDRepositoryArray[n]).addShutdownListener(this);
            mDRepositoryArray[n].shutdown();
            ((NBMDRepositoryImpl)mDRepositoryArray[n]).removeShutdownListener(this);
        }
        this.fireProgressListenerStop();
    }

    public void shutdown() {
    }

    public void stepFinished() {
        this.fireProgressListenerStep();
    }

    public boolean setProgressListener(ProgressListener progressListener) {
        boolean bl = false;
        if (this.progress == null) {
            this.progress = progressListener;
            bl = true;
        }
        return bl && !this.stopFired;
    }

    private void fireProgressListenerStart(int n) {
        if (this.progress == null) {
            return;
        }
        this.progress.start(n);
    }

    private void fireProgressListenerInitialize() {
        if (this.progress == null) {
            return;
        }
        this.progress.init();
    }

    public void fireProgressListenerStep() {
        if (this.progress == null) {
            return;
        }
        this.progress.step();
    }

    private void fireProgressListenerStop() {
        if (this.progress == null) {
            this.stopFired = true;
            return;
        }
        this.progress.stop();
    }

    public MDRepository getRepository(String string) {
        this.init();
        MDRDataObject mDRDataObject = (MDRDataObject)((Object)this.repositoryMap.get(string));
        if (mDRDataObject == null) {
            return null;
        }
        MDRDescriptor mDRDescriptor = mDRDataObject.getDescriptor();
        return mDRDescriptor.getMDRInstance();
    }

    public MDRepository getDefaultRepository() {
        return this.getRepository(DEFAULT_REPOSITORY);
    }

    public String[] getRepositoryNames() {
        this.init();
        String[] stringArray = new String[]{};
        stringArray = this.repositoryMap.keySet().toArray(stringArray);
        return stringArray;
    }

    public void fileFolderCreated(FileEvent fileEvent) {
        this.refreshChildren();
    }

    public void fileDataCreated(FileEvent fileEvent) {
        this.refreshChildren();
    }

    public void fileChanged(FileEvent fileEvent) {
        this.refreshChildren();
    }

    public void fileDeleted(FileEvent fileEvent) {
        this.refreshChildren();
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        this.refreshChildren();
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        this.refreshChildren();
    }

    void preShutdownAll() {
        this.fireProgressListenerInitialize();
    }

    static {
        BaseObjectHandler.setClassLoaderProvider(new CLProviderImpl());
    }

    public static interface ProgressListener {
        public void init();

        public void start(int var1);

        public void step();

        public void stop();
    }

    private static class CLProviderImpl
    implements ClassLoaderProvider {
        private CLProviderImpl() {
        }

        public ClassLoader getClassLoader() {
            return (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = MDRManagerImpl.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
        }

        public Class defineClass(String string, byte[] byArray) {
            return null;
        }
    }
}

