/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.uiapi;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JPanel;
import org.netbeans.modules.project.uiapi.CategoryModel;
import org.netbeans.modules.project.uiapi.Utilities;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class CategoryView
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener {
    private ExplorerManager manager;
    private BeanTreeView btv;
    private CategoryModel categoryModel;

    public CategoryView(CategoryModel categoryModel) {
        this.categoryModel = categoryModel;
        this.manager = new ExplorerManager();
        this.setLayout(new BorderLayout());
        Dimension dimension = new Dimension(220, 4);
        this.btv = new BeanTreeView();
        this.btv.setSelectionMode(1);
        this.btv.setPopupAllowed(false);
        this.btv.setRootVisible(false);
        this.btv.setDefaultActionAllowed(false);
        this.btv.setMinimumSize(dimension);
        this.btv.setPreferredSize(dimension);
        this.btv.setMaximumSize(dimension);
        this.btv.setDragSource(false);
        this.add((Component)this.btv, "Center");
        this.manager.setRootContext(this.createRootNode(categoryModel));
        this.manager.addPropertyChangeListener((PropertyChangeListener)this);
        categoryModel.addPropertyChangeListener(this);
        this.btv.expandAll();
        this.selectNode(categoryModel.getCurrentCategory());
        this.btv.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)CategoryView.class, (String)"AN_CatgoryView"));
        this.btv.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)CategoryView.class, (String)"AD_CategoryView"));
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public void addNotify() {
        super.addNotify();
        this.btv.expandAll();
    }

    private void selectNode(ProjectCustomizer.Category category) {
        Node node = this.findNode(category, this.manager.getRootContext());
        if (node != null) {
            try {
                this.manager.setSelectedNodes(new Node[]{node});
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    private Node findNode(ProjectCustomizer.Category category, Node node) {
        Node[] nodeArray;
        Children children = node.getChildren();
        if (children != null && children != Children.LEAF && (nodeArray = children.getNodes(true)) != null) {
            for (int i = 0; i < nodeArray.length; ++i) {
                ProjectCustomizer.Category category2 = (ProjectCustomizer.Category)nodeArray[i].getLookup().lookup(class$org$netbeans$spi$project$ui$support$ProjectCustomizer$Category == null ? CategoryView.class$("org.netbeans.spi.project.ui.support.ProjectCustomizer$Category") : class$org$netbeans$spi$project$ui$support$ProjectCustomizer$Category);
                if (category2 == category) {
                    return nodeArray[i];
                }
                Node node2 = this.findNode(category, nodeArray[i]);
                if (node2 == null) continue;
                return node2;
            }
        }
        return null;
    }

    private Node createRootNode(CategoryModel categoryModel) {
        ProjectCustomizer.Category category = ProjectCustomizer.Category.create("root", "root", null, categoryModel.getCategories());
        return new CategoryNode(category);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        String string = propertyChangeEvent.getPropertyName();
        if (object == this.manager && "selectedNodes".equals(string)) {
            Node[] nodeArray = this.manager.getSelectedNodes();
            if (nodeArray == null || nodeArray.length <= 0) {
                return;
            }
            Node node = nodeArray[0];
            ProjectCustomizer.Category category = (ProjectCustomizer.Category)node.getLookup().lookup(ProjectCustomizer.Category.class);
            if (category != this.categoryModel.getCurrentCategory()) {
                this.categoryModel.setCurrentCategory(category);
            }
        }
        if (object == this.categoryModel && "propCurrentCategory".equals(string)) {
            this.selectNode((ProjectCustomizer.Category)propertyChangeEvent.getNewValue());
        }
    }

    private static class CategoryChildren
    extends Children.Keys {
        private Collection descriptions;

        public CategoryChildren(ProjectCustomizer.Category[] categoryArray) {
            this.descriptions = Arrays.asList(categoryArray);
        }

        public void addNotify() {
            this.setKeys(this.descriptions);
        }

        public void removeNotify() {
            this.setKeys(Collections.EMPTY_LIST);
        }

        protected Node[] createNodes(Object object) {
            return new Node[]{new CategoryNode((ProjectCustomizer.Category)object)};
        }
    }

    private static class CategoryNode
    extends AbstractNode
    implements PropertyChangeListener {
        private Image icon = org.openide.util.Utilities.loadImage((String)"org/netbeans/modules/project/uiapi/defaultCategory.gif");
        private ProjectCustomizer.Category category;

        public CategoryNode(ProjectCustomizer.Category category) {
            super((Children)(category.getSubcategories() == null || category.getSubcategories().length == 0 ? Children.LEAF : new CategoryChildren(category.getSubcategories())), Lookups.fixed((Object[])new Object[]{category}));
            this.setName(category.getName());
            this.category = category;
            this.setDisplayName(category.getDisplayName());
            if (category.getIcon() != null) {
                this.icon = category.getIcon();
            }
            Utilities.getCategoryChangeSupport(category).addPropertyChangeListener(this);
        }

        public String getHtmlDisplayName() {
            return this.category.isValid() ? null : "<html><font color=\"!nb.errorForeground\">" + this.category.getDisplayName() + "</font></html>";
        }

        public Image getIcon(int n) {
            return this.icon;
        }

        public Image getOpenedIcon(int n) {
            return this.getIcon(n);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName() == "isCategoryValid") {
                this.fireDisplayNameChange(null, null);
            }
        }
    }
}

