/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.uiapi;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.netbeans.modules.project.uiapi.Utilities;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CustomizerDialog {
    private static final int OPTION_OK = 0;
    private static final int OPTION_CANCEL = 1;
    private static final String COMMAND_OK = "OK";
    private static final String COMMAND_CANCEL = "CANCEL";

    private CustomizerDialog() {
    }

    public static Dialog createDialog(ActionListener actionListener, JPanel jPanel, HelpCtx helpCtx, final ProjectCustomizer.Category[] categoryArray) {
        ListeningButton listeningButton = new ListeningButton(NbBundle.getMessage((Class)CustomizerDialog.class, (String)"LBL_Customizer_Ok_Option"), categoryArray);
        listeningButton.setEnabled(CustomizerDialog.checkValidity(categoryArray));
        Object[] objectArray = new JButton[]{listeningButton, new JButton(NbBundle.getMessage((Class)CustomizerDialog.class, (String)"LBL_Customizer_Cancel_Option"))};
        objectArray[0].setActionCommand(COMMAND_OK);
        objectArray[1].setActionCommand(COMMAND_CANCEL);
        objectArray[0].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)CustomizerDialog.class, (String)"AD_Customizer_Ok_Option"));
        objectArray[1].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)CustomizerDialog.class, (String)"AD_Customizer_Cancel_Option"));
        OptionListener optionListener = new OptionListener(actionListener);
        objectArray[0].addActionListener(optionListener);
        objectArray[1].addActionListener(optionListener);
        jPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)CustomizerDialog.class, (String)"AN_ProjectCustomizer"));
        jPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)CustomizerDialog.class, (String)"AD_ProjectCustomizer"));
        if (helpCtx == null) {
            helpCtx = HelpCtx.DEFAULT_HELP;
        }
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jPanel, NbBundle.getMessage((Class)CustomizerDialog.class, (String)"LBL_Customizer_Title"), false, objectArray, (Object)objectArray[0], 0, helpCtx, null);
        jPanel.addPropertyChangeListener(new HelpCtxChangeListener(dialogDescriptor, helpCtx));
        if (jPanel instanceof HelpCtx.Provider) {
            dialogDescriptor.setHelpCtx(((HelpCtx.Provider)jPanel).getHelpCtx());
        }
        dialogDescriptor.setClosingOptions(new Object[]{objectArray[0], objectArray[1]});
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                LinkedList<ProjectCustomizer.Category> linkedList = new LinkedList<ProjectCustomizer.Category>(Arrays.asList(categoryArray));
                while (!linkedList.isEmpty()) {
                    ProjectCustomizer.Category category = (ProjectCustomizer.Category)linkedList.remove(0);
                    Utilities.removeCategoryChangeSupport(category);
                    if (category.getSubcategories() == null) continue;
                    linkedList.addAll(Arrays.asList(category.getSubcategories()));
                }
            }
        });
        return dialog;
    }

    private static boolean checkValidity(ProjectCustomizer.Category[] categoryArray) {
        for (int i = 0; i < categoryArray.length; ++i) {
            if (!categoryArray[i].isValid()) {
                return false;
            }
            ProjectCustomizer.Category[] categoryArray2 = categoryArray[i].getSubcategories();
            if (categoryArray2 == null || CustomizerDialog.checkValidity(categoryArray2)) continue;
            return false;
        }
        return true;
    }

    private static class ListeningButton
    extends JButton
    implements PropertyChangeListener {
        private ProjectCustomizer.Category[] categories;

        public ListeningButton(String string, ProjectCustomizer.Category[] categoryArray) {
            super(string);
            this.categories = categoryArray;
            for (int i = 0; i < categoryArray.length; ++i) {
                Utilities.getCategoryChangeSupport(categoryArray[i]).addPropertyChangeListener(this);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName() == "isCategoryValid") {
                boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                this.setEnabled(bl && CustomizerDialog.checkValidity(this.categories));
            }
        }
    }

    private static class HelpCtxChangeListener
    implements PropertyChangeListener {
        DialogDescriptor dialogDescriptor;
        HelpCtx defaultHelpCtx;

        HelpCtxChangeListener(DialogDescriptor dialogDescriptor, HelpCtx helpCtx) {
            this.dialogDescriptor = dialogDescriptor;
            this.defaultHelpCtx = helpCtx;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("helpCtxProperty".equals(propertyChangeEvent.getPropertyName())) {
                HelpCtx helpCtx = (HelpCtx)propertyChangeEvent.getNewValue();
                this.dialogDescriptor.setHelpCtx(helpCtx == null || helpCtx == HelpCtx.DEFAULT_HELP ? this.defaultHelpCtx : helpCtx);
            }
        }
    }

    private static class OptionListener
    implements ActionListener {
        private ActionListener okOptionListener;

        OptionListener(ActionListener actionListener) {
            this.okOptionListener = actionListener;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (CustomizerDialog.COMMAND_OK.equals(string)) {
                this.okOptionListener.actionPerformed(actionEvent);
            }
        }
    }
}

