/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.uiapi;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.netbeans.modules.project.uiapi.CategoryModel;
import org.netbeans.modules.project.uiapi.Utilities;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CustomizerPane
extends JPanel
implements HelpCtx.Provider,
PropertyChangeListener {
    public static final String HELP_CTX_PROPERTY = "helpCtxProperty";
    private Component currentCustomizer;
    private JTextArea errorMessageValue = new JTextArea();
    private HelpCtx currentHelpCtx;
    private GridBagConstraints fillConstraints;
    private GridBagConstraints errMessConstraints = new GridBagConstraints();
    private ProjectCustomizer.CategoryComponentProvider componentProvider;
    private JPanel categoryPanel;
    private JPanel customizerPanel;
    private JLabel jLabel1;

    public CustomizerPane(JPanel jPanel, CategoryModel categoryModel, ProjectCustomizer.CategoryComponentProvider categoryComponentProvider) {
        this.initComponents();
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)CustomizerPane.class, (String)"AD_CustomizerPane"));
        this.componentProvider = categoryComponentProvider;
        this.fillConstraints = new GridBagConstraints();
        this.fillConstraints.gridwidth = 0;
        this.fillConstraints.gridheight = 1;
        this.fillConstraints.fill = 1;
        this.fillConstraints.weightx = 1.0;
        this.fillConstraints.weighty = 1.0;
        categoryModel.addPropertyChangeListener(new CategoryChangeListener());
        this.categoryPanel.add((Component)jPanel, this.fillConstraints);
        this.errorMessageValue.setWrapStyleWord(true);
        this.errorMessageValue.setLineWrap(true);
        this.errorMessageValue.setBorder(BorderFactory.createEmptyBorder());
        this.errorMessageValue.setEditable(false);
        this.errorMessageValue.setForeground(UIManager.getColor("nb.errorForeground"));
        this.errorMessageValue.setBackground(this.customizerPanel.getBackground());
        this.errMessConstraints = new GridBagConstraints();
        this.errMessConstraints.gridx = 0;
        this.errMessConstraints.gridy = 1;
        this.errMessConstraints.gridwidth = 1;
        this.errMessConstraints.gridheight = 1;
        this.errMessConstraints.insets = new Insets(12, 0, 0, 0);
        this.errMessConstraints.fill = 2;
        this.customizerPanel.add((Component)this.errorMessageValue, this.errMessConstraints);
        this.setCategory(categoryModel.getCurrentCategory());
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.categoryPanel = new JPanel();
        this.customizerPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(750, 450));
        this.jLabel1.setLabelFor(this.categoryPanel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage((Class)CustomizerPane.class, (String)"LBL_Customizer_Categories"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 11, 0, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.categoryPanel.setLayout(new GridBagLayout());
        this.categoryPanel.setBorder(BorderFactory.createEtchedBorder());
        this.categoryPanel.setMinimumSize(new Dimension(220, 4));
        this.categoryPanel.setPreferredSize(new Dimension(220, 4));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 11, 8, 11);
        this.add((Component)this.categoryPanel, gridBagConstraints);
        this.customizerPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 8, 11);
        this.add((Component)this.customizerPanel, gridBagConstraints);
    }

    public HelpCtx getHelpCtx() {
        return this.currentHelpCtx;
    }

    private void setCategory(ProjectCustomizer.Category category) {
        JComponent jComponent;
        if (category == null) {
            return;
        }
        if (this.currentCustomizer != null) {
            this.customizerPanel.remove(this.currentCustomizer);
        }
        if ((jComponent = this.componentProvider.create(category)) != null) {
            Utilities.getCategoryChangeSupport(category).addPropertyChangeListener(this);
            this.currentCustomizer = jComponent;
            this.currentHelpCtx = HelpCtx.findHelp((Component)this.currentCustomizer);
            this.customizerPanel.add(this.currentCustomizer, this.fillConstraints);
            this.customizerPanel.validate();
            this.customizerPanel.repaint();
            this.setErrorMessage(category.getErrorMessage());
            this.firePropertyChange(HELP_CTX_PROPERTY, null, this.getHelpCtx());
        } else {
            this.currentCustomizer = null;
        }
    }

    private void setErrorMessage(String string) {
        this.errorMessageValue.setText(string);
        if (string == null || string.trim().equals("")) {
            this.customizerPanel.remove(this.errorMessageValue);
        } else {
            this.customizerPanel.add((Component)this.errorMessageValue, this.errMessConstraints);
        }
        this.customizerPanel.revalidate();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() == "categoryErrorMessage") {
            String string = (String)propertyChangeEvent.getNewValue();
            this.setErrorMessage(string);
        }
    }

    private class CategoryChangeListener
    implements PropertyChangeListener {
        private CategoryChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("propCurrentCategory".equals(propertyChangeEvent.getPropertyName())) {
                ProjectCustomizer.Category category = (ProjectCustomizer.Category)propertyChangeEvent.getNewValue();
                CustomizerPane.this.setCategory(category);
            }
        }
    }
}

