/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.uiapi;

import java.awt.Container;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.project.uiapi.DefaultProjectDeletePanel;
import org.netbeans.modules.project.uiapi.DefaultProjectOperationsImplementation;
import org.netbeans.modules.project.uiapi.DefaultProjectRenamePanel;
import org.netbeans.modules.project.uiapi.ProjectCopyPanel;
import org.netbeans.spi.project.MoveOperationImplementation;
import org.netbeans.spi.project.support.ProjectOperations;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.LifecycleManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public final class DefaultProjectOperationsImplementation {
    private static final ErrorManager ERR;
    private static final double NOTIFY_WORK = 0.1;
    private static final double FIND_PROJECT_WORK = 0.1;
    private static final int MAX_WORK = 100;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$netbeans$spi$project$MoveOperationImplementation;

    private DefaultProjectOperationsImplementation() {
    }

    private static String getDisplayName(Project project) {
        return ProjectUtils.getInformation((Project)project).getDisplayName();
    }

    private static boolean performDelete(Project project, List list, ProgressHandle progressHandle) throws Exception {
        try {
            progressHandle.start(list.size() + 1);
            int n = 0;
            progressHandle.progress(NbBundle.getMessage((Class)DefaultProjectOperationsImplementation.class, (String)"LBL_Progress_Cleaning_Project"));
            ProjectOperations.notifyDeleting((Project)project);
            progressHandle.progress(++n);
            FileObject fileObject = list.iterator();
            while (fileObject.hasNext()) {
                FileObject fileObject2 = (FileObject)fileObject.next();
                progressHandle.progress(NbBundle.getMessage((Class)(class$org$netbeans$modules$project$uiapi$DefaultProjectOperationsImplementation == null ? DefaultProjectOperationsImplementation.class$("org.netbeans.modules.project.uiapi.DefaultProjectOperationsImplementation") : class$org$netbeans$modules$project$uiapi$DefaultProjectOperationsImplementation), (String)"LBL_Progress_Deleting_File", (Object[])new Object[]{FileUtil.getFileDisplayName((FileObject)fileObject2)}));
                if (fileObject2 != null) {
                    fileObject2.delete();
                }
                progressHandle.progress(++n);
            }
            fileObject = project.getProjectDirectory();
            if (fileObject.getChildren().length == 0) {
                fileObject.delete();
            }
            progressHandle.finish();
            ProjectOperations.notifyDeleted((Project)project);
            return true;
        }
        catch (Exception exception) {
            String string = DefaultProjectOperationsImplementation.getDisplayName(project);
            String string2 = NbBundle.getMessage((Class)DefaultProjectOperationsImplementation.class, (String)"LBL_Project_cannot_be_deleted.", (Object[])new Object[]{string});
            ErrorManager.getDefault().annotate((Throwable)exception, string2);
            return false;
        }
    }

    public static void deleteProject(Project project) {
        DefaultProjectOperationsImplementation.deleteProject(project, new GUIUserInputHandler());
    }

    static void deleteProject(final Project project, UserInputHandler userInputHandler) {
        Object object;
        String string = DefaultProjectOperationsImplementation.getDisplayName(project);
        FileObject fileObject = project.getProjectDirectory();
        if (ERR.isLoggable(1)) {
            ERR.log(1, "delete started: " + string);
        }
        List list = ProjectOperations.getMetadataFiles((Project)project);
        List list2 = ProjectOperations.getDataFiles((Project)project);
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(list);
        arrayList.addAll(list2);
        ProgressHandle progressHandle = arrayList.iterator();
        while (progressHandle.hasNext()) {
            object = (FileObject)progressHandle.next();
            if (FileUtil.isParentOf((FileObject)fileObject, (FileObject)object)) continue;
            progressHandle.remove();
        }
        progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage((Class)DefaultProjectOperationsImplementation.class, (String)"LBL_Delete_Project_Caption"));
        object = new DefaultProjectDeletePanel(progressHandle, string, FileUtil.getFileDisplayName((FileObject)fileObject), !list2.isEmpty());
        String string2 = NbBundle.getMessage((Class)DefaultProjectOperationsImplementation.class, (String)"LBL_Delete_Project_Caption");
        userInputHandler.showConfirmationDialog((JComponent)object, project, string2, "Yes_Button", "No_Button", true, new Executor((DefaultProjectDeletePanel)object, arrayList, progressHandle, list){
            private final /* synthetic */ DefaultProjectDeletePanel val$deletePanel;
            private final /* synthetic */ List val$allFiles;
            private final /* synthetic */ ProgressHandle val$handle;
            private final /* synthetic */ List val$metadataFiles;
            {
                this.val$deletePanel = defaultProjectDeletePanel;
                this.val$allFiles = list;
                this.val$handle = progressHandle;
                this.val$metadataFiles = list2;
            }

            public void execute() throws Exception {
                DefaultProjectOperationsImplementation.close(project);
                if (this.val$deletePanel.isDeleteSources()) {
                    DefaultProjectOperationsImplementation.performDelete(project, this.val$allFiles, this.val$handle);
                } else {
                    DefaultProjectOperationsImplementation.performDelete(project, this.val$metadataFiles, this.val$handle);
                }
            }
        });
        if (ERR.isLoggable(1)) {
            ERR.log(1, "delete done: " + string);
        }
    }

    public static void copyProject(final Project project) {
        final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage((Class)DefaultProjectOperationsImplementation.class, (String)"LBL_Copy_Project_Handle"));
        final ProjectCopyPanel projectCopyPanel = new ProjectCopyPanel(progressHandle, project, false);
        DefaultProjectOperationsImplementation.showConfirmationDialog(projectCopyPanel, project, NbBundle.getMessage((Class)DefaultProjectOperationsImplementation.class, (String)"LBL_Copy_Project_Caption"), "Copy_Button", null, false, new Executor(){

            public void execute() throws Exception {
                String string = projectCopyPanel.getNewName();
                File file = projectCopyPanel.getNewDirectory();
                FileObject fileObject = FileUtil.toFileObject((File)file);
                DefaultProjectOperationsImplementation.doCopyProject(progressHandle, project, string, fileObject);
            }
        });
    }

    static void doCopyProject(ProgressHandle progressHandle, Project project, String string, FileObject fileObject) throws Exception {
        try {
            int n = 100;
            progressHandle.start(n);
            double d = 0.0;
            progressHandle.progress((int)d);
            ProjectOperations.notifyCopying((Project)project);
            d = (double)n * 0.1;
            progressHandle.progress((int)d);
            FileObject fileObject2 = fileObject.createFolder(string);
            FileObject fileObject3 = project.getProjectDirectory();
            List<FileObject> list = Arrays.asList(fileObject3.getChildren());
            double d2 = (double)n * 0.7000000000000001 / (double)list.size();
            Project project2 = list.iterator();
            while (project2.hasNext()) {
                FileObject fileObject4 = project2.next();
                File file = FileUtil.toFile((FileObject)fileObject4);
                DefaultProjectOperationsImplementation.doCopy(project, fileObject4, fileObject2);
                int n2 = (int)d;
                if (n2 >= (int)(d += d2)) continue;
                progressHandle.progress((int)d);
            }
            ProjectManager.getDefault().clearNonProjectCache();
            project2 = ProjectManager.getDefault().findProject(fileObject2);
            if (!$assertionsDisabled && project2 == null) {
                throw new AssertionError();
            }
            progressHandle.progress((int)(d += (double)n * 0.1));
            ProjectOperations.notifyCopied((Project)project, (Project)project2, (File)FileUtil.toFile((FileObject)project.getProjectDirectory()), (String)string);
            progressHandle.progress((int)(d += (double)n * 0.1));
            ProjectManager.getDefault().saveProject(project2);
            DefaultProjectOperationsImplementation.open(project2, false);
            progressHandle.progress(n);
            progressHandle.finish();
        }
        catch (Exception exception) {
            ErrorManager.getDefault().annotate((Throwable)exception, NbBundle.getMessage((Class)DefaultProjectOperationsImplementation.class, (String)"ERR_Cannot_Move", (Object[])new Object[]{exception.getLocalizedMessage()}));
            throw exception;
        }
    }

    public static void moveProject(final Project project) {
        final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage((Class)DefaultProjectOperationsImplementation.class, (String)"LBL_Move_Project_Handle"));
        final ProjectCopyPanel projectCopyPanel = new ProjectCopyPanel(progressHandle, project, true);
        DefaultProjectOperationsImplementation.showConfirmationDialog(projectCopyPanel, project, NbBundle.getMessage((Class)DefaultProjectOperationsImplementation.class, (String)"LBL_Move_Project_Caption"), "Move_Button", null, false, new Executor(){

            public void execute() throws Exception {
                String string = projectCopyPanel.getNewName();
                File file = projectCopyPanel.getNewDirectory();
                FileObject fileObject = FileUtil.toFileObject((File)file);
                DefaultProjectOperationsImplementation.doMoveProject(progressHandle, project, string, fileObject, "ERR_Cannot_Move");
            }
        });
    }

    public static void renameProject(Project project) {
        DefaultProjectOperationsImplementation.renameProject(project, null);
    }

    public static void renameProject(final Project project, String string) {
        final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage((Class)DefaultProjectOperationsImplementation.class, (String)"LBL_Rename_Project_Handle"));
        final DefaultProjectRenamePanel defaultProjectRenamePanel = new DefaultProjectRenamePanel(progressHandle, project, string);
        DefaultProjectOperationsImplementation.showConfirmationDialog(defaultProjectRenamePanel, project, NbBundle.getMessage((Class)DefaultProjectOperationsImplementation.class, (String)"LBL_Rename_Project_Caption"), "Rename_Button", null, false, new Executor(){
            static final /* synthetic */ boolean $assertionsDisabled;

            public void execute() throws Exception {
                String string = defaultProjectRenamePanel.getNewName();
                if (defaultProjectRenamePanel.getRenameProjectFolder()) {
                    DefaultProjectOperationsImplementation.doMoveProject(progressHandle, project, string, project.getProjectDirectory().getParent(), "ERR_Cannot_Rename");
                } else {
                    boolean bl = true;
                    Project project3 = OpenProjects.getDefault().getMainProject();
                    boolean bl2 = project3 != null && project.getProjectDirectory().equals(project3.getProjectDirectory());
                    Project project2 = null;
                    try {
                        progressHandle.start(5);
                        int n = 0;
                        FileObject fileObject = project.getProjectDirectory();
                        File file = FileUtil.toFile((FileObject)project.getProjectDirectory());
                        Collection collection = project.getLookup().lookup(new Lookup.Template(class$org$netbeans$spi$project$MoveOperationImplementation == null ? (class$org$netbeans$spi$project$MoveOperationImplementation = DefaultProjectOperationsImplementation.class$("org.netbeans.spi.project.MoveOperationImplementation")) : class$org$netbeans$spi$project$MoveOperationImplementation)).allInstances();
                        DefaultProjectOperationsImplementation.close(project);
                        progressHandle.progress(++n);
                        Object object = collection.iterator();
                        while (object.hasNext()) {
                            ((MoveOperationImplementation)object.next()).notifyMoving();
                        }
                        progressHandle.progress(++n);
                        object = collection.iterator();
                        while (object.hasNext()) {
                            ((MoveOperationImplementation)object.next()).notifyMoved(null, file, string);
                        }
                        progressHandle.progress(++n);
                        ProjectManager.getDefault().clearNonProjectCache();
                        project2 = ProjectManager.getDefault().findProject(fileObject);
                        if (!$assertionsDisabled && project2 == null) {
                            throw new AssertionError();
                        }
                        bl = false;
                        progressHandle.progress(++n);
                        object = project2.getLookup().lookup(new Lookup.Template(class$org$netbeans$spi$project$MoveOperationImplementation == null ? (class$org$netbeans$spi$project$MoveOperationImplementation = DefaultProjectOperationsImplementation.class$("org.netbeans.spi.project.MoveOperationImplementation")) : class$org$netbeans$spi$project$MoveOperationImplementation)).allInstances();
                        Iterator iterator = object.iterator();
                        while (iterator.hasNext()) {
                            ((MoveOperationImplementation)iterator.next()).notifyMoved(project, file, string);
                        }
                        ProjectManager.getDefault().saveProject(project2);
                        DefaultProjectOperationsImplementation.open(project2, bl2);
                        progressHandle.progress(++n);
                        progressHandle.finish();
                    }
                    catch (Exception exception) {
                        if (bl) {
                            DefaultProjectOperationsImplementation.open(project, bl2);
                        } else {
                            if (!$assertionsDisabled && project2 == null) {
                                throw new AssertionError();
                            }
                            DefaultProjectOperationsImplementation.open(project2, bl2);
                        }
                        ErrorManager.getDefault().annotate((Throwable)exception, NbBundle.getMessage((Class)(class$org$netbeans$modules$project$uiapi$DefaultProjectOperationsImplementation == null ? (class$org$netbeans$modules$project$uiapi$DefaultProjectOperationsImplementation = DefaultProjectOperationsImplementation.class$("org.netbeans.modules.project.uiapi.DefaultProjectOperationsImplementation")) : class$org$netbeans$modules$project$uiapi$DefaultProjectOperationsImplementation), (String)"ERR_Cannot_Rename", (Object[])new Object[]{exception.getLocalizedMessage()}));
                        throw exception;
                    }
                }
            }

            static {
                $assertionsDisabled = !(class$org$netbeans$modules$project$uiapi$DefaultProjectOperationsImplementation == null ? (class$org$netbeans$modules$project$uiapi$DefaultProjectOperationsImplementation = DefaultProjectOperationsImplementation.class$("org.netbeans.modules.project.uiapi.DefaultProjectOperationsImplementation")) : class$org$netbeans$modules$project$uiapi$DefaultProjectOperationsImplementation).desiredAssertionStatus();
            }
        });
    }

    static void doMoveProject(ProgressHandle progressHandle, Project project, String string, FileObject fileObject, String string2) throws Exception {
        boolean bl = true;
        Project project2 = OpenProjects.getDefault().getMainProject();
        boolean bl2 = project2 != null && project.getProjectDirectory().equals(project2.getProjectDirectory());
        FileObject fileObject2 = null;
        try {
            FileObject fileObject3;
            int n = 100;
            progressHandle.start(n);
            double d = 0.0;
            progressHandle.progress((int)d);
            ProjectOperations.notifyMoving((Project)project);
            DefaultProjectOperationsImplementation.close(project);
            d = (double)n * 0.1;
            progressHandle.progress((int)d);
            FileObject fileObject4 = project.getProjectDirectory();
            List<FileObject> list = Arrays.asList(fileObject4.getChildren());
            double d2 = (double)n * 0.7000000000000001 / (double)list.size() / 2.0;
            fileObject2 = fileObject.createFolder(string);
            Project project3 = list.iterator();
            while (project3.hasNext()) {
                fileObject3 = project3.next();
                DefaultProjectOperationsImplementation.doCopy(project, fileObject3, fileObject2);
                int n2 = (int)d;
                if (n2 >= (int)(d += d2)) continue;
                progressHandle.progress((int)d);
            }
            bl = false;
            project3 = list.iterator();
            while (project3.hasNext()) {
                fileObject3 = project3.next();
                File file = FileUtil.toFile((FileObject)fileObject3);
                DefaultProjectOperationsImplementation.doDelete(project, fileObject3);
                int n3 = (int)d;
                if (n3 >= (int)(d += d2)) continue;
                progressHandle.progress((int)d);
            }
            if (fileObject4.getChildren().length == 0) {
                fileObject4.delete();
            }
            ProjectManager.getDefault().clearNonProjectCache();
            project3 = ProjectManager.getDefault().findProject(fileObject2);
            progressHandle.progress((int)(d += (double)n * 0.1));
            if (!$assertionsDisabled && project3 == null) {
                throw new AssertionError();
            }
            ProjectOperations.notifyMoved((Project)project, (Project)project3, (File)FileUtil.toFile((FileObject)project.getProjectDirectory()), (String)string);
            progressHandle.progress((int)(d += (double)n * 0.1));
            ProjectManager.getDefault().saveProject(project3);
            DefaultProjectOperationsImplementation.open(project3, bl2);
            progressHandle.progress(n);
            progressHandle.finish();
        }
        catch (Exception exception) {
            if (bl) {
                DefaultProjectOperationsImplementation.open(project, bl2);
            } else {
                if (!$assertionsDisabled && fileObject2 == null) {
                    throw new AssertionError();
                }
                ProjectManager.getDefault().clearNonProjectCache();
                Project project4 = ProjectManager.getDefault().findProject(fileObject2);
                if (!$assertionsDisabled && project4 == null) {
                    throw new AssertionError();
                }
                DefaultProjectOperationsImplementation.open(project4, bl2);
            }
            ErrorManager.getDefault().annotate((Throwable)exception, NbBundle.getMessage((Class)DefaultProjectOperationsImplementation.class, (String)string2, (Object[])new Object[]{exception.getLocalizedMessage()}));
            throw exception;
        }
    }

    private static void doCopy(Project project, FileObject fileObject, FileObject fileObject2) throws IOException {
        if (!VisibilityQuery.getDefault().isVisible(fileObject)) {
            return;
        }
        if (!project.getProjectDirectory().equals(FileOwnerQuery.getOwner((FileObject)fileObject).getProjectDirectory())) {
            return;
        }
        if (fileObject.isFolder()) {
            FileObject fileObject3 = fileObject2.createFolder(fileObject.getNameExt());
            FileObject[] fileObjectArray = fileObject.getChildren();
            for (int i = 0; i < fileObjectArray.length; ++i) {
                DefaultProjectOperationsImplementation.doCopy(project, fileObjectArray[i], fileObject3);
            }
        } else {
            if (!$assertionsDisabled && !fileObject.isData()) {
                throw new AssertionError();
            }
            FileObject fileObject4 = FileUtil.copyFile((FileObject)fileObject, (FileObject)fileObject2, (String)fileObject.getName(), (String)fileObject.getExt());
        }
    }

    private static boolean doDelete(Project project, FileObject fileObject) throws IOException {
        if (!project.getProjectDirectory().equals(FileOwnerQuery.getOwner((FileObject)fileObject).getProjectDirectory())) {
            return false;
        }
        if (fileObject.isFolder()) {
            FileObject[] fileObjectArray = fileObject.getChildren();
            boolean bl = true;
            for (int i = 0; i < fileObjectArray.length; ++i) {
                bl &= DefaultProjectOperationsImplementation.doDelete(project, fileObjectArray[i]);
            }
            if (bl) {
                fileObject.delete();
            }
            return bl;
        }
        if (!$assertionsDisabled && !fileObject.isData()) {
            throw new AssertionError();
        }
        fileObject.delete();
        return true;
    }

    private static JComponent wrapPanel(JComponent jComponent) {
        jComponent.setBorder(new EmptyBorder(12, 12, 12, 12));
        return jComponent;
    }

    private static void showConfirmationDialog(final JComponent jComponent, Project project, String string, String string2, String string3, boolean bl, final Executor executor) {
        final JButton jButton = new JButton(NbBundle.getMessage((Class)DefaultProjectOperationsImplementation.class, (String)("LBL_" + string2)));
        final JButton jButton2 = new JButton(string3 == null ? NbBundle.getMessage((Class)DefaultProjectOperationsImplementation.class, (String)"LBL_Cancel_Button") : NbBundle.getMessage((Class)DefaultProjectOperationsImplementation.class, (String)("LBL_" + string3)));
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)DefaultProjectOperationsImplementation.class, (String)("ACSD_" + string2)));
        jButton2.getAccessibleContext().setAccessibleDescription(string3 == null ? NbBundle.getMessage((Class)DefaultProjectOperationsImplementation.class, (String)"ACSD_Cancel_Button") : NbBundle.getMessage((Class)DefaultProjectOperationsImplementation.class, (String)("ACSD_" + string3)));
        if (!$assertionsDisabled && !(jComponent instanceof InvalidablePanel)) {
            throw new AssertionError();
        }
        ((InvalidablePanel)((Object)jComponent)).addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                jButton.setEnabled(((InvalidablePanel)((Object)jComponent)).isPanelValid());
            }
        });
        jButton.setEnabled(((InvalidablePanel)((Object)jComponent)).isPanelValid());
        final Dialog[] dialogArray = new Dialog[1];
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)(bl ? jComponent : DefaultProjectOperationsImplementation.wrapPanel(jComponent)), string, true, new Object[]{jButton, jButton2}, (Object)(string3 != null ? jButton2 : jButton), 0, null, new ActionListener(){
            private boolean operationRunning;

            public void actionPerformed(ActionEvent actionEvent) {
                if (this.operationRunning) {
                    return;
                }
                if (dialogArray[0] instanceof JDialog) {
                    ((JDialog)dialogArray[0]).getRootPane().getInputMap(1).remove(KeyStroke.getKeyStroke(27, 0));
                    ((JDialog)dialogArray[0]).setDefaultCloseOperation(0);
                }
                this.operationRunning = true;
                if (actionEvent.getSource() == jButton) {
                    Container container;
                    jButton.setEnabled(false);
                    jButton2.setEnabled(false);
                    ((InvalidablePanel)((Object)jComponent)).showProgress();
                    for (container = jComponent; container != null && !(container instanceof Window); container = container.getParent()) {
                    }
                    if (container != null) {
                        ((Window)container).pack();
                    }
                    RequestProcessor.getDefault().post(new Runnable(this){
                        private final /* synthetic */ 6 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public void run() {
                            Exception exception = null;
                            try {
                                6.access$500(this.this$0).execute();
                            }
                            catch (Exception exception2) {
                                exception = exception2;
                            }
                            Exception exception3 = exception;
                            SwingUtilities.invokeLater(new Runnable(this, exception3){
                                private final /* synthetic */ Exception val$ex;
                                private final /* synthetic */ 7 this$1;
                                {
                                    this.this$1 = var1_1;
                                    this.val$ex = exception;
                                }

                                public void run() {
                                    6.access$700(7.access$600(this.this$1))[0].setVisible(false);
                                    if (this.val$ex != null) {
                                        ErrorManager.getDefault().notify(1, (Throwable)this.val$ex);
                                        ErrorManager.getDefault().notify(256, (Throwable)this.val$ex);
                                    }
                                }
                            });
                        }

                        static /* synthetic */ 6 access$600(7 var0) {
                            return var0.this$0;
                        }
                    });
                } else {
                    dialogArray[0].setVisible(false);
                }
            }

            static /* synthetic */ Executor access$500(6 var0) {
                return var0.executor;
            }

            static /* synthetic */ Dialog[] access$700(6 var0) {
                return var0.dialogArray;
            }
        });
        if (bl) {
            dialogDescriptor.setMessageType(3);
        }
        dialogDescriptor.setClosingOptions(new Object[0]);
        dialogArray[0] = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialogArray[0].setVisible(true);
        dialogArray[0] = null;
    }

    static String computeError(File file, String string, boolean bl) {
        if (!file.exists()) {
            return NbBundle.getMessage((Class)DefaultProjectOperationsImplementation.class, (String)"ERR_Location_Does_Not_Exist");
        }
        if (!file.canWrite()) {
            return NbBundle.getMessage((Class)DefaultProjectOperationsImplementation.class, (String)"ERR_Location_Read_Only");
        }
        if (string.length() == 0) {
            return NbBundle.getMessage((Class)DefaultProjectOperationsImplementation.class, (String)"ERR_Project_Name_Must_Entered");
        }
        File file2 = new File(file, string);
        if (file2.exists() && !bl) {
            return NbBundle.getMessage((Class)DefaultProjectOperationsImplementation.class, (String)"ERR_Project_Folder_Exists");
        }
        if (string.indexOf(47) != -1 || string.indexOf(92) != -1) {
            return NbBundle.getMessage((Class)DefaultProjectOperationsImplementation.class, (String)"ERR_Not_Valid_Filename", (Object)string);
        }
        return null;
    }

    private static void close(final Project project) {
        Mutex.EVENT.readAccess(new Mutex.Action(){

            public Object run() {
                LifecycleManager.getDefault().saveAll();
                Action action = CommonProjectActions.closeProjectAction();
                Action action2 = action = action instanceof ContextAwareAction ? ((ContextAwareAction)action).createContextAwareInstance(Lookups.fixed((Object[])new Object[]{project})) : null;
                if (action != null && action.isEnabled()) {
                    action.actionPerformed(new ActionEvent(project, -1, ""));
                } else {
                    OpenProjects.getDefault().close(new Project[]{project});
                }
                return null;
            }
        });
    }

    private static void open(final Project project, final boolean bl) {
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                OpenProjects.getDefault().open(new Project[]{project}, false);
                if (bl) {
                    OpenProjects.getDefault().setMainProject(project);
                }
            }
        });
    }

    static {
        $assertionsDisabled = !DefaultProjectOperationsImplementation.class.desiredAssertionStatus();
        ERR = ErrorManager.getDefault();
    }

    public static interface InvalidablePanel {
        public void addChangeListener(ChangeListener var1);

        public void removeChangeListener(ChangeListener var1);

        public boolean isPanelValid();

        public void showProgress();
    }

    static interface Executor {
        public void execute() throws Exception;
    }

    private static final class GUIUserInputHandler
    implements UserInputHandler {
        private GUIUserInputHandler() {
        }

        public void showConfirmationDialog(JComponent jComponent, Project project, String string, String string2, String string3, boolean bl, Executor executor) {
            DefaultProjectOperationsImplementation.showConfirmationDialog(jComponent, project, string, string2, string3, bl, executor);
        }
    }

    static interface UserInputHandler {
        public void showConfirmationDialog(JComponent var1, Project var2, String var3, String var4, String var5, boolean var6, Executor var7);
    }
}

