/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.ui.support;

import java.awt.Dialog;
import java.awt.Image;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import org.netbeans.modules.project.uiapi.CategoryChangeSupport;
import org.netbeans.modules.project.uiapi.CategoryModel;
import org.netbeans.modules.project.uiapi.CategoryView;
import org.netbeans.modules.project.uiapi.CustomizerDialog;
import org.netbeans.modules.project.uiapi.CustomizerPane;
import org.netbeans.modules.project.uiapi.Utilities;
import org.openide.util.HelpCtx;

public final class ProjectCustomizer {
    private ProjectCustomizer() {
    }

    public static Dialog createCustomizerDialog(Category[] categoryArray, CategoryComponentProvider categoryComponentProvider, String string, ActionListener actionListener, HelpCtx helpCtx) {
        CustomizerPane customizerPane = ProjectCustomizer.createCustomizerPane(categoryArray, categoryComponentProvider, string);
        Dialog dialog = CustomizerDialog.createDialog(actionListener, customizerPane, helpCtx, categoryArray);
        return dialog;
    }

    private static CustomizerPane createCustomizerPane(Category[] categoryArray, CategoryComponentProvider categoryComponentProvider, String string) {
        Category category;
        CategoryChangeSupport categoryChangeSupport = new CategoryChangeSupport();
        ProjectCustomizer.registerCategoryChangeSupport(categoryChangeSupport, categoryArray);
        CategoryModel categoryModel = new CategoryModel(categoryArray);
        CategoryView categoryView = new CategoryView(categoryModel);
        CustomizerPane customizerPane = new CustomizerPane(categoryView, categoryModel, categoryComponentProvider);
        if (string == null) {
            string = categoryArray[0].getName();
        }
        if ((category = categoryModel.getCategory(string)) != null) {
            categoryModel.setCurrentCategory(category);
        }
        return customizerPane;
    }

    private static void registerCategoryChangeSupport(CategoryChangeSupport categoryChangeSupport, Category[] categoryArray) {
        for (int i = 0; i < categoryArray.length; ++i) {
            Utilities.putCategoryChangeSupport(categoryArray[i], categoryChangeSupport);
            Category[] categoryArray2 = categoryArray[i].getSubcategories();
            if (categoryArray2 == null) continue;
            ProjectCustomizer.registerCategoryChangeSupport(categoryChangeSupport, categoryArray2);
        }
    }

    public static final class Category {
        private String name;
        private String displayName;
        private Image icon;
        private Category[] subcategories;
        private boolean valid;
        private String errorMessage;

        private Category(String string, String string2, Image image, Category[] categoryArray) {
            this.name = string;
            this.displayName = string2;
            this.icon = image;
            this.subcategories = categoryArray;
            this.valid = true;
        }

        public static Category create(String string, String string2, Image image, Category[] categoryArray) {
            return new Category(string, string2, image, categoryArray);
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Image getIcon() {
            return this.icon;
        }

        public Category[] getSubcategories() {
            return this.subcategories;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public boolean isValid() {
            return this.valid;
        }

        public void setValid(boolean bl) {
            if (this.valid != bl) {
                this.valid = bl;
                Utilities.getCategoryChangeSupport(this).firePropertyChange("isCategoryValid", !bl, bl);
            }
        }

        public void setErrorMessage(String string) {
            if (string == null) {
                string = "";
            }
            if (!string.equals(this.errorMessage)) {
                String string2 = this.errorMessage;
                this.errorMessage = string;
                Utilities.getCategoryChangeSupport(this).firePropertyChange("categoryErrorMessage", string2, string);
            }
        }
    }

    public static interface CategoryComponentProvider {
        public JComponent create(Category var1);
    }
}

