/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.completion;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.MultiKeymap;
import org.netbeans.editor.Registry;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.Completion;
import org.netbeans.editor.ext.CompletionJavaDoc;
import org.netbeans.editor.ext.ExtUtilities;
import org.netbeans.lib.editor.util.swing.DocumentListenerPriority;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.completion.CompletionItemComparator;
import org.netbeans.modules.editor.completion.CompletionLayout;
import org.netbeans.modules.editor.completion.CompletionResultSetImpl;
import org.netbeans.modules.editor.completion.CompletionSettings;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CompletionImpl
extends MouseAdapter
implements DocumentListener,
CaretListener,
KeyListener,
FocusListener,
ListSelectionListener,
ChangeListener,
SettingsChangeListener {
    private static final boolean debug;
    private static CompletionImpl singleton;
    private static final String FOLDER_NAME = "CompletionProviders";
    private static final String NO_SUGGESTIONS;
    private static final String PLEASE_WAIT;
    private static final String POPUP_HIDE = "popup-hide";
    private static final String COMPLETION_SHOW = "completion-show";
    private static final String DOC_SHOW = "doc-show";
    private static final String TOOLTIP_SHOW = "tooltip-show";
    private static final int PLEASE_WAIT_TIMEOUT = 250;
    private WeakReference activeComponent = null;
    private WeakReference activeDocument = null;
    private InputMap inputMap;
    private ActionMap actionMap;
    private final CompletionLayout layout = new CompletionLayout();
    private CompletionProvider[] activeProviders = null;
    private HashMap providersCache = new HashMap();
    private Result completionResult;
    private Result docResult;
    private Result toolTipResult;
    private Timer completionAutoPopupTimer;
    private Timer docAutoPopupTimer;
    private Timer pleaseWaitTimer;
    private boolean refreshedQuery = false;
    private boolean explicitQuery = false;
    private boolean tabCompletionWaiting = false;
    private LinkedList waitingEvents = new LinkedList();
    private int modEndOffset;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static CompletionImpl get() {
        if (singleton == null) {
            singleton = new CompletionImpl();
        }
        return singleton;
    }

    private CompletionImpl() {
        Registry.addChangeListener((ChangeListener)this);
        this.completionAutoPopupTimer = new Timer(0, new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                Result result;
                1 var3_2 = this;
                synchronized (var3_2) {
                    result = CompletionImpl.this.completionResult;
                }
                if (result != null && !result.isQueryInvoked()) {
                    CompletionImpl.this.pleaseWaitTimer.restart();
                    CompletionImpl.queryResultSets(result.getResultSets());
                    result.queryInvoked();
                }
            }
        });
        this.completionAutoPopupTimer.setRepeats(false);
        this.docAutoPopupTimer = new Timer(0, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CompletionImpl.this.showDocumentation(true);
            }
        });
        this.docAutoPopupTimer.setRepeats(false);
        this.pleaseWaitTimer = new Timer(250, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = PLEASE_WAIT;
                Iterator iterator = CompletionImpl.this.completionResult.getResultSets().iterator();
                while (iterator.hasNext()) {
                    CompletionResultSetImpl completionResultSetImpl = (CompletionResultSetImpl)iterator.next();
                    if (completionResultSetImpl.getWaitText() == null) continue;
                    string = completionResultSetImpl.getWaitText();
                    break;
                }
                CompletionImpl.this.layout.showCompletion(Collections.singletonList(string), null, -1, CompletionImpl.this);
            }
        });
        this.pleaseWaitTimer.setRepeats(false);
        Settings.addSettingsChangeListener((SettingsChangeListener)this);
    }

    private JTextComponent getActiveComponent() {
        return this.activeComponent != null ? (JTextComponent)this.activeComponent.get() : null;
    }

    private Document getActiveDocument() {
        return this.activeDocument != null ? (Document)this.activeDocument.get() : null;
    }

    public int getSortType() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertUpdate(DocumentEvent documentEvent) {
        if (!SwingUtilities.isEventDispatchThread()) {
            return;
        }
        if (!DocumentUtilities.isTypingModification((DocumentEvent)documentEvent)) {
            return;
        }
        if (this.activeProviders != null) {
            try {
                this.modEndOffset = documentEvent.getOffset() + documentEvent.getLength();
                if (this.getActiveComponent().getCaretPosition() != this.modEndOffset) {
                    return;
                }
                String string = documentEvent.getDocument().getText(documentEvent.getOffset(), documentEvent.getLength());
                for (int i = 0; i < this.activeProviders.length; ++i) {
                    boolean bl;
                    boolean bl2;
                    int n = this.activeProviders[i].getAutoQueryTypes(this.getActiveComponent(), string);
                    CompletionImpl completionImpl = this;
                    synchronized (completionImpl) {
                        bl2 = this.completionResult == null;
                    }
                    if (bl2 && (n & 1) != 0 && CompletionSettings.INSTANCE.completionAutoPopup()) {
                        this.showCompletion(false, true);
                    }
                    CompletionImpl completionImpl2 = this;
                    synchronized (completionImpl2) {
                        bl = this.toolTipResult == null;
                    }
                    if (!bl || (n & 4) == 0) continue;
                    this.showToolTip();
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (this.completionAutoPopupTimer.isRunning()) {
                this.restartCompletionAutoPopupTimer();
            }
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (!SwingUtilities.isEventDispatchThread()) {
            return;
        }
        this.modEndOffset = documentEvent.getOffset();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void caretUpdate(CaretEvent caretEvent) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        if (this.activeProviders != null) {
            Result result;
            CompletionImpl completionImpl = this;
            synchronized (completionImpl) {
                result = this.completionResult;
            }
            if ((this.completionAutoPopupTimer.isRunning() || result != null) && !this.layout.isCompletionVisible() && caretEvent.getDot() != this.modEndOffset) {
                this.hideCompletion();
            }
            this.completionRefresh();
            this.toolTipRefresh();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.dispatchKeyEvent(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.dispatchKeyEvent(keyEvent);
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.dispatchKeyEvent(keyEvent);
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.hideAll();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.hideAll();
    }

    public void hideAll() {
        this.hideToolTip();
        this.hideCompletion();
        this.hideDocumentation();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        if (this.layout.isDocumentationVisible()) {
            this.restartDocumentationAutoPopupTimer();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object object;
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        boolean bl = false;
        JTextComponent jTextComponent = Registry.getMostActiveComponent();
        if (jTextComponent != this.getActiveComponent()) {
            this.activeProviders = this.getCompletionProvidersForComponent(jTextComponent);
            if (debug) {
                object = new StringBuffer("Completion PROVIDERS:\n");
                if (this.activeProviders != null) {
                    for (int i = 0; i < this.activeProviders.length; ++i) {
                        ((StringBuffer)object).append("providers[");
                        ((StringBuffer)object).append(i);
                        ((StringBuffer)object).append("]: ");
                        ((StringBuffer)object).append(this.activeProviders[i].getClass());
                        ((StringBuffer)object).append('\n');
                    }
                }
                System.err.println(((StringBuffer)object).toString());
            }
            if (this.getActiveComponent() != null) {
                this.getActiveComponent().removeCaretListener(this);
                this.getActiveComponent().removeKeyListener(this);
                this.getActiveComponent().removeFocusListener(this);
                this.getActiveComponent().removeMouseListener(this);
            }
            if (jTextComponent != null) {
                jTextComponent.addCaretListener(this);
                jTextComponent.addKeyListener(this);
                jTextComponent.addFocusListener(this);
                jTextComponent.addMouseListener(this);
            }
            this.activeComponent = jTextComponent != null ? new WeakReference<JTextComponent>(jTextComponent) : null;
            CompletionSettings.INSTANCE.notifyEditorComponentChange(this.getActiveComponent());
            this.layout.setEditorComponent(this.getActiveComponent());
            this.installKeybindings();
            bl = true;
        }
        if ((object = Registry.getMostActiveDocument()) != this.getActiveDocument()) {
            this.activeProviders = this.getCompletionProvidersForComponent(jTextComponent);
            if (debug) {
                StringBuffer stringBuffer = new StringBuffer("Completion PROVIDERS:\n");
                if (this.activeProviders != null) {
                    for (int i = 0; i < this.activeProviders.length; ++i) {
                        stringBuffer.append("providers[");
                        stringBuffer.append(i);
                        stringBuffer.append("]: ");
                        stringBuffer.append(this.activeProviders[i].getClass());
                        stringBuffer.append('\n');
                    }
                }
                System.err.println(stringBuffer.toString());
            }
            if (this.getActiveDocument() != null) {
                DocumentUtilities.removeDocumentListener((Document)this.getActiveDocument(), (DocumentListener)this, (DocumentListenerPriority)DocumentListenerPriority.AFTER_CARET_UPDATE);
            }
            if (this.activeProviders != null) {
                DocumentUtilities.addDocumentListener((Document)object, (DocumentListener)this, (DocumentListenerPriority)DocumentListenerPriority.AFTER_CARET_UPDATE);
            }
            this.activeDocument = new WeakReference<Object>(object);
            bl = true;
        }
        if (bl) {
            this.completionCancel();
        }
    }

    private void restartCompletionAutoPopupTimer() {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        int n = CompletionSettings.INSTANCE.completionAutoPopupDelay();
        this.completionAutoPopupTimer.setInitialDelay(n);
        this.completionAutoPopupTimer.restart();
    }

    private void restartDocumentationAutoPopupTimer() {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        int n = CompletionSettings.INSTANCE.documentationAutoPopupDelay();
        this.docAutoPopupTimer.setInitialDelay(n);
        this.docAutoPopupTimer.restart();
    }

    private CompletionProvider[] getCompletionProvidersForComponent(JTextComponent jTextComponent) {
        Object object;
        String string;
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        if (jTextComponent == null) {
            return null;
        }
        Object object2 = jTextComponent.getDocument().getProperty("mimeType");
        if (object2 instanceof String) {
            string = (String)object2;
        } else {
            object = Utilities.getKit((JTextComponent)jTextComponent);
            if (object == null) {
                return new CompletionProvider[0];
            }
            string = object.getContentType();
        }
        if (this.providersCache.containsKey(string)) {
            return (CompletionProvider[])this.providersCache.get(string);
        }
        object = new ArrayList();
        MimeLookup mimeLookup = MimeLookup.getMimeLookup((String)string);
        object.addAll(mimeLookup.lookup(new Lookup.Template(CompletionProvider.class)).allInstances());
        int n = object.size();
        CompletionProvider[] completionProviderArray = n == 0 ? null : object.toArray(new CompletionProvider[n]);
        this.providersCache.put(string, completionProviderArray);
        return completionProviderArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void dispatchKeyEvent(KeyEvent keyEvent) {
        Object object;
        if (keyEvent == null) {
            return;
        }
        if (this.tabCompletionWaiting) {
            this.waitingEvents.add(keyEvent);
            keyEvent.consume();
            return;
        }
        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
        Object object2 = this.inputMap.get(keyStroke);
        if (object2 != null && (object = this.actionMap.get(object2)) != null) {
            object.actionPerformed(null);
            keyEvent.consume();
            return;
        }
        if (this.layout.isCompletionVisible()) {
            object = this.layout.getSelectedCompletionItem();
            if (object != null) {
                object.processKeyEvent(keyEvent);
                if (keyEvent.isConsumed()) {
                    return;
                }
                if (keyEvent.getKeyCode() == 10 && keyEvent.getID() == 401) {
                    keyEvent.consume();
                    object.defaultAction(this.getActiveComponent());
                    return;
                }
            } else if (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40 || keyEvent.getKeyCode() == 33 || keyEvent.getKeyCode() == 34 || keyEvent.getKeyCode() == 36 || keyEvent.getKeyCode() == 35) {
                this.hideCompletion();
            }
            if (keyEvent.getKeyCode() == 9) {
                keyEvent.consume();
                CompletionImpl completionImpl = this;
                synchronized (completionImpl) {
                    if (!CompletionImpl.isAllResultsFinished(this.completionResult.getResultSets())) {
                        this.tabCompletionWaiting = true;
                    } else {
                        this.insertCommonPrefix();
                    }
                }
                return;
            }
        }
        this.layout.processKeyEvent(keyEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void completionQuery(boolean bl) {
        this.refreshedQuery = false;
        Result result = new Result(this.activeProviders.length);
        Object object = this;
        synchronized (object) {
            if (!$assertionsDisabled && this.completionResult != null) {
                throw new AssertionError();
            }
            this.completionResult = result;
        }
        object = result.getResultSets();
        for (int i = 0; i < this.activeProviders.length; ++i) {
            CompletionTask completionTask = this.activeProviders[i].createTask(1, this.getActiveComponent());
            if (completionTask == null) continue;
            CompletionResultSetImpl completionResultSetImpl = new CompletionResultSetImpl(this, result, completionTask, 1);
            object.add(completionResultSetImpl);
        }
        if (bl) {
            this.restartCompletionAutoPopupTimer();
        } else {
            this.pleaseWaitTimer.restart();
            CompletionImpl.queryResultSets((List)object);
            result.queryInvoked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completionRefresh() {
        Result result;
        Object object = this;
        synchronized (object) {
            result = this.completionResult;
        }
        if (result != null) {
            this.refreshedQuery = true;
            object = result.createRefreshResult();
            CompletionImpl completionImpl = this;
            synchronized (completionImpl) {
                this.completionResult = object;
            }
            ((Result)object).invokeRefresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completionCancel() {
        Result result;
        CompletionImpl completionImpl = this;
        synchronized (completionImpl) {
            result = this.completionResult;
            this.completionResult = null;
            if (this.tabCompletionWaiting) {
                this.tabCompletionWaiting = false;
                this.waitingEvents.clear();
            }
        }
        if (result != null) {
            result.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertCommonPrefix() {
        Result result;
        JTextComponent jTextComponent = this.getActiveComponent();
        Object object = this;
        synchronized (object) {
            result = this.completionResult;
        }
        if (result != null) {
            CompletionResultSetImpl completionResultSetImpl;
            object = null;
            int n = -1;
            Iterator iterator = result.getResultSets().iterator();
            block8: while (iterator.hasNext()) {
                completionResultSetImpl = (CompletionResultSetImpl)iterator.next();
                if (n == -1) {
                    n = completionResultSetImpl.getAnchorOffset();
                }
                Iterator iterator2 = completionResultSetImpl.getItems().iterator();
                block9: while (iterator2.hasNext()) {
                    CharSequence charSequence = ((CompletionItem)iterator2.next()).getInsertPrefix();
                    if (charSequence == null) {
                        object = null;
                        break block8;
                    }
                    if (object == null) {
                        object = charSequence;
                        continue;
                    }
                    int n2 = Math.min(charSequence.length(), object.length());
                    for (int i = 0; i < n2; ++i) {
                        if (charSequence.charAt(i) == object.charAt(i)) continue;
                        if (i == 0) {
                            object = null;
                            break block8;
                        }
                        object = object.subSequence(0, i);
                        continue block9;
                    }
                }
            }
            if (object != null) {
                int n3 = jTextComponent.getCaret().getDot();
                if (n > -1) {
                    object = object.subSequence(n3 - n, object.length());
                }
                completionResultSetImpl = (BaseDocument)this.getActiveDocument();
                completionResultSetImpl.atomicLock();
                try {
                    completionResultSetImpl.insertString(n3, object.toString(), null);
                }
                catch (BadLocationException badLocationException) {
                }
                finally {
                    completionResultSetImpl.atomicUnlock();
                }
            }
        }
        if (this.tabCompletionWaiting) {
            this.tabCompletionWaiting = false;
            while (!this.waitingEvents.isEmpty()) {
                object = (KeyEvent)this.waitingEvents.removeFirst();
                object = new KeyEvent((Component)((EventObject)object).getSource(), ((AWTEvent)object).getID(), ((InputEvent)object).getWhen(), ((InputEvent)object).getModifiers(), ((KeyEvent)object).getKeyCode(), ((KeyEvent)object).getKeyChar(), ((KeyEvent)object).getKeyLocation());
                jTextComponent.dispatchEvent((AWTEvent)object);
            }
        }
    }

    public void showCompletion() {
        this.showCompletion(false, false);
    }

    private void showCompletion(boolean bl, boolean bl2) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new ParamRunnable(0));
            return;
        }
        this.explicitQuery = bl;
        if (this.activeProviders == null) {
            Completion completion = ExtUtilities.getCompletion((JTextComponent)this.getActiveComponent());
            if (completion != null) {
                completion.setPaneVisible(true);
            }
            return;
        }
        this.completionAutoPopupTimer.stop();
        this.completionCancel();
        this.completionQuery(bl2);
    }

    void requestShowCompletionPane(Result result) {
        Object object;
        Object object2;
        this.pleaseWaitTimer.stop();
        int n = 0;
        List list = result.getResultSets();
        for (int i = list.size() - 1; i >= 0; --i) {
            object2 = (CompletionResultSetImpl)list.get(i);
            n += ((CompletionResultSetImpl)object2).getItems().size();
        }
        final ArrayList arrayList = new ArrayList(n);
        object2 = null;
        int n2 = -1;
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            CompletionResultSetImpl completionResultSetImpl = (CompletionResultSetImpl)list.get(i);
            object = completionResultSetImpl.getItems();
            if (object.size() <= 0) continue;
            arrayList.addAll(object);
            if (object2 == null) {
                object2 = completionResultSetImpl.getTitle();
            }
            if (n2 != -1) continue;
            n2 = completionResultSetImpl.getAnchorOffset();
        }
        Collections.sort(arrayList, CompletionItemComparator.get(this.getSortType()));
        CompletionResultSetImpl completionResultSetImpl = object2;
        int n3 = n2;
        object = new Runnable((String)((Object)completionResultSetImpl), n3){
            private final /* synthetic */ String val$displayTitle;
            private final /* synthetic */ int val$displayAnchorOffset;
            {
                this.val$displayTitle = string;
                this.val$displayAnchorOffset = n;
            }

            public void run() {
                Object object;
                int n = CompletionImpl.this.getActiveComponent().getCaretPosition();
                if (arrayList.size() == 1 && !CompletionImpl.this.refreshedQuery && CompletionImpl.this.explicitQuery && CompletionSettings.INSTANCE.completionInstantSubstitution()) {
                    try {
                        CompletionItem completionItem;
                        object = Utilities.getIdentifierBlock((JTextComponent)CompletionImpl.this.getActiveComponent(), (int)n);
                        if ((object == null || object[1] == n) && (completionItem = (CompletionItem)arrayList.get(0)).instantSubstitution(CompletionImpl.this.getActiveComponent())) {
                            return;
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                object = new ArrayList<String>(arrayList);
                boolean bl = false;
                if (object.size() == 0) {
                    object.add(NO_SUGGESTIONS);
                    bl = true;
                }
                CompletionImpl.this.layout.showCompletion((List)object, this.val$displayTitle, this.val$displayAnchorOffset, CompletionImpl.this);
                if (CompletionSettings.INSTANCE.documentationAutoPopup()) {
                    if (bl) {
                        CompletionImpl.this.hideDocumentation();
                    } else {
                        CompletionImpl.this.restartDocumentationAutoPopupTimer();
                    }
                }
            }
        };
        CompletionImpl.runInAWT((Runnable)object);
    }

    public boolean hideCompletion() {
        this.completionCancel();
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new ParamRunnable(3));
            return false;
        }
        return this.hideCompletionPane();
    }

    private boolean hideCompletionPane() {
        this.completionAutoPopupTimer.stop();
        this.pleaseWaitTimer.stop();
        boolean bl = this.layout.hideCompletion();
        if (bl && CompletionSettings.INSTANCE.documentationAutoPopup()) {
            this.hideDocumentation();
        }
        return bl;
    }

    public void showDocumentation() {
        this.showDocumentation(false);
    }

    void showDocumentation(boolean bl) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new ParamRunnable(1));
            return;
        }
        if (this.activeProviders != null) {
            this.documentationCancel();
            if (bl) {
                this.layout.clearDocumentationHistory();
            }
        } else {
            CompletionJavaDoc completionJavaDoc = ExtUtilities.getCompletionJavaDoc((JTextComponent)this.getActiveComponent());
            if (completionJavaDoc != null) {
                completionJavaDoc.setJavaDocVisible(true);
            }
            return;
        }
        this.documentationQuery();
    }

    void requestShowDocumentationPane(Result result) {
        final CompletionResultSetImpl completionResultSetImpl = CompletionImpl.findFirstValidResult(result.getResultSets());
        if (completionResultSetImpl != null) {
            CompletionImpl.runInAWT(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    CompletionImpl completionImpl = CompletionImpl.this;
                    synchronized (completionImpl) {
                        CompletionImpl.this.layout.showDocumentation(completionResultSetImpl.getDocumentation(), completionResultSetImpl.getAnchorOffset());
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void documentationQuery() {
        CompletionTask completionTask;
        Result result = new Result(1);
        Object object = this;
        synchronized (object) {
            if (!$assertionsDisabled && this.docResult != null) {
                throw new AssertionError();
            }
            this.docResult = result;
        }
        object = this.docResult.getResultSets();
        CompletionItem completionItem = this.layout.getSelectedCompletionItem();
        if (completionItem != null && (completionTask = completionItem.createDocumentationTask()) != null) {
            CompletionResultSetImpl completionResultSetImpl = new CompletionResultSetImpl(this, result, completionTask, 2);
            object.add(completionResultSetImpl);
        } else {
            for (int i = 0; i < this.activeProviders.length; ++i) {
                completionTask = this.activeProviders[i].createTask(2, this.getActiveComponent());
                if (completionTask == null) continue;
                CompletionResultSetImpl completionResultSetImpl = new CompletionResultSetImpl(this, result, completionTask, 2);
                object.add(completionResultSetImpl);
            }
        }
        CompletionImpl.queryResultSets((List)object);
        result.queryInvoked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void documentationRefresh() {
        Result result;
        Object object = this;
        synchronized (object) {
            result = this.docResult;
        }
        if (result != null) {
            object = result.createRefreshResult();
            CompletionImpl completionImpl = this;
            synchronized (completionImpl) {
                this.docResult = object;
            }
            ((Result)object).invokeRefresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void documentationCancel() {
        Result result;
        CompletionImpl completionImpl = this;
        synchronized (completionImpl) {
            result = this.docResult;
            this.docResult = null;
        }
        if (result != null) {
            result.cancel();
        }
    }

    public boolean hideDocumentation() {
        this.documentationCancel();
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new ParamRunnable(4));
            return false;
        }
        return this.hideDocumentationPane();
    }

    boolean hideDocumentationPane() {
        this.docAutoPopupTimer.stop();
        boolean bl = this.layout.hideDocumentation();
        if (bl && CompletionSettings.INSTANCE.documentationAutoPopup()) {
            this.hideCompletion();
        }
        return bl;
    }

    public void showToolTip() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new ParamRunnable(2));
            return;
        }
        if (this.activeProviders != null) {
            this.toolTipCancel();
            this.toolTipQuery();
        }
    }

    void requestShowToolTipPane(Result result) {
        final CompletionResultSetImpl completionResultSetImpl = CompletionImpl.findFirstValidResult(result.getResultSets());
        CompletionImpl.runInAWT(new Runnable(){

            public void run() {
                if (completionResultSetImpl != null) {
                    CompletionImpl.this.layout.showToolTip(completionResultSetImpl.getToolTip(), completionResultSetImpl.getAnchorOffset());
                } else {
                    CompletionImpl.this.hideToolTip();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void toolTipQuery() {
        CompletionTask completionTask;
        Result result = new Result(1);
        Object object = this;
        synchronized (object) {
            if (!$assertionsDisabled && this.toolTipResult != null) {
                throw new AssertionError();
            }
            this.toolTipResult = result;
        }
        object = result.getResultSets();
        CompletionItem completionItem = this.layout.getSelectedCompletionItem();
        if (completionItem != null && (completionTask = completionItem.createToolTipTask()) != null) {
            CompletionResultSetImpl completionResultSetImpl = new CompletionResultSetImpl(this, result, completionTask, 4);
            object.add(completionResultSetImpl);
        } else {
            for (int i = 0; i < this.activeProviders.length; ++i) {
                completionTask = this.activeProviders[i].createTask(4, this.getActiveComponent());
                if (completionTask == null) continue;
                CompletionResultSetImpl completionResultSetImpl = new CompletionResultSetImpl(this, result, completionTask, 4);
                object.add(completionResultSetImpl);
            }
        }
        CompletionImpl.queryResultSets((List)object);
        result.queryInvoked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void toolTipRefresh() {
        Result result;
        Object object = this;
        synchronized (object) {
            result = this.toolTipResult;
        }
        if (result != null) {
            object = result.createRefreshResult();
            CompletionImpl completionImpl = this;
            synchronized (completionImpl) {
                this.toolTipResult = object;
            }
            ((Result)object).invokeRefresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void toolTipCancel() {
        Result result;
        CompletionImpl completionImpl = this;
        synchronized (completionImpl) {
            result = this.toolTipResult;
            this.toolTipResult = null;
        }
        if (result != null) {
            result.cancel();
        }
    }

    public boolean hideToolTip() {
        this.toolTipCancel();
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new ParamRunnable(5));
            return false;
        }
        return this.hideToolTipPane();
    }

    boolean hideToolTipPane() {
        return this.layout.hideToolTip();
    }

    private KeyStroke[] findEditorKeys(String string, KeyStroke keyStroke) {
        KeyStroke[] keyStrokeArray = new KeyStroke[]{keyStroke};
        if (string != null && this.getActiveComponent() != null) {
            Action action;
            EditorKit editorKit;
            TextUI textUI = this.getActiveComponent().getUI();
            Keymap keymap = this.getActiveComponent().getKeymap();
            if (textUI != null && keymap != null && (editorKit = textUI.getEditorKit(this.getActiveComponent())) instanceof BaseKit && (action = ((BaseKit)editorKit).getActionByName(string)) != null) {
                KeyStroke[] keyStrokeArray2 = keymap.getKeyStrokesForAction(action);
                if (keyStrokeArray2 != null && keyStrokeArray2.length > 0) {
                    keyStrokeArray = keyStrokeArray2;
                } else {
                    MultiKeymap multiKeymap = ((BaseKit)editorKit).getKeymap();
                    KeyStroke[] keyStrokeArray3 = multiKeymap.getKeyStrokesForAction(action);
                    if (keyStrokeArray3 != null && keyStrokeArray3.length > 0) {
                        keyStrokeArray = keyStrokeArray3;
                    }
                }
            }
        }
        return keyStrokeArray;
    }

    private void installKeybindings() {
        int n;
        this.actionMap = new ActionMap();
        this.inputMap = new InputMap();
        KeyStroke[] keyStrokeArray = this.findEditorKeys(COMPLETION_SHOW, KeyStroke.getKeyStroke(32, 2));
        for (n = 0; n < keyStrokeArray.length; ++n) {
            this.inputMap.put(keyStrokeArray[n], COMPLETION_SHOW);
        }
        this.actionMap.put(COMPLETION_SHOW, new CompletionShowAction());
        keyStrokeArray = this.findEditorKeys("documentation-show", KeyStroke.getKeyStroke(32, 3));
        for (n = 0; n < keyStrokeArray.length; ++n) {
            this.inputMap.put(keyStrokeArray[n], DOC_SHOW);
        }
        this.actionMap.put(DOC_SHOW, new DocShowAction());
        keyStrokeArray = this.findEditorKeys(TOOLTIP_SHOW, KeyStroke.getKeyStroke(80, 8));
        for (n = 0; n < keyStrokeArray.length; ++n) {
            this.inputMap.put(keyStrokeArray[n], TOOLTIP_SHOW);
        }
        this.actionMap.put(TOOLTIP_SHOW, new ToolTipShowAction());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishNotify(CompletionResultSetImpl completionResultSetImpl) {
        switch (completionResultSetImpl.getQueryType()) {
            case 1: {
                Result result;
                CompletionImpl completionImpl = this;
                synchronized (completionImpl) {
                    result = this.completionResult;
                }
                if (completionResultSetImpl.getResultId() != result || !CompletionImpl.isAllResultsFinished(result.getResultSets())) break;
                this.requestShowCompletionPane(result);
                completionImpl = this;
                synchronized (completionImpl) {
                    if (this.tabCompletionWaiting) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                CompletionImpl.this.insertCommonPrefix();
                            }
                        });
                    }
                    break;
                }
            }
            case 2: {
                Result result;
                CompletionImpl completionImpl = this;
                synchronized (completionImpl) {
                    result = this.docResult;
                }
                if (completionResultSetImpl.getResultId() != result || !CompletionImpl.isAllResultsFinished(result.getResultSets())) break;
                this.requestShowDocumentationPane(result);
                break;
            }
            case 4: {
                Result result;
                CompletionImpl completionImpl = this;
                synchronized (completionImpl) {
                    result = this.toolTipResult;
                }
                if (completionResultSetImpl.getResultId() != result || !CompletionImpl.isAllResultsFinished(result.getResultSets())) break;
                this.requestShowToolTipPane(result);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private static boolean isAllResultsFinished(List list) {
        for (int i = list.size() - 1; i >= 0; --i) {
            CompletionResultSetImpl completionResultSetImpl = (CompletionResultSetImpl)list.get(i);
            if (completionResultSetImpl.isFinished()) continue;
            if (debug) {
                System.err.println("CompletionTask: " + completionResultSetImpl.getTask() + " not finished yet");
            }
            return false;
        }
        if (debug) {
            System.err.println("----- All tasks finished -----");
        }
        return true;
    }

    private static CompletionResultSetImpl findFirstValidResult(List list) {
        block4: for (int i = 0; i < list.size(); ++i) {
            CompletionResultSetImpl completionResultSetImpl = (CompletionResultSetImpl)list.get(i);
            switch (completionResultSetImpl.getQueryType()) {
                case 2: {
                    if (completionResultSetImpl.getDocumentation() == null) continue block4;
                    return completionResultSetImpl;
                }
                case 4: {
                    if (completionResultSetImpl.getToolTip() == null) continue block4;
                    return completionResultSetImpl;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return null;
    }

    private static void runInAWT(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private static void queryResultSets(List list) {
        for (int i = 0; i < list.size(); ++i) {
            CompletionResultSetImpl completionResultSetImpl = (CompletionResultSetImpl)list.get(i);
            completionResultSetImpl.getTask().query(completionResultSetImpl.getResultSet());
        }
    }

    private static void createRefreshResultSets(List list, Result result) {
        List list2 = result.getResultSets();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            CompletionResultSetImpl completionResultSetImpl = (CompletionResultSetImpl)list.get(i);
            completionResultSetImpl.markInactive();
            completionResultSetImpl = new CompletionResultSetImpl(completionResultSetImpl.getCompletionImpl(), result, completionResultSetImpl.getTask(), completionResultSetImpl.getQueryType());
            list2.add(completionResultSetImpl);
        }
    }

    private static void refreshResultSets(List list, boolean bl) {
        try {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                CompletionResultSetImpl completionResultSetImpl = (CompletionResultSetImpl)list.get(i);
                completionResultSetImpl.getTask().refresh(bl ? null : completionResultSetImpl.getResultSet());
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
    }

    private static void cancelResultSets(List list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            CompletionResultSetImpl completionResultSetImpl = (CompletionResultSetImpl)list.get(i);
            completionResultSetImpl.markInactive();
            completionResultSetImpl.getTask().cancel();
        }
    }

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        if (settingsChangeEvent == null) {
            return;
        }
        String string = settingsChangeEvent.getSettingName();
        if ("key-bindings".equals(string) || string == null) {
            Utilities.runInEventDispatchThread((Runnable)new Runnable(){

                public void run() {
                    CompletionImpl.this.installKeybindings();
                }
            });
        }
    }

    static {
        $assertionsDisabled = !CompletionImpl.class.desiredAssertionStatus();
        debug = Boolean.getBoolean("netbeans.debug.editor.completion");
        singleton = null;
        NO_SUGGESTIONS = NbBundle.getMessage((Class)CompletionImpl.class, (String)"completion-no-suggestions");
        PLEASE_WAIT = NbBundle.getMessage((Class)CompletionImpl.class, (String)"completion-please-wait");
    }

    static final class Result {
        private final List resultSets;
        private boolean invoked;
        private boolean cancelled;
        private boolean beforeQuery = true;
        static final /* synthetic */ boolean $assertionsDisabled;

        Result(int n) {
            this.resultSets = new ArrayList(n);
        }

        List getResultSets() {
            return this.resultSets;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cancel() {
            boolean bl;
            Result result = this;
            synchronized (result) {
                if (!$assertionsDisabled && this.cancelled) {
                    throw new AssertionError();
                }
                bl = this.invoked;
                if (!this.invoked) {
                    this.cancelled = true;
                }
            }
            if (bl) {
                CompletionImpl.cancelResultSets(this.resultSets);
            }
        }

        synchronized boolean isQueryInvoked() {
            return this.invoked;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean queryInvoked() {
            boolean bl;
            Result result = this;
            synchronized (result) {
                if (!$assertionsDisabled && this.invoked) {
                    throw new AssertionError();
                }
                this.invoked = true;
                bl = this.cancelled;
                this.beforeQuery = false;
            }
            if (bl) {
                CompletionImpl.cancelResultSets(this.resultSets);
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Result createRefreshResult() {
            Result result = this;
            synchronized (result) {
                if (this.cancelled) {
                    return null;
                }
                if (this.beforeQuery) {
                    return this;
                }
                if (!$assertionsDisabled && !this.invoked) {
                    throw new AssertionError();
                }
                this.invoked = false;
            }
            result = new Result(this.getResultSets().size());
            result.beforeQuery = this.beforeQuery;
            CompletionImpl.createRefreshResultSets(this.resultSets, result);
            return result;
        }

        void invokeRefresh() {
            CompletionImpl.refreshResultSets(this.getResultSets(), this.beforeQuery);
            if (!this.beforeQuery) {
                this.queryInvoked();
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$editor$completion$CompletionImpl == null ? (class$org$netbeans$modules$editor$completion$CompletionImpl = CompletionImpl.class$("org.netbeans.modules.editor.completion.CompletionImpl")) : class$org$netbeans$modules$editor$completion$CompletionImpl).desiredAssertionStatus();
        }
    }

    private final class ParamRunnable
    implements Runnable {
        private static final int SHOW_COMPLETION = 0;
        private static final int SHOW_DOCUMENTATION = 1;
        private static final int SHOW_TOOL_TIP = 2;
        private static final int HIDE_COMPLETION_PANE = 3;
        private static final int HIDE_DOCUMENTATION_PANE = 4;
        private static final int HIDE_TOOL_TIP_PANE = 5;
        private final int opCode;

        ParamRunnable(int n) {
            this.opCode = n;
        }

        public void run() {
            switch (this.opCode) {
                case 0: {
                    CompletionImpl.this.showCompletion();
                    break;
                }
                case 1: {
                    CompletionImpl.this.showDocumentation();
                    break;
                }
                case 2: {
                    CompletionImpl.this.showToolTip();
                    break;
                }
                case 3: {
                    CompletionImpl.this.hideCompletionPane();
                    break;
                }
                case 4: {
                    CompletionImpl.this.hideDocumentationPane();
                    break;
                }
                case 5: {
                    CompletionImpl.this.hideToolTipPane();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    private final class ToolTipShowAction
    extends AbstractAction {
        private ToolTipShowAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CompletionImpl.this.showToolTip();
        }
    }

    private final class DocShowAction
    extends AbstractAction {
        private DocShowAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CompletionImpl.this.showDocumentation(false);
        }
    }

    private final class CompletionShowAction
    extends AbstractAction {
        private CompletionShowAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CompletionImpl.this.showCompletion(true, false);
        }
    }
}

