/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.completion;

import java.util.Comparator;
import org.netbeans.spi.editor.completion.CompletionItem;

public class CompletionItemComparator
implements Comparator {
    public static final Comparator BY_PRIORITY;
    public static final Comparator ALPHABETICAL;
    private final boolean byPriority;
    static final /* synthetic */ boolean $assertionsDisabled;

    private CompletionItemComparator(boolean bl) {
        this.byPriority = bl;
    }

    public static final Comparator get(int n) {
        if (n == 0) {
            return BY_PRIORITY;
        }
        if (n == 1) {
            return ALPHABETICAL;
        }
        throw new IllegalArgumentException();
    }

    public int compare(Object object, Object object2) {
        CompletionItemComparator.assertCompletionItem(object);
        CompletionItemComparator.assertCompletionItem(object2);
        if (object == object2) {
            return 0;
        }
        CompletionItem completionItem = (CompletionItem)object;
        CompletionItem completionItem2 = (CompletionItem)object2;
        if (this.byPriority) {
            int n = completionItem.getSortPriority() - completionItem2.getSortPriority();
            if (n != 0) {
                return n;
            }
            int n2 = CompletionItemComparator.compareText(completionItem.getSortText(), completionItem2.getSortText());
            if (n2 != 0) {
                return n2;
            }
        } else {
            int n = CompletionItemComparator.compareText(completionItem.getSortText(), completionItem2.getSortText());
            if (n != 0) {
                return n;
            }
            int n3 = completionItem.getSortPriority() - completionItem2.getSortPriority();
            if (n3 != 0) {
                return n3;
            }
        }
        return -1;
    }

    private static void assertCompletionItem(Object object) {
        if (!$assertionsDisabled && !(object instanceof CompletionItem)) {
            throw new AssertionError((Object)("Non CompletionItem instance " + object + ":" + (object != null ? object.getClass().getName() : "<null>") + " appeared in the code completion result list"));
        }
    }

    private static int compareText(CharSequence charSequence, CharSequence charSequence2) {
        int n = Math.min(charSequence.length(), charSequence2.length());
        for (int i = 0; i < n; ++i) {
            char c;
            char c2 = charSequence.charAt(i);
            if (c2 == (c = charSequence2.charAt(i))) continue;
            return c2 - c;
        }
        return charSequence.length() - charSequence2.length();
    }

    static {
        $assertionsDisabled = !CompletionItemComparator.class.desiredAssertionStatus();
        BY_PRIORITY = new CompletionItemComparator(true);
        ALPHABETICAL = new CompletionItemComparator(false);
    }
}

