/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.completion;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.event.MouseListener;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.spi.editor.completion.CompletionItem;

public class CompletionJList
extends JList {
    private static final int DARKER_COLOR_COMPONENT = 5;
    private final RenderComponent renderComponent;
    private Graphics cellPreferredSizeGraphics;
    private int fixedItemHeight;
    private int maxVisibleRowCount;
    static /* synthetic */ Class class$org$netbeans$modules$editor$completion$CompletionJList;

    public CompletionJList(int n, MouseListener mouseListener) {
        this.maxVisibleRowCount = n;
        this.addMouseListener(mouseListener);
        this.setLayoutOrientation(0);
        this.fixedItemHeight = Math.max(16, this.getFontMetrics(this.getFont()).getHeight());
        this.setFixedCellHeight(this.fixedItemHeight);
        this.setModel(new Model(Collections.EMPTY_LIST));
        this.renderComponent = new RenderComponent();
        this.setSelectionMode(0);
        this.setCellRenderer(new ListCellRenderer(){
            private ListCellRenderer defaultRenderer = new DefaultListCellRenderer();

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (object instanceof CompletionItem) {
                    Color color;
                    Color color2;
                    CompletionItem completionItem = (CompletionItem)object;
                    CompletionJList.this.renderComponent.setItem(completionItem);
                    CompletionJList.this.renderComponent.setSelected(bl);
                    if (bl) {
                        color2 = jList.getSelectionBackground();
                        color = jList.getSelectionForeground();
                    } else {
                        color2 = jList.getBackground();
                        if (n % 2 == 0) {
                            color2 = new Color(Math.abs(color2.getRed() - 5), Math.abs(color2.getGreen() - 5), Math.abs(color2.getBlue() - 5));
                        }
                        color = jList.getForeground();
                    }
                    if (CompletionJList.this.renderComponent.getBackground() != color2) {
                        CompletionJList.this.renderComponent.setBackground(color2);
                    }
                    if (CompletionJList.this.renderComponent.getForeground() != color) {
                        CompletionJList.this.renderComponent.setForeground(color);
                    }
                    return CompletionJList.this.renderComponent;
                }
                return this.defaultRenderer.getListCellRendererComponent(jList, object, n, bl, bl2);
            }
        });
        this.getAccessibleContext().setAccessibleName(LocaleSupport.getString((String)"ACSN_CompletionView"));
        this.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString((String)"ACSD_CompletionView"));
    }

    void setData(List list) {
        if (list != null) {
            int n;
            int n2 = list.size();
            ((Model)this.getModel()).setData(list);
            if (n2 > 0) {
                this.setSelectedIndex(0);
            }
            if (n2 > (n = this.getVisibleRowCount())) {
                n = Math.min(n2, this.maxVisibleRowCount);
            } else if (n2 < n && n2 < n * 2 / 3) {
                n = n2;
            }
            this.setVisibleRowCount(n);
        }
    }

    public void up() {
        int n = this.getModel().getSize();
        if (n > 0) {
            this.setSelectedIndex((this.getSelectedIndex() - 1 + n) % n);
            this.ensureIndexIsVisible(this.getSelectedIndex());
        }
    }

    public void down() {
        int n = this.getModel().getSize();
        if (n > 0) {
            this.setSelectedIndex((this.getSelectedIndex() + 1) % n);
            this.ensureIndexIsVisible(this.getSelectedIndex());
        }
    }

    public void pageUp() {
        if (this.getModel().getSize() > 0) {
            int n = Math.max(this.getLastVisibleIndex() - this.getFirstVisibleIndex(), 0);
            int n2 = Math.max(this.getSelectedIndex() - n, 0);
            this.setSelectedIndex(n2);
            this.ensureIndexIsVisible(n2);
        }
    }

    public void pageDown() {
        int n = this.getModel().getSize() - 1;
        if (n >= 0) {
            int n2 = Math.max(this.getLastVisibleIndex() - this.getFirstVisibleIndex(), 0);
            int n3 = Math.min(this.getSelectedIndex() + n2, n);
            this.setSelectedIndex(n3);
            this.ensureIndexIsVisible(n3);
        }
    }

    public void begin() {
        if (this.getModel().getSize() > 0) {
            this.setSelectedIndex(0);
            this.ensureIndexIsVisible(0);
        }
    }

    public void end() {
        int n = this.getModel().getSize() - 1;
        if (n >= 0) {
            this.setSelectedIndex(n);
            this.ensureIndexIsVisible(n);
        }
    }

    private final class RenderComponent
    extends JComponent {
        private CompletionItem item;
        private boolean selected;
        static final /* synthetic */ boolean $assertionsDisabled;

        private RenderComponent() {
        }

        void setItem(CompletionItem completionItem) {
            this.item = completionItem;
        }

        void setSelected(boolean bl) {
            this.selected = bl;
        }

        private void clearItem() {
            this.item = this.item;
        }

        public void paintComponent(Graphics graphics) {
            int n = ((JViewport)CompletionJList.this.getParent()).getWidth();
            Color color = this.getBackground();
            Color color2 = this.getForeground();
            int n2 = this.getHeight();
            graphics.setColor(color);
            graphics.fillRect(0, 0, n, n2);
            graphics.setColor(color2);
            this.item.render(graphics, this.getFont(), this.getForeground(), color, n, this.getHeight(), this.selected);
        }

        public Dimension getPreferredSize() {
            if (CompletionJList.this.cellPreferredSizeGraphics == null) {
                CompletionJList.this.cellPreferredSizeGraphics = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(1, 1).getGraphics();
                if (!$assertionsDisabled && CompletionJList.this.cellPreferredSizeGraphics == null) {
                    throw new AssertionError();
                }
            }
            return new Dimension(this.item.getPreferredWidth(CompletionJList.this.cellPreferredSizeGraphics, this.getFont()), CompletionJList.this.fixedItemHeight);
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$editor$completion$CompletionJList == null ? (class$org$netbeans$modules$editor$completion$CompletionJList = CompletionJList.class$("org.netbeans.modules.editor.completion.CompletionJList")) : class$org$netbeans$modules$editor$completion$CompletionJList).desiredAssertionStatus();
        }
    }

    static class Model
    extends AbstractListModel {
        List data;
        static final long serialVersionUID = 3292276783870598274L;

        public Model(List list) {
            this.data = list;
        }

        public void setData(List list) {
            List list2 = this.data;
            this.data = list;
            this.fireContentsChanged(this, 0, list2.size());
        }

        public int getSize() {
            return this.data.size();
        }

        public Object getElementAt(int n) {
            return n >= 0 && n < this.data.size() ? this.data.get(n) : null;
        }

        List getData() {
            return this.data;
        }
    }
}

