/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.completion;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public class CompletionPopup {
    private static final int WINDOW_GAP = 1;
    private JTextComponent component;
    private Popup completionPopup = null;
    private Popup docPopup = null;
    private Popup tipPopup = null;
    private JComponent completionComponent = null;
    private int completionOffset = -1;
    private JComponent docComponent = null;
    private int docOffset = -1;
    private JToolTip tipComponent = null;
    private int tipOffset = -1;
    private boolean isCompletionAbove = false;
    private boolean isTipAbove = false;

    public void setCompletion(JComponent jComponent, int n) {
        if (this.isCompletionShowing()) {
            this.completionPopup.hide();
            this.completionPopup = null;
            this.completionComponent = null;
            this.completionOffset = -1;
        }
        if (jComponent != null) {
            try {
                this.completionComponent = jComponent;
                this.completionOffset = n;
                Dimension dimension = this.completionComponent.getPreferredSize();
                Rectangle rectangle = this.component.modelToView(n < 0 ? this.component.getCaret().getDot() : n);
                Point point = rectangle.getLocation();
                SwingUtilities.convertPointToScreen(point, this.component);
                Rectangle rectangle2 = this.component.getGraphicsConfiguration().getBounds();
                int n2 = Math.min(0, rectangle2.x + rectangle2.width - point.x - dimension.width);
                int n3 = 0;
                if (point.y + rectangle.height + dimension.height > rectangle2.y + rectangle2.height) {
                    this.isCompletionAbove = true;
                    n3 = -dimension.height - 1;
                } else {
                    this.isCompletionAbove = false;
                    n3 = rectangle.height + 1;
                }
                point.translate(n2, n3);
                PopupFactory popupFactory = PopupFactory.getSharedInstance();
                this.completionPopup = popupFactory.getPopup(null, jComponent, point.x, point.y);
                this.completionPopup.show();
                if (this.isTipShowing() && this.isTipAbove == this.isCompletionAbove) {
                    this.setTip(this.tipComponent, this.tipOffset);
                }
                if (this.isDocShowing()) {
                    this.setDoc(this.docComponent, this.docOffset, true);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public boolean isCompletionShowing() {
        return this.completionPopup != null;
    }

    public void setDoc(JComponent jComponent, int n) {
        this.setDoc(jComponent, n, false);
    }

    private void setDoc(JComponent jComponent, int n, boolean bl) {
        if (!bl && this.docComponent == jComponent && this.docOffset == n) {
            return;
        }
        if (this.isDocShowing()) {
            this.docPopup.hide();
            this.docPopup = null;
            this.docComponent = null;
            this.docOffset = -1;
        }
        if (jComponent != null) {
            try {
                int n2;
                this.docComponent = jComponent;
                this.docOffset = this.isCompletionShowing() ? this.completionOffset : (n < 0 ? this.component.getCaret().getDot() : n);
                Dimension dimension = this.docComponent.getPreferredSize();
                Rectangle rectangle = this.component.modelToView(this.docOffset);
                Point point = rectangle.getLocation();
                SwingUtilities.convertPointToScreen(point, this.component);
                Rectangle rectangle2 = this.component.getGraphicsConfiguration().getBounds();
                int n3 = Math.min(0, rectangle2.x + rectangle2.width - point.x - dimension.width);
                int n4 = 0;
                int n5 = n2 = this.isTipShowing() ? this.tipComponent.getHeight() : 0;
                if (this.isCompletionShowing()) {
                    int n6 = this.completionComponent.getHeight();
                    n4 = this.isCompletionAbove ? (point.y - dimension.height - n6 > rectangle2.y ? -dimension.height - n6 - 1 : rectangle.height + (this.isTipShowing() ? n2 : 0) + 1) : (point.y + rectangle.height + n6 + dimension.height > rectangle2.y + rectangle2.height ? -dimension.height - (this.isTipShowing() ? n2 : 0) - 1 : rectangle.height + n6 + 1);
                } else {
                    n4 = point.y - dimension.height - (this.isTipAbove ? n2 : 0) > rectangle2.y ? -dimension.height - (this.isTipAbove ? n2 : 0) - 1 : rectangle.height + (this.isTipAbove ? n2 : 0) + 1;
                }
                point.translate(n3, n4);
                PopupFactory popupFactory = PopupFactory.getSharedInstance();
                this.docPopup = popupFactory.getPopup(null, jComponent, point.x, point.y);
                this.docPopup.show();
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public boolean isDocShowing() {
        return this.docPopup != null;
    }

    public void setTip(JToolTip jToolTip, int n) {
        this.setTip(jToolTip, n, false);
    }

    private void setTip(JToolTip jToolTip, int n, boolean bl) {
        if (this.tipComponent == jToolTip && this.tipOffset == n) {
            return;
        }
        if (this.isTipShowing()) {
            this.tipPopup.hide();
            this.tipPopup = null;
            this.tipComponent = null;
            this.tipOffset = -1;
        }
        if (jToolTip != null) {
            try {
                this.tipComponent = jToolTip;
                this.tipOffset = n;
                Dimension dimension = this.tipComponent.getPreferredSize();
                Rectangle rectangle = this.component.modelToView(n < 0 ? this.component.getCaret().getDot() : n);
                Point point = rectangle.getLocation();
                SwingUtilities.convertPointToScreen(point, this.component);
                Rectangle rectangle2 = this.component.getGraphicsConfiguration().getBounds();
                int n2 = Math.min(0, rectangle2.x + rectangle2.width - point.x - dimension.width);
                int n3 = 0;
                if (this.isCompletionShowing() && this.isCompletionAbove) {
                    this.isTipAbove = false;
                    n3 = rectangle.height + 1;
                } else {
                    this.isTipAbove = true;
                    n3 = -dimension.height - 1;
                }
                point.translate(n2, n3);
                PopupFactory popupFactory = PopupFactory.getSharedInstance();
                this.tipPopup = popupFactory.getPopup(null, jToolTip, point.x, point.y);
                this.tipPopup.show();
                if (this.isDocShowing()) {
                    this.setDoc(this.docComponent, this.docOffset, true);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public boolean isTipShowing() {
        return this.tipPopup != null;
    }

    public void setComponent(JTextComponent jTextComponent) {
        this.hide();
        this.component = jTextComponent;
    }

    private void hide() {
        this.setCompletion(null, -1);
        this.setDoc(null, -1);
        this.setTip(null, -1);
    }
}

