/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.completion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JToolTip;
import org.netbeans.modules.editor.completion.CompletionImpl;
import org.netbeans.modules.editor.completion.CompletionSpiPackageAccessor;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;

public final class CompletionResultSetImpl {
    private static final CompletionSpiPackageAccessor spi;
    private final CompletionImpl completionImpl;
    private final Object resultId;
    private final CompletionTask task;
    private final int queryType;
    private CompletionResultSet resultSet;
    private boolean active;
    private String title;
    private String waitText;
    private int anchorOffset;
    private List items;
    private boolean itemsAlreadySorted;
    private boolean finished;
    private CompletionDocumentation documentation;
    private JToolTip toolTip;
    private int estimatedItemCount;
    private int estimatedItemWidth;
    static final /* synthetic */ boolean $assertionsDisabled;

    CompletionResultSetImpl(CompletionImpl completionImpl, Object object, CompletionTask completionTask, int n) {
        if (!$assertionsDisabled && completionImpl == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && object == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && completionTask == null) {
            throw new AssertionError();
        }
        this.completionImpl = completionImpl;
        this.resultId = object;
        this.task = completionTask;
        this.queryType = n;
        this.anchorOffset = -1;
        this.estimatedItemCount = -1;
        this.active = true;
        spi.createCompletionResultSet(this);
    }

    public synchronized CompletionResultSet getResultSet() {
        return this.resultSet;
    }

    public synchronized void setResultSet(CompletionResultSet completionResultSet) {
        if (!$assertionsDisabled && completionResultSet == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.resultSet != null) {
            throw new AssertionError();
        }
        this.resultSet = completionResultSet;
    }

    public CompletionTask getTask() {
        return this.task;
    }

    public int getQueryType() {
        return this.queryType;
    }

    public synchronized void markInactive() {
        this.active = false;
    }

    public synchronized String getTitle() {
        return this.title;
    }

    public synchronized void setTitle(String string) {
        this.checkNotFinished();
        this.title = string;
    }

    public synchronized int getAnchorOffset() {
        return this.anchorOffset;
    }

    public synchronized void setAnchorOffset(int n) {
        this.checkNotFinished();
        this.anchorOffset = n;
    }

    public synchronized boolean addItem(CompletionItem completionItem) {
        if (!$assertionsDisabled && completionItem == null) {
            throw new AssertionError((Object)"Added item cannot be null");
        }
        this.checkNotFinished();
        if (!this.active || this.queryType != 1) {
            return false;
        }
        if (this.items == null) {
            int n = this.estimatedItemCount == -1 ? 10 : this.estimatedItemCount;
            this.items = new ArrayList(n);
        }
        this.items.add(completionItem);
        return this.items.size() < 1000;
    }

    public boolean addAllItems(Collection collection) {
        boolean bl = true;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            bl = this.addItem((CompletionItem)iterator.next());
        }
        return bl;
    }

    public synchronized List getItems() {
        if (!$assertionsDisabled && !this.isFinished()) {
            throw new AssertionError((Object)"Adding not finished");
        }
        return this.items != null ? this.items : Collections.EMPTY_LIST;
    }

    public synchronized void setDocumentation(CompletionDocumentation completionDocumentation) {
        this.checkNotFinished();
        if (!this.active || this.queryType != 2) {
            return;
        }
        this.documentation = completionDocumentation;
    }

    public synchronized CompletionDocumentation getDocumentation() {
        return this.documentation;
    }

    public synchronized JToolTip getToolTip() {
        return this.toolTip;
    }

    public synchronized void setToolTip(JToolTip jToolTip) {
        this.checkNotFinished();
        if (!this.active || this.queryType != 4) {
            return;
        }
        this.toolTip = jToolTip;
    }

    public synchronized boolean isFinished() {
        return this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        CompletionResultSetImpl completionResultSetImpl = this;
        synchronized (completionResultSetImpl) {
            if (this.finished) {
                throw new IllegalStateException("finish() already called");
            }
            this.finished = true;
        }
        this.completionImpl.finishNotify(this);
    }

    public int getSortType() {
        return this.completionImpl.getSortType();
    }

    public synchronized void estimateItems(int n, int n2) {
        this.estimatedItemCount = n;
        this.estimatedItemWidth = n2;
    }

    CompletionImpl getCompletionImpl() {
        return this.completionImpl;
    }

    Object getResultId() {
        return this.resultId;
    }

    private void checkNotFinished() {
        if (this.isFinished()) {
            throw new IllegalStateException("Result set already finished");
        }
    }

    public synchronized String getWaitText() {
        return this.waitText;
    }

    public synchronized void setWaitText(String string) {
        this.waitText = string;
    }

    static {
        $assertionsDisabled = !CompletionResultSetImpl.class.desiredAssertionStatus();
        CompletionResultSet.class.getName();
        spi = CompletionSpiPackageAccessor.get();
    }
}

