/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.completion;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import org.netbeans.editor.BaseKit;
import org.netbeans.modules.editor.completion.CompletionImpl;
import org.netbeans.modules.editor.completion.CompletionJList;
import org.netbeans.modules.editor.completion.CompletionSettings;
import org.netbeans.spi.editor.completion.CompletionItem;

public class CompletionScrollPane
extends JScrollPane {
    private static final String ESCAPE = "escape";
    private static final String COMPLETION_UP = "completion-up";
    private static final String COMPLETION_DOWN = "completion-down";
    private static final String COMPLETION_PGUP = "completion-pgup";
    private static final String COMPLETION_PGDN = "completion-pgdn";
    private static final String COMPLETION_BEGIN = "completion-begin";
    private static final String COMPLETION_END = "completion-end";
    private static final int ACTION_ESCAPE = 0;
    private static final int ACTION_COMPLETION_UP = 1;
    private static final int ACTION_COMPLETION_DOWN = 2;
    private static final int ACTION_COMPLETION_PGUP = 3;
    private static final int ACTION_COMPLETION_PGDN = 4;
    private static final int ACTION_COMPLETION_BEGIN = 5;
    private static final int ACTION_COMPLETION_END = 6;
    private JTextComponent editorComponent;
    private CompletionJList view;
    private JLabel topLabel;

    public CompletionScrollPane(JTextComponent jTextComponent, ListSelectionListener listSelectionListener, MouseListener mouseListener) {
        this.editorComponent = jTextComponent;
        this.setHorizontalScrollBarPolicy(31);
        this.setVerticalScrollBarPolicy(20);
        this.setMaximumSize(CompletionSettings.INSTANCE.completionPopupMaximumSize());
        int n = Math.max(2, this.getMaximumSize().height / 16 - 1);
        this.view = new CompletionJList(n, mouseListener);
        if (listSelectionListener != null) {
            this.view.addListSelectionListener(listSelectionListener);
        }
        this.setViewportView(this.view);
        this.installKeybindings();
    }

    public void setData(List list, String string) {
        this.view.setData(list);
        this.setTitle(string);
        this.setViewportView(this.getViewport().getView());
    }

    public CompletionItem getSelectedCompletionItem() {
        Object e = this.view.getSelectedValue();
        return e instanceof CompletionItem ? (CompletionItem)e : null;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        Dimension dimension2 = this.getMaximumSize();
        if (dimension.width > dimension2.width) {
            dimension.width = dimension2.width;
        }
        return dimension;
    }

    private void setTitle(String string) {
        if (string == null) {
            if (this.topLabel != null) {
                this.setColumnHeader(null);
                this.topLabel = null;
            }
        } else if (this.topLabel != null) {
            this.topLabel.setText(string);
        } else {
            this.topLabel = new JLabel(string);
            this.topLabel.setForeground(Color.blue);
            this.topLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            this.setColumnHeaderView(this.topLabel);
        }
    }

    private KeyStroke[] findEditorKeys(String string, KeyStroke keyStroke) {
        KeyStroke[] keyStrokeArray = new KeyStroke[]{keyStroke};
        if (this.editorComponent != null) {
            KeyStroke[] keyStrokeArray2;
            Action action;
            EditorKit editorKit;
            TextUI textUI = this.editorComponent.getUI();
            Keymap keymap = this.editorComponent.getKeymap();
            if (textUI != null && keymap != null && (editorKit = textUI.getEditorKit(this.editorComponent)) instanceof BaseKit && (action = ((BaseKit)editorKit).getActionByName(string)) != null && (keyStrokeArray2 = keymap.getKeyStrokesForAction(action)) != null && keyStrokeArray2.length > 0) {
                keyStrokeArray = keyStrokeArray2;
            }
        }
        return keyStrokeArray;
    }

    private void registerKeybinding(int n, String string, KeyStroke keyStroke, String string2) {
        KeyStroke[] keyStrokeArray = this.findEditorKeys(string2, keyStroke);
        for (int i = 0; i < keyStrokeArray.length; ++i) {
            this.getInputMap().put(keyStrokeArray[i], string);
        }
        this.getActionMap().put(string, new CompletionPaneAction(n));
    }

    private void installKeybindings() {
        this.registerKeybinding(0, ESCAPE, KeyStroke.getKeyStroke(27, 0), ESCAPE);
        this.registerKeybinding(1, COMPLETION_UP, KeyStroke.getKeyStroke(38, 0), "caret-up");
        this.registerKeybinding(2, COMPLETION_DOWN, KeyStroke.getKeyStroke(40, 0), "caret-down");
        this.registerKeybinding(4, COMPLETION_PGDN, KeyStroke.getKeyStroke(34, 0), "page-down");
        this.registerKeybinding(3, COMPLETION_PGUP, KeyStroke.getKeyStroke(33, 0), "page-up");
        this.registerKeybinding(5, COMPLETION_BEGIN, KeyStroke.getKeyStroke(36, 0), "caret-begin-line");
        this.registerKeybinding(6, COMPLETION_END, KeyStroke.getKeyStroke(35, 0), "caret-end-line");
    }

    private class CompletionPaneAction
    extends AbstractAction {
        private int action;

        private CompletionPaneAction(int n) {
            this.action = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            switch (this.action) {
                case 0: {
                    CompletionImpl.get().hideCompletion();
                    break;
                }
                case 1: {
                    CompletionScrollPane.this.view.up();
                    break;
                }
                case 2: {
                    CompletionScrollPane.this.view.down();
                    break;
                }
                case 3: {
                    CompletionScrollPane.this.view.pageUp();
                    break;
                }
                case 4: {
                    CompletionScrollPane.this.view.pageDown();
                    break;
                }
                case 5: {
                    CompletionScrollPane.this.view.begin();
                    break;
                }
                case 6: {
                    CompletionScrollPane.this.view.end();
                }
            }
        }
    }
}

