/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.completion;

import java.awt.Color;
import java.awt.Dimension;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtSettingsDefaults;

public final class CompletionSettings
implements SettingsChangeListener {
    public static final CompletionSettings INSTANCE = new CompletionSettings();
    private static final Object NULL_VALUE = new Object();
    private Reference editorComponentRef;
    private Map settingName2value = new HashMap();

    private CompletionSettings() {
        Settings.addSettingsChangeListener((SettingsChangeListener)this);
    }

    public boolean completionAutoPopup() {
        return (Boolean)this.getValue("completion-auto-popup", ExtSettingsDefaults.defaultCompletionAutoPopup);
    }

    public int completionAutoPopupDelay() {
        return (Integer)this.getValue("completion-auto-popup-delay", ExtSettingsDefaults.defaultCompletionAutoPopupDelay);
    }

    public boolean documentationAutoPopup() {
        return (Boolean)this.getValue("javadoc-auto-popup", ExtSettingsDefaults.defaultJavaDocAutoPopup);
    }

    public int documentationAutoPopupDelay() {
        return (Integer)this.getValue("javadoc-auto-popup-delay", ExtSettingsDefaults.defaultJavaDocAutoPopupDelay);
    }

    public Dimension completionPopupMaximumSize() {
        return (Dimension)this.getValue("completion-pane-max-size", ExtSettingsDefaults.defaultCompletionPaneMaxSize);
    }

    public Dimension documentationPopupPreferredSize() {
        return (Dimension)this.getValue("javadoc-preferred-size", ExtSettingsDefaults.defaultJavaDocPreferredSize);
    }

    public Color documentationBackgroundColor() {
        return (Color)INSTANCE.getValue("javadoc-bg-color", ExtSettingsDefaults.defaultJavaDocBGColor);
    }

    public boolean completionInstantSubstitution() {
        return (Boolean)this.getValue("completion-instant-substitution", ExtSettingsDefaults.defaultCompletionInstantSubstitution);
    }

    public void notifyEditorComponentChange(JTextComponent jTextComponent) {
        this.editorComponentRef = new WeakReference<JTextComponent>(jTextComponent);
        this.clearSettingValues();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue(String string) {
        Object object;
        Object object2 = this;
        synchronized (object2) {
            object = this.settingName2value.get(string);
        }
        if (object == null) {
            Object object3;
            object2 = (JTextComponent)this.editorComponentRef.get();
            if (object2 != null && (object3 = Utilities.getKitClass((JTextComponent)object2)) != null && (object = Settings.getValue((Class)object3, (String)string)) == null) {
                object = NULL_VALUE;
            }
            if (object != null) {
                object3 = this;
                synchronized (object3) {
                    this.settingName2value.put(string, object);
                }
            }
        }
        if (object == NULL_VALUE) {
            object = null;
        }
        return object;
    }

    public Object getValue(String string, Object object) {
        Object object2 = this.getValue(string);
        if (object2 == null) {
            object2 = object;
        }
        return object2;
    }

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        this.clearSettingValues();
    }

    private synchronized void clearSettingValues() {
        this.settingName2value.clear();
    }
}

