/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.completion;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class HTMLDocView
extends JEditorPane {
    private HTMLEditorKit htmlKit;

    public HTMLDocView(Color color) {
        this.setEditable(false);
        this.setBackground(color);
        this.setMargin(new Insets(0, 3, 3, 3));
    }

    public void setContent(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                StringReader stringReader = new StringReader("<HTML><BODY>" + string + "</BODY></HTML>");
                try {
                    Document document = HTMLDocView.this.getDocument();
                    document.remove(0, document.getLength());
                    HTMLDocView.this.getEditorKit().read(stringReader, HTMLDocView.this.getDocument(), 0);
                    HTMLDocView.this.setCaretPosition(0);
                    HTMLDocView.this.scrollRectToVisible(new Rectangle(0, 0, 0, 0));
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        });
    }

    protected EditorKit createDefaultEditorKit() {
        if (this.htmlKit == null) {
            this.htmlKit = new HTMLEditorKit();
            this.setEditorKit(this.htmlKit);
            if (this.htmlKit.getStyleSheet().getStyleSheets() != null) {
                return this.htmlKit;
            }
            StyleSheet styleSheet = new StyleSheet();
            Font font = this.getFont();
            styleSheet.addRule("body { font-size: " + font.getSize() + "; font-family: " + font.getName() + "; }");
            styleSheet.addStyleSheet(this.htmlKit.getStyleSheet());
            this.htmlKit.setStyleSheet(styleSheet);
        }
        return this.htmlKit;
    }
}

