/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.editor.completion.support;

import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.openide.util.RequestProcessor;

public final class AsyncCompletionTask
implements CompletionTask,
Runnable {
    private final AsyncCompletionQuery query;
    private final JTextComponent component;
    private Document doc;
    private int queryCaretOffset;
    private CompletionResultSet queryResultSet;
    private CompletionResultSet refreshResultSet;
    private RequestProcessor.Task rpTask;
    private boolean cancelled;
    private boolean queryInvoked;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AsyncCompletionTask(AsyncCompletionQuery asyncCompletionQuery, JTextComponent jTextComponent) {
        if (!$assertionsDisabled && asyncCompletionQuery == null) {
            throw new AssertionError((Object)"Query must be non-null");
        }
        this.query = asyncCompletionQuery;
        this.component = jTextComponent;
    }

    public AsyncCompletionTask(AsyncCompletionQuery asyncCompletionQuery) {
        this(asyncCompletionQuery, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void query(CompletionResultSet completionResultSet) {
        if (!$assertionsDisabled && completionResultSet == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        this.doc = this.component != null ? this.component.getDocument() : null;
        this.queryInvoked = true;
        AsyncCompletionTask asyncCompletionTask = this;
        synchronized (asyncCompletionTask) {
            this.performQuery(completionResultSet);
        }
    }

    public void refresh(CompletionResultSet completionResultSet) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.cancelled) {
            throw new AssertionError((Object)"refresh() called on canceled task");
        }
        if (this.queryInvoked) {
            if (!$assertionsDisabled && completionResultSet == null) {
                throw new AssertionError();
            }
            this.refreshResultSet = completionResultSet;
            this.refreshImpl();
        } else {
            this.query.preQueryUpdate(this.component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        this.cancelled = true;
        AsyncCompletionTask asyncCompletionTask = this;
        synchronized (asyncCompletionTask) {
            if (this.rpTask != null) {
                this.rpTask.cancel();
                this.rpTask = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performQuery(CompletionResultSet completionResultSet) {
        this.queryCaretOffset = this.component != null ? this.component.getCaretPosition() : -1;
        this.query.prepareQuery(this.component);
        AsyncCompletionTask asyncCompletionTask = this;
        synchronized (asyncCompletionTask) {
            this.queryResultSet = completionResultSet;
            this.rpTask = RequestProcessor.getDefault().post((Runnable)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshImpl() {
        CompletionResultSet completionResultSet;
        boolean bl;
        AsyncCompletionTask asyncCompletionTask = this;
        synchronized (asyncCompletionTask) {
            bl = this.rpTask == null;
            completionResultSet = this.refreshResultSet;
        }
        if (completionResultSet != null) {
            if (bl) {
                asyncCompletionTask = this;
                synchronized (asyncCompletionTask) {
                    this.refreshResultSet = null;
                }
                if (this.query.canFilter(this.component)) {
                    this.query.filter(completionResultSet);
                    if (!$assertionsDisabled && !completionResultSet.isFinished()) {
                        throw new AssertionError((Object)(this.toString() + ": query.filter(): Result set not finished by resultSet.finish()"));
                    }
                } else {
                    this.performQuery(completionResultSet);
                }
            } else if (!this.query.canFilter(this.component)) {
                // empty if block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        CompletionResultSet completionResultSet = this.queryResultSet;
        if (completionResultSet != null) {
            this.query.query(completionResultSet, this.doc, this.queryCaretOffset);
            if (!$assertionsDisabled && !completionResultSet.isFinished()) {
                throw new AssertionError((Object)(this.toString() + ": query.query(): Result set not finished by resultSet.finish()"));
            }
        }
        AsyncCompletionTask asyncCompletionTask = this;
        synchronized (asyncCompletionTask) {
            this.rpTask = null;
            this.queryResultSet = null;
            if (this.refreshResultSet != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        AsyncCompletionTask.this.refreshImpl();
                    }
                });
            }
        }
    }

    synchronized boolean isCancelled() {
        return this.cancelled;
    }

    public String toString() {
        return "AsyncCompletionTask: query=" + this.query;
    }

    static {
        $assertionsDisabled = !AsyncCompletionTask.class.desiredAssertionStatus();
    }
}

