/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.clazz;

import java.io.IOException;
import org.netbeans.modules.clazz.ClassDataObject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.ExtensionList;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.util.NbBundle;

public final class ClassDataLoader
extends MultiFileLoader {
    private static final String SER_EXT = "ser";
    private static final String CLASS_EXT = "class";
    private static final String REPRESENTATION_CLASS_NAME = "org.netbeans.modules.clazz.ClassDataObject";
    private static final char INNER_CLASS_DIVIDER = '$';
    private static ExtensionList extensions;
    static final long serialVersionUID = 3149080169747384034L;

    public ClassDataLoader() {
        super(REPRESENTATION_CLASS_NAME);
    }

    protected String defaultDisplayName() {
        return NbBundle.getMessage((Class)ClassDataLoader.class, (String)"PROP_ClassLoader_Name");
    }

    protected String actionsContext() {
        return "Loaders/application/x-java-class/Actions/";
    }

    protected FileObject findPrimaryFile(FileObject fileObject) {
        if (fileObject.isFolder()) {
            return null;
        }
        if (SER_EXT.equals(fileObject.getExt())) {
            try {
                return fileObject.getFileSystem() != Repository.getDefault().getDefaultFileSystem() ? fileObject : null;
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                return null;
            }
        }
        if (CLASS_EXT.equals(fileObject.getExt())) {
            return this.findPrimaryForClass(fileObject);
        }
        return null;
    }

    protected MultiDataObject createMultiObject(FileObject fileObject) throws DataObjectExistsException, IOException {
        if (SER_EXT.equals(fileObject.getExt())) {
            return ClassDataObject.createSerDataObject(fileObject, this);
        }
        if (CLASS_EXT.equals(fileObject.getExt())) {
            return ClassDataObject.createCompiledDataObject(fileObject, this);
        }
        return null;
    }

    protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        return new FileEntry(multiDataObject, fileObject);
    }

    protected MultiDataObject.Entry createSecondaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        return new FileEntry(multiDataObject, fileObject);
    }

    private FileObject findPrimaryForClass(FileObject fileObject) {
        FileObject fileObject2;
        String string = fileObject.getName();
        int n = string.indexOf(36);
        if (n > 0 && (fileObject2 = fileObject.getParent().getFileObject(string.substring(0, n), CLASS_EXT)) != null) {
            return fileObject2;
        }
        return fileObject;
    }

    public ExtensionList getExtensions() {
        if (extensions == null) {
            extensions = new ExtensionList();
            extensions.addExtension(CLASS_EXT);
            extensions.addExtension(SER_EXT);
        }
        return extensions;
    }
}

