/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.clazz;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import org.netbeans.modules.clazz.ClassDataObject;
import org.netbeans.modules.clazz.LazySourceChildren;
import org.netbeans.modules.clazz.Util;
import org.openide.ErrorManager;
import org.openide.cookies.SourceCookie;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.src.nodes.SourceChildren;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

abstract class ClassDataNode
extends DataNode
implements Runnable,
PropertyChangeListener {
    static final long serialVersionUID = -1543899241509520203L;
    private static final String PROP_CLASS_NAME = "className";
    private static final String PROP_IS_JAVA_BEAN = "isJavaBean";
    private static final String PROP_IS_APPLET = "isApplet";
    private boolean showDeclaredOnly = true;
    transient boolean iconResolved = false;
    transient String errorMsg;
    transient boolean initialized;
    private static final RequestProcessor iconResolver = new RequestProcessor("clazz icon resolver", 1);

    ClassDataNode(ClassDataObject classDataObject) {
        this(classDataObject, (Children)new LazySourceChildren((DataObject)classDataObject, ClassDataObject.getExplorerFactory()));
    }

    protected ClassDataNode(ClassDataObject classDataObject, Children children) {
        super((DataObject)classDataObject, children);
        this.initialize();
    }

    protected SourceChildren getSourceChildren() {
        return (SourceChildren)this.getChildren();
    }

    protected abstract String initialIconBase();

    protected abstract void resolveIcons();

    protected abstract void requestResolveIcon();

    private void initialize() {
        this.setIconBase(this.initialIconBase());
    }

    public Image getIcon(int n) {
        this.ensureIconResolved();
        return super.getIcon(n);
    }

    public Image getOpenedIcon(int n) {
        this.ensureIconResolved();
        return super.getOpenedIcon(n);
    }

    private void ensureIconResolved() {
        if (this.iconResolved) {
            return;
        }
        iconResolver.post(new Runnable(){

            public void run() {
                ClassDataNode.this.requestResolveIcon();
            }
        });
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)ClassDataNode.class);
        final ClassDataObject classDataObject = (ClassDataObject)this.getDataObject();
        Sheet.Set set = sheet.get("properties");
        set.put((Node.Property)new PropertySupport.ReadOnly(PROP_CLASS_NAME, String.class, resourceBundle.getString("PROP_className"), resourceBundle.getString("HINT_className")){

            public Object getValue() throws InvocationTargetException {
                return classDataObject.getClassName();
            }
        });
        set.put((Node.Property)new PropertySupport.ReadOnly("modifiers", String.class, resourceBundle.getString("PROP_modifiers"), resourceBundle.getString("HINT_modifiers")){

            public Object getValue() throws InvocationTargetException {
                String string = null;
                try {
                    string = classDataObject.getModifiers();
                }
                catch (IOException iOException) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                return string;
            }
        });
        set.put((Node.Property)new PropertySupport.ReadOnly("superclass", String.class, resourceBundle.getString("PROP_superclass"), resourceBundle.getString("HINT_superclass")){

            public Object getValue() throws InvocationTargetException {
                return classDataObject.getSuperclass();
            }
        });
        set.put((Node.Property)new PropertySupport.ReadOnly("classOrInterface", Boolean.TYPE, resourceBundle.getString("PROP_isInterface"), resourceBundle.getString("HINT_isInterface")){

            public Object getValue() throws InvocationTargetException {
                return classDataObject.isInterface() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        set.put((Node.Property)new PropertySupport.ReadOnly(PROP_IS_APPLET, Boolean.TYPE, resourceBundle.getString("PROP_isApplet"), resourceBundle.getString("HINT_isApplet")){

            public Object getValue() throws InvocationTargetException {
                return classDataObject.isApplet() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        set.put((Node.Property)new PropertySupport.ReadOnly(PROP_IS_JAVA_BEAN, Boolean.TYPE, resourceBundle.getString("PROP_isJavaBean"), resourceBundle.getString("HINT_isJavaBean")){

            public Object getValue() throws InvocationTargetException {
                return classDataObject.isJavaBean() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return sheet;
    }

    public void run() {
        SourceCookie sourceCookie = (SourceCookie)this.getDataObject().getCookie(SourceCookie.class);
        if (sourceCookie != null) {
            if (!this.initialized) {
                sourceCookie.getSource().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)sourceCookie.getSource()));
            }
            this.initialized = true;
        }
        this.resolveIcons();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("status".equals(propertyChangeEvent.getPropertyName())) {
            Util.getClassProcessor().post((Runnable)this, 200);
        }
    }

    protected void setErrorToolTip(Exception exception) {
        String string = this.findErrorMessage(exception);
        this.errorMsg = NbBundle.getMessage((Class)ClassDataNode.class, (String)"FMT_ErrorHint", (Object)string);
        this.setShortDescription(this.errorMsg);
    }

    private String findErrorMessage(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        ErrorManager.Annotation[] annotationArray = ErrorManager.getDefault().findAnnotations(throwable);
        if (annotationArray == null) {
            return throwable.getLocalizedMessage();
        }
        for (int i = 0; i < annotationArray.length; ++i) {
            String string = annotationArray[i].getMessage();
            String string2 = annotationArray[i].getLocalizedMessage();
            if (string2 != null) {
                return string2;
            }
            Throwable throwable2 = annotationArray[i].getStackTrace();
            if (throwable2 == null || (string2 = throwable2.getLocalizedMessage()) == null || string2.equals(string)) continue;
            return string2;
        }
        return throwable.getLocalizedMessage();
    }
}

