/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.clazz;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.HashSet;
import java.util.LinkedList;
import javax.jmi.reflect.InvalidObjectException;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.modules.clazz.ClassDataLoader;
import org.netbeans.modules.clazz.ClassElementNodeFactory;
import org.netbeans.modules.clazz.CompiledDataObject;
import org.netbeans.modules.clazz.NodeFactoryPool;
import org.netbeans.modules.clazz.SerDataObject;
import org.netbeans.modules.clazz.SourceElementImpl;
import org.netbeans.modules.clazz.Util;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.InstanceCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.SourceCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.InstanceSupport;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.Identifier;
import org.openide.src.SourceElement;
import org.openide.src.Type;
import org.openide.src.nodes.ElementNodeFactory;
import org.openide.src.nodes.FilterFactory;
import org.openide.util.NbBundle;

public class ClassDataObject
extends MultiDataObject
implements CookieSet.Factory,
SourceCookie {
    public static final String PROP_CLASS_LOADING_ERROR = "classLoadingError";
    private Throwable classLoadingError;
    protected static final int UNDECIDED = 0;
    protected static final int APPLET = 1;
    protected static final int APPLICATION = 2;
    static final long serialVersionUID = -1L;
    private transient InstanceSupport instanceSupport;
    private transient boolean sourceCreated;
    transient PropL propL;
    transient Reference srcEl = new WeakReference<Object>(null);
    private transient ClassFile mainClass;
    private static NodeFactoryPool explorerFactories;
    private static NodeFactoryPool browserFactories;
    private static ElementNodeFactory basicBrowser;
    private static ElementNodeFactory basicExplorer;
    static /* synthetic */ Class class$org$netbeans$modules$clazz$ClassDataObject;

    public ClassDataObject(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException {
        super(fileObject, multiFileLoader);
    }

    static ClassDataObject createSerDataObject(FileObject fileObject, ClassDataLoader classDataLoader) throws DataObjectExistsException, IOException {
        return new SerDataObject(fileObject, classDataLoader);
    }

    static ClassDataObject createCompiledDataObject(FileObject fileObject, ClassDataLoader classDataLoader) throws DataObjectExistsException, IOException {
        return new CompiledDataObject(fileObject, classDataLoader);
    }

    protected void initCookies() {
        CookieSet cookieSet = this.getCookieSet();
        cookieSet.add(new Class[]{SourceCookie.class}, (CookieSet.Factory)this);
        cookieSet.add(OpenCookie.class, (CookieSet.Factory)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InstanceSupport createInstanceSupport() {
        if (this.instanceSupport != null) {
            return this.instanceSupport;
        }
        ClassDataObject classDataObject = this;
        synchronized (classDataObject) {
            if (this.instanceSupport == null) {
                this.instanceSupport = new ClazzInstanceSupport(this.getPrimaryEntry());
                if (this.propL == null) {
                    this.propL = new PropL();
                    FileObject fileObject = this.getPrimaryFile();
                    fileObject.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.propL, (Object)fileObject));
                }
            }
        }
        return this.instanceSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceElement getSource() {
        SourceElement sourceElement = (SourceElement)this.srcEl.get();
        if (sourceElement != null) {
            return sourceElement;
        }
        ClassDataObject classDataObject = this;
        synchronized (classDataObject) {
            sourceElement = (SourceElement)this.srcEl.get();
            if (sourceElement != null) {
                return sourceElement;
            }
            this.sourceCreated = true;
            sourceElement = new SourceElement((SourceElement.Impl)new SourceElementImpl(this));
            this.srcEl = new WeakReference<SourceElement>(sourceElement);
        }
        return sourceElement;
    }

    public Node.Cookie createCookie(Class clazz) {
        if (clazz == InstanceCookie.class) {
            return this.createInstanceSupport();
        }
        if (OpenCookie.class.isAssignableFrom(clazz)) {
            return new OpenSourceCookie();
        }
        return null;
    }

    protected Throwable getClassLoadingError() {
        this.getClassFile();
        return this.classLoadingError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forceReload() {
        SourceElementImpl sourceElementImpl;
        CookieSet cookieSet = this.getCookieSet();
        InstanceSupport instanceSupport = this.instanceSupport;
        ClassDataObject classDataObject = this;
        synchronized (classDataObject) {
            this.instanceSupport = null;
            this.mainClass = null;
        }
        if (instanceSupport != null) {
            cookieSet.remove((Node.Cookie)instanceSupport);
            cookieSet.add(new Class[]{InstanceCookie.class}, (CookieSet.Factory)this);
        }
        if (this.sourceCreated && (sourceElementImpl = (SourceElementImpl)(classDataObject = (SourceCookie)this.getCookie(SourceCookie.class)).getSource().getCookie(SourceElement.Impl.class)) != null) {
            sourceElementImpl.setResource(null);
        }
    }

    protected ClassFile getClassFile() {
        if (this.mainClass == null) {
            Throwable throwable = this.classLoadingError;
            this.classLoadingError = null;
            try {
                this.mainClass = this.loadClassFile();
            }
            catch (RuntimeException runtimeException) {
                this.classLoadingError = runtimeException;
            }
            catch (IOException iOException) {
                this.classLoadingError = iOException;
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.classLoadingError = classNotFoundException;
            }
            if (this.classLoadingError != null) {
                this.firePropertyChange(PROP_CLASS_LOADING_ERROR, throwable, this.classLoadingError);
            }
        }
        return this.mainClass;
    }

    protected ClassElement getMainClass() {
        ClassElement[] classElementArray = this.getSource().getClasses();
        if (classElementArray.length == 0) {
            return null;
        }
        return classElementArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClassFile loadClassFile() throws IOException, ClassNotFoundException {
        InputStream inputStream = this.getPrimaryEntry().getFile().getInputStream();
        if (inputStream == null) {
            return null;
        }
        try {
            ClassFile classFile = new ClassFile(inputStream, false);
            return classFile;
        }
        finally {
            inputStream.close();
        }
    }

    public boolean isCopyAllowed() {
        return true;
    }

    public boolean isMoveAllowed() {
        return this.getPrimaryFile().canWrite();
    }

    public boolean isRenameAllowed() {
        return this.getPrimaryFile().canWrite();
    }

    public boolean isJavaBean() {
        return this.createInstanceSupport().isJavaBean();
    }

    public boolean isApplet() {
        return this.createInstanceSupport().isApplet();
    }

    public boolean isInterface() {
        return this.createInstanceSupport().isInterface();
    }

    public String getSuperclass() {
        ClassElement classElement = this.getMainClass();
        if (classElement == null) {
            return "";
        }
        Identifier identifier = classElement.getSuperclass();
        return identifier == null ? "" : identifier.getFullName();
    }

    public String getModifiers() throws IOException, ClassNotFoundException {
        ClassElement classElement = this.getMainClass();
        if (classElement == null) {
            throw new ClassNotFoundException();
        }
        return Modifier.toString(classElement.getModifiers());
    }

    public String getClassName() {
        return this.createInstanceSupport().instanceName();
    }

    public Class getBeanClass() throws IOException, ClassNotFoundException {
        return this.createInstanceSupport().instanceClass();
    }

    static synchronized ElementNodeFactory createBasicExplorerFactory() {
        if (basicExplorer == null) {
            basicExplorer = new ClassElementNodeFactory();
        }
        return basicExplorer;
    }

    static synchronized ElementNodeFactory createBasicBrowserFactory() {
        if (basicBrowser == null) {
            basicBrowser = new ClassElementNodeFactory();
            ((ClassElementNodeFactory)basicBrowser).setGenerateForTree(true);
        }
        return basicBrowser;
    }

    public static ElementNodeFactory getExplorerFactory() {
        NodeFactoryPool nodeFactoryPool = ClassDataObject.createExplorerFactory();
        ElementNodeFactory elementNodeFactory = null;
        if (nodeFactoryPool != null) {
            elementNodeFactory = nodeFactoryPool.getHead();
        }
        if (elementNodeFactory == null) {
            elementNodeFactory = ClassDataObject.createBasicExplorerFactory();
        }
        return elementNodeFactory;
    }

    public static ElementNodeFactory getBrowserFactory() {
        NodeFactoryPool nodeFactoryPool = ClassDataObject.createBrowserFactory();
        ElementNodeFactory elementNodeFactory = null;
        if (nodeFactoryPool != null) {
            elementNodeFactory = nodeFactoryPool.getHead();
        }
        if (elementNodeFactory == null) {
            elementNodeFactory = ClassDataObject.createBasicBrowserFactory();
        }
        return elementNodeFactory;
    }

    static NodeFactoryPool createFactoryPool(String string, ElementNodeFactory elementNodeFactory) {
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource(string);
        if (fileObject == null) {
            return null;
        }
        try {
            DataFolder dataFolder = (DataFolder)DataObject.find((FileObject)fileObject).getCookie(DataFolder.class);
            return new NodeFactoryPool(dataFolder, elementNodeFactory);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return null;
        }
    }

    static synchronized NodeFactoryPool createBrowserFactory() {
        if (browserFactories != null) {
            return browserFactories;
        }
        browserFactories = ClassDataObject.createFactoryPool("/NodeFactories/clazz/objectbrowser", ClassDataObject.createBasicBrowserFactory());
        return browserFactories;
    }

    static synchronized NodeFactoryPool createExplorerFactory() {
        if (explorerFactories != null) {
            return explorerFactories;
        }
        explorerFactories = ClassDataObject.createFactoryPool("/NodeFactories/clazz/explorer", ClassDataObject.createBasicExplorerFactory());
        return explorerFactories;
    }

    public static void addExplorerFilterFactory(FilterFactory filterFactory) {
        NodeFactoryPool nodeFactoryPool = ClassDataObject.createExplorerFactory();
        if (nodeFactoryPool != null) {
            nodeFactoryPool.addFactory(filterFactory);
        }
    }

    public static void removeExplorerFilterFactory(FilterFactory filterFactory) {
        NodeFactoryPool nodeFactoryPool = ClassDataObject.createExplorerFactory();
        if (nodeFactoryPool != null) {
            nodeFactoryPool.removeFactory(filterFactory);
        }
    }

    public static void addBrowserFilterFactory(FilterFactory filterFactory) {
        NodeFactoryPool nodeFactoryPool = ClassDataObject.createBrowserFactory();
        if (nodeFactoryPool != null) {
            nodeFactoryPool.addFactory(filterFactory);
        }
    }

    public static void removeBrowserFilterFactory(FilterFactory filterFactory) {
        NodeFactoryPool nodeFactoryPool = ClassDataObject.createBrowserFactory();
        if (nodeFactoryPool != null) {
            nodeFactoryPool.removeFactory(filterFactory);
        }
    }

    private class OpenSourceCookie
    implements OpenCookie {
        private OpenSourceCookie() {
        }

        public void open() {
            try {
                FileObject fileObject = ClassDataObject.this.getPrimaryFile();
                FileObject fileObject2 = null;
                String string = null;
                ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile");
                if (classPath == null || (fileObject2 = classPath.findOwnerRoot(fileObject)) == null) {
                    classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/execute");
                    if (classPath != null) {
                        fileObject2 = classPath.findOwnerRoot(fileObject);
                        string = classPath.getResourceName(fileObject, '/', false);
                    }
                } else if (fileObject2 != null) {
                    string = classPath.getResourceName(fileObject, '/', false);
                }
                FileObject[] fileObjectArray = null;
                if (fileObject2 != null) {
                    fileObjectArray = SourceForBinaryQuery.findSourceRoots((URL)fileObject2.getURL()).getRoots();
                }
                FileObject fileObject3 = null;
                if (fileObjectArray != null && fileObjectArray.length > 0) {
                    classPath = ClassPathSupport.createClassPath((FileObject[])fileObjectArray);
                    fileObject3 = classPath.findResource(string + ".java");
                }
                if (fileObject3 != null) {
                    DataObject dataObject = DataObject.find(fileObject3);
                    OpenCookie openCookie = (OpenCookie)dataObject.getCookie(class$org$openide$cookies$OpenCookie == null ? (class$org$openide$cookies$OpenCookie = ClassDataObject.class$("org.openide.cookies.OpenCookie")) : class$org$openide$cookies$OpenCookie);
                    if (openCookie != null) {
                        openCookie.open();
                    } else {
                        ErrorManager.getDefault().log("SourceFile: " + fileObject3.getPath() + " has no OpenCookie");
                    }
                } else {
                    if (string == null) {
                        string = fileObject.getName();
                    }
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$modules$clazz$ClassDataObject == null ? (class$org$netbeans$modules$clazz$ClassDataObject = ClassDataObject.class$("org.netbeans.modules.clazz.ClassDataObject")) : class$org$netbeans$modules$clazz$ClassDataObject), (String)"TXT_NoSources", (Object)string.replace('/', '.')));
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ErrorManager.getDefault().notify((Throwable)fileStateInvalidException);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
            }
        }
    }

    protected final class ClazzInstanceSupport
    extends InstanceSupport {
        private Boolean bean;
        private Boolean executable;

        ClazzInstanceSupport(MultiDataObject.Entry entry) {
            super(entry);
        }

        public Class instanceClass() throws IOException, ClassNotFoundException {
            try {
                Class clazz = super.instanceClass();
                return clazz;
            }
            catch (RuntimeException runtimeException) {
                ClassDataObject.this.classLoadingError = runtimeException;
                throw new ClassNotFoundException(runtimeException.getMessage());
            }
        }

        protected ClassLoader createClassLoader(FileObject fileObject) {
            HashSet<ClassPath> hashSet = new HashSet<ClassPath>();
            ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile");
            if (classPath != null) {
                hashSet.add(classPath);
            }
            if ((classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/execute")) != null) {
                hashSet.add(classPath);
            }
            if (hashSet.size() > 0) {
                classPath = ClassPathSupport.createProxyClassPath((ClassPath[])hashSet.toArray(new ClassPath[hashSet.size()]));
                return classPath.getClassLoader(true);
            }
            return null;
        }

        public boolean isJavaBean() {
            if (this.bean != null) {
                return this.bean;
            }
            if (this.isSerialized()) {
                this.bean = Boolean.TRUE;
                return true;
            }
            try {
                ClassElement classElement = ClassDataObject.this.getMainClass();
                if (classElement == null) {
                    return false;
                }
                int n = classElement.getModifiers();
                if (!Modifier.isPublic(n) || Modifier.isAbstract(n)) {
                    this.bean = Boolean.FALSE;
                    return false;
                }
                ConstructorElement constructorElement = classElement.getConstructor(new Type[0]);
                if (constructorElement == null || !Modifier.isPublic(constructorElement.getModifiers())) {
                    this.bean = Boolean.FALSE;
                    return false;
                }
                for (ClassElement classElement2 = classElement.getDeclaringClass(); classElement2 != null; classElement2 = classElement2.getDeclaringClass()) {
                    if (!Modifier.isStatic(n)) {
                        this.bean = Boolean.FALSE;
                        return false;
                    }
                    n = classElement2.getModifiers();
                    if (Modifier.isPublic(n)) continue;
                    this.bean = Boolean.FALSE;
                    return false;
                }
            }
            catch (InvalidObjectException invalidObjectException) {
                this.bean = Boolean.FALSE;
                return false;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                this.bean = Boolean.FALSE;
                return false;
            }
            this.bean = Boolean.TRUE;
            return true;
        }

        public boolean isInterface() {
            ClassElement classElement = ClassDataObject.this.getMainClass();
            return classElement == null ? false : classElement.isInterface();
        }

        public String instanceName() {
            ClassElement classElement = ClassDataObject.this.getMainClass();
            if (classElement == null) {
                return super.instanceName();
            }
            return classElement.getName().getFullName();
        }

        public boolean instanceOf(Class clazz) {
            String string = clazz.getName();
            ClassElement classElement = ClassDataObject.this.getMainClass();
            if (classElement == null) {
                return false;
            }
            boolean bl = !clazz.isInterface();
            String string2 = clazz.getName().replace('$', '.');
            LinkedList<Identifier> linkedList = new LinkedList<Identifier>();
            do {
                if (classElement.getName().getFullName().equals(string2)) {
                    return true;
                }
                Identifier identifier = classElement.getSuperclass();
                Identifier[] identifierArray = classElement.getInterfaces();
                for (int i = 0; i < identifierArray.length; ++i) {
                    linkedList.addLast(identifierArray[i]);
                }
                if (identifier == null) {
                    if (linkedList.isEmpty()) {
                        return false;
                    }
                    identifier = (Identifier)linkedList.removeFirst();
                }
                classElement = ClassElement.forName((String)identifier.getFullName(), (FileObject)ClassDataObject.this.getPrimaryFile());
                while (classElement == null && !linkedList.isEmpty()) {
                    classElement = ClassElement.forName((String)((Identifier)linkedList.removeFirst()).getFullName(), (FileObject)ClassDataObject.this.getPrimaryFile());
                }
            } while (classElement != null);
            return false;
        }

        public boolean isExecutable() {
            try {
                if (this.executable == null) {
                    ClassElement classElement = ClassDataObject.this.getMainClass();
                    this.executable = classElement != null && classElement.hasMainMethod() ? Boolean.TRUE : Boolean.FALSE;
                }
            }
            catch (InvalidObjectException invalidObjectException) {
                this.executable = Boolean.FALSE;
            }
            return this.executable;
        }

        private boolean isSerialized() {
            return this.instanceOrigin().getExt().equals("ser");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object instanceCreate() throws IOException, ClassNotFoundException {
            try {
                if (this.isSerialized()) {
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(this.instanceOrigin().getInputStream(), 1024);
                    ClassLoader classLoader = this.createClassLoader(this.instanceOrigin());
                    if (classLoader == null) {
                        throw new ClassNotFoundException();
                    }
                    CMObjectInputStream cMObjectInputStream = new CMObjectInputStream(bufferedInputStream, classLoader);
                    Object object = null;
                    try {
                        object = cMObjectInputStream.readObject();
                    }
                    finally {
                        cMObjectInputStream.close();
                    }
                    return object;
                }
                return super.instanceCreate();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().annotate((Throwable)iOException, this.instanceName());
                throw iOException;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw classNotFoundException;
            }
            catch (Exception exception) {
                throw new ClassNotFoundException(exception.toString(), exception);
            }
            catch (LinkageError linkageError) {
                throw new ClassNotFoundException(linkageError.toString(), linkageError);
            }
        }

        private final class CMObjectInputStream
        extends ObjectInputStream {
            private ClassLoader loader;

            protected CMObjectInputStream(InputStream inputStream, ClassLoader classLoader) throws IOException {
                super(inputStream);
                this.loader = classLoader;
            }

            protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
                return Class.forName(objectStreamClass.getName(), false, this.loader);
            }
        }
    }

    private class PropL
    extends FileChangeAdapter
    implements Runnable,
    PropertyChangeListener {
        private PropL() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("primaryFile".equals(string)) {
                FileObject fileObject = ClassDataObject.this.getPrimaryFile();
                fileObject.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)ClassDataObject.this.getPrimaryFile()));
                this.postReload();
            }
        }

        public void fileChanged(FileEvent fileEvent) {
            this.postReload();
        }

        public void run() {
            ClassDataObject.this.forceReload();
        }

        private void postReload() {
            Util.getClassProcessor().post((Runnable)this, 100);
        }
    }
}

