/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.clazz;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.clazz.SerParser;
import org.openide.ErrorManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public abstract class SerStructureNode {
    static /* synthetic */ Class class$org$netbeans$modules$clazz$SerStructureNode;

    private SerStructureNode() {
    }

    private static String prettify(String string) {
        if (string.equals("B")) {
            return "byte";
        }
        if (string.equals("S")) {
            return "short";
        }
        if (string.equals("I")) {
            return "int";
        }
        if (string.equals("J")) {
            return "long";
        }
        if (string.equals("F")) {
            return "float";
        }
        if (string.equals("D")) {
            return "double";
        }
        if (string.equals("C")) {
            return "char";
        }
        if (string.equals("Z")) {
            return "boolean";
        }
        if (string.startsWith("L") && string.endsWith(";")) {
            String string2 = string.substring(1, string.length() - 1).replace('/', '.').replace('$', '.');
            if (string2.startsWith("java.lang.")) {
                string2 = string2.substring(10, string2.length());
            }
            return string2;
        }
        if (string.startsWith("[")) {
            return SerStructureNode.prettify(string.substring(1, string.length())) + "[]";
        }
        return "ILLEGAL<" + string + ">";
    }

    private static final class NbMarshalledObjectChildren
    extends Children.Keys {
        private final SerParser.ObjectWrapper ow;

        public NbMarshalledObjectChildren(SerParser.ObjectWrapper objectWrapper) {
            this.ow = objectWrapper;
        }

        protected void addNotify() {
            super.addNotify();
            this.setKeys(Collections.singleton(Boolean.TRUE));
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
            super.removeNotify();
        }

        protected Node[] createNodes(Object object) {
            List list = this.ow.data;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof SerParser.NameValue)) continue;
                SerParser.NameValue nameValue = (SerParser.NameValue)e;
                if (!nameValue.name.name.equals("objBytes") || !nameValue.name.type.equals("[B")) continue;
                SerParser.ArrayWrapper arrayWrapper = (SerParser.ArrayWrapper)nameValue.value;
                List list2 = arrayWrapper.values;
                byte[] byArray = new byte[list2.size()];
                for (int i = 0; i < byArray.length; ++i) {
                    byArray[i] = (Byte)list2.get(i);
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                try {
                    SerParser.Stream stream = new SerParser(byteArrayInputStream).parse();
                    return new Node[]{new StreamNode(stream)};
                }
                catch (SerParser.CorruptException corruptException) {
                    ErrorManager.getDefault().notify(1, (Throwable)corruptException);
                    return new Node[0];
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                    return new Node[0];
                }
                catch (RuntimeException runtimeException) {
                    ErrorManager.getDefault().notify((Throwable)runtimeException);
                    return new Node[0];
                }
            }
            return new Node[0];
        }
    }

    private static class GeneralChildren
    extends Children.Keys {
        private final List things;

        public GeneralChildren(List list) {
            this.things = list;
        }

        protected void addNotify() {
            super.addNotify();
            this.setKeys(this.things);
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
            super.removeNotify();
        }

        protected Node[] createNodes(Object object) {
            return new Node[]{this.createNode(object)};
        }

        protected Node createNode(Object object) {
            if (object instanceof SerParser.NameValue) {
                SerParser.NameValue nameValue = (SerParser.NameValue)object;
                Node node = this.createNode(nameValue.value);
                node.setName(SerStructureNode.prettify(nameValue.name.type) + " " + nameValue.name.name + " = " + node.getName());
                return node;
            }
            if (object instanceof SerParser.ObjectWrapper) {
                SerParser.ObjectWrapper objectWrapper = (SerParser.ObjectWrapper)object;
                String string = SerStructureNode.prettify(objectWrapper.classdesc.name);
                Children.Keys keys = string.equals("org.openide.util.io.NbMarshalledObject") ? new NbMarshalledObjectChildren(objectWrapper) : new GeneralChildren(objectWrapper.data);
                AbstractNode abstractNode = new AbstractNode((Children)keys);
                abstractNode.setName(NbBundle.getMessage((Class)(class$org$netbeans$modules$clazz$SerStructureNode == null ? (class$org$netbeans$modules$clazz$SerStructureNode = SerStructureNode.class$("org.netbeans.modules.clazz.SerStructureNode")) : class$org$netbeans$modules$clazz$SerStructureNode), (String)"LBL_instance_of", (Object)string));
                abstractNode.setIconBase("org/netbeans/modules/clazz/resources/serAlone");
                return abstractNode;
            }
            if (object instanceof SerParser.ArrayWrapper) {
                SerParser.ArrayWrapper arrayWrapper = (SerParser.ArrayWrapper)object;
                AbstractNode abstractNode = new AbstractNode((Children)new GeneralChildren(arrayWrapper.values));
                if (!arrayWrapper.classdesc.name.startsWith("[")) {
                    throw new IllegalStateException("Strange array name: " + arrayWrapper.classdesc.name);
                }
                abstractNode.setName(SerStructureNode.prettify(arrayWrapper.classdesc.name.substring(1, arrayWrapper.classdesc.name.length())) + "[" + arrayWrapper.values.size() + "]");
                abstractNode.setIconBase("org/netbeans/modules/clazz/resources/serAlone");
                return abstractNode;
            }
            if (object instanceof byte[]) {
                AbstractNode abstractNode = new AbstractNode(Children.LEAF);
                abstractNode.setName(SerParser.hexify((byte[])object));
                abstractNode.setIconBase("org/netbeans/modules/clazz/resources/serAlone");
                return abstractNode;
            }
            if (object instanceof SerParser.ClassDesc) {
                AbstractNode abstractNode = new AbstractNode(Children.LEAF);
                abstractNode.setName("class " + SerStructureNode.prettify(((SerParser.ClassDesc)object).name));
                abstractNode.setIconBase("org/netbeans/modules/clazz/resources/serAlone");
                return abstractNode;
            }
            if (object == SerParser.NULL) {
                AbstractNode abstractNode = new AbstractNode(Children.LEAF);
                abstractNode.setName("null");
                abstractNode.setIconBase("org/netbeans/modules/clazz/resources/serAlone");
                return abstractNode;
            }
            if (object instanceof String) {
                AbstractNode abstractNode = new AbstractNode(Children.LEAF);
                abstractNode.setName("\"" + (String)object + "\"");
                abstractNode.setIconBase("org/netbeans/modules/clazz/resources/serAlone");
                return abstractNode;
            }
            if (object instanceof Boolean || object instanceof Character || object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double) {
                AbstractNode abstractNode = new AbstractNode(Children.LEAF);
                abstractNode.setName(object.toString());
                abstractNode.setIconBase("org/netbeans/modules/clazz/resources/serAlone");
                return abstractNode;
            }
            AbstractNode abstractNode = new AbstractNode(Children.LEAF);
            abstractNode.setName("What is this? " + object + " [" + object.getClass().getName() + "]");
            abstractNode.setIconBase("org/netbeans/modules/clazz/resources/serAlone");
            return abstractNode;
        }
    }

    public static final class StreamNode
    extends AbstractNode {
        public StreamNode(SerParser.Stream stream) {
            super((Children)new GeneralChildren(stream.contents));
            this.setName(NbBundle.getMessage((Class)(class$org$netbeans$modules$clazz$SerStructureNode == null ? (class$org$netbeans$modules$clazz$SerStructureNode = SerStructureNode.class$("org.netbeans.modules.clazz.SerStructureNode")) : class$org$netbeans$modules$clazz$SerStructureNode), (String)"LBL_ser_stream"));
            this.setIconBase("org/netbeans/modules/clazz/resources/serAlone");
        }
    }
}

