/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.clazz;

import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.clazz.ClassDataObject;
import org.netbeans.modules.clazz.ClassElementImpl;
import org.netbeans.modules.clazz.MemberElementImpl;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.Element;
import org.openide.src.ElementProperties;
import org.openide.src.Identifier;
import org.openide.src.Import;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.util.Task;
import org.openide.util.TaskListener;

final class SourceElementImpl
extends MemberElementImpl
implements SourceElement.Impl,
ElementProperties,
TaskListener {
    private static final Map EMPTY_MAP = Collections.unmodifiableMap(new HashMap(0));
    static final Import[] EMPTY_IMPORTS = new Import[0];
    static final ClassElement[] NO_CLASSES = new ClassElement[0];
    private SoftReference topClass;
    private SoftReference allClasses;
    private Identifier packg;
    private ClassDataObject cdo;
    private ClassLoader loader;
    Task loadingTask;
    int status = -1;
    private transient boolean attached;
    private boolean isEmpty = false;
    private ClassPath classPath = null;
    static final long serialVersionUID = -4870331896218546842L;

    SourceElementImpl(ClassDataObject classDataObject) {
        this(null, classDataObject);
    }

    public SourceElementImpl(Resource resource, ClassDataObject classDataObject) {
        super(resource);
        this.cdo = classDataObject;
        FileObject fileObject = classDataObject.getPrimaryFile();
        this.classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/execute");
    }

    public void attachedToElement(Element element) {
        super.attachedToElement(element);
        this.initializeData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeData() {
        JavaMetamodel javaMetamodel = JavaMetamodel.getManager();
        FileObject fileObject = this.cdo.getPrimaryFile();
        JavaMetamodel.getManager();
        MDRepository mDRepository = JavaMetamodel.getDefaultRepository();
        mDRepository.beginTrans(false);
        try {
            Resource resource = javaMetamodel.getResource(fileObject);
            if (resource == null || !resource.isValid()) {
                return;
            }
            this.data = resource;
            this.getPackage();
            ClassElement classElement = this.getClassElement();
            if (classElement != null) {
                ClassElementImpl classElementImpl = (ClassElementImpl)classElement.getCookie(Element.Impl.class);
                classElementImpl.initializeData();
            }
        }
        finally {
            mDRepository.endTrans();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshData() {
        boolean bl = false;
        JavaMetamodel.getManager();
        MDRepository mDRepository = JavaMetamodel.getDefaultRepository();
        mDRepository.beginTrans(false);
        try {
            Object object = this.data;
            FileObject fileObject = this.cdo.getPrimaryFile();
            this.data = JavaMetamodel.getManager().getResource(fileObject);
            if (this.data != null && ((Resource)this.data).isValid()) {
                ClassElementImpl classElementImpl;
                this.topClass = null;
                this.allClasses = null;
                bl = true;
                ClassElement classElement = this.getClassElement();
                if (classElement != null && (classElementImpl = (ClassElementImpl)classElement.getCookie(Element.Impl.class)) != null) {
                    classElementImpl.refreshData();
                }
            }
        }
        finally {
            mDRepository.endTrans();
        }
        if (bl) {
            this.firePropertyChange("classes", null, null);
            this.firePropertyChange("allClasses", null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResource(Resource resource) {
        int n;
        int n2;
        SourceElementImpl sourceElementImpl = this;
        synchronized (sourceElementImpl) {
            n2 = this.getStatus();
            this.data = resource;
            this.topClass = null;
            this.allClasses = null;
            n = this.getStatus();
            this.loadingTask = null;
        }
        this.initializeData();
        if (n2 != 0) {
            this.firePropertyChange("classes", null, null);
            this.firePropertyChange("allClasses", null, null);
        }
        this.firePropertyChange("status", new Integer(n2), new Integer(n));
    }

    public void setPackage(Identifier identifier) throws SourceException {
        this.throwReadOnlyException();
    }

    Resource getResource() {
        this.checkData();
        return (Resource)this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Identifier getPackage() {
        if (this.packg != null) {
            return this.packg;
        }
        JavaMetamodel.getManager();
        MDRepository mDRepository = JavaMetamodel.getDefaultRepository();
        mDRepository.beginTrans(false);
        try {
            if (this.getResource() == null || !this.isValid()) {
                Identifier identifier = null;
                return identifier;
            }
            JavaPackage javaPackage = (JavaPackage)this.getResource().refImmediateComposite();
            if (javaPackage == null) {
                Identifier identifier = null;
                return identifier;
            }
            Identifier identifier = this.packg = Identifier.create((String)javaPackage.getName());
            return identifier;
        }
        finally {
            mDRepository.endTrans();
        }
    }

    public Import[] getImports() {
        return EMPTY_IMPORTS;
    }

    public void changeImports(Import[] importArray, int n) throws SourceException {
        this.throwReadOnlyException();
    }

    public void changeClasses(ClassElement[] classElementArray, int n) throws SourceException {
        this.throwReadOnlyException();
    }

    public ClassElement[] getClasses() {
        this.checkData();
        if (this.data == null) {
            return NO_CLASSES;
        }
        ClassElement classElement = this.getClassElement();
        if (classElement == null) {
            return NO_CLASSES;
        }
        return new ClassElement[]{classElement};
    }

    public ClassElement getClass(Identifier identifier) {
        ClassElement classElement = this.getClassElement();
        if (classElement != null) {
            String string = identifier.getSourceName();
            String string2 = identifier.getFullName();
            Identifier identifier2 = classElement.getName();
            String string3 = identifier2.getSourceName();
            String string4 = identifier2.getFullName();
            if (string3.equals(string)) {
                if (string.equals(string2) || string4.equals(string2)) {
                    return classElement;
                }
                return null;
            }
            if (string4.equals(string2)) {
                return classElement;
            }
        }
        return null;
    }

    public ClassElement[] getAllClasses() {
        if (this.isEmpty) {
            return new ClassElement[0];
        }
        return this.getAllClassesMap().values().toArray(new ClassElement[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStatus() {
        int n;
        if (this.status != -1) {
            return this.status;
        }
        if (this.data != null) {
            n = 3;
        } else {
            Task task = this.prepare();
            if (task.isFinished()) {
                this.checkData();
                n = this.data == null ? 1 : 3;
            } else {
                SourceElementImpl sourceElementImpl = this;
                synchronized (sourceElementImpl) {
                    if (!this.attached) {
                        this.attached = true;
                        task.addTaskListener((TaskListener)this);
                    }
                }
                n = 0;
            }
        }
        this.setStatus(n);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStatus(int n) {
        int n2;
        SourceElementImpl sourceElementImpl = this;
        synchronized (sourceElementImpl) {
            if (this.status == n) {
                return;
            }
            n2 = this.status;
            this.status = n;
        }
        if (n2 != -1) {
            this.firePropertyChange("status", new Integer(n2), new Integer(n));
        }
    }

    void checkData() {
        if (this.data == null) {
            FileObject fileObject = this.cdo.getPrimaryFile();
            this.data = JavaMetamodel.getManager().getResource(fileObject);
        }
    }

    public Task prepare() {
        return Task.EMPTY;
    }

    public boolean isReadOnly() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassElement getClassElement() {
        ClassElement classElement;
        if (this.isEmpty) {
            return null;
        }
        ClassElement classElement2 = classElement = this.topClass == null ? null : (ClassElement)this.topClass.get();
        if (classElement == null) {
            JavaMetamodel.getManager();
            MDRepository mDRepository = JavaMetamodel.getDefaultRepository();
            mDRepository.beginTrans(false);
            try {
                if (!this.isValid()) {
                    ClassElement classElement3 = null;
                    return classElement3;
                }
                if (this.getResource() == null) {
                    ClassElement classElement4 = null;
                    return classElement4;
                }
                JavaClass[] javaClassArray = this.getResource().getClassifiers().toArray(new JavaClass[0]);
                if (javaClassArray.length != 1) {
                    ClassElement classElement5 = null;
                    return classElement5;
                }
                classElement = new ClassElement((ClassElement.Impl)new ClassElementImpl(javaClassArray[0]), (SourceElement)this.element);
                this.topClass = new SoftReference<ClassElement>(classElement);
            }
            finally {
                mDRepository.endTrans();
            }
        }
        return classElement;
    }

    private Map getAllClassesMap() {
        Map map;
        Map map2 = map = this.allClasses == null ? null : (Map)this.allClasses.get();
        if (map == null) {
            this.checkData();
            if (this.data != null) {
                map = this.createClassesMap();
                this.allClasses = new SoftReference<Map>(map);
            } else {
                return EMPTY_MAP;
            }
        }
        return map;
    }

    private Map createClassesMap() {
        HashMap hashMap = new HashMap(15);
        ClassElement classElement = this.getClassElement();
        if (classElement != null) {
            this.addClassElement(hashMap, classElement);
        }
        return hashMap;
    }

    private void addClassElement(Map map, ClassElement classElement) {
        map.put(classElement.getName(), classElement);
        ClassElement[] classElementArray = null;
        try {
            classElementArray = classElement.getClasses();
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            return;
        }
        for (int i = 0; i < classElementArray.length; ++i) {
            this.addClassElement(map, classElementArray[i]);
        }
    }

    public void runAtomic(Runnable runnable) {
        runnable.run();
    }

    public void runAtomicAsUser(Runnable runnable) {
        runnable.run();
    }

    public Node.Cookie getCookie(Class clazz) {
        if (clazz.equals(DataObject.class) || clazz.equals(MultiDataObject.class) || ClassDataObject.class.isAssignableFrom(clazz)) {
            return this.cdo;
        }
        if (clazz == SourceElement.Impl.class || clazz == Element.Impl.class) {
            return this;
        }
        return null;
    }

    public Object readResolve() {
        return new SourceElement((SourceElement.Impl)this);
    }

    public void run() {
        if (this.cdo == null) {
            throw new IllegalStateException("Cannot load classfile without the DataObject");
        }
        this.setResource(null);
    }

    public void taskFinished(Task task) {
        this.checkData();
        this.attached = false;
        task.removeTaskListener((TaskListener)this);
        this.setStatus(this.data == null ? 1 : 3);
    }
}

