/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.project.libraries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public final class Library {
    public static final String PROP_NAME = "name";
    public static final String PROP_DESCRIPTION = "description";
    public static final String PROP_CONTENT = "content";
    private LibraryImplementation impl;
    private List listeners;

    Library(LibraryImplementation libraryImplementation) {
        this.impl = libraryImplementation;
        this.impl.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                Library.this.fireChange(string, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        });
    }

    public List getContent(String string) {
        return this.impl.getContent(string);
    }

    public String getName() {
        return this.impl.getName();
    }

    public String getDescription() {
        return this.getLocalizedString(this.impl.getLocalizingBundle(), this.impl.getDescription());
    }

    public String getDisplayName() {
        return this.getLocalizedString(this.impl.getLocalizingBundle(), this.impl.getName());
    }

    public String getType() {
        return this.impl.getType();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Library) {
            Library library = (Library)object;
            return library.impl.equals(this.impl);
        }
        return false;
    }

    public int hashCode() {
        return this.impl.hashCode();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(propertyChangeListener);
    }

    LibraryImplementation getLibraryImplementation() {
        return this.impl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange(String string, Object object, Object object2) {
        Iterator iterator = null;
        Object object3 = this;
        synchronized (object3) {
            if (this.listeners == null) {
                return;
            }
            iterator = new ArrayList(this.listeners).iterator();
        }
        object3 = new PropertyChangeEvent(this, string, object, object2);
        while (iterator.hasNext()) {
            ((PropertyChangeListener)iterator.next()).propertyChange((PropertyChangeEvent)object3);
        }
    }

    private String getLocalizedString(String string, String string2) {
        ResourceBundle resourceBundle;
        if (string2 == null) {
            return null;
        }
        if (string == null) {
            return string2;
        }
        try {
            resourceBundle = NbBundle.getBundle((String)string);
        }
        catch (MissingResourceException missingResourceException) {
            ErrorManager.getDefault().notify(1, (Throwable)missingResourceException);
            return string2;
        }
        try {
            return resourceBundle.getString(string2);
        }
        catch (MissingResourceException missingResourceException) {
            return string2;
        }
    }
}

