/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.project.libraries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryProvider;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public final class LibraryManager {
    public static final String PROP_LIBRARIES = "libraries";
    private static LibraryManager instance;
    private Lookup.Result result;
    private Collection currentStorages = new ArrayList();
    private PropertyChangeListener plistener;
    private PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private Collection cache;
    static final /* synthetic */ boolean $assertionsDisabled;

    private LibraryManager() {
    }

    public Library getLibrary(String string) {
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        Library[] libraryArray = this.getLibraries();
        for (int i = 0; i < libraryArray.length; ++i) {
            if (!string.equals(libraryArray[i].getName())) continue;
            return libraryArray[i];
        }
        return null;
    }

    public synchronized Library[] getLibraries() {
        if (this.cache == null) {
            if (this.result == null) {
                this.plistener = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        LibraryManager.this.resetCache();
                    }
                };
                this.result = Lookup.getDefault().lookup(new Lookup.Template(LibraryProvider.class));
                this.result.addLookupListener(new LookupListener(){

                    public void resultChanged(LookupEvent lookupEvent) {
                        LibraryManager.this.resetCache();
                    }
                });
            }
            ArrayList<Library> arrayList = new ArrayList<Library>();
            Collection collection = this.result.allInstances();
            HashSet hashSet = new HashSet(collection);
            hashSet.removeAll(this.currentStorages);
            HashSet hashSet2 = new HashSet(this.currentStorages);
            hashSet2.removeAll(collection);
            this.currentStorages.clear();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                LibraryProvider libraryProvider = (LibraryProvider)iterator.next();
                this.currentStorages.add(libraryProvider);
                LibraryImplementation[] libraryImplementationArray = libraryProvider.getLibraries();
                for (int i = 0; i < libraryImplementationArray.length; ++i) {
                    arrayList.add(new Library(libraryImplementationArray[i]));
                }
            }
            iterator = hashSet2.iterator();
            while (iterator.hasNext()) {
                ((LibraryProvider)iterator.next()).removePropertyChangeListener(this.plistener);
            }
            iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                ((LibraryProvider)iterator.next()).addPropertyChangeListener(this.plistener);
            }
            this.cache = arrayList;
        }
        return this.cache.toArray(new Library[this.cache.size()]);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (!$assertionsDisabled && propertyChangeListener == null) {
            throw new AssertionError();
        }
        this.listeners.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (!$assertionsDisabled && propertyChangeListener == null) {
            throw new AssertionError();
        }
        this.listeners.removePropertyChangeListener(propertyChangeListener);
    }

    private synchronized void resetCache() {
        this.cache = null;
        this.listeners.firePropertyChange(PROP_LIBRARIES, null, null);
    }

    public static synchronized LibraryManager getDefault() {
        if (instance == null) {
            instance = new LibraryManager();
        }
        return instance;
    }

    static {
        $assertionsDisabled = !LibraryManager.class.desiredAssertionStatus();
    }
}

