/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.libraries;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.project.libraries.LibraryDeclarationConvertorImpl;
import org.netbeans.modules.project.libraries.LibraryDeclarationHandlerImpl;
import org.netbeans.modules.project.libraries.LibraryDeclarationParser;
import org.netbeans.modules.project.libraries.LibraryTypeRegistry;
import org.netbeans.modules.project.libraries.WriteableLibraryProvider;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryTypeProvider;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LibrariesStorage
extends FileChangeAdapter
implements WriteableLibraryProvider {
    private static final String NB_HOME_PROPERTY = "netbeans.home";
    private static final String LIBRARIES_REPOSITORY = "org-netbeans-api-project-libraries/Libraries";
    private static final String TIME_STAMPS_FILE = "libraries-timestamps.properties";
    private static final String XML_EXT = "xml";
    private FileObject storage = null;
    private Map libraries;
    private Map librariesByFileNames;
    private ResourceBundle bundle;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private boolean initialized;
    private Properties timeStamps;
    static final /* synthetic */ boolean $assertionsDisabled;

    public LibrariesStorage() {
    }

    LibrariesStorage(FileObject fileObject) {
        this();
        this.storage = fileObject;
    }

    private static final FileObject createStorage() {
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        try {
            return FileUtil.createFolder((FileObject)fileSystem.getRoot(), (String)LIBRARIES_REPOSITORY);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void loadFromStorage() {
        this.libraries = new HashMap();
        this.librariesByFileNames = new HashMap();
        LibraryDeclarationHandlerImpl libraryDeclarationHandlerImpl = new LibraryDeclarationHandlerImpl();
        LibraryDeclarationConvertorImpl libraryDeclarationConvertorImpl = new LibraryDeclarationConvertorImpl();
        LibraryDeclarationParser libraryDeclarationParser = new LibraryDeclarationParser(libraryDeclarationHandlerImpl, libraryDeclarationConvertorImpl);
        FileObject[] fileObjectArray = this.storage.getChildren();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            FileObject fileObject = fileObjectArray[i];
            if (!XML_EXT.equalsIgnoreCase(fileObject.getExt())) continue;
            try {
                libraryDeclarationHandlerImpl.setLibrary(null);
                LibrariesStorage.readLibrary(fileObject, libraryDeclarationParser);
                LibraryImplementation libraryImplementation = libraryDeclarationHandlerImpl.getLibrary();
                if (libraryImplementation == null) continue;
                LibraryTypeProvider libraryTypeProvider = LibraryTypeRegistry.getDefault().getLibraryTypeProvider(libraryImplementation.getType());
                if (libraryTypeProvider == null) {
                    ErrorManager.getDefault().log(16, "LibrariesStorage: Can not invoke LibraryTypeProvider.libraryCreated(), the library type provider is unknown.");
                    continue;
                }
                if (this.libraries.keySet().contains(libraryImplementation.getName())) {
                    ErrorManager.getDefault().log(16, "LibrariesStorage: Library \"" + libraryImplementation.getName() + "\" is already defined, skeeping the definition from: " + FileUtil.getFileDisplayName((FileObject)fileObject));
                    continue;
                }
                if (!this.isUpToDate(fileObject)) {
                    libraryTypeProvider.libraryCreated(libraryImplementation);
                    this.updateTimeStamp(fileObject);
                }
                this.librariesByFileNames.put(fileObject.getPath(), libraryImplementation);
                this.libraries.put(libraryImplementation.getName(), libraryImplementation);
                continue;
            }
            catch (SAXException sAXException) {
                ErrorManager.getDefault().notify((Throwable)sAXException);
                continue;
            }
            catch (ParserConfigurationException parserConfigurationException) {
                ErrorManager.getDefault().notify((Throwable)parserConfigurationException);
                continue;
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
                continue;
            }
            catch (RuntimeException runtimeException) {
                ErrorManager.getDefault().notify((Throwable)runtimeException);
            }
        }
        try {
            this.saveTimeStamps();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    private synchronized void initStorage() {
        if (!this.initialized) {
            if (this.storage == null) {
                this.storage = LibrariesStorage.createStorage();
                if (this.storage == null) {
                    this.libraries = Collections.EMPTY_MAP;
                    this.librariesByFileNames = Collections.EMPTY_MAP;
                    this.initialized = true;
                    return;
                }
            }
            this.loadFromStorage();
            this.storage.addFileChangeListener((FileChangeListener)this);
            this.initialized = true;
        }
    }

    private static LibraryImplementation readLibrary(FileObject fileObject) throws SAXException, ParserConfigurationException, IOException {
        return LibrariesStorage.readLibrary(fileObject, (LibraryImplementation)null);
    }

    private static LibraryImplementation readLibrary(FileObject fileObject, LibraryImplementation libraryImplementation) throws SAXException, ParserConfigurationException, IOException {
        LibraryDeclarationHandlerImpl libraryDeclarationHandlerImpl = new LibraryDeclarationHandlerImpl();
        LibraryDeclarationConvertorImpl libraryDeclarationConvertorImpl = new LibraryDeclarationConvertorImpl();
        LibraryDeclarationParser libraryDeclarationParser = new LibraryDeclarationParser(libraryDeclarationHandlerImpl, libraryDeclarationConvertorImpl);
        libraryDeclarationHandlerImpl.setLibrary(libraryImplementation);
        LibrariesStorage.readLibrary(fileObject, libraryDeclarationParser);
        return libraryDeclarationHandlerImpl.getLibrary();
    }

    private static void readLibrary(FileObject fileObject, LibraryDeclarationParser libraryDeclarationParser) throws SAXException, ParserConfigurationException, IOException {
        URL uRL = fileObject.getURL();
        InputSource inputSource = new InputSource(uRL.toExternalForm());
        inputSource.setByteStream(fileObject.getInputStream());
        try {
            libraryDeclarationParser.parse(inputSource);
        }
        catch (SAXException sAXException) {
            ErrorManager.getDefault().annotate((Throwable)sAXException, 0, "From " + uRL, null, null, null);
            throw sAXException;
        }
    }

    private void writeLibrary(final FileObject fileObject, final LibraryImplementation libraryImplementation) throws IOException {
        fileObject.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                String string = libraryImplementation.getType();
                LibraryTypeProvider libraryTypeProvider = LibraryTypeRegistry.getDefault().getLibraryTypeProvider(string);
                if (libraryTypeProvider == null) {
                    ErrorManager.getDefault().log(16, "LibrariesStorage: Cannot store library, the library type is not recognized by any of installed LibraryTypeProviders.");
                    return;
                }
                FileObject fileObject2 = fileObject.createData(libraryImplementation.getName(), LibrariesStorage.XML_EXT);
                LibrariesStorage.writeLibraryDefinition(fileObject2, libraryImplementation, libraryTypeProvider);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void writeLibraryDefinition(FileObject fileObject, LibraryImplementation libraryImplementation, LibraryTypeProvider libraryTypeProvider) throws IOException {
        FileLock fileLock = null;
        PrintWriter printWriter = null;
        try {
            String string;
            fileLock = fileObject.lock();
            printWriter = new PrintWriter(new OutputStreamWriter(fileObject.getOutputStream(fileLock), "UTF-8"));
            printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            printWriter.println("<!DOCTYPE library PUBLIC \"-//NetBeans//DTD Library Declaration 1.0//EN\" \"http://www.netbeans.org/dtds/library-declaration-1_0.dtd\">");
            printWriter.println("<library version=\"1.0\">");
            printWriter.println("\t<name>" + libraryImplementation.getName() + "</name>");
            printWriter.println("\t<type>" + libraryImplementation.getType() + "</type>");
            String string2 = libraryImplementation.getDescription();
            if (string2 != null && string2.length() > 0) {
                printWriter.println("\t<description>" + string2 + "</description>");
            }
            if ((string = libraryImplementation.getLocalizingBundle()) != null && string.length() > 0) {
                printWriter.println("\t<localizing-bundle>" + XMLUtil.toElementContent((String)string) + "</localizing-bundle>");
            }
            String[] stringArray = libraryTypeProvider.getSupportedVolumeTypes();
            for (int i = 0; i < stringArray.length; ++i) {
                printWriter.println("\t<volume>");
                printWriter.println("\t\t<type>" + stringArray[i] + "</type>");
                List list = libraryImplementation.getContent(stringArray[i]);
                if (list != null) {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        URL uRL = (URL)iterator.next();
                        printWriter.println("\t\t<resource>" + XMLUtil.toElementContent((String)uRL.toExternalForm()) + "</resource>");
                    }
                }
                printWriter.println("\t</volume>");
            }
            printWriter.println("</library>");
            Object var13_12 = null;
            if (printWriter != null) {
                printWriter.close();
            }
            if (fileLock == null) return;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            if (printWriter != null) {
                printWriter.close();
            }
            if (fileLock == null) throw throwable;
            fileLock.releaseLock();
            throw throwable;
        }
        fileLock.releaseLock();
    }

    private void fireLibrariesChanged() {
        this.support.firePropertyChange("libraries", null, null);
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public final LibraryImplementation[] getLibraries() {
        this.initStorage();
        if (!$assertionsDisabled && this.storage == null) {
            throw new AssertionError((Object)"Storage is not initialized");
        }
        return this.libraries.values().toArray(new LibraryImplementation[this.libraries.size()]);
    }

    public void addLibrary(LibraryImplementation libraryImplementation) throws IOException {
        this.initStorage();
        if (!$assertionsDisabled && this.storage == null) {
            throw new AssertionError((Object)"Storage is not initialized");
        }
        this.writeLibrary(this.storage, libraryImplementation);
    }

    public void removeLibrary(LibraryImplementation libraryImplementation) throws IOException {
        this.initStorage();
        if (!$assertionsDisabled && this.storage == null) {
            throw new AssertionError((Object)"Storage is not initialized");
        }
        Iterator iterator = this.librariesByFileNames.keySet().iterator();
        while (iterator.hasNext()) {
            FileObject fileObject;
            String string = (String)iterator.next();
            LibraryImplementation libraryImplementation2 = (LibraryImplementation)this.librariesByFileNames.get(string);
            if (!libraryImplementation.equals(libraryImplementation2) || (fileObject = this.storage.getFileSystem().findResource(string)) == null) continue;
            fileObject.delete();
            return;
        }
    }

    public void updateLibrary(LibraryImplementation libraryImplementation, final LibraryImplementation libraryImplementation2) throws IOException {
        this.initStorage();
        if (!$assertionsDisabled && this.storage == null) {
            throw new AssertionError((Object)"Storage is not initialized");
        }
        Iterator iterator = this.librariesByFileNames.keySet().iterator();
        while (iterator.hasNext()) {
            FileObject fileObject;
            String string = (String)iterator.next();
            LibraryImplementation libraryImplementation3 = (LibraryImplementation)this.librariesByFileNames.get(string);
            if (!libraryImplementation.equals(libraryImplementation3) || (fileObject = this.storage.getFileSystem().findResource(string)) == null) continue;
            String string2 = libraryImplementation2.getType();
            final LibraryTypeProvider libraryTypeProvider = LibraryTypeRegistry.getDefault().getLibraryTypeProvider(string2);
            if (libraryTypeProvider == null) {
                ErrorManager.getDefault().log(16, "LibrariesStorageL Cannot store library, the library type is not recognized by any of installed LibraryTypeProviders.");
                return;
            }
            this.storage.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    LibrariesStorage.writeLibraryDefinition(fileObject, libraryImplementation2, libraryTypeProvider);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileDataCreated(FileEvent fileEvent) {
        block10: {
            FileObject fileObject = fileEvent.getFile();
            try {
                LibraryImplementation libraryImplementation = LibrariesStorage.readLibrary(fileObject);
                if (libraryImplementation == null) break block10;
                LibraryTypeProvider libraryTypeProvider = LibraryTypeRegistry.getDefault().getLibraryTypeProvider(libraryImplementation.getType());
                if (libraryTypeProvider == null) {
                    ErrorManager.getDefault().log(16, "LibrariesStorage: Can not invoke LibraryTypeProvider.libraryCreated(), the library type provider is unknown.");
                    break block10;
                }
                LibrariesStorage librariesStorage = this;
                synchronized (librariesStorage) {
                    this.libraries.put(libraryImplementation.getName(), libraryImplementation);
                    this.librariesByFileNames.put(fileObject.getPath(), libraryImplementation);
                }
                try {
                    libraryTypeProvider.libraryCreated(libraryImplementation);
                    this.updateTimeStamp(fileObject);
                    this.saveTimeStamps();
                }
                catch (RuntimeException runtimeException) {
                    String string = NbBundle.getMessage((Class)LibrariesStorage.class, (String)"MSG_libraryCreatedError");
                    ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)runtimeException, string));
                }
                this.fireLibrariesChanged();
            }
            catch (SAXException sAXException) {
                ErrorManager.getDefault().notify((Throwable)sAXException);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                ErrorManager.getDefault().notify((Throwable)parserConfigurationException);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileDeleted(FileEvent fileEvent) {
        LibraryImplementation libraryImplementation;
        String string = fileEvent.getFile().getPath();
        Object object = this;
        synchronized (object) {
            libraryImplementation = (LibraryImplementation)this.librariesByFileNames.remove(string);
            if (libraryImplementation != null) {
                this.libraries.remove(libraryImplementation.getName());
            }
        }
        if (libraryImplementation != null) {
            object = LibraryTypeRegistry.getDefault().getLibraryTypeProvider(libraryImplementation.getType());
            if (object == null) {
                ErrorManager.getDefault().log(16, "LibrariesStorage: Cannot invoke LibraryTypeProvider.libraryDeleted(), the library type provider is unknown.");
            } else {
                try {
                    object.libraryDeleted(libraryImplementation);
                }
                catch (RuntimeException runtimeException) {
                    String string2 = NbBundle.getMessage((Class)LibrariesStorage.class, (String)"MSG_libraryDeletedError");
                    ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)runtimeException, string2));
                }
            }
            this.fireLibrariesChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileChanged(FileEvent fileEvent) {
        LibraryImplementation libraryImplementation;
        FileObject fileObject = fileEvent.getFile();
        String string = fileObject.getPath();
        Object object = this;
        synchronized (object) {
            libraryImplementation = (LibraryImplementation)this.librariesByFileNames.get(string);
        }
        if (libraryImplementation != null) {
            try {
                LibrariesStorage.readLibrary(fileObject, libraryImplementation);
                object = LibraryTypeRegistry.getDefault().getLibraryTypeProvider(libraryImplementation.getType());
                if (object == null) {
                    ErrorManager.getDefault().log(16, "LibrariesStorage: Can not invoke LibraryTypeProvider.libraryCreated(), the library type provider is unknown.");
                }
                try {
                    object.libraryCreated(libraryImplementation);
                    this.updateTimeStamp(fileObject);
                    this.saveTimeStamps();
                }
                catch (RuntimeException runtimeException) {
                    String string2 = NbBundle.getMessage((Class)LibrariesStorage.class, (String)"MSG_libraryCreatedError");
                    ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)runtimeException, string2));
                }
            }
            catch (SAXException sAXException) {
                ErrorManager.getDefault().notify((Throwable)sAXException);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                ErrorManager.getDefault().notify((Throwable)parserConfigurationException);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
    }

    protected final ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle((Class)LibrariesStorage.class);
        }
        return this.bundle;
    }

    private boolean isUpToDate(FileObject fileObject) {
        Properties properties = this.getTimeStamps();
        String string = (String)properties.get(fileObject.getNameExt());
        return string == null ? false : Long.parseLong(string) >= fileObject.lastModified().getTime();
    }

    private void updateTimeStamp(FileObject fileObject) {
        Properties properties = this.getTimeStamps();
        properties.put(fileObject.getNameExt(), Long.toString(fileObject.lastModified().getTime()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveTimeStamps() throws IOException {
        if (this.storage != null) {
            FileObject fileObject;
            String string;
            Properties properties = this.getTimeStamps();
            if (properties.get(NB_HOME_PROPERTY) == null) {
                string = LibrariesStorage.getNBRoots();
                properties.put(NB_HOME_PROPERTY, string);
            }
            if ((fileObject = (string = this.storage.getParent()).getFileObject(TIME_STAMPS_FILE)) == null) {
                fileObject = string.createData(TIME_STAMPS_FILE);
            }
            FileLock fileLock = fileObject.lock();
            try {
                OutputStream outputStream = fileObject.getOutputStream(fileLock);
                try {
                    properties.store(outputStream, null);
                }
                finally {
                    outputStream.close();
                }
            }
            finally {
                fileLock.releaseLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getTimeStamps() {
        if (this.timeStamps == null) {
            FileObject fileObject;
            this.timeStamps = new Properties();
            if (this.storage != null && (fileObject = this.storage.getParent().getFileObject(TIME_STAMPS_FILE)) != null) {
                try {
                    InputStream inputStream = fileObject.getInputStream();
                    try {
                        this.timeStamps.load(inputStream);
                    }
                    finally {
                        inputStream.close();
                    }
                    String string = (String)this.timeStamps.get(NB_HOME_PROPERTY);
                    String string2 = LibrariesStorage.getNBRoots();
                    if (string == null || !string.equals(string2)) {
                        this.timeStamps.clear();
                    }
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        }
        return this.timeStamps;
    }

    private static String getNBRoots() {
        Object object;
        Object object2;
        TreeSet<String> treeSet = new TreeSet<String>();
        String string = System.getProperty(NB_HOME_PROPERTY);
        if (string != null && ((File)(object2 = FileUtil.normalizeFile((File)new File(string)))).isDirectory()) {
            treeSet.add(((File)object2).getAbsolutePath());
        }
        if ((string = System.getProperty("netbeans.dirs")) != null) {
            object2 = new StringTokenizer(string, File.pathSeparator);
            while (((StringTokenizer)object2).hasMoreTokens()) {
                object = FileUtil.normalizeFile((File)new File(((StringTokenizer)object2).nextToken()));
                treeSet.add(((File)object).getAbsolutePath());
            }
        }
        object2 = new StringBuffer();
        object = treeSet.iterator();
        while (object.hasNext()) {
            ((StringBuffer)object2).append(object.next());
            if (!object.hasNext()) continue;
            ((StringBuffer)object2).append(":");
        }
        return ((StringBuffer)object2).toString();
    }

    static {
        $assertionsDisabled = !LibrariesStorage.class.desiredAssertionStatus();
    }
}

