/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.libraries;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.project.libraries.LibraryDeclarationHandler;
import org.netbeans.modules.project.libraries.LibraryTypeRegistry;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.openide.ErrorManager;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class LibraryDeclarationHandlerImpl
implements LibraryDeclarationHandler {
    private LibraryImplementation library;
    private String libraryType;
    private String libraryDescription;
    private String libraryName;
    private String localizingBundle;
    private Map contentTypes = new HashMap();
    private List cpEntries;
    private String contentType;
    private boolean inVolume = false;
    public static final boolean DEBUG = false;

    public void start_volume(Attributes attributes) throws SAXException {
        this.cpEntries = new ArrayList();
        this.inVolume = true;
    }

    public void end_volume() throws SAXException {
        this.contentTypes.put(this.contentType, this.cpEntries);
        this.inVolume = false;
        this.contentType = null;
    }

    public void handle_type(String string, Attributes attributes) throws SAXException {
        if (string == null || string.length() == 0) {
            throw new SAXException("Empty value of type element");
        }
        if (this.inVolume) {
            this.contentType = string;
        } else {
            this.libraryType = string;
        }
    }

    public void start_library(Attributes attributes) throws SAXException {
        if (!"1.0".equals(attributes.getValue("version"))) {
            throw new SAXException("Invalid librray descriptor version");
        }
    }

    public void end_library() throws SAXException {
        Object object;
        boolean bl;
        if (this.library != null) {
            if (this.libraryType == null || !this.libraryType.equals(this.library.getType())) {
                throw new SAXParseException("Changing library type of library: " + this.libraryName + " from: " + this.library.getType() + " to: " + this.libraryType, null);
            }
            bl = true;
        } else {
            object = LibraryTypeRegistry.getDefault().getLibraryTypeProvider(this.libraryType);
            if (object == null) {
                ErrorManager.getDefault().log(16, "LibraryDeclarationHandlerImpl: Cannot create library: " + this.libraryName + " of unknown type: " + this.libraryType);
                return;
            }
            this.library = object.createLibrary();
            bl = false;
        }
        if (!bl || !LibraryDeclarationHandlerImpl.safeEquals(this.library.getLocalizingBundle(), this.localizingBundle)) {
            this.library.setLocalizingBundle(this.localizingBundle);
        }
        if (!bl || !LibraryDeclarationHandlerImpl.safeEquals(this.library.getName(), this.libraryName)) {
            this.library.setName(this.libraryName);
        }
        if (!bl || !LibraryDeclarationHandlerImpl.safeEquals(this.library.getDescription(), this.libraryDescription)) {
            this.library.setDescription(this.libraryDescription);
        }
        object = this.contentTypes.keySet().iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            List list = (List)this.contentTypes.get(string);
            try {
                if (bl && LibraryDeclarationHandlerImpl.safeEquals(this.library.getContent(string), list)) continue;
                this.library.setContent(string, list);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw (SAXException)new SAXException(illegalArgumentException.toString()).initCause(illegalArgumentException);
            }
        }
        this.libraryName = null;
        this.libraryDescription = null;
        this.libraryType = null;
        this.localizingBundle = null;
        this.contentTypes.clear();
    }

    public void handle_resource(URL uRL, Attributes attributes) throws SAXException {
        if (uRL != null) {
            this.cpEntries.add(uRL);
        }
    }

    public void handle_name(String string, Attributes attributes) throws SAXException {
        this.libraryName = string;
    }

    public void handle_description(String string, Attributes attributes) throws SAXException {
        this.libraryDescription = string;
    }

    public void handle_localizingBundle(String string, Attributes attributes) throws SAXException {
        this.localizingBundle = string;
    }

    public void setLibrary(LibraryImplementation libraryImplementation) {
        this.library = libraryImplementation;
    }

    public LibraryImplementation getLibrary() {
        LibraryImplementation libraryImplementation = this.library;
        this.library = null;
        return libraryImplementation;
    }

    private static boolean safeEquals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }
}

