/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.libraries.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.modules.project.libraries.LibraryTypeRegistry;
import org.netbeans.modules.project.libraries.ui.LibrariesModel;
import org.netbeans.modules.project.libraries.ui.NewLibraryPanel;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryTypeProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public final class LibrariesCustomizer
extends JPanel
implements ExplorerManager.Provider,
HelpCtx.Provider {
    private ExplorerManager manager;
    private LibrariesModel model = new LibrariesModel();
    private BeanTreeView libraries;
    private JButton createButton;
    private JButton deleteButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JTextField libraryName;
    private JPanel libsPanel;
    private JTabbedPane properties;

    public LibrariesCustomizer() {
        this.initComponents();
        this.postInitComponents();
    }

    public void setSelectedLibrary(LibraryImplementation libraryImplementation) {
        if (libraryImplementation == null) {
            return;
        }
        ExplorerManager explorerManager = this.getExplorerManager();
        Node node = explorerManager.getRootContext();
        String[] stringArray = new String[]{libraryImplementation.getType(), libraryImplementation.getName()};
        try {
            Node node2 = NodeOp.findPath((Node)node, (String[])stringArray);
            if (node2 != null) {
                explorerManager.setSelectedNodes(new Node[]{node2});
            }
        }
        catch (NodeNotFoundException nodeNotFoundException) {
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(LibrariesCustomizer.class);
    }

    public boolean apply() {
        try {
            this.model.apply();
            return true;
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return false;
        }
    }

    public void cancel() {
        this.model.cancel();
    }

    public void addNotify() {
        super.addNotify();
        LibrariesCustomizer.expandAllNodes(this.libraries, this.getExplorerManager().getRootContext());
        if (this.getExplorerManager().getSelectedNodes().length == 0) {
            Node node = this.getExplorerManager().getRootContext();
            Node[] nodeArray = node.getChildren().getNodes(true);
            for (int i = 0; i < nodeArray.length; ++i) {
                Node[] nodeArray2 = nodeArray[i].getChildren().getNodes(true);
                if (nodeArray2.length <= 0) continue;
                try {
                    this.getExplorerManager().setSelectedNodes(new Node[]{nodeArray2[0]});
                }
                catch (PropertyVetoException propertyVetoException) {}
                break;
            }
        }
        this.libraries.requestFocus();
    }

    public ExplorerManager getExplorerManager() {
        if (this.manager == null) {
            this.manager = new ExplorerManager();
            this.manager.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
                        Node[] nodeArray = (Node[])propertyChangeEvent.getNewValue();
                        LibrariesCustomizer.this.selectLibrary(nodeArray);
                        LibrariesCustomizer.this.libraries.requestFocus();
                    }
                }
            });
            this.manager.addVetoableChangeListener(new VetoableChangeListener(){

                public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                    if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
                        Node[] nodeArray = (Node[])propertyChangeEvent.getNewValue();
                        if (nodeArray.length <= 1) {
                            return;
                        }
                        throw new PropertyVetoException("Invalid length", propertyChangeEvent);
                    }
                }
            });
            this.manager.setRootContext(LibrariesCustomizer.buildTree(this.model));
        }
        return this.manager;
    }

    private void postInitComponents() {
        this.libraries = new LibrariesView();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        ((GridBagLayout)this.libsPanel.getLayout()).setConstraints((Component)this.libraries, gridBagConstraints);
        this.libsPanel.add((Component)this.libraries);
        this.libraries.setPreferredSize(new Dimension(200, 334));
        this.libraryName.setColumns(25);
        this.libraryName.setEnabled(false);
        this.libraryName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LibrariesCustomizer.this.nameChanged();
            }
        });
    }

    private void nameChanged() {
        Node[] nodeArray = this.getExplorerManager().getSelectedNodes();
        if (nodeArray.length == 1 && nodeArray[0] instanceof LibraryNode) {
            LibraryNode libraryNode = (LibraryNode)nodeArray[0];
            String string = this.libraryName.getText();
            if (string.length() == 0) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)LibrariesCustomizer.class, (String)"ERR_InvalidName"), 0));
            } else if (LibrariesCustomizer.isValidName(this.model, string)) {
                libraryNode.getLibrary().setName(string);
            } else {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)LibrariesCustomizer.class, (String)"ERR_ExistingName", (Object)string), 0));
            }
        }
    }

    private void selectLibrary(Node[] nodeArray) {
        int n = this.properties.getTabCount();
        for (int i = 0; i < n; ++i) {
            this.properties.removeTabAt(0);
        }
        this.libraryName.setEnabled(false);
        this.libraryName.setText("");
        this.jLabel1.setVisible(false);
        this.libraryName.setVisible(false);
        this.properties.setVisible(false);
        this.deleteButton.setEnabled(false);
        if (nodeArray.length != 1 || !(nodeArray[0] instanceof LibraryNode)) {
            return;
        }
        this.jLabel1.setVisible(true);
        this.libraryName.setVisible(true);
        this.properties.setVisible(true);
        LibraryNode libraryNode = (LibraryNode)nodeArray[0];
        LibraryImplementation libraryImplementation = libraryNode.getLibrary();
        boolean bl = this.model.isLibraryEditable(libraryImplementation);
        this.libraryName.setEnabled(bl);
        this.deleteButton.setEnabled(bl);
        this.libraryName.setText(LibrariesCustomizer.getLocalizedString(libraryImplementation.getLocalizingBundle(), libraryImplementation.getName()));
        String string = libraryImplementation.getType();
        LibraryTypeProvider libraryTypeProvider = libraryNode.getProvider();
        if (libraryTypeProvider == null) {
            return;
        }
        String[] stringArray = libraryTypeProvider.getSupportedVolumeTypes();
        for (int i = 0; i < stringArray.length; ++i) {
            Customizer customizer = libraryTypeProvider.getCustomizer(stringArray[i]);
            if (!(customizer instanceof JComponent)) continue;
            customizer.setObject(libraryImplementation);
            JComponent jComponent = (JComponent)((Object)customizer);
            jComponent.setEnabled(bl);
            String string2 = jComponent.getName();
            if (string2 == null) {
                string2 = stringArray[i];
            }
            this.properties.addTab(string2, jComponent);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.libraryName = new JTextField();
        this.jPanel1 = new JPanel();
        this.properties = new JTabbedPane();
        this.createButton = new JButton();
        this.deleteButton = new JButton();
        this.libsPanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/project/libraries/ui/Bundle").getString("AD_LibrariesCustomizer"));
        this.jLabel1.setLabelFor(this.libraryName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)ResourceBundle.getBundle("org/netbeans/modules/project/libraries/ui/Bundle").getString("CTL_CustomizerLibraryName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 12, 6);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.libraryName.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.6;
        gridBagConstraints.insets = new Insets(0, 0, 12, 12);
        this.add((Component)this.libraryName, gridBagConstraints);
        this.libraryName.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/project/libraries/ui/Bundle").getString("AD_LibraryName"));
        this.jPanel1.setLayout(new BorderLayout());
        this.properties.setPreferredSize(new Dimension(400, 300));
        this.jPanel1.add((Component)this.properties, "Center");
        this.properties.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/project/libraries/ui/Bundle").getString("AN_LibrariesCustomizerProperties"));
        this.properties.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/project/libraries/ui/Bundle").getString("AD_LibrariesCustomizerProperties"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 12);
        this.add((Component)this.jPanel1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.createButton, (String)ResourceBundle.getBundle("org/netbeans/modules/project/libraries/ui/Bundle").getString("CTL_NewLibrary"));
        this.createButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LibrariesCustomizer.this.createLibrary(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        this.add((Component)this.createButton, gridBagConstraints);
        this.createButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/project/libraries/ui/Bundle").getString("AD_NewLibrary"));
        Mnemonics.setLocalizedText((AbstractButton)this.deleteButton, (String)ResourceBundle.getBundle("org/netbeans/modules/project/libraries/ui/Bundle").getString("CTL_DeleteLibrary"));
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LibrariesCustomizer.this.deleteLibrary(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.deleteButton, gridBagConstraints);
        this.deleteButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/project/libraries/ui/Bundle").getString("AD_DeleteLibrary"));
        this.libsPanel.setLayout(new GridBagLayout());
        this.libsPanel.setBorder(new EtchedBorder());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 12, 6);
        this.add((Component)this.libsPanel, gridBagConstraints);
        this.libsPanel.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/project/libraries/ui/Bundle").getString("AD_libsPanel"));
        this.jLabel2.setLabelFor(this.libsPanel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)ResourceBundle.getBundle("org/netbeans/modules/project/libraries/ui/Bundle").getString("TXT_LibrariesPanel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 2, 12);
        this.add((Component)this.jLabel2, gridBagConstraints);
    }

    private void deleteLibrary(ActionEvent actionEvent) {
        Node[] nodeArray = this.getExplorerManager().getSelectedNodes();
        if (nodeArray.length == 1 && nodeArray[0] instanceof LibraryNode) {
            Node[] nodeArray2 = nodeArray[0].getParentNode().getChildren().getNodes(true);
            Node node = null;
            for (int i = 0; i < nodeArray2.length; ++i) {
                if (!nodeArray[0].equals((Object)nodeArray2[i])) continue;
                if (i > 0) {
                    node = nodeArray2[i - 1];
                    continue;
                }
                if (i >= nodeArray2.length - 1) continue;
                node = nodeArray2[i + 1];
            }
            this.model.removeLibrary(((LibraryNode)nodeArray[0]).getLibrary());
            try {
                if (node != null) {
                    this.getExplorerManager().setSelectedNodes(new Node[]{node});
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.libraries.requestFocus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createLibrary(ActionEvent actionEvent) {
        block12: {
            Window window = null;
            try {
                Object object;
                String string = null;
                Node[] nodeArray = this.getExplorerManager().getSelectedNodes();
                if (nodeArray.length == 1 && (object = (LibraryCategory)nodeArray[0].getLookup().lookup(LibraryCategory.class)) != null) {
                    string = ((LibraryCategory)object).getCategoryType();
                }
                object = new NewLibraryPanel(this.model, string);
                DialogDescriptor dialogDescriptor = new DialogDescriptor(object, NbBundle.getMessage((Class)LibrariesCustomizer.class, (String)"CTL_CreateLibrary"), true, 2, null, null);
                ((NewLibraryPanel)object).setDialogDescriptor(dialogDescriptor);
                window = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                ((Dialog)window).setVisible(true);
                if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
                    String string2 = ((NewLibraryPanel)object).getLibraryType();
                    String string3 = ((NewLibraryPanel)object).getLibraryName();
                    LibraryTypeProvider libraryTypeProvider = LibraryTypeRegistry.getDefault().getLibraryTypeProvider(string2);
                    if (libraryTypeProvider == null) {
                        return;
                    }
                    LibraryImplementation libraryImplementation = libraryTypeProvider.createLibrary();
                    libraryImplementation.setName(string3);
                    this.model.addLibrary(libraryImplementation);
                    String[] stringArray = new String[]{libraryImplementation.getType(), libraryImplementation.getName()};
                    ExplorerManager explorerManager = this.getExplorerManager();
                    try {
                        Node node = NodeOp.findPath((Node)explorerManager.getRootContext(), (String[])stringArray);
                        if (node != null) {
                            explorerManager.setSelectedNodes(new Node[]{node});
                        }
                    }
                    catch (PropertyVetoException propertyVetoException) {
                    }
                    catch (NodeNotFoundException nodeNotFoundException) {
                        // empty catch block
                    }
                    this.libraryName.requestFocus();
                    this.libraryName.selectAll();
                    break block12;
                }
                this.libraries.requestFocus();
            }
            finally {
                if (window != null) {
                    window.dispose();
                }
            }
        }
    }

    static boolean isValidName(LibrariesModel librariesModel, String string) {
        int n = librariesModel.getSize();
        for (int i = 0; i < n; ++i) {
            LibraryImplementation libraryImplementation = (LibraryImplementation)librariesModel.getElementAt(i);
            if (libraryImplementation == null || !libraryImplementation.getName().equals(string)) continue;
            return false;
        }
        return true;
    }

    static String getLocalizedString(String string, String string2) {
        ResourceBundle resourceBundle;
        if (string2 == null) {
            return null;
        }
        if (string == null) {
            return string2;
        }
        try {
            resourceBundle = NbBundle.getBundle((String)string);
        }
        catch (MissingResourceException missingResourceException) {
            ErrorManager.getDefault().notify(1, (Throwable)missingResourceException);
            return string2;
        }
        try {
            return resourceBundle.getString(string2);
        }
        catch (MissingResourceException missingResourceException) {
            return string2;
        }
    }

    private static void expandAllNodes(BeanTreeView beanTreeView, Node node) {
        beanTreeView.expandNode(node);
        Children children = node.getChildren();
        if (children == Children.LEAF) {
            return;
        }
        Node[] nodeArray = children.getNodes(true);
        for (int i = 0; i < nodeArray.length; ++i) {
            LibrariesCustomizer.expandAllNodes(beanTreeView, nodeArray[i]);
        }
    }

    private static Node buildTree(LibrariesModel librariesModel) {
        return new AbstractNode((Children)new RootChildren(librariesModel));
    }

    private static class LibraryNode
    extends AbstractNode {
        private static final String ICON = "org/netbeans/modules/project/libraries/resources/libraries";
        private LibraryImplementation lib;
        private LibraryTypeProvider provider;

        public LibraryNode(LibraryImplementation libraryImplementation, LibraryTypeProvider libraryTypeProvider) {
            super(Children.LEAF);
            this.lib = libraryImplementation;
            this.provider = libraryTypeProvider;
            this.setIconBase(ICON);
        }

        public String getName() {
            return this.lib.getName();
        }

        public String getDisplayName() {
            return LibrariesCustomizer.getLocalizedString(this.lib.getLocalizingBundle(), this.lib.getName());
        }

        public LibraryImplementation getLibrary() {
            return this.lib;
        }

        public LibraryTypeProvider getProvider() {
            return this.provider;
        }

        public boolean equals(Object object) {
            if (object instanceof LibraryNode) {
                LibraryNode libraryNode = (LibraryNode)((Object)object);
                return (this.lib == null ? libraryNode.lib == null : this.lib.equals(libraryNode.lib)) && (this.provider == null ? libraryNode.provider == null : this.provider.equals(libraryNode.provider));
            }
            return false;
        }
    }

    private static class CategoryChildren
    extends Children.Keys
    implements ListDataListener {
        private LibraryTypeProvider provider;
        private LibrariesModel model;

        public CategoryChildren(LibraryTypeProvider libraryTypeProvider, LibrariesModel librariesModel) {
            this.provider = libraryTypeProvider;
            this.model = librariesModel;
            this.model.addListDataListener(this);
        }

        public void addNotify() {
            ArrayList<LibraryImplementation> arrayList = new ArrayList<LibraryImplementation>();
            for (int i = 0; i < this.model.getSize(); ++i) {
                LibraryImplementation libraryImplementation = (LibraryImplementation)this.model.getElementAt(i);
                if (!this.provider.getLibraryType().equals(libraryImplementation.getType())) continue;
                arrayList.add(libraryImplementation);
            }
            this.setKeys(arrayList);
        }

        public void removeNotify() {
            this.setKeys(new Object[0]);
        }

        protected Node[] createNodes(Object object) {
            if (object instanceof LibraryImplementation) {
                LibraryImplementation libraryImplementation = (LibraryImplementation)object;
                return new Node[]{new LibraryNode(libraryImplementation, this.provider)};
            }
            return new Node[0];
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            this.addNotify();
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            this.addNotify();
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.addNotify();
        }
    }

    private static class CategoryNode
    extends AbstractNode {
        private LibraryTypeProvider provider;
        private Node iconDelegate;

        public CategoryNode(LibraryTypeProvider libraryTypeProvider, LibrariesModel librariesModel) {
            super((Children)new CategoryChildren(libraryTypeProvider, librariesModel), Lookups.singleton((Object)new LibraryCategory(libraryTypeProvider.getLibraryType())));
            this.provider = libraryTypeProvider;
            this.iconDelegate = DataFolder.findFolder((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot()).getNodeDelegate();
        }

        public String getName() {
            return this.provider.getLibraryType();
        }

        public String getDisplayName() {
            return this.provider.getDisplayName();
        }

        public Image getIcon(int n) {
            return this.iconDelegate.getIcon(n);
        }

        public Image getOpenedIcon(int n) {
            return this.iconDelegate.getOpenedIcon(n);
        }
    }

    private static final class LibraryCategory {
        private final String name;

        LibraryCategory(String string) {
            this.name = string;
        }

        public String getCategoryType() {
            return this.name;
        }
    }

    private static class RootChildren
    extends Children.Keys {
        private LibrariesModel model;

        public RootChildren(LibrariesModel librariesModel) {
            this.model = librariesModel;
        }

        public void addNotify() {
            this.setKeys(LibraryTypeRegistry.getDefault().getLibraryTypeProviders());
        }

        public void removeNotify() {
            this.setKeys(new Object[0]);
        }

        protected Node[] createNodes(Object object) {
            if (object instanceof LibraryTypeProvider) {
                LibraryTypeProvider libraryTypeProvider = (LibraryTypeProvider)object;
                return new Node[]{new CategoryNode(libraryTypeProvider, this.model)};
            }
            return new Node[0];
        }
    }

    private static class LibrariesView
    extends BeanTreeView {
        public LibrariesView() {
            this.setRootVisible(false);
            this.setPopupAllowed(false);
            this.setDefaultActionAllowed(false);
            this.tree.setEditable(false);
            this.tree.setShowsRootHandles(false);
        }
    }
}

