/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.libraries.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import org.netbeans.modules.project.libraries.WriteableLibraryProvider;
import org.netbeans.modules.project.libraries.ui.LibrariesCustomizer;
import org.netbeans.modules.project.libraries.ui.ProxyLibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryProvider;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

class LibrariesModel
extends AbstractListModel
implements PropertyChangeListener,
LookupListener {
    private List actualLibraries;
    private List addedLibraries = new ArrayList();
    private List removedLibraries = new ArrayList();
    private List changedLibraries = new ArrayList();
    private Collection currentStorages = Collections.EMPTY_SET;
    private Map storageByLib = new HashMap();
    private Lookup.Result lresult;
    private WriteableLibraryProvider writeableProvider;
    static /* synthetic */ Class class$org$netbeans$modules$project$libraries$ui$LibrariesModel;

    public LibrariesModel() {
        this.getLibraries();
    }

    public Object getElementAt(int n) {
        if (n < 0 || n >= this.actualLibraries.size()) {
            return null;
        }
        return this.actualLibraries.get(n);
    }

    public int getSize() {
        return this.actualLibraries.size();
    }

    public void addLibrary(LibraryImplementation libraryImplementation) {
        Object e;
        int n;
        this.addedLibraries.add(libraryImplementation);
        LibrariesComparator librariesComparator = new LibrariesComparator();
        for (n = 0; n < this.actualLibraries.size() && librariesComparator.compare(libraryImplementation, e = this.actualLibraries.get(n)) >= 0; ++n) {
        }
        this.actualLibraries.add(n, libraryImplementation);
        this.fireIntervalAdded(this, n, n);
    }

    public void removeLibrary(LibraryImplementation libraryImplementation) {
        if (this.addedLibraries.contains(libraryImplementation)) {
            this.addedLibraries.remove(libraryImplementation);
        } else {
            this.removedLibraries.add(((ProxyLibraryImplementation)libraryImplementation).getOriginal());
        }
        int n = this.actualLibraries.indexOf(libraryImplementation);
        this.actualLibraries.remove(n);
        this.fireIntervalRemoved(this, n, n);
    }

    public void modifyLibrary(LibraryImplementation libraryImplementation) {
        if (!this.addedLibraries.contains(libraryImplementation) && !this.changedLibraries.contains(libraryImplementation)) {
            this.changedLibraries.add(libraryImplementation);
        }
        int n = this.actualLibraries.indexOf(libraryImplementation);
        this.fireContentsChanged(this, n, n);
    }

    public boolean isLibraryEditable(LibraryImplementation libraryImplementation) {
        if (this.addedLibraries.contains(libraryImplementation)) {
            return true;
        }
        LibraryProvider libraryProvider = (LibraryProvider)this.storageByLib.get(((ProxyLibraryImplementation)libraryImplementation).getOriginal());
        return libraryProvider == this.writeableProvider;
    }

    public void apply() throws IOException {
        LibraryProvider libraryProvider;
        LibraryImplementation libraryImplementation;
        Iterator iterator = this.removedLibraries.iterator();
        while (iterator.hasNext()) {
            libraryImplementation = (LibraryImplementation)iterator.next();
            libraryProvider = (LibraryProvider)this.storageByLib.get(libraryImplementation);
            if (libraryProvider == this.writeableProvider) {
                this.writeableProvider.removeLibrary(libraryImplementation);
                continue;
            }
            ErrorManager.getDefault().log("Can not find storage for library: " + libraryImplementation.getName());
        }
        if (this.writeableProvider != null) {
            iterator = this.addedLibraries.iterator();
            while (iterator.hasNext()) {
                this.writeableProvider.addLibrary((LibraryImplementation)iterator.next());
            }
        } else {
            ErrorManager.getDefault().log("Can not add libraries, no WriteableProvider.");
        }
        iterator = this.changedLibraries.iterator();
        while (iterator.hasNext()) {
            libraryImplementation = (ProxyLibraryImplementation)iterator.next();
            libraryProvider = (LibraryProvider)this.storageByLib.get(((ProxyLibraryImplementation)libraryImplementation).getOriginal());
            if (libraryProvider == this.writeableProvider) {
                this.writeableProvider.updateLibrary(((ProxyLibraryImplementation)libraryImplementation).getOriginal(), libraryImplementation);
                continue;
            }
            ErrorManager.getDefault().log("Can not find storage for library: " + ((ProxyLibraryImplementation)libraryImplementation).getOriginal().getName());
        }
        this.cleanUp();
    }

    public void cancel() {
        this.cleanUp();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.storagesChanged();
    }

    public void resultChanged(LookupEvent lookupEvent) {
        this.storagesChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storagesChanged() {
        int n;
        LibrariesModel librariesModel = this;
        synchronized (librariesModel) {
            n = this.actualLibraries == null ? 0 : this.actualLibraries.size();
            this.getLibraries();
        }
        this.fireContentsChanged(this, 0, Math.max(n, this.actualLibraries.size()));
    }

    private LibraryImplementation findModified(LibraryImplementation libraryImplementation) {
        Iterator iterator = this.changedLibraries.iterator();
        while (iterator.hasNext()) {
            ProxyLibraryImplementation proxyLibraryImplementation = (ProxyLibraryImplementation)iterator.next();
            if (!proxyLibraryImplementation.getOriginal().equals(libraryImplementation)) continue;
            return proxyLibraryImplementation;
        }
        return null;
    }

    private synchronized void cleanUp() {
        this.addedLibraries.clear();
        this.removedLibraries.clear();
        this.changedLibraries.clear();
        Iterator iterator = this.currentStorages.iterator();
        while (iterator.hasNext()) {
            ((LibraryProvider)iterator.next()).removePropertyChangeListener(this);
        }
        this.currentStorages = Collections.EMPTY_SET;
    }

    private synchronized void getLibraries() {
        ArrayList<LibraryImplementation> arrayList = new ArrayList<LibraryImplementation>();
        if (this.lresult == null) {
            this.lresult = Lookup.getDefault().lookup(new Lookup.Template(LibraryProvider.class));
            this.lresult.addLookupListener((LookupListener)this);
        }
        Collection collection = this.lresult.allInstances();
        HashSet hashSet = new HashSet(collection);
        hashSet.removeAll(this.currentStorages);
        HashSet hashSet2 = new HashSet(this.currentStorages);
        hashSet2.removeAll(collection);
        this.currentStorages = collection;
        this.storageByLib.clear();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            LibraryProvider libraryProvider = (LibraryProvider)iterator.next();
            if (this.writeableProvider == null && libraryProvider instanceof WriteableLibraryProvider) {
                this.writeableProvider = (WriteableLibraryProvider)libraryProvider;
            }
            LibraryImplementation[] libraryImplementationArray = libraryProvider.getLibraries();
            for (int i = 0; i < libraryImplementationArray.length; ++i) {
                LibraryImplementation libraryImplementation = libraryImplementationArray[i];
                LibraryImplementation libraryImplementation2 = null;
                if (this.removedLibraries.contains(libraryImplementation)) {
                    this.storageByLib.put(libraryImplementation, libraryProvider);
                    continue;
                }
                libraryImplementation2 = this.findModified(libraryImplementation);
                if (libraryImplementation2 != null) {
                    arrayList.add(libraryImplementation2);
                    this.storageByLib.put(libraryImplementation, libraryProvider);
                    continue;
                }
                arrayList.add(new ProxyLibraryImplementation(libraryImplementation, this));
                this.storageByLib.put(libraryImplementation, libraryProvider);
            }
        }
        arrayList.addAll(this.addedLibraries);
        Collections.sort(arrayList, new LibrariesComparator());
        iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            ((LibraryProvider)iterator.next()).removePropertyChangeListener(this);
        }
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ((LibraryProvider)iterator.next()).addPropertyChangeListener(this);
        }
        this.actualLibraries = arrayList;
    }

    private static class LibrariesComparator
    implements Comparator {
        static final /* synthetic */ boolean $assertionsDisabled;

        private LibrariesComparator() {
        }

        public int compare(Object object, Object object2) {
            if (!($assertionsDisabled || object instanceof LibraryImplementation && object2 instanceof LibraryImplementation)) {
                throw new AssertionError();
            }
            LibraryImplementation libraryImplementation = (LibraryImplementation)object;
            LibraryImplementation libraryImplementation2 = (LibraryImplementation)object2;
            String string = LibrariesCustomizer.getLocalizedString(libraryImplementation.getLocalizingBundle(), libraryImplementation.getName());
            String string2 = LibrariesCustomizer.getLocalizedString(libraryImplementation2.getLocalizingBundle(), libraryImplementation2.getName());
            return string.compareToIgnoreCase(string2);
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$project$libraries$ui$LibrariesModel == null ? (class$org$netbeans$modules$project$libraries$ui$LibrariesModel = LibrariesModel.class$("org.netbeans.modules.project.libraries.ui.LibrariesModel")) : class$org$netbeans$modules$project$libraries$ui$LibrariesModel).desiredAssertionStatus();
        }
    }
}

