/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.libraries.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.project.libraries.LibraryTypeRegistry;
import org.netbeans.modules.project.libraries.ui.LibrariesCustomizer;
import org.netbeans.modules.project.libraries.ui.LibrariesModel;
import org.netbeans.spi.project.libraries.LibraryTypeProvider;
import org.openide.DialogDescriptor;
import org.openide.util.NbBundle;

public class NewLibraryPanel
extends JPanel {
    private LibrariesModel model;
    private Map typeMap;
    private DialogDescriptor dd;
    private static final Pattern VALID_LIBRARY_NAME = Pattern.compile("[-._a-zA-Z0-9]+");
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JComboBox libraryType;
    private JTextField name;
    private JLabel status;

    public NewLibraryPanel(LibrariesModel librariesModel, String string) {
        this.model = librariesModel;
        this.initComponents();
        this.name.setColumns(25);
        this.name.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                NewLibraryPanel.this.nameChanged();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                NewLibraryPanel.this.nameChanged();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                NewLibraryPanel.this.nameChanged();
            }
        });
        this.initModel(string);
        Color color = UIManager.getColor("nb.errorForeground");
        if (color == null) {
            color = new Color(89, 79, 191);
        }
        this.status.setForeground(color);
    }

    void setDialogDescriptor(DialogDescriptor dialogDescriptor) {
        this.dd = dialogDescriptor;
    }

    public String getLibraryType() {
        Integer n = new Integer(this.libraryType.getSelectedIndex());
        return (String)this.typeMap.get(n);
    }

    public String getLibraryName() {
        return this.name.getText();
    }

    public void addNotify() {
        super.addNotify();
        this.name.selectAll();
    }

    private void initModel(String string) {
        this.typeMap = new HashMap();
        this.name.setText(NbBundle.getMessage((Class)NewLibraryPanel.class, (String)"TXT_NewLibrary"));
        LibraryTypeRegistry libraryTypeRegistry = LibraryTypeRegistry.getDefault();
        LibraryTypeProvider[] libraryTypeProviderArray = libraryTypeRegistry.getLibraryTypeProviders();
        int n = 0;
        for (int i = 0; i < libraryTypeProviderArray.length; ++i) {
            String string2 = libraryTypeProviderArray[i].getLibraryType();
            if (string2.equals(string)) {
                n = i;
            }
            this.typeMap.put(new Integer(i), string2);
            String string3 = libraryTypeProviderArray[i].getDisplayName();
            if (string3 == null) {
                string3 = libraryTypeProviderArray[i].getLibraryType();
            }
            this.libraryType.addItem(string3);
        }
        if (this.libraryType.getItemCount() > 0) {
            this.libraryType.setSelectedIndex(n);
        }
    }

    private void nameChanged() {
        String string;
        String string2 = this.name.getText();
        boolean bl = false;
        if (string2.length() == 0) {
            string = NbBundle.getMessage((Class)NewLibraryPanel.class, (String)"ERR_InvalidName");
        } else {
            bl = LibrariesCustomizer.isValidName(this.model, string2);
            if (bl) {
                if (this.isReasonableAntProperty(string2)) {
                    string = " ";
                } else {
                    bl = false;
                    string = NbBundle.getMessage((Class)NewLibraryPanel.class, (String)"ERR_InvalidCharacters");
                }
            } else {
                string = NbBundle.getMessage((Class)NewLibraryPanel.class, (String)"ERR_ExistingName", (Object)string2);
            }
        }
        if (this.dd != null) {
            this.dd.setValid(bl);
        }
        this.status.setText(string);
    }

    private boolean isReasonableAntProperty(String string) {
        return VALID_LIBRARY_NAME.matcher(string).matches();
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.name = new JTextField();
        this.jLabel1 = new JLabel();
        this.libraryType = new JComboBox();
        this.status = new JLabel();
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/project/libraries/ui/Bundle").getString("AD_NewLibraryPanel"));
        this.jLabel2.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/project/libraries/ui/Bundle").getString("MNE_AddLibraryLibraryName").charAt(0));
        this.jLabel2.setLabelFor(this.name);
        this.jLabel2.setText(ResourceBundle.getBundle("org/netbeans/modules/project/libraries/ui/Bundle").getString("CTL_LibraryName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 6, 6);
        this.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 6, 6, 12);
        this.add((Component)this.name, gridBagConstraints);
        this.name.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/project/libraries/ui/Bundle").getString("AD_LibraryName"));
        this.jLabel1.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/project/libraries/ui/Bundle").getString("MNE_AddLibraryLibraryType").charAt(0));
        this.jLabel1.setLabelFor(this.libraryType);
        this.jLabel1.setText(ResourceBundle.getBundle("org/netbeans/modules/project/libraries/ui/Bundle").getString("CTL_LibraryType"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 6, 6);
        this.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 12);
        this.add((Component)this.libraryType, gridBagConstraints);
        this.libraryType.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/project/libraries/ui/Bundle").getString("AD_LibraryType"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 12, 12, 12);
        this.add((Component)this.status, gridBagConstraints);
    }
}

