/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.awt.Image;
import java.io.File;
import java.lang.reflect.Field;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.Action;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.FileInformation;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.settings.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.ui.actions.SystemActionBridge;
import org.netbeans.modules.versioning.system.cvss.ui.actions.commit.CommitAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.DiffAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.ResolveConflictsAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.ignore.IgnoreAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.log.AnnotationsAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.log.SearchHistoryAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.status.StatusAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.BranchAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.MergeBranchAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.SwitchBranchAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.TagAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.GetCleanAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.UpdateAction;
import org.netbeans.modules.versioning.system.cvss.util.FlatFolder;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

public class Annotator {
    private static MessageFormat uptodateFormat = Annotator.getFormat("uptodateFormat");
    private static MessageFormat newLocallyFormat = Annotator.getFormat("newLocallyFormat");
    private static MessageFormat addedLocallyFormat = Annotator.getFormat("addedLocallyFormat");
    private static MessageFormat modifiedLocallyFormat = Annotator.getFormat("modifiedLocallyFormat");
    private static MessageFormat removedLocallyFormat = Annotator.getFormat("removedLocallyFormat");
    private static MessageFormat deletedLocallyFormat = Annotator.getFormat("deletedLocallyFormat");
    private static MessageFormat newInRepositoryFormat = Annotator.getFormat("newInRepositoryFormat");
    private static MessageFormat modifiedInRepositoryFormat = Annotator.getFormat("modifiedInRepositoryFormat");
    private static MessageFormat removedInRepositoryFormat = Annotator.getFormat("removedInRepositoryFormat");
    private static MessageFormat conflictFormat = Annotator.getFormat("conflictFormat");
    private static MessageFormat mergeableFormat = Annotator.getFormat("mergeableFormat");
    private static MessageFormat excludedFormat = Annotator.getFormat("excludedFormat");
    private static final int STATUS_TEXT_ANNOTABLE = 6494;
    private static final Pattern lessThan = Pattern.compile("<");
    private final FileStatusCache cache;
    private MessageFormat format;

    Annotator(CvsVersioningSystem cvsVersioningSystem) {
        this.cache = cvsVersioningSystem.getStatusCache();
        this.initDefaults();
    }

    private void initDefaults() {
        Field[] fieldArray = Annotator.class.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            String string = fieldArray[i].getName();
            if (!string.endsWith("Format")) continue;
            this.initDefaultColor(string.substring(0, string.length() - 6));
        }
        String string = System.getProperty("netbeans.experimental.cvs.ui.statusLabelFormat");
        if (string != null) {
            ErrorManager.getDefault().log(16, "CVS status labels use format \"" + string + "\" where:");
            ErrorManager.getDefault().log(16, "\t{0} stays for revision");
            ErrorManager.getDefault().log(16, "\t{1} stays for status");
            ErrorManager.getDefault().log(16, "\t{2} stays for branch or sticky tag");
            ErrorManager.getDefault().log(16, "\t{3} stays for binary flag");
            this.format = new MessageFormat(string);
        }
    }

    private void initDefaultColor(String string) {
        String string2 = System.getProperty("cvs.color." + string);
        if (string2 == null) {
            return;
        }
        this.setAnnotationColor(string, string2);
    }

    private void setAnnotationColor(String string, String string2) {
        try {
            Field field = Annotator.class.getDeclaredField(string + "Format");
            MessageFormat messageFormat = new MessageFormat("<font color=\"" + string2 + "\">{0}</font><font color=\"#999999\">{1}</font>");
            field.set(null, messageFormat);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid color name");
        }
    }

    public String annotateNameHtml(String string, FileInformation fileInformation, File file) {
        String string2;
        string = this.htmlEncode(string);
        int n = fileInformation.getStatus();
        String string3 = CvsModuleConfig.getDefault().getTextAnnotationsFormat();
        if (string3 != null && file != null && (n & 0x195E) != 0) {
            if (this.format != null) {
                string2 = this.formatAnnotation(fileInformation, file);
            } else {
                String string4 = Utils.getSticky(file);
                string2 = n == 8 && string4 == null ? "" : (n == 8 ? " [" + string4.substring(1) + "]" : (string4 == null ? " [" + fileInformation.getShortStatusText() + "]" : " [" + fileInformation.getShortStatusText() + "; " + string4.substring(1) + "]"));
            }
        } else {
            string2 = "";
        }
        if (string2.length() > 0) {
            string2 = NbBundle.getMessage((Class)Annotator.class, (String)"textAnnotation", (Object)string2);
        }
        switch (n) {
            case 0: 
            case 1: {
                return string;
            }
            case 8: {
                return uptodateFormat.format(new Object[]{string, string2});
            }
            case 16: {
                return modifiedLocallyFormat.format(new Object[]{string, string2});
            }
            case 4: {
                return newLocallyFormat.format(new Object[]{string, string2});
            }
            case 256: {
                return removedLocallyFormat.format(new Object[]{string, string2});
            }
            case 2048: {
                return deletedLocallyFormat.format(new Object[]{string, string2});
            }
            case 512: {
                return newInRepositoryFormat.format(new Object[]{string, string2});
            }
            case 32: {
                return modifiedInRepositoryFormat.format(new Object[]{string, string2});
            }
            case 1024: {
                return removedInRepositoryFormat.format(new Object[]{string, string2});
            }
            case 4096: {
                return addedLocallyFormat.format(new Object[]{string, string2});
            }
            case 128: {
                return mergeableFormat.format(new Object[]{string, string2});
            }
            case 64: {
                return conflictFormat.format(new Object[]{string, string2});
            }
            case 2: {
                return excludedFormat.format(new Object[]{string, string2});
            }
        }
        throw new IllegalArgumentException("Unknown status: " + n);
    }

    private String formatAnnotation(FileInformation fileInformation, File file) {
        String string;
        String string2 = "";
        int n = fileInformation.getStatus();
        if (n != 8) {
            string2 = fileInformation.getShortStatusText();
        }
        String string3 = "";
        String string4 = "";
        Entry entry = fileInformation.getEntry(file);
        if (entry != null) {
            string3 = entry.getRevision();
            string4 = entry.getOptions();
            if (!"-kb".equals(string4)) {
                string4 = "";
            }
        }
        string = (string = Utils.getSticky(file)) != null ? string.substring(1) : "";
        Object[] objectArray = new Object[]{string3, string2, string, string4};
        return this.format.format(objectArray, new StringBuffer(), (FieldPosition)null).toString().trim();
    }

    private String annotateFolderNameHtml(String string, FileInformation fileInformation, File file) {
        String string2;
        string = this.htmlEncode(string);
        int n = fileInformation.getStatus();
        String string3 = CvsModuleConfig.getDefault().getTextAnnotationsFormat();
        if (string3 != null && file != null && (n & 0xFFFFFFFE) != 0) {
            String string4 = Utils.getSticky(file);
            string2 = n == 8 && string4 == null ? "" : (n == 8 ? " [" + string4.substring(1) + "]" : (string4 == null ? " [" + fileInformation.getShortStatusText() + "]" : " [" + fileInformation.getShortStatusText() + "; " + string4.substring(1) + "]"));
        } else {
            string2 = "";
        }
        if (string2.length() > 0) {
            string2 = NbBundle.getMessage((Class)Annotator.class, (String)"textAnnotation", (Object)string2);
        }
        switch (n) {
            case 0: 
            case 1: 
            case 16: 
            case 32: 
            case 64: 
            case 128: 
            case 256: 
            case 512: 
            case 1024: 
            case 2048: {
                return string;
            }
            case 4: 
            case 8: 
            case 4096: {
                return uptodateFormat.format(new Object[]{string, string2});
            }
            case 2: {
                return excludedFormat.format(new Object[]{string, string2});
            }
        }
        throw new IllegalArgumentException("Unknown status: " + n);
    }

    private String htmlEncode(String string) {
        if (string.indexOf(60) == -1) {
            return string;
        }
        return lessThan.matcher(string).replaceAll("&lt;");
    }

    public String annotateNameHtml(File file, FileInformation fileInformation) {
        return this.annotateNameHtml(file.getName(), fileInformation, file);
    }

    String annotateNameHtml(String string, Set set, int n) {
        if (set.size() == 0) {
            return string;
        }
        FileInformation fileInformation = null;
        File file = null;
        boolean bl = false;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            FileObject fileObject = (FileObject)iterator.next();
            File file2 = FileUtil.toFile((FileObject)fileObject);
            FileInformation fileInformation2 = this.cache.getStatus(file2);
            int n2 = fileInformation2.getStatus();
            if ((n2 & n) == 0 || !this.isMoreImportant(fileInformation2, fileInformation)) continue;
            fileInformation = fileInformation2;
            file = file2;
            bl = fileObject.isFolder();
        }
        if (!bl && set.size() > 1) {
            bl = Annotator.looksLikeLogicalFolder(set);
        }
        if (fileInformation == null) {
            return this.htmlEncode(string);
        }
        return bl ? this.annotateFolderNameHtml(string, fileInformation, file) : this.annotateNameHtml(string, fileInformation, file);
    }

    private boolean isMoreImportant(FileInformation fileInformation, FileInformation fileInformation2) {
        if (fileInformation2 == null) {
            return true;
        }
        if (fileInformation == null) {
            return false;
        }
        return Utils.getComparableStatus(fileInformation.getStatus()) < Utils.getComparableStatus(fileInformation2.getStatus());
    }

    String annotateName(String string, Set set) {
        return null;
    }

    Image annotateFolderIcon(Set set, Image image) {
        Object object;
        File file;
        CvsModuleConfig cvsModuleConfig = CvsModuleConfig.getDefault();
        boolean bl = true;
        boolean bl2 = false;
        Map map = this.cache.getAllModifiedFiles();
        HashMap hashMap = new HashMap();
        Object object2 = map.keySet().iterator();
        while (object2.hasNext()) {
            file = (File)object2.next();
            object = (FileInformation)map.get(file);
            if (((FileInformation)object).isDirectory() || (((FileInformation)object).getStatus() & 0x19D4) == 0) continue;
            hashMap.put(file, object);
        }
        object2 = set.iterator();
        while (object2.hasNext()) {
            int n;
            FileInformation fileInformation;
            File file2;
            file = (File)object2.next();
            if (file instanceof FlatFolder) {
                object = hashMap.keySet().iterator();
                while (object.hasNext()) {
                    file2 = (File)object.next();
                    if (!file2.getParentFile().equals(file) || (fileInformation = (FileInformation)hashMap.get(file2)).isDirectory()) continue;
                    n = fileInformation.getStatus();
                    if (n == 64) {
                        Image image2 = Utilities.loadImage((String)"org/netbeans/modules/versioning/system/cvss/resources/icons/conflicts-badge.png", (boolean)true);
                        return Utilities.mergeImages((Image)image, (Image)image2, (int)16, (int)9);
                    }
                    bl2 = true;
                    bl &= cvsModuleConfig.isExcludedFromCommit(file2.getAbsolutePath());
                }
                continue;
            }
            object = hashMap.keySet().iterator();
            while (object.hasNext()) {
                file2 = (File)object.next();
                if (!Utils.isParentOrEqual(file, file2)) continue;
                fileInformation = (FileInformation)hashMap.get(file2);
                n = fileInformation.getStatus();
                if (n == 64) {
                    Image image3 = Utilities.loadImage((String)"org/netbeans/modules/versioning/system/cvss/resources/icons/conflicts-badge.png", (boolean)true);
                    return Utilities.mergeImages((Image)image, (Image)image3, (int)16, (int)9);
                }
                bl2 = true;
                bl &= cvsModuleConfig.isExcludedFromCommit(file2.getAbsolutePath());
            }
        }
        if (bl2 && !bl) {
            object2 = Utilities.loadImage((String)"org/netbeans/modules/versioning/system/cvss/resources/icons/modified-badge.png", (boolean)true);
            return Utilities.mergeImages((Image)image, (Image)object2, (int)16, (int)9);
        }
        return image;
    }

    public static Action[] getActions(Lookup lookup) {
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)Annotator.class);
        Node[] nodeArray = lookup.lookup(new Lookup.Template(Node.class)).allInstances().toArray(new Node[0]);
        File[] fileArray = Utils.getCurrentContext(nodeArray).getRootFiles();
        if (Annotator.onlyFolders(fileArray)) {
            return new Action[]{SystemActionBridge.createAction((Action)SystemAction.get((Class)StatusAction.class), resourceBundle.getString("CTL_PopupMenuItem_Status"), lookup), SystemActionBridge.createAction((Action)SystemAction.get((Class)DiffAction.class), resourceBundle.getString("CTL_PopupMenuItem_Diff"), lookup), SystemActionBridge.createAction((Action)SystemAction.get((Class)UpdateAction.class), resourceBundle.getString("CTL_PopupMenuItem_Update"), lookup), SystemActionBridge.createAction((Action)SystemAction.get((Class)CommitAction.class), resourceBundle.getString("CTL_PopupMenuItem_Commit"), lookup), null, SystemActionBridge.createAction((Action)SystemAction.get((Class)TagAction.class), resourceBundle.getString("CTL_PopupMenuItem_Tag"), lookup), null, SystemActionBridge.createAction((Action)SystemAction.get((Class)BranchAction.class), resourceBundle.getString("CTL_PopupMenuItem_Branch"), lookup), SystemActionBridge.createAction((Action)SystemAction.get((Class)SwitchBranchAction.class), resourceBundle.getString("CTL_PopupMenuItem_SwitchBranch"), lookup), SystemActionBridge.createAction((Action)SystemAction.get((Class)MergeBranchAction.class), resourceBundle.getString("CTL_PopupMenuItem_MergeBranch"), lookup), null, SystemActionBridge.createAction((Action)SystemAction.get((Class)SearchHistoryAction.class), resourceBundle.getString("CTL_PopupMenuItem_SearchHistory"), lookup), null, SystemActionBridge.createAction((Action)SystemAction.get((Class)GetCleanAction.class), resourceBundle.getString("CTL_PopupMenuItem_GetClean"), lookup), SystemActionBridge.createAction((Action)SystemAction.get((Class)ResolveConflictsAction.class), resourceBundle.getString("CTL_PopupMenuItem_ResolveConflicts"), lookup), SystemActionBridge.createAction((Action)SystemAction.get((Class)IgnoreAction.class), ((IgnoreAction)SystemAction.get((Class)IgnoreAction.class)).getActionStatus(nodeArray) == 2 ? resourceBundle.getString("CTL_PopupMenuItem_Unignore") : resourceBundle.getString("CTL_PopupMenuItem_Ignore"), lookup)};
        }
        return new Action[]{SystemActionBridge.createAction((Action)SystemAction.get((Class)StatusAction.class), resourceBundle.getString("CTL_PopupMenuItem_Status"), lookup), SystemActionBridge.createAction((Action)SystemAction.get((Class)DiffAction.class), resourceBundle.getString("CTL_PopupMenuItem_Diff"), lookup), SystemActionBridge.createAction((Action)SystemAction.get((Class)UpdateAction.class), resourceBundle.getString("CTL_PopupMenuItem_Update"), lookup), SystemActionBridge.createAction((Action)SystemAction.get((Class)CommitAction.class), resourceBundle.getString("CTL_PopupMenuItem_Commit"), lookup), null, SystemActionBridge.createAction((Action)SystemAction.get((Class)TagAction.class), resourceBundle.getString("CTL_PopupMenuItem_Tag"), lookup), null, SystemActionBridge.createAction((Action)SystemAction.get((Class)BranchAction.class), resourceBundle.getString("CTL_PopupMenuItem_Branch"), lookup), SystemActionBridge.createAction((Action)SystemAction.get((Class)SwitchBranchAction.class), resourceBundle.getString("CTL_PopupMenuItem_SwitchBranch"), lookup), SystemActionBridge.createAction((Action)SystemAction.get((Class)MergeBranchAction.class), resourceBundle.getString("CTL_PopupMenuItem_MergeBranch"), lookup), null, SystemActionBridge.createAction((Action)SystemAction.get((Class)AnnotationsAction.class), ((AnnotationsAction)SystemAction.get((Class)AnnotationsAction.class)).visible(nodeArray) ? resourceBundle.getString("CTL_PopupMenuItem_HideAnnotations") : resourceBundle.getString("CTL_PopupMenuItem_ShowAnnotations"), lookup), SystemActionBridge.createAction((Action)SystemAction.get((Class)SearchHistoryAction.class), resourceBundle.getString("CTL_PopupMenuItem_SearchHistory"), lookup), null, SystemActionBridge.createAction((Action)SystemAction.get((Class)GetCleanAction.class), resourceBundle.getString("CTL_PopupMenuItem_GetClean"), lookup), SystemActionBridge.createAction((Action)SystemAction.get((Class)ResolveConflictsAction.class), resourceBundle.getString("CTL_PopupMenuItem_ResolveConflicts"), lookup), SystemActionBridge.createAction((Action)SystemAction.get((Class)IgnoreAction.class), ((IgnoreAction)SystemAction.get((Class)IgnoreAction.class)).getActionStatus(nodeArray) == 2 ? resourceBundle.getString("CTL_PopupMenuItem_Unignore") : resourceBundle.getString("CTL_PopupMenuItem_Ignore"), lookup)};
    }

    private static boolean onlyFolders(File[] fileArray) {
        FileStatusCache fileStatusCache = CvsVersioningSystem.getInstance().getStatusCache();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isFile()) {
                return false;
            }
            if (fileArray[i].exists() || fileStatusCache.getStatus(fileArray[i]).isDirectory()) continue;
            return false;
        }
        return true;
    }

    static boolean looksLikeLogicalFolder(Set set) {
        Iterator iterator = set.iterator();
        FileObject fileObject = (FileObject)iterator.next();
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            while (iterator.hasNext()) {
                FileObject fileObject2 = (FileObject)iterator.next();
                if (dataObject.equals(DataObject.find((FileObject)fileObject2))) continue;
                return true;
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            ErrorManager errorManager = ErrorManager.getDefault();
            errorManager.annotate((Throwable)dataObjectNotFoundException, "Can not find dataobject, annottaing as logical folder");
            errorManager.notify((Throwable)dataObjectNotFoundException);
            return true;
        }
        return false;
    }

    private static MessageFormat getFormat(String string) {
        String string2 = NbBundle.getMessage((Class)Annotator.class, (String)string);
        return new MessageFormat(string2);
    }
}

