/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.lib.cvsclient.admin.AdminHandler;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.admin.StandardAdminHandler;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.modules.versioning.system.cvss.CvsMetadata;
import org.netbeans.modules.versioning.system.cvss.settings.MetadataAttic;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.filesystems.FileUtil;

class CvsLiteAdminHandler
implements AdminHandler {
    static final String INVALID_METADATA_MARKER = "invalid-metadata";
    private static final String INVALID_METADATA_MARKER_PATH = "CVS/invalid-metadata";
    private StandardAdminHandler stdHandler = new StandardAdminHandler();

    private void checkForInvalidMetadata(File file) {
        File file2 = new File(file, INVALID_METADATA_MARKER_PATH);
        if (file2.exists()) {
            Utils.deleteRecursively(file2.getParentFile());
        }
    }

    public void updateAdminData(String string, String string2, Entry entry, GlobalOptions globalOptions) throws IOException {
        this.checkForInvalidMetadata(new File(string));
        this.stdHandler.updateAdminData(string, string2, entry, globalOptions);
    }

    public Entry getEntry(File file) throws IOException {
        this.checkForInvalidMetadata(file.getParentFile());
        if (file.exists()) {
            return this.stdHandler.getEntry(file);
        }
        File file2 = file.getParentFile();
        if (file2.exists()) {
            return this.stdHandler.getEntry(file);
        }
        CvsMetadata cvsMetadata = MetadataAttic.getMetadata(file2);
        if (cvsMetadata == null) {
            return this.stdHandler.getEntry(file);
        }
        String[] stringArray = cvsMetadata.getEntries();
        for (int i = 0; i < stringArray.length; ++i) {
            Entry entry = new Entry(stringArray[i]);
            if (entry.getName() == null || !entry.getName().equals(file.getName())) continue;
            return entry;
        }
        return null;
    }

    public boolean exists(File file) {
        if (file.exists()) {
            return true;
        }
        if ("CVS".equals(file.getName())) {
            file = file.getParentFile();
        }
        return MetadataAttic.getMetadata(file) != null;
    }

    public Iterator getEntries(File file) throws IOException {
        this.checkForInvalidMetadata(file);
        if (file.exists()) {
            return this.stdHandler.getEntries(file);
        }
        CvsMetadata cvsMetadata = MetadataAttic.getMetadata(file = FileUtil.normalizeFile((File)file));
        if (cvsMetadata == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return new CvsMetadataIterator(cvsMetadata);
    }

    public Entry[] getEntriesAsArray(File file) throws IOException {
        this.checkForInvalidMetadata(file);
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.getEntries(file);
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList.toArray(new Entry[arrayList.size()]);
    }

    public void setEntry(File file, Entry entry) throws IOException {
        this.checkForInvalidMetadata(file.getParentFile());
        File file2 = new File(file.getParentFile(), "CVS");
        this.createAdminDirs(file2);
        this.stdHandler.setEntry(file, entry);
    }

    private void createAdminDirs(File file) throws IOException {
        if (!file.exists()) {
            CvsMetadata cvsMetadata;
            if (file.getParentFile() != null && file.getParentFile().getParentFile() != null) {
                this.createAdminDirs(new File(file.getParentFile().getParentFile(), "CVS"));
            }
            if ((cvsMetadata = MetadataAttic.getMetadata(file.getParentFile())) != null) {
                cvsMetadata.save(file);
                MetadataAttic.setMetadata(file.getParentFile(), null);
            }
        }
    }

    public String getRepositoryForDirectory(String string, String string2) throws IOException {
        this.checkForInvalidMetadata(new File(string));
        File file = new File(string);
        if (file.exists()) {
            return this.stdHandler.getRepositoryForDirectory(string, string2);
        }
        CvsMetadata cvsMetadata = MetadataAttic.getMetadata(file);
        if (cvsMetadata == null) {
            return this.stdHandler.getRepositoryForDirectory(string, string2);
        }
        String string3 = cvsMetadata.getRepository();
        if (string3 == null) {
            string3 = "";
        }
        if (string3.startsWith("/")) {
            return string3;
        }
        return string2 + '/' + string3;
    }

    public void removeEntry(File file) throws IOException {
        File file2 = file.getParentFile();
        this.checkForInvalidMetadata(file2);
        CvsMetadata cvsMetadata = MetadataAttic.getMetadata(file2);
        if (cvsMetadata != null) {
            String[] stringArray = cvsMetadata.getEntries();
            for (int i = 0; i < stringArray.length; ++i) {
                Entry entry = new Entry(stringArray[i]);
                if (!file.getName().equals(entry.getName())) continue;
                ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
                arrayList.remove(stringArray[i]);
                if (arrayList.size() == 0 || arrayList.size() == 1 && "D".equals(arrayList.get(0))) {
                    MetadataAttic.setMetadata(file2, null);
                } else {
                    CvsMetadata cvsMetadata2 = new CvsMetadata(cvsMetadata.getRepository(), cvsMetadata.getRoot(), arrayList.toArray(new String[arrayList.size()]));
                    MetadataAttic.setMetadata(file2, cvsMetadata2);
                }
                return;
            }
        }
        this.stdHandler.removeEntry(file);
    }

    public Set getAllFiles(File file) throws IOException {
        this.checkForInvalidMetadata(file);
        return this.stdHandler.getAllFiles(file);
    }

    public String getStickyTagForDirectory(File file) {
        this.checkForInvalidMetadata(file);
        return this.stdHandler.getStickyTagForDirectory(file);
    }

    private static class CvsMetadataIterator
    implements Iterator {
        private final Entry[] entries;
        private int index;

        public CvsMetadataIterator(CvsMetadata cvsMetadata) {
            String[] stringArray = cvsMetadata.getEntries();
            ArrayList<Entry> arrayList = new ArrayList<Entry>();
            for (int i = 0; i < stringArray.length; ++i) {
                Entry entry = new Entry(stringArray[i]);
                if (entry.getName() == null) continue;
                arrayList.add(entry);
            }
            this.entries = arrayList.toArray(new Entry[arrayList.size()]);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return this.index < this.entries.length;
        }

        public Object next() {
            return this.entries[this.index++];
        }
    }
}

