/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.netbeans.lib.cvsclient.file.DefaultFileHandler;
import org.netbeans.modules.versioning.system.cvss.FilesystemHandler;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

class CvsLiteFileHandler
extends DefaultFileHandler {
    CvsLiteFileHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean createNewFile(File file) throws IOException {
        boolean bl = file.isFile();
        if (bl) {
            return false;
        }
        File file2 = file.getParentFile();
        FileObject fileObject = Utils.mkfolders(file2);
        try {
            FilesystemHandler.ignoreEvents(true);
            try {
                fileObject.createData(file.getName());
            }
            catch (IOException iOException) {
                boolean bl2 = file.createNewFile();
                FilesystemHandler.ignoreEvents(false);
                return bl2;
            }
        }
        finally {
            FilesystemHandler.ignoreEvents(false);
        }
        return true;
    }

    protected OutputStream createOutputStream(File file) throws IOException {
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null) {
            return new FileOutputStream(file);
        }
        FileLock fileLock = fileObject.lock();
        OutputStream outputStream = fileObject.getOutputStream(fileLock);
        return new LockedOutputStream(fileLock, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocalFile(String string) throws IOException {
        File file = new File(string);
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null) {
            file.delete();
            return;
        }
        try {
            FilesystemHandler.ignoreEvents(true);
            fileObject.delete();
        }
        finally {
            FilesystemHandler.ignoreEvents(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameLocalFile(String string, String string2) throws IOException {
        File file = new File(string);
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null) {
            file.renameTo(new File(file.getParentFile(), string2));
            return;
        }
        FileLock fileLock = null;
        try {
            fileLock = fileObject.lock();
            try {
                FilesystemHandler.ignoreEvents(true);
                fileObject.rename(fileLock, string2, null);
            }
            finally {
                FilesystemHandler.ignoreEvents(false);
            }
        }
        finally {
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
    }

    private static class LockedOutputStream
    extends OutputStream {
        private final OutputStream peer;
        private final FileLock lock;

        public LockedOutputStream(FileLock fileLock, OutputStream outputStream) {
            this.lock = fileLock;
            this.peer = outputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            this.lock.releaseLock();
            try {
                FilesystemHandler.ignoreEvents(true);
                this.peer.close();
            }
            finally {
                FilesystemHandler.ignoreEvents(false);
            }
        }

        public void flush() throws IOException {
            this.peer.flush();
        }

        public void write(byte[] byArray) throws IOException {
            this.peer.write(byArray);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.peer.write(byArray, n, n2);
        }

        public void write(int n) throws IOException {
            this.peer.write(n);
        }
    }
}

