/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import org.netbeans.lib.cvsclient.admin.Entry;

public class CvsMetadata
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String repository;
    private String root;
    private String[] entries;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CvsMetadata readAndRemove(File file) throws IOException {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(file + " is not a directory");
        }
        BufferedReader bufferedReader = null;
        CvsMetadata cvsMetadata = new CvsMetadata();
        try {
            bufferedReader = new BufferedReader(new FileReader(new File(file, "CVS/Repository")));
            cvsMetadata.repository = bufferedReader.readLine();
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        try {
            bufferedReader = new BufferedReader(new FileReader(new File(file, "CVS/Root")));
            cvsMetadata.root = bufferedReader.readLine();
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        try {
            String string;
            bufferedReader = new BufferedReader(new FileReader(new File(file, "CVS/Entries")));
            ArrayList<String> arrayList = new ArrayList<String>();
            while ((string = bufferedReader.readLine()) != null) {
                Entry entry = new Entry(string);
                if (!"D".equals(string) && !entry.isDirectory()) {
                    if (entry.getRevision().charAt(0) != '-') {
                        entry.setRevision("-" + entry.getRevision());
                    }
                    entry.setConflict("dummy timestamp");
                    string = entry.toString();
                }
                arrayList.add(string);
            }
            cvsMetadata.entries = arrayList.toArray(new String[arrayList.size()]);
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        return cvsMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file) throws IOException {
        file.mkdirs();
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter(new File(file, "Repository")));
            printWriter.println(this.repository);
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
        try {
            printWriter = new PrintWriter(new FileWriter(new File(file, "Root")));
            printWriter.println(this.root);
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
        try {
            printWriter = new PrintWriter(new FileWriter(new File(file, "Entries")));
            for (int i = 0; i < this.entries.length; ++i) {
                printWriter.println(this.entries[i]);
            }
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    public CvsMetadata(String string, String string2, String[] stringArray) {
        this.repository = string;
        this.root = string2;
        this.entries = (String[])stringArray.clone();
    }

    public CvsMetadata() {
    }

    public String getRepository() {
        return this.repository;
    }

    public String getRoot() {
        return this.root;
    }

    public String[] getEntries() {
        return this.entries;
    }

    public Entry[] getEntryObjects() {
        Entry[] entryArray = new Entry[this.entries.length];
        for (int i = 0; i < this.entries.length; ++i) {
            entryArray[i] = new Entry(this.entries[i]);
        }
        return entryArray;
    }
}

