/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.SwingUtilities;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.lib.cvsclient.admin.AdminHandler;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.KeywordSubstitutionOptions;
import org.netbeans.lib.cvsclient.command.add.AddCommand;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.file.FileHandler;
import org.netbeans.modules.versioning.system.cvss.Annotator;
import org.netbeans.modules.versioning.system.cvss.ClientRuntime;
import org.netbeans.modules.versioning.system.cvss.CvsFileTableModel;
import org.netbeans.modules.versioning.system.cvss.CvsLiteAdminHandler;
import org.netbeans.modules.versioning.system.cvss.CvsLiteFileHandler;
import org.netbeans.modules.versioning.system.cvss.CvsLiteGzippedFileHandler;
import org.netbeans.modules.versioning.system.cvss.ExecutorSupport;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.FileStatusProvider;
import org.netbeans.modules.versioning.system.cvss.FilesystemHandler;
import org.netbeans.modules.versioning.system.cvss.IllegalCommandException;
import org.netbeans.modules.versioning.system.cvss.NotVersionedException;
import org.netbeans.modules.versioning.system.cvss.settings.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.settings.MetadataAttic;
import org.netbeans.modules.versioning.system.cvss.ui.syncview.CvsSynchronizeTopComponent;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.netbeans.modules.versioning.util.ListenersSupport;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.RequestProcessor;

public class CvsVersioningSystem {
    private static CvsVersioningSystem instance;
    public static final String FILENAME_CVSIGNORE = ".cvsignore";
    public static final String FILENAME_CVS = "CVS";
    public static final Object EVENT_PARAM_CHANGED;
    public static final Object PARAM_BATCH_REFRESH_RUNNING;
    private static final String FILENAME_CVS_REPOSITORY = "CVS/Repository";
    private static final Set textExtensions;
    private final Map clientsCache = new HashMap();
    private final Map params = new HashMap();
    private GlobalOptions defaultGlobalOptions;
    private FileStatusCache fileStatusCache;
    private CvsLiteAdminHandler sah;
    private CvsLiteFileHandler workdirFileHandler;
    private CvsLiteGzippedFileHandler workdirGzippedFileHandler;
    private FilesystemHandler filesystemHandler;
    private Annotator annotator;
    private final Set userIgnorePatterns = new HashSet();
    private boolean userIgnorePatternsReset;
    private long userIgnorePatternsTimestamp;
    ListenersSupport listenerSupport = new ListenersSupport((Object)this);

    public static synchronized CvsVersioningSystem getInstance() {
        if (instance == null) {
            instance = new CvsVersioningSystem();
            instance.init();
        }
        return instance;
    }

    private void init() {
        this.defaultGlobalOptions = CvsVersioningSystem.createGlobalOptions();
        this.sah = new CvsLiteAdminHandler();
        this.workdirFileHandler = new CvsLiteFileHandler();
        this.workdirGzippedFileHandler = new CvsLiteGzippedFileHandler();
        this.fileStatusCache = new FileStatusCache(this);
        this.filesystemHandler = new FilesystemHandler(this);
        this.annotator = new Annotator(this);
        this.cleanup();
    }

    private void cleanup() {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                if (FileStatusProvider.getInstance() != null) {
                    CvsVersioningSystem.this.fileStatusCache.addVersioningListener(FileStatusProvider.getInstance());
                    FileStatusProvider.getInstance().init();
                }
                MetadataAttic.cleanUp();
                CvsVersioningSystem.this.fileStatusCache.cleanUp();
                CvsVersioningSystem.this.filesystemHandler.init();
            }
        }, 3000);
    }

    private CvsVersioningSystem() {
    }

    public CvsFileTableModel getFileTableModel(Context context, int n) {
        return new CvsFileTableModel(context, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientRuntime getClientRuntime(String string) {
        ClientRuntime clientRuntime;
        string.length();
        Map map = this.clientsCache;
        synchronized (map) {
            clientRuntime = (ClientRuntime)this.clientsCache.get(string);
            if (clientRuntime == null) {
                clientRuntime = new ClientRuntime(string);
                this.clientsCache.put(string, clientRuntime);
            }
        }
        return clientRuntime;
    }

    String detectCvsRoot(Command command) throws NotVersionedException {
        File[] fileArray;
        Object object;
        if (command instanceof AddCommand) {
            object = (AddCommand)command;
            fileArray = object.getFiles();
        } else if (command instanceof BasicCommand) {
            object = (BasicCommand)command;
            fileArray = object.getFiles();
        } else {
            throw new NotVersionedException("Cannot determine CVSRoot for command: " + command);
        }
        object = fileArray[0];
        try {
            String string = Utils.getCVSRootFor((File)object);
            return string;
        }
        catch (IOException iOException) {
            throw new NotVersionedException("Cannot determine CVSRoot for: " + object);
        }
    }

    public RequestProcessor.Task post(Command command, ExecutorSupport executorSupport) throws CommandException, AuthenticationException, NotVersionedException, IllegalCommandException, IOException {
        return this.post(command, this.defaultGlobalOptions, executorSupport);
    }

    public RequestProcessor.Task post(Command command, GlobalOptions globalOptions, ExecutorSupport executorSupport) throws IllegalCommandException {
        ClientRuntime clientRuntime = this.getClientRuntime(command, globalOptions);
        RequestProcessor.Task task = clientRuntime.createTask(command, globalOptions != null ? globalOptions : this.defaultGlobalOptions, executorSupport);
        task.schedule(0);
        return task;
    }

    public ClientRuntime getClientRuntime(Command command, GlobalOptions globalOptions) {
        String string;
        if (globalOptions != null && globalOptions.getCVSRoot() != null) {
            string = globalOptions.getCVSRoot();
        } else {
            try {
                string = this.detectCvsRoot(command);
            }
            catch (NotVersionedException notVersionedException) {
                if (globalOptions == null) {
                    return null;
                }
                string = globalOptions.getCVSRoot();
            }
        }
        return this.getClientRuntime(string);
    }

    public FileStatusCache getStatusCache() {
        return this.fileStatusCache;
    }

    public void addVersioningListener(VersioningListener versioningListener) {
        this.listenerSupport.addListener(versioningListener);
    }

    public void removeVersioningListener(VersioningListener versioningListener) {
        this.listenerSupport.removeListener(versioningListener);
    }

    boolean isIgnored(File file) {
        Object object;
        if (file.isDirectory() && ((File)(object = new File(file, FILENAME_CVS_REPOSITORY))).canRead()) {
            return false;
        }
        object = file.getName();
        if (FILENAME_CVSIGNORE.equals(object)) {
            return false;
        }
        if (".nbintdb".equals(object)) {
            return true;
        }
        HashSet<Pattern> hashSet = new HashSet<Pattern>(Arrays.asList(CvsModuleConfig.getDefault().getIgnoredFilePatterns()));
        this.addUserPatterns(hashSet);
        this.addCvsIgnorePatterns(hashSet, file.getParentFile());
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Pattern pattern = (Pattern)iterator.next();
            if (!pattern.matcher((CharSequence)object).matches()) continue;
            return true;
        }
        int n = SharabilityQuery.getSharability((File)file);
        if (n == 2) {
            try {
                this.setIgnored(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    private void addUserPatterns(Set set) {
        File file = new File(System.getProperty("user.home"), FILENAME_CVSIGNORE);
        long l = file.lastModified();
        if (l > this.userIgnorePatternsTimestamp || l == 0L && this.userIgnorePatternsTimestamp > 0L) {
            this.userIgnorePatternsTimestamp = l;
            this.parseUserPatterns(file);
        }
        if (this.userIgnorePatternsReset) {
            set.clear();
        }
        set.addAll(this.userIgnorePatterns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseUserPatterns(File file) {
        String string;
        this.userIgnorePatternsReset = false;
        this.userIgnorePatterns.clear();
        BufferedReader bufferedReader = null;
        bufferedReader = new BufferedReader(new FileReader(file));
        while ((string = bufferedReader.readLine()) != null) {
            if ("!".equals(string)) {
                this.userIgnorePatternsReset = true;
                this.userIgnorePatterns.clear();
                continue;
            }
            try {
                this.userIgnorePatterns.add(CvsVersioningSystem.sh2regex(string));
            }
            catch (IOException iOException) {}
        }
        Object var6_6 = null;
        if (bufferedReader == null) return;
        try {
            bufferedReader.close();
            return;
        }
        catch (IOException iOException) {}
        return;
        {
            catch (IOException iOException) {
                Object var6_7 = null;
                if (bufferedReader == null) return;
                try {
                    bufferedReader.close();
                    return;
                }
                catch (IOException iOException2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private static Pattern sh2regex(String string) throws IOException {
        string = string.replaceAll("\\.", "\\\\.");
        string = string.replaceAll("\\*", ".*");
        try {
            return Pattern.compile(string);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new IOException(patternSyntaxException.getMessage());
        }
    }

    boolean isManaged(File file) {
        if (file.isDirectory() && file.getName().equals(FILENAME_CVS)) {
            return false;
        }
        if (file.isFile()) {
            file = file.getParentFile();
        }
        while (file != null) {
            File file2 = new File(file, FILENAME_CVS_REPOSITORY);
            if (file2.canRead()) {
                return true;
            }
            file = file.getParentFile();
        }
        return false;
    }

    private void addCvsIgnorePatterns(Set set, File file) {
        Set set2;
        try {
            set2 = this.readCvsIgnoreEntries(file);
        }
        catch (IOException iOException) {
            return;
        }
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if ("!".equals(string)) {
                set.clear();
                continue;
            }
            try {
                set.add(CvsVersioningSystem.sh2regex(string));
            }
            catch (IOException iOException) {}
        }
    }

    public boolean isInCvsIgnore(File file) {
        try {
            return this.readCvsIgnoreEntries(file.getParentFile()).contains(file.getName());
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return false;
        }
    }

    public boolean isIgnoredFilename(File file) {
        return FILENAME_CVS.equals(file.getName());
    }

    public AdminHandler getAdminHandler() {
        return this.sah;
    }

    public FileHandler getFileHandler() {
        return this.workdirFileHandler;
    }

    public FileHandler getGzippedFileHandler() {
        return this.workdirGzippedFileHandler;
    }

    public Annotator getAnnotator() {
        return this.annotator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getParameter(Object object) {
        Map map = this.params;
        synchronized (map) {
            return this.params.get(object);
        }
    }

    public KeywordSubstitutionOptions getDefaultKeywordSubstitution(File file) {
        return this.isText(file) || !this.isBinary(file) ? KeywordSubstitutionOptions.DEFAULT : KeywordSubstitutionOptions.BINARY;
    }

    public boolean isText(File file) {
        Entry entry;
        if (FILENAME_CVSIGNORE.equals(file.getName())) {
            return true;
        }
        try {
            entry = this.sah.getEntry(file);
            if (entry != null) {
                return !entry.isBinary();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        entry = FileUtil.toFileObject((File)file);
        if (entry == null) {
            return false;
        }
        try {
            DataObject dataObject = DataObject.find((FileObject)entry);
            return dataObject.getCookie(EditorCookie.class) != null;
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            if (entry.getMIMEType().startsWith("text")) {
                return true;
            }
            return textExtensions.contains(entry.getExt());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isBinary(File var1_1) {
        block12: {
            block11: {
                var2_2 = null;
                try {
                    try {
                        var2_2 = new FileInputStream(var1_1);
                        var2_2 = new BufferedInputStream(var2_2);
                        for (var3_3 = 0; var3_3 < 1024 && (var4_5 = var2_2.read()) != -1; ++var3_3) {
                            if (var4_5 >= 32 || var4_5 == 9 || var4_5 == 10 || var4_5 == 13) continue;
                            var5_7 = true;
                            var7_8 = null;
                            if (var2_2 == null) return var5_7;
                            break block11;
                        }
                        break block12;
                    }
                    catch (IOException var3_4) {
                        var4_6 = ErrorManager.getDefault();
                        var4_6.notify(1, (Throwable)var3_4);
                        var7_10 = null;
                        if (var2_2 == null) return false;
                        try {
                            var2_2.close();
                            return false;
                        }
                        catch (IOException var8_14) {
                            return false;
                        }
                    }
                }
                catch (Throwable var6_16) {
                    var7_11 = null;
                    if (var2_2 == null) throw var6_16;
                    ** try [egrp 2[TRYBLOCK] [6 : 126->133)] { 
lbl30:
                    // 1 sources

                    var2_2.close();
                    throw var6_16;
lbl32:
                    // 1 sources

                    catch (IOException var8_15) {
                        // empty catch block
                    }
                    throw var6_16;
                }
            }
            ** try [egrp 2[TRYBLOCK] [6 : 126->133)] { 
lbl37:
            // 1 sources

            var2_2.close();
            return var5_7;
lbl39:
            // 1 sources

            catch (IOException var8_12) {
                // empty catch block
            }
            return var5_7;
        }
        var7_9 = null;
        if (var2_2 == null) return false;
        try {}
        catch (IOException var8_13) {}
        var2_2.close();
        return false;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameter(Object object, Object object2) {
        Object object3;
        Map map = this.params;
        synchronized (map) {
            object3 = this.params.put(object, object2);
        }
        if (object3 != object2) {
            this.listenerSupport.fireVersioningEvent(EVENT_PARAM_CHANGED, object);
        }
    }

    public void setIgnored(File[] fileArray) {
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                this.setIgnored(fileArray[i]);
                continue;
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
    }

    private void setIgnored(File file) throws IOException {
        if (file.exists()) {
            this.addToCvsIgnore(file);
        }
    }

    public void setNotignored(File[] fileArray) {
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                this.removeFromCvsIgnore(fileArray[i]);
                continue;
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
    }

    private void addToCvsIgnore(File file) throws IOException {
        Set set = this.readCvsIgnoreEntries(file.getParentFile());
        if (set.add(file.getName())) {
            this.writeCvsIgnoreEntries(file.getParentFile(), set);
        }
    }

    private void removeFromCvsIgnore(File file) throws IOException {
        Set set = this.readCvsIgnoreEntries(file.getParentFile());
        if (set.remove(file.getName())) {
            this.writeCvsIgnoreEntries(file.getParentFile(), set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Set readCvsIgnoreEntries(File file) throws IOException {
        File file2 = new File(file, FILENAME_CVSIGNORE);
        HashSet<String> hashSet = new HashSet<String>(5);
        if (!file2.canRead()) {
            return hashSet;
        }
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new FileReader(file2));
            while ((string = bufferedReader.readLine()) != null) {
                hashSet.add(string.trim());
            }
            Object var7_6 = null;
            if (bufferedReader == null) return hashSet;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            bufferedReader.close();
            return hashSet;
        }
        catch (IOException iOException) {}
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCvsIgnoreEntries(File file, Set set) throws IOException {
        File file2 = new File(file, FILENAME_CVSIGNORE);
        FileObject fileObject = FileUtil.toFileObject((File)file2);
        if (set.size() == 0) {
            if (fileObject != null) {
                fileObject.delete();
            }
            return;
        }
        if (fileObject == null || !fileObject.isValid()) {
            fileObject = FileUtil.toFileObject((File)file);
            fileObject = fileObject.createData(FILENAME_CVSIGNORE);
        }
        FileLock fileLock = fileObject.lock();
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(fileObject.getOutputStream(fileLock));
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                printWriter.println(iterator.next());
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            fileLock.releaseLock();
            if (printWriter != null) {
                printWriter.close();
            }
            throw throwable;
        }
        fileLock.releaseLock();
        if (printWriter != null) {
            printWriter.close();
        }
    }

    FilesystemHandler getFileSystemHandler() {
        return this.filesystemHandler;
    }

    public static void ignoreFilesystemEvents(boolean bl) {
        FilesystemHandler.ignoreEvents(bl);
    }

    public static boolean ignoringFilesystemEvents() {
        return FilesystemHandler.ignoringEvents();
    }

    void shutdown() {
        this.filesystemHandler.shutdown();
        FileStatusProvider.getInstance().shutdown();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    CvsSynchronizeTopComponent.getInstance().close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    public static GlobalOptions createGlobalOptions() {
        GlobalOptions globalOptions = new GlobalOptions();
        if (System.getProperty("cvsClientLog") == null) {
            int n = 4;
            String string = System.getProperty("netbeans.experimental.cvs.io.compressionLevel");
            if (string != null) {
                try {
                    int n2 = Integer.parseInt(string);
                    if (0 <= n2 && n2 < 10) {
                        n = n2;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (n > 0) {
                globalOptions.setCompressionLevel(n);
            }
        }
        return globalOptions;
    }

    static {
        EVENT_PARAM_CHANGED = new Object();
        PARAM_BATCH_REFRESH_RUNNING = new Object();
        textExtensions = new HashSet<String>(Arrays.asList("txt", "xml", "html", "properties", "mf", "jhm", "hs", "form"));
    }
}

