/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.versioning.system.cvss.ClientRuntime;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroupBar;
import org.netbeans.modules.versioning.system.cvss.ExecutorSupport;
import org.openide.ErrorManager;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;

public final class ExecutorGroup
extends AbstractAction
implements Cancellable {
    private final String name;
    private final boolean abortOnExecutorFailure;
    public boolean executed;
    private boolean cancelled;
    private List listeners = new ArrayList(2);
    private List executors = new ArrayList(2);
    private List cleanups = new ArrayList(2);
    private Map queues = new HashMap();
    private Set started = new HashSet();
    private ProgressHandle progressHandle;
    private long dataCounter;
    private boolean hasBarrier;
    private boolean failed;
    private boolean executingCleanup;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ExecutorGroup(String string) {
        this(string, true);
    }

    public ExecutorGroup(String string, boolean bl) {
        this.name = string;
        this.abortOnExecutorFailure = bl;
    }

    public String getDisplayName() {
        return this.name;
    }

    public synchronized void progress(String string) {
        if (this.progressHandle == null) {
            this.progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage((Class)ExecutorGroup.class, (String)"BK2001", (Object)this.name), (Cancellable)this, (Action)this);
            this.progressHandle.start();
        }
        if (string != null) {
            this.progressHandle.progress(string);
        }
    }

    synchronized void enqueued(ClientRuntime clientRuntime, Object object) {
        this.progress(null);
        if (this.started.size() == 0) {
            this.progressHandle.setDisplayName(NbBundle.getMessage((Class)ExecutorGroup.class, (String)"BK2005", (Object)this.name));
            this.progressHandle.progress(NbBundle.getMessage((Class)ExecutorGroup.class, (String)"BK1007"));
            this.progressHandle.switchToDeterminate(100);
            this.progressHandle.progress(1);
        }
        Set<ClientRuntime> set = clientRuntime == null ? this.queues.keySet() : Collections.singleton(clientRuntime);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            HashSet<Object> hashSet = (HashSet<Object>)this.queues.get(e);
            if (hashSet == null) {
                hashSet = new HashSet<Object>();
            }
            hashSet.add(object);
            this.queues.put(e, hashSet);
        }
    }

    synchronized void started(ClientRuntime clientRuntime) {
        this.progressHandle.switchToIndeterminate();
        this.progressHandle.setDisplayName(NbBundle.getMessage((Class)ExecutorGroup.class, (String)"BK2001", (Object)this.name));
        if (this.started.add(clientRuntime)) {
            String string = NbBundle.getMessage((Class)ExecutorGroup.class, (String)"BK1001", (Object)new Date(), (Object)this.getDisplayName());
            String string2 = NbBundle.getMessage((Class)ExecutorGroup.class, (String)"BK1000");
            String string3 = "\n" + string2 + "\n" + string + "\n";
            clientRuntime.log(string3);
        }
    }

    synchronized void finished(ClientRuntime clientRuntime, Object object) {
        Set<ClientRuntime> set = clientRuntime == null ? new HashSet(this.queues.keySet()) : Collections.singleton(clientRuntime);
        boolean bl = this.executed;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Set set2 = (Set)this.queues.get(e);
            set2.remove(object);
            if (set2.isEmpty()) {
                this.queues.remove(e);
                if (this.executed && this.queues.isEmpty() && this.progressHandle != null) {
                    this.progressHandle.finish();
                    this.progressHandle = null;
                }
            }
            bl &= set2.isEmpty();
        }
        if (bl) {
            this.logFinished(clientRuntime);
        }
    }

    private void logFinished(ClientRuntime clientRuntime) {
        Set<ClientRuntime> set = clientRuntime == null ? this.started : Collections.singleton(clientRuntime);
        String string = this.isCancelled() ? NbBundle.getMessage((Class)ExecutorGroup.class, (String)"BK1006", (Object)new Date(), (Object)this.getDisplayName()) : NbBundle.getMessage((Class)ExecutorGroup.class, (String)"BK1002", (Object)new Date(), (Object)this.getDisplayName());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ClientRuntime clientRuntime2 = (ClientRuntime)iterator.next();
            clientRuntime2.log(string + "\n");
            clientRuntime2.flushLog();
        }
    }

    boolean isCancelled() {
        return this.cancelled;
    }

    public boolean cancel() {
        this.cancelled = true;
        this.fail();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fail() {
        Iterator iterator;
        if (!this.abortOnExecutorFailure) {
            return;
        }
        this.failed = true;
        Object object = this.listeners;
        synchronized (object) {
            iterator = new ArrayList(this.listeners).iterator();
        }
        while (iterator.hasNext()) {
            try {
                object = (Cancellable)iterator.next();
                object.cancel();
            }
            catch (RuntimeException runtimeException) {
                ErrorManager.getDefault().notify(1, (Throwable)runtimeException);
            }
        }
        object = this;
        synchronized (object) {
            if (this.progressHandle != null) {
                this.progressHandle.finish();
                this.progressHandle = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCancellable(Cancellable cancellable) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(cancellable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCancellable(Cancellable cancellable) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(cancellable);
        }
    }

    public synchronized void addExecutor(ExecutorSupport executorSupport) {
        if (!$assertionsDisabled && this.executed) {
            throw new AssertionError();
        }
        executorSupport.joinGroup(this);
        this.executors.add(executorSupport);
    }

    public final synchronized void addExecutors(ExecutorSupport[] executorSupportArray) {
        if (executorSupportArray == null) {
            return;
        }
        for (int i = 0; i < executorSupportArray.length; ++i) {
            ExecutorSupport executorSupport = executorSupportArray[i];
            this.addExecutor(executorSupport);
        }
    }

    public synchronized void addBarrier(Runnable runnable) {
        if (!$assertionsDisabled && this.executed) {
            throw new AssertionError();
        }
        ExecutorGroupBar executorGroupBar = new ExecutorGroupBar(this.executors, runnable);
        executorGroupBar.joinGroup(this);
        this.executors.add(executorGroupBar);
        this.hasBarrier = true;
    }

    public synchronized void addCleanups(ExecutorSupport[] executorSupportArray) {
        if (executorSupportArray == null) {
            return;
        }
        for (int i = 0; i < executorSupportArray.length; ++i) {
            ExecutorSupport executorSupport = executorSupportArray[i];
            this.addCleanup(executorSupport);
        }
    }

    public synchronized void addCleanup(ExecutorSupport executorSupport) {
        if (!$assertionsDisabled && this.executingCleanup) {
            throw new AssertionError();
        }
        executorSupport.joinGroup(this);
        this.cleanups.add(executorSupport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        Object object;
        if (!$assertionsDisabled && SwingUtilities.isEventDispatchThread() && this.hasBarrier) {
            throw new AssertionError();
        }
        Iterator iterator = this;
        synchronized (iterator) {
            this.executed = true;
        }
        iterator = this.executors.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            object = (Groupable)iterator.next();
            try {
                object.execute();
            }
            catch (Error error) {
                ErrorManager.getDefault().notify((Throwable)error);
                this.fail();
            }
            catch (RuntimeException runtimeException) {
                ErrorManager.getDefault().notify((Throwable)runtimeException);
                this.fail();
            }
            ++n;
            if (!this.failed) continue;
        }
        object = this;
        synchronized (object) {
            this.executingCleanup = true;
        }
        iterator = this.cleanups.iterator();
        while (iterator.hasNext()) {
            object = (Groupable)iterator.next();
            object.execute();
            ++n;
        }
        object = this;
        synchronized (object) {
            if (n == 0 && this.progressHandle != null) {
                this.progressHandle.finish();
                this.progressHandle = null;
            }
        }
    }

    public synchronized void executed() {
        if (!this.executed) {
            if (this.progressHandle != null) {
                this.progressHandle.finish();
                this.progressHandle = null;
            }
            this.logFinished(null);
        }
    }

    synchronized void increaseDataCounter(long l) {
        this.dataCounter += l;
        if (this.progressHandle != null) {
            this.progressHandle.progress(NbBundle.getMessage((Class)ExecutorGroup.class, (String)"BK2002", (Object)this.name, (Object)ExecutorGroup.format(this.dataCounter)));
        }
    }

    private static String format(long l) {
        if (l < 16384L) {
            return NbBundle.getMessage((Class)ExecutorGroup.class, (String)"BK2003", (Object)new Long(l));
        }
        return NbBundle.getMessage((Class)ExecutorGroup.class, (String)"BK2004", (Object)new Long(l /= 1024L));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Set set;
        if (this.queues != null && !(set = this.queues.keySet()).isEmpty()) {
            ClientRuntime clientRuntime = (ClientRuntime)set.iterator().next();
            clientRuntime.focusLog();
        }
    }

    static {
        $assertionsDisabled = !ExecutorGroup.class.desiredAssertionStatus();
    }

    public static interface Groupable {
        public void joinGroup(ExecutorGroup var1);

        public void execute();
    }
}

