/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ResourceBundle;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.openide.util.NbBundle;

public class FileInformation
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int STATUS_UNKNOWN = 0;
    public static final int STATUS_NOTVERSIONED_NOTMANAGED = 1;
    public static final int STATUS_NOTVERSIONED_EXCLUDED = 2;
    public static final int STATUS_NOTVERSIONED_NEWLOCALLY = 4;
    public static final int STATUS_VERSIONED_UPTODATE = 8;
    public static final int STATUS_VERSIONED_MODIFIEDLOCALLY = 16;
    public static final int STATUS_VERSIONED_MODIFIEDINREPOSITORY = 32;
    public static final int STATUS_VERSIONED_CONFLICT = 64;
    public static final int STATUS_VERSIONED_MERGE = 128;
    public static final int STATUS_VERSIONED_REMOVEDLOCALLY = 256;
    public static final int STATUS_VERSIONED_NEWINREPOSITORY = 512;
    public static final int STATUS_VERSIONED_REMOVEDINREPOSITORY = 1024;
    public static final int STATUS_VERSIONED_DELETEDLOCALLY = 2048;
    public static final int STATUS_VERSIONED_ADDEDLOCALLY = 4096;
    public static final int STATUS_ALL = -1;
    public static final int STATUS_MANAGED = -2;
    public static final int STATUS_IN_REPOSITORY = 4088;
    public static final int STATUS_LOCAL_CHANGE = 6612;
    public static final int STATUS_REMOTE_CHANGE = 1696;
    private final int status;
    private final boolean isDirectory;
    private transient Entry cvsEntry;
    private static final String STATUS_UNKNOWN_EXT = "W";
    private static final String STATUS_NOTVERSIONED_NOTMANAGED_EXT = "Z";
    private static final String STATUS_NOTVERSIONED_EXCLUDED_EXT = "I";
    private static final String STATUS_NOTVERSIONED_NEWLOCALLY_EXT = "?";
    private static final String STATUS_VERSIONED_UPTODATE_EXT = "S";
    private static final String STATUS_VERSIONED_MODIFIEDLOCALLY_EXT = "M";
    private static final String STATUS_VERSIONED_MODIFIEDINREPOSITORY_EXT = "G";
    private static final String STATUS_VERSIONED_CONFLICT_EXT = "C";
    private static final String STATUS_VERSIONED_MERGE_EXT = "P";
    private static final String STATUS_VERSIONED_REMOVEDLOCALLY_EXT = "R";
    private static final String STATUS_VERSIONED_NEWINREPOSITORY_EXT = "N";
    private static final String STATUS_VERSIONED_REMOVEDINREPOSITORY_EXT = "D";
    private static final String STATUS_VERSIONED_DELETEDLOCALLY_EXT = "E";
    private static final String STATUS_VERSIONED_ADDEDLOCALLY_EXT = "A";

    public FileInformation() {
        this.status = 0;
        this.isDirectory = false;
    }

    FileInformation(int n, Entry entry, boolean bl) {
        this.status = n;
        this.cvsEntry = entry;
        this.isDirectory = bl;
    }

    FileInformation(int n, boolean bl) {
        this(n, null, bl);
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public String toExternalForm() {
        String string = this.isDirectory ? "d" : "";
        switch (this.status) {
            case 0: {
                return STATUS_UNKNOWN_EXT + string;
            }
            case 1: {
                return STATUS_NOTVERSIONED_NOTMANAGED_EXT + string;
            }
            case 2: {
                return STATUS_NOTVERSIONED_EXCLUDED_EXT + string;
            }
            case 4: {
                return STATUS_NOTVERSIONED_NEWLOCALLY_EXT + string;
            }
            case 8: {
                return STATUS_VERSIONED_UPTODATE_EXT + string;
            }
            case 16: {
                return STATUS_VERSIONED_MODIFIEDLOCALLY_EXT + string;
            }
            case 32: {
                return STATUS_VERSIONED_MODIFIEDINREPOSITORY_EXT + string;
            }
            case 64: {
                return STATUS_VERSIONED_CONFLICT_EXT + string;
            }
            case 128: {
                return STATUS_VERSIONED_MERGE_EXT + string;
            }
            case 256: {
                return STATUS_VERSIONED_REMOVEDLOCALLY_EXT + string;
            }
            case 512: {
                return STATUS_VERSIONED_NEWINREPOSITORY_EXT + string;
            }
            case 1024: {
                return STATUS_VERSIONED_REMOVEDINREPOSITORY_EXT + string;
            }
            case 2048: {
                return STATUS_VERSIONED_DELETEDLOCALLY_EXT + string;
            }
            case 4096: {
                return STATUS_VERSIONED_ADDEDLOCALLY_EXT + string;
            }
        }
        throw new IllegalStateException("Status " + this.status);
    }

    public static FileInformation fromExternalForm(String string) {
        boolean bl;
        boolean bl2 = bl = string.length() == 2;
        if (bl) {
            string = string.substring(0, 1);
        }
        if (STATUS_UNKNOWN_EXT.equals(string)) {
            return new FileInformation(0, bl);
        }
        if (STATUS_NOTVERSIONED_NOTMANAGED_EXT.equals(string)) {
            return new FileInformation(1, bl);
        }
        if (STATUS_NOTVERSIONED_EXCLUDED_EXT.equals(string)) {
            return new FileInformation(2, bl);
        }
        if (STATUS_NOTVERSIONED_NEWLOCALLY_EXT.equals(string)) {
            return new FileInformation(4, bl);
        }
        if (STATUS_VERSIONED_UPTODATE_EXT.equals(string)) {
            return new FileInformation(8, bl);
        }
        if (STATUS_VERSIONED_MODIFIEDLOCALLY_EXT.equals(string)) {
            return new FileInformation(16, bl);
        }
        if (STATUS_VERSIONED_MODIFIEDINREPOSITORY_EXT.equals(string)) {
            return new FileInformation(32, bl);
        }
        if (STATUS_VERSIONED_CONFLICT_EXT.equals(string)) {
            return new FileInformation(64, bl);
        }
        if (STATUS_VERSIONED_MERGE_EXT.equals(string)) {
            return new FileInformation(128, bl);
        }
        if (STATUS_VERSIONED_REMOVEDLOCALLY_EXT.equals(string)) {
            return new FileInformation(256, bl);
        }
        if (STATUS_VERSIONED_NEWINREPOSITORY_EXT.equals(string)) {
            return new FileInformation(512, bl);
        }
        if (STATUS_VERSIONED_REMOVEDINREPOSITORY_EXT.equals(string)) {
            return new FileInformation(1024, bl);
        }
        if (STATUS_VERSIONED_DELETEDLOCALLY_EXT.equals(string)) {
            return new FileInformation(2048, bl);
        }
        if (STATUS_VERSIONED_ADDEDLOCALLY_EXT.equals(string)) {
            return new FileInformation(4096, bl);
        }
        throw new IllegalStateException("External form " + string);
    }

    public Entry getEntry(File file) {
        if (this.cvsEntry == null && file != null) {
            this.readEntry(file);
        }
        return this.cvsEntry;
    }

    private void readEntry(File file) {
        try {
            this.cvsEntry = CvsVersioningSystem.getInstance().getAdminHandler().getEntry(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getStatusText() {
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)FileInformation.class);
        if (this.status == 0) {
            return resourceBundle.getString("CTL_FileInfoStatus_Unknown");
        }
        if (this.status == 2) {
            return resourceBundle.getString("CTL_FileInfoStatus_Excluded");
        }
        if (this.status == 4) {
            return resourceBundle.getString("CTL_FileInfoStatus_NewLocally");
        }
        if (this.status == 4096) {
            return resourceBundle.getString("CTL_FileInfoStatus_AddedLocally");
        }
        if (this.status == 8) {
            return resourceBundle.getString("CTL_FileInfoStatus_UpToDate");
        }
        if (this.status == 512) {
            return resourceBundle.getString("CTL_FileInfoStatus_NewInRepository");
        }
        if (this.status == 256) {
            return resourceBundle.getString("CTL_FileInfoStatus_RemovedLocally");
        }
        if (this.status == 2048) {
            return resourceBundle.getString("CTL_FileInfoStatus_DeletedLocally");
        }
        if (this.status == 16) {
            return resourceBundle.getString("CTL_FileInfoStatus_ModifiedLocally");
        }
        if (this.status == 32) {
            return resourceBundle.getString("CTL_FileInfoStatus_ModifiedInRepository");
        }
        if (this.status == 1024) {
            return resourceBundle.getString("CTL_FileInfoStatus_RemovedInRepository");
        }
        if (this.status == 64) {
            return resourceBundle.getString("CTL_FileInfoStatus_Conflict");
        }
        if (this.status == 128) {
            return resourceBundle.getString("CTL_FileInfoStatus_Merge");
        }
        return "";
    }

    public String getShortStatusText() {
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)FileInformation.class);
        if (this.status == 2) {
            return resourceBundle.getString("CTL_FileInfoStatus_Excluded_Short");
        }
        if (this.status == 4) {
            return resourceBundle.getString("CTL_FileInfoStatus_NewLocally_Short");
        }
        if (this.status == 4096) {
            return resourceBundle.getString("CTL_FileInfoStatus_AddedLocally_Short");
        }
        if (this.status == 16) {
            return resourceBundle.getString("CTL_FileInfoStatus_ModifiedLocally_Short");
        }
        if (this.status == 64) {
            return resourceBundle.getString("CTL_FileInfoStatus_Conflict_Short");
        }
        return "";
    }
}

