/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.io.File;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.modules.turbo.CustomProviders;
import org.netbeans.modules.turbo.Turbo;
import org.netbeans.modules.versioning.system.cvss.CvsLiteAdminHandler;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.DiskMapTurboProvider;
import org.netbeans.modules.versioning.system.cvss.FileInformation;
import org.netbeans.modules.versioning.system.cvss.settings.MetadataAttic;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.netbeans.modules.versioning.system.cvss.util.FlatFolder;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.netbeans.modules.versioning.util.ListenersSupport;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;

public class FileStatusCache {
    public static final Object EVENT_FILE_STATUS_CHANGED = new Object();
    private static final Map NOT_MANAGED_MAP = new NotManagedMap();
    private static final int STATUS_MISSING = 2816;
    public static final int REPOSITORY_STATUS_UNKNOWN = 0;
    public static final int REPOSITORY_STATUS_UPDATED = 85;
    public static final int REPOSITORY_STATUS_PATCHED = 80;
    public static final int REPOSITORY_STATUS_MODIFIED = 77;
    public static final int REPOSITORY_STATUS_CONFLICT = 67;
    public static final int REPOSITORY_STATUS_MERGEABLE = 71;
    public static final int REPOSITORY_STATUS_REMOVED = 82;
    public static final int REPOSITORY_STATUS_REMOVED_REMOTELY = 89;
    public static final int REPOSITORY_STATUS_UPTODATE = 65536;
    private static final FileInformation FILE_INFORMATION_EXCLUDED = new FileInformation(2, false);
    private static final FileInformation FILE_INFORMATION_EXCLUDED_DIRECTORY = new FileInformation(2, true);
    private static final FileInformation FILE_INFORMATION_UPTODATE_DIRECTORY = new FileInformation(8, true);
    private static final FileInformation FILE_INFORMATION_NOTMANAGED = new FileInformation(1, false);
    private static final FileInformation FILE_INFORMATION_NOTMANAGED_DIRECTORY = new FileInformation(1, true);
    private static final FileInformation FILE_INFORMATION_UNKNOWN = new FileInformation(0, false);
    private final CvsVersioningSystem cvs;
    private final CvsLiteAdminHandler sah;
    private final Turbo turbo;
    private final String FILE_STATUS_MAP = "org.netbeans.modules.versioning.system.cvss.DiskMapTurboProvider.STATUS_MAP";
    private DiskMapTurboProvider cacheProvider;
    ListenersSupport listenerSupport = new ListenersSupport((Object)this);

    FileStatusCache(CvsVersioningSystem cvsVersioningSystem) {
        this.cvs = cvsVersioningSystem;
        this.sah = (CvsLiteAdminHandler)this.cvs.getAdminHandler();
        this.cacheProvider = new DiskMapTurboProvider();
        this.turbo = Turbo.createCustom((CustomProviders)new CustomProviders(){
            private final Set providers;
            {
                this.providers = Collections.singleton(FileStatusCache.this.cacheProvider);
            }

            public Iterator providers() {
                return this.providers.iterator();
            }
        }, (int)200, (int)5000);
    }

    private File[] listFiles(File file) {
        Set set = this.getScannedFiles(file).keySet();
        return set.toArray(new File[set.size()]);
    }

    public File[] listFiles(Context context, int n) {
        Object object;
        Object object2;
        File file;
        HashSet<File> hashSet = new HashSet<File>();
        Map map = this.cacheProvider.getAllModifiedValues();
        Iterator<Object> iterator = map.keySet().iterator();
        block0: while (iterator.hasNext()) {
            file = (File)iterator.next();
            object2 = (FileInformation)map.get(file);
            if (((FileInformation)object2).isDirectory() || (((FileInformation)object2).getStatus() & n) == 0) continue;
            object = context.getRootFiles();
            for (int i = 0; i < ((File[])object).length; ++i) {
                File file2 = object[i];
                if (file2 instanceof FlatFolder) {
                    if (!file.getParentFile().equals(file2)) continue;
                    hashSet.add(file);
                    continue block0;
                }
                if (!Utils.isParentOrEqual(file2, file)) continue;
                hashSet.add(file);
                continue block0;
            }
        }
        if (context.getExclusions().size() > 0) {
            iterator = context.getExclusions().iterator();
            while (iterator.hasNext()) {
                file = (File)iterator.next();
                object2 = hashSet.iterator();
                while (object2.hasNext()) {
                    object = (File)object2.next();
                    if (!Utils.isParentOrEqual(file, (File)object)) continue;
                    object2.remove();
                }
            }
        }
        return hashSet.toArray(new File[hashSet.size()]);
    }

    public FileInformation getStatus(File file) {
        if (file.getName().equals("CVS")) {
            return FILE_INFORMATION_NOTMANAGED_DIRECTORY;
        }
        File file2 = file.getParentFile();
        if (file2 == null) {
            return FILE_INFORMATION_NOTMANAGED;
        }
        Map map = this.getScannedFiles(file2);
        if (map == NOT_MANAGED_MAP) {
            return FILE_INFORMATION_NOTMANAGED;
        }
        FileInformation fileInformation = (FileInformation)map.get(file);
        if (fileInformation != null) {
            return fileInformation;
        }
        if (!this.exists(file)) {
            return FILE_INFORMATION_UNKNOWN;
        }
        if (file.isDirectory()) {
            return this.refresh(file, 0);
        }
        return new FileInformation(8, false);
    }

    public FileInformation refresh(File file, int n) {
        File file2 = file.getParentFile();
        if (file2 == null) {
            return FILE_INFORMATION_NOTMANAGED;
        }
        Map map = this.getScannedFiles(file2);
        if (map == NOT_MANAGED_MAP) {
            return FILE_INFORMATION_NOTMANAGED;
        }
        FileInformation fileInformation = (FileInformation)map.get(file);
        Entry entry = null;
        try {
            entry = this.cvs.getAdminHandler().getEntry(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        FileInformation fileInformation2 = this.createFileInformation(file, entry, n);
        if (FileStatusCache.equivalent(fileInformation2, fileInformation)) {
            return fileInformation2;
        }
        if (fileInformation == null && !fileInformation2.isDirectory() && fileInformation2.getStatus() == 8) {
            return fileInformation2;
        }
        file = FileUtil.normalizeFile((File)file);
        file2 = FileUtil.normalizeFile((File)file2);
        HashMap<File, FileInformation> hashMap = new HashMap<File, FileInformation>(map);
        if (fileInformation2.getStatus() == 0) {
            hashMap.remove(file);
            this.turbo.writeEntry((Object)file, "org.netbeans.modules.versioning.system.cvss.DiskMapTurboProvider.STATUS_MAP", null);
        } else if (fileInformation2.getStatus() == 8 && file.isFile()) {
            hashMap.remove(file);
        } else {
            hashMap.put(file, fileInformation2);
        }
        this.turbo.writeEntry((Object)file2, "org.netbeans.modules.versioning.system.cvss.DiskMapTurboProvider.STATUS_MAP", hashMap.size() == 0 ? null : hashMap);
        if (file.isDirectory() && this.needRecursiveRefresh(fileInformation2, fileInformation)) {
            File[] fileArray = this.listFiles(file);
            for (int i = 0; i < fileArray.length; ++i) {
                this.refresh(fileArray[i], 0);
            }
        }
        this.fireFileStatusChanged(file, fileInformation, fileInformation2);
        return fileInformation2;
    }

    private static boolean equivalent(FileInformation fileInformation, FileInformation fileInformation2) {
        Entry entry;
        if (fileInformation2 == null || fileInformation.getStatus() != fileInformation2.getStatus() || fileInformation.isDirectory() != fileInformation2.isDirectory()) {
            return false;
        }
        Entry entry2 = fileInformation.getEntry(null);
        return entry2 == (entry = fileInformation2.getEntry(null)) || entry2 == null || entry == null || FileStatusCache.equal(entry2, entry);
    }

    private static boolean equal(Entry entry, Entry entry2) {
        if (!entry.getRevision().equals(entry2.getRevision())) {
            return false;
        }
        return entry.getStickyInformation() == entry2.getStickyInformation() || entry.getStickyInformation() != null && entry.getStickyInformation().equals(entry2.getStickyInformation());
    }

    private boolean needRecursiveRefresh(FileInformation fileInformation, FileInformation fileInformation2) {
        if (fileInformation.getStatus() == 2 || fileInformation2 != null && fileInformation2.getStatus() == 2) {
            return true;
        }
        return fileInformation.getStatus() == 1 || fileInformation2 != null && fileInformation2.getStatus() == 1;
    }

    public void refreshCached(File file, int n) {
        this.refresh(file, n);
    }

    public void clearVirtualDirectoryContents(File file, boolean bl, File[] fileArray) {
        Map map = (Map)this.turbo.readEntry((Object)file, "org.netbeans.modules.versioning.system.cvss.DiskMapTurboProvider.STATUS_MAP");
        if (map == null) {
            return;
        }
        HashSet hashSet = new HashSet(map.keySet());
        HashMap hashMap = null;
        Iterator iterator = hashSet.iterator();
        block0: while (iterator.hasNext()) {
            FileInformation fileInformation;
            File file2 = (File)iterator.next();
            if (fileArray != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    if (Utils.isParentOrEqual(fileArray[i], file2)) continue block0;
                }
            }
            if (bl && file2.isDirectory()) {
                this.clearVirtualDirectoryContents(file2, true, fileArray);
            }
            if (((fileInformation = this.refresh(file2, 0)).getStatus() & 0xB00) == 0) continue;
            if (hashMap == null) {
                hashMap = new HashMap(map);
            }
            hashMap.remove(file2);
        }
        if (hashMap != null) {
            file = FileUtil.normalizeFile((File)file);
            this.turbo.writeEntry((Object)file, "org.netbeans.modules.versioning.system.cvss.DiskMapTurboProvider.STATUS_MAP", hashMap);
        }
    }

    Map getAllModifiedFiles() {
        return this.cacheProvider.getAllModifiedValues();
    }

    void directoryContentChanged(File file) {
        Map map = (Map)this.turbo.readEntry((Object)file, "org.netbeans.modules.versioning.system.cvss.DiskMapTurboProvider.STATUS_MAP");
        if (map != null) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                File file2 = (File)iterator.next();
                this.refresh(file2, 0);
            }
        }
    }

    void cleanUp() {
        Map map = this.cacheProvider.getAllModifiedValues();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            FileInformation fileInformation = (FileInformation)map.get(file);
            if ((fileInformation.getStatus() & 0x19D4) != 0) {
                this.refresh(file, 0);
                continue;
            }
            if (fileInformation.getStatus() != 2 || this.exists(file)) continue;
            this.refresh(file, 0);
        }
    }

    private Map getScannedFiles(File file) {
        if (file.getName().equals("CVS")) {
            return NOT_MANAGED_MAP;
        }
        Map map = (Map)this.turbo.readEntry((Object)file, "org.netbeans.modules.versioning.system.cvss.DiskMapTurboProvider.STATUS_MAP");
        if (map != null) {
            return map;
        }
        if (this.isNotManagedByDefault(file)) {
            return NOT_MANAGED_MAP;
        }
        file = FileUtil.normalizeFile((File)file);
        map = this.scanFolder(file);
        this.turbo.writeEntry((Object)file, "org.netbeans.modules.versioning.system.cvss.DiskMapTurboProvider.STATUS_MAP", (Object)map);
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            File file2 = (File)iterator.next();
            FileInformation fileInformation = (FileInformation)map.get(file2);
            if ((fileInformation.getStatus() & 0x19D4) == 0) continue;
            this.fireFileStatusChanged(file2, null, fileInformation);
        }
        return map;
    }

    private boolean isNotManagedByDefault(File file) {
        return !file.exists() && MetadataAttic.getMetadata(file) == null;
    }

    private Map scanFolder(File file) {
        Object object;
        File file2;
        int n;
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            fileArray = new File[]{};
        }
        HashMap<File, Object> hashMap = new HashMap<File, Object>(fileArray.length);
        Entry[] entryArray = null;
        try {
            entryArray = this.sah.getEntriesAsArray(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (n = 0; n < fileArray.length; ++n) {
            FileInformation fileInformation;
            file2 = fileArray[n];
            String string = file2.getName();
            if (string.equals("CVS") || !(fileInformation = this.createFileInformation(file2, (Entry)(object = this.getEntry(entryArray, string)), 0)).isDirectory() && fileInformation.getStatus() == 8) continue;
            hashMap.put(file2, fileInformation);
        }
        if (entryArray != null) {
            block3: for (n = 0; n < entryArray.length; ++n) {
                file2 = entryArray[n];
                for (int i = 0; i < fileArray.length; ++i) {
                    object = fileArray[i];
                    if (((File)object).getName().equals(file2.getName())) continue block3;
                }
                File file3 = new File(file, entryArray[n].getName());
                object = this.createFileInformation(file3, (Entry)file2, 0);
                hashMap.put(file3, object);
            }
        }
        return hashMap;
    }

    private Entry getEntry(Entry[] entryArray, String string) {
        if (entryArray != null) {
            for (int i = 0; i < entryArray.length; ++i) {
                Entry entry = entryArray[i];
                if (!string.equals(entry.getName())) continue;
                return entry;
            }
        }
        return null;
    }

    private FileInformation createFileInformation(File file, Entry entry, int n) {
        if (entry == null) {
            if (!this.cvs.isManaged(file)) {
                return file.isDirectory() ? FILE_INFORMATION_NOTMANAGED_DIRECTORY : FILE_INFORMATION_NOTMANAGED;
            }
            return this.createMissingEntryFileInformation(file, n);
        }
        return this.createVersionedFileInformation(entry, file, n);
    }

    private FileInformation createVersionedFileInformation(Entry entry, File file, int n) {
        if (entry.isDirectory()) {
            if (new File(file, "CVS").isDirectory()) {
                return FILE_INFORMATION_UPTODATE_DIRECTORY;
            }
            return new FileInformation(4, true);
        }
        if (entry.isNewUserFile()) {
            return new FileInformation(4096, entry, false);
        }
        if (entry.isUserFileToBeRemoved()) {
            return new FileInformation(256, entry, false);
        }
        if (!this.exists(file)) {
            return new FileInformation(2048, entry, false);
        }
        if (n == 65536) {
            if (!this.entryTimestampMatches(entry, file)) {
                entry.setConflict(Entry.getLastModifiedDateFormatter().format(new Date(file.lastModified())));
                try {
                    this.sah.setEntry(file, entry);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
            return new FileInformation(8, entry, false);
        }
        if (n == 85 || n == 80) {
            return new FileInformation(32, entry, false);
        }
        if (n == 77) {
            FileInformation fileInformation = new FileInformation(16, entry, false);
            return fileInformation;
        }
        if (n == 67) {
            if (this.isLocalConflict(entry, file)) {
                return new FileInformation(64, entry, false);
            }
            return new FileInformation(128, entry, false);
        }
        if (n == 71) {
            return new FileInformation(128, entry, false);
        }
        if (n == 89) {
            return new FileInformation(1024, entry, false);
        }
        if (n == 0 || n == 63) {
            if (this.exists(file)) {
                if (this.isLocalConflict(entry, file)) {
                    return new FileInformation(64, entry, false);
                }
                if (this.entryTimestampMatches(entry, file)) {
                    return new FileInformation(8, entry, false);
                }
                FileInformation fileInformation = new FileInformation(16, entry, false);
                return fileInformation;
            }
            return new FileInformation(2048, entry, false);
        }
        throw new IllegalArgumentException("Unknown repository status: " + (char)n);
    }

    private boolean isLocalConflict(Entry entry, File file) {
        return this.exists(file) && entry.hadConflicts() && this.entryTimestampMatches(entry, file);
    }

    private FileInformation createMissingEntryFileInformation(File file, int n) {
        boolean bl = file.isDirectory();
        int n2 = this.getStatus(file.getParentFile()).getStatus();
        if (n2 == 2) {
            return bl ? FILE_INFORMATION_EXCLUDED_DIRECTORY : FILE_INFORMATION_EXCLUDED;
        }
        if (n2 == 1) {
            if (bl) {
                return this.isInsideCvsMetadata(file) ? FILE_INFORMATION_NOTMANAGED_DIRECTORY : FILE_INFORMATION_UPTODATE_DIRECTORY;
            }
            return FILE_INFORMATION_NOTMANAGED;
        }
        if (n == 0 || n == 63) {
            if (this.exists(file)) {
                if (this.cvs.isIgnored(file)) {
                    return bl ? FILE_INFORMATION_EXCLUDED_DIRECTORY : FILE_INFORMATION_EXCLUDED;
                }
                return new FileInformation(4, bl);
            }
            return new FileInformation(0, false);
        }
        if (n == 85) {
            if (file.exists()) {
                return new FileInformation(64, bl);
            }
            return new FileInformation(512, bl);
        }
        if (n == 65536) {
            if (n2 == 4) {
                return new FileInformation(4, bl);
            }
            return new FileInformation(2, bl);
        }
        if (n == 89) {
            if (this.exists(file)) {
                return new FileInformation(4, bl);
            }
            return FILE_INFORMATION_UNKNOWN;
        }
        if (n == 67) {
            return new FileInformation(64, false);
        }
        throw new IllegalArgumentException("Unknown repository status: " + (char)n);
    }

    private boolean isInsideCvsMetadata(File file) {
        return file.getAbsolutePath().indexOf(File.separator + "CVS" + File.separator) != -1;
    }

    private boolean exists(File file) {
        if (!file.exists()) {
            return false;
        }
        return file.getAbsolutePath().equals(FileUtil.normalizeFile((File)file).getAbsolutePath());
    }

    private boolean entryTimestampMatches(Entry entry, File file) {
        Date date = entry.getLastModified();
        if (date == null) {
            return false;
        }
        long l = date.getTime();
        long l2 = file.lastModified() / 1000L * 1000L;
        if (TimeZone.getDefault().inDaylightTime(entry.getLastModified())) {
            l2 -= (long)TimeZone.getDefault().getDSTSavings();
        }
        return l == l2 || l - l2 == 3600000L || l2 - l == 3600000L;
    }

    public void addVersioningListener(VersioningListener versioningListener) {
        this.listenerSupport.addListener(versioningListener);
    }

    public void removeVersioningListener(VersioningListener versioningListener) {
        this.listenerSupport.removeListener(versioningListener);
    }

    private void fireFileStatusChanged(File file, FileInformation fileInformation, FileInformation fileInformation2) {
        this.listenerSupport.fireVersioningEvent(EVENT_FILE_STATUS_CHANGED, new Object[]{file, fileInformation, fileInformation2});
    }

    private static final class NotManagedMap
    extends AbstractMap {
        private NotManagedMap() {
        }

        public Set entrySet() {
            return Collections.EMPTY_SET;
        }
    }
}

